/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.folderproperties;

import com.appframework.components.ComponentBorder;
import com.appframework.mvc.MVCController;
import com.novell.gw.folder.FolderSharedList;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableRadioButton;
import com.novell.gw.jclient.application.dialogs.folderproperties.ShareFolderNotificationDialog;
import com.novell.gw.jclient.application.dialogs.folderproperties.SharingPropertyPane;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class FPSharingPane
extends SharingPropertyPane {
    private JRadioButton rbNotShare = new OrientableRadioButton(new UnShareAction());
    private JRadioButton rbShare = new OrientableRadioButton(new ShareWithAction());
    private AbstractFolder folder;

    public FPSharingPane(JDialog theParentDialog, MVCController theParentController, AbstractFolder theFolder) {
        super(theParentDialog, theParentController, theFolder);
        this.folder = theFolder;
        this.init();
    }

    public FPSharingPane(JDialog theParentDialog, MVCController theParentController) {
        super(theParentDialog, theParentController);
        this.init();
    }

    private void init() {
        this.add((Component)this.buildTopPane(), "North");
        this.enableShareControls(false);
        this.rbNotShare.setSelected(true);
        if (this.folder != null) {
            if (this.folder.getNativeFolder().isSharedFolder()) {
                this.enableShareControls(true);
                this.rbShare.setSelected(true);
            }
            if (this.folder.getNativeFolder().isSharedFolderReference()) {
                this.isReadOnly = true;
                this.rbShare.setSelected(true);
                this.rbShare.setEnabled(false);
                this.rbNotShare.setEnabled(false);
            }
            if (this.folder.getNativeFolder().isSharedFolder() || this.folder.getNativeFolder().isSharedFolderReference()) {
                FolderSharedList sharedAccessList = this.folder.getNativeFolder().getSharedList();
                if (sharedAccessList == null) {
                    sharedAccessList = new FolderSharedList();
                }
                this.tableContactList.setMVCModel(sharedAccessList);
            }
        }
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 21;
        constraints.gridy = 1;
        this.pnlBottom.add((Component)this.rbShare, constraints);
        ComponentBorder componentBorder = new ComponentBorder(this.rbShare);
        this.pnlBottom.setBorder(BorderFactory.createCompoundBorder(componentBorder, BorderFactory.createEmptyBorder(0, 10, 10, 10)));
        this.setBorder(BorderFactory.createEmptyBorder(0, 15, 10, 15));
    }

    public boolean saveProperties() {
        super.saveProperties();
        return this.save();
    }

    public boolean isFolderShared() {
        return this.rbShare.isSelected();
    }

    protected JPanel buildTopPane() {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbNotShare);
        buttonGroup.add(this.rbShare);
        this.rbShare.setSelected(true);
        OrientablePanel pnlContent = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weightx = 1.0;
        constraints.anchor = 21;
        constraints.insets = new Insets(10, 15, 0, 0);
        pnlContent.add((Component)this.rbNotShare, constraints);
        return pnlContent;
    }

    public boolean isChangedProperties() {
        return !FPSharingPane.doEquals(this.folder.getNativeFolder().getSharedList(), this.isFolderShared() ? this.tableContactList.getAccessList() : null);
    }

    public boolean save() {
        boolean isSavedSuccessful = true;
        this.tfName.updateListener();
        if (!FPSharingPane.doEquals(this.folder.getNativeFolder().getSharedList(), this.isFolderShared() ? this.tableContactList.getAccessList() : null)) {
            isSavedSuccessful = this.isFolderShared() && this.tableContactList.getAccessList() != null && this.tableContactList.getAccessList().getSize() != 0 ? this.saveSharedList() : this.unShareFolder();
        }
        return isSavedSuccessful;
    }

    private static boolean doEquals(FolderSharedList sharedList1, FolderSharedList sharedList2) {
        if (sharedList1 == null && sharedList2 == null) {
            return false;
        }
        if (sharedList1 == sharedList2) {
            return true;
        }
        if (sharedList1 == null && sharedList2.getSize() == 0) {
            return true;
        }
        if (sharedList1 == null || sharedList2 == null) {
            return false;
        }
        if (sharedList1.getSize() != sharedList2.getSize()) {
            return false;
        }
        int nSize = sharedList1.getSize();
        for (int i = 0; i < nSize; ++i) {
            if (ShareFolderNotificationDialog.equalsFolderSharedEntry(sharedList1.get(i), sharedList2.get(i))) continue;
            return false;
        }
        return true;
    }

    protected class UnShareAction
    extends AbstractAction {
        public UnShareAction() {
            super(StringResources.NOT_SHARED);
        }

        public void actionPerformed(ActionEvent e) {
            FPSharingPane.this.enableShareControls(false);
        }
    }

    private class ShareWithAction
    extends AbstractAction {
        public ShareWithAction() {
            super(StringResources.SHARED_WITH);
        }

        public void actionPerformed(ActionEvent e) {
            FPSharingPane.this.enableShareControls(true);
        }
    }
}

