/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.folderproperties;

import com.appframework.mvc.GlobalCommand;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.Savable;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialog;
import com.novell.gw.jclient.application.controls.orientable.OrientableTabbedPane;
import com.novell.gw.jclient.application.controls.panelviews.MultiPanelViewModelManager;
import com.novell.gw.jclient.application.dialogs.folderproperties.DisplayPanel;
import com.novell.gw.jclient.application.dialogs.folderproperties.FPSharingPane;
import com.novell.gw.jclient.application.dialogs.folderproperties.FolderPropertiesDialogController;
import com.novell.gw.jclient.application.dialogs.folderproperties.GeneralPanel;
import com.novell.gw.jclient.application.dialogs.folderproperties.NntpFolderPropertiesPane;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.NntpSubFolder;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.JTabbedPane;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FolderPropertiesDialog
extends ApplicationDialog<FolderPropertiesDialogController> {
    private static final Logger logger = Logger.getLogger(FolderPropertiesDialog.class);
    private final AbstractFolder folder;
    private JTabbedPane tabbedPane = new OrientableTabbedPane();

    public FolderPropertiesDialog(Frame owner, MVCController parentController, AbstractFolder folder) {
        super(owner, parentController);
        this.folder = folder;
        this.buildUI();
    }

    public FolderPropertiesDialog(Dialog owner, MVCController parentController, AbstractFolder folder) {
        super(owner, parentController);
        this.folder = folder;
        this.buildUI();
    }

    private void buildUI() {
        this.setTitle(StringResources.PROPERTIES_C);
        this.tabbedPane.addTab(StringResources.GENERAL, new GeneralPanel(this.folder, (MVCController)this.getController()));
        this.tabbedPane.addTab(StringResources.DISPLAY, new DisplayPanel(this.folder.getNativeFolder(), ControlsUtils.getUserGuid(this.getController())));
        if (this.folder.canShare()) {
            FPSharingPane pnlSharingProperty = new FPSharingPane(this, (MVCController)this.getController(), this.folder);
            this.tabbedPane.addTab(StringResources.SHARING, pnlSharingProperty);
        }
        if (this.folder instanceof NntpSubFolder) {
            this.tabbedPane.addTab(StringResources.NNTP, new NntpFolderPropertiesPane((MVCController)this.getController(), (NntpSubFolder)this.folder));
        }
        this.add((Component)this.tabbedPane, "Center");
        this.add((Component)this.createOkCancelButtonsPanel(), "Last");
        this.pack();
    }

    @Override
    protected void processOkAction(ActionEvent event) {
        boolean needRefresh = false;
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            Savable savable = (Savable)((Object)this.tabbedPane.getComponentAt(i));
            if (savable == null || !savable.isChangedProperties()) continue;
            boolean result = savable.saveProperties();
            if (!result) {
                return;
            }
            logger.debug((Object)("result: " + result));
            if (savable instanceof FPSharingPane) continue;
            needRefresh = true;
        }
        super.processOkAction(event);
        if (needRefresh) {
            if (this.folder.getDisplaySettings().getViewMode() == 8) {
                logger.debug((Object)"removing outdated MultiPanelViewModel");
                MultiPanelViewModelManager.getInstance().removeModel(this.folder.getNativeFolder());
            }
            FolderPropertiesDialogController controller = (FolderPropertiesDialogController)this.getController();
            controller.processCommand(new GlobalCommand(85));
            controller.processCommand(new GlobalCommand(1210, this.folder));
            controller.processCommand(new GlobalCommand(200));
        }
    }

    @Override
    protected FolderPropertiesDialogController createController(MVCController parentController) {
        return new FolderPropertiesDialogController(this, parentController);
    }

    public void selectSharingProperties() {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            Component component = this.tabbedPane.getComponentAt(i);
            if (!(component instanceof FPSharingPane)) continue;
            this.tabbedPane.setSelectedComponent(component);
            break;
        }
    }
}

