/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.folderproperties;

import com.appframework.AppAction;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.api.interfaces.folder.INntpFolder;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.folder.ActionResetNntpFolder;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableSpinner;
import com.novell.gw.jclient.application.dialogs.folderproperties.SavablePanel;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.folders.NntpSubFolder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;

public class NntpFolderPropertiesPane
extends SavablePanel {
    private OrientableCheckBox cbUseDownload;
    private OrientableCheckBox cbDownloadMsg;
    private OrientableCheckBox cbDownloadHeaders;
    private OrientableCheckBox cbViewNewest;
    private OrientableCheckBox cbShowDeleted;
    private OrientableSpinner spDays;
    private OrientableButton btnReset;
    private OrientableButton btnResetHeaders;
    private OrientablePanel pnlDownload;
    private MVCController controller;
    private NntpSubFolder folder;

    public NntpFolderPropertiesPane(MVCController parentController, NntpSubFolder theFolder) {
        this.controller = parentController;
        this.folder = theFolder;
        this.initComponents();
        this.loadProperties();
        this.updateCBStates();
        this.buildUI();
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
    }

    private void initComponents() {
        this.cbUseDownload = new OrientableCheckBox(new UseDownloadAction());
        this.cbDownloadMsg = new OrientableCheckBox(new DownloadMsgAction());
        this.cbDownloadHeaders = new OrientableCheckBox(new DownloadHeadersAction());
        this.cbViewNewest = new OrientableCheckBox(StringResources.VIEW_ONLY_NEWEST_ITEMS);
        this.cbShowDeleted = new OrientableCheckBox(StringResources.SHOW_DELETED_ITEMS);
        this.spDays = new OrientableSpinner(new SpinnerNumberModel(1, 1, 9999, 1));
        this.spDays.setPreferredSize(new Dimension(50, (int)this.spDays.getPreferredSize().getHeight()));
        this.propertyManager.addPropertyView(this.cbUseDownload);
        this.propertyManager.addPropertyView(this.cbDownloadMsg);
        this.propertyManager.addPropertyView(this.cbDownloadHeaders);
        this.propertyManager.addPropertyView(this.cbViewNewest);
        this.propertyManager.addPropertyView(this.cbShowDeleted);
        this.propertyManager.addPropertyView(this.spDays);
        this.propertyManager.addPropertyView(this.spDays);
        this.btnReset = new OrientableButton(new ResetAction());
        this.btnResetHeaders = new OrientableButton(new ResetHeadersAction());
    }

    private void buildUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 8, 0);
        this.add((Component)this.cbUseDownload, c);
        ++c.gridy;
        c.insets = new Insets(0, 0, 0, 0);
        this.buildDownloadSettingsPanel();
        this.add((Component)this.pnlDownload, c);
        OrientablePanel pnlTemp = new OrientablePanel(new BorderLayout(3, 0));
        pnlTemp.add((Component)this.btnReset, "Before");
        pnlTemp.add((Component)new OrientableLabel(StringResources.REMOVE_ALL_DOWNLOADED_HEADERS_AND_MESSAGES), "Center");
        ++c.gridy;
        c.insets = new Insets(8, 0, 4, 0);
        this.add((Component)pnlTemp, c);
        pnlTemp = new OrientablePanel(new BorderLayout(3, 0));
        pnlTemp.add((Component)this.btnResetHeaders, "Before");
        pnlTemp.add((Component)new OrientableLabel(StringResources.REMOVE_DOWNLOADED_HEADERS_ONLY), "Center");
        ++c.gridy;
        this.add((Component)pnlTemp, c);
        ++c.gridy;
        c.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.cbShowDeleted, c);
        ++c.gridy;
        c.insets = new Insets(0, 0, 0, 0);
        c.weighty = 1.0;
        this.add((Component)new JPanel(), c);
    }

    public boolean saveProperties() {
        this.saveOptions();
        return true;
    }

    public boolean loadProperties() {
        this.cbUseDownload.setSelected(((INntpFolder)this.folder.getNativeFolder()).getAccountOverrideUseAccountSettings());
        this.cbDownloadHeaders.setSelected(((INntpFolder)this.folder.getNativeFolder()).getAccountOverrideHeadersOnly());
        this.cbViewNewest.setSelected(((INntpFolder)this.folder.getNativeFolder()).getAccountOverrideViewNewOnly());
        this.cbShowDeleted.setSelected(((INntpFolder)this.folder.getNativeFolder()).getAccountOverrideShowingDeletedItems());
        int days = ((INntpFolder)this.folder.getNativeFolder()).getAccountOverrideMaxDaysOldMessages();
        this.cbDownloadMsg.setSelected(days > 0);
        this.spDays.setValue(days < 1 ? 1 : days);
        this.spDays.setEnabled(days > 0);
        return super.loadProperties();
    }

    protected void saveOptions() {
        INntpFolder nntpFolder = (INntpFolder)this.folder.getNativeFolder();
        nntpFolder.setAccountOverrides(this.cbUseDownload.isSelected(), this.cbDownloadMsg.isSelected() ? (Integer)this.spDays.getValue() : -1, this.cbDownloadHeaders.isSelected(), this.cbViewNewest.isSelected(), this.cbShowDeleted.isSelected());
    }

    private void updateCBStates() {
        Boolean enabled = this.cbUseDownload.isSelected();
        this.cbDownloadMsg.setEnabled(enabled == false);
        this.cbDownloadHeaders.setEnabled(enabled == false);
        if (enabled.booleanValue()) {
            this.spDays.setEnabled(false);
        } else if (this.cbDownloadMsg.isSelected()) {
            this.spDays.setEnabled(true);
        }
    }

    private void buildDownloadSettingsPanel() {
        this.pnlDownload = new OrientablePanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.insets = new Insets(3, 8, 3, 5);
        this.pnlDownload.add((Component)this.cbDownloadMsg, c);
        ++c.gridx;
        c.anchor = 21;
        c.insets = new Insets(0, 0, 0, 5);
        c.fill = 2;
        this.pnlDownload.add((Component)this.spDays, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 1;
        this.pnlDownload.add((Component)new OrientableLabel(StringResources.DAYS_OLD), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 3;
        c.insets = new Insets(0, 8, 3, 0);
        this.pnlDownload.add((Component)this.cbDownloadHeaders, c);
        this.pnlDownload.setBorder(BorderFactory.createTitledBorder(StringResources.OVERRIDE_ACCOUNT_C));
    }

    private class ResetHeadersAction
    extends AbstractAction {
        public ResetHeadersAction() {
            super(StringResources.RESET_HEADERS);
        }

        public void actionPerformed(ActionEvent e) {
            ((INntpFolder)NntpFolderPropertiesPane.this.folder.getNativeFolder()).reset(true);
            AppAction a = NntpFolderPropertiesPane.this.controller.getActionList().getAction(ActionKey.REFRESH);
            a.actionPerformed(null);
        }
    }

    private class ResetAction
    extends AbstractAction {
        public ResetAction() {
            super(StringResources.RESET);
        }

        public void actionPerformed(ActionEvent e) {
            ActionResetNntpFolder.resetNntpFolder((INntpFolder)NntpFolderPropertiesPane.this.folder.getNativeFolder(), true, NntpFolderPropertiesPane.this.controller.getActionList());
        }
    }

    private class DownloadHeadersAction
    extends AbstractAction {
        public DownloadHeadersAction() {
            super(StringResources.DOWNLOAD_HEADERS_ONLY);
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    private class DownloadMsgAction
    extends AbstractAction {
        public DownloadMsgAction() {
            super(StringResources.DOWNLOAD_MESSAGES_LESS_THAN);
        }

        public void actionPerformed(ActionEvent e) {
            if (NntpFolderPropertiesPane.this.cbDownloadMsg.isSelected()) {
                NntpFolderPropertiesPane.this.spDays.setEnabled(this.enabled);
            } else {
                NntpFolderPropertiesPane.this.spDays.setEnabled(!this.enabled);
            }
        }
    }

    private class UseDownloadAction
    extends AbstractAction {
        public UseDownloadAction() {
            super(StringResources.USE_DOWNLOAD_SETTINGS_FROM_ACCOUNT);
        }

        public void actionPerformed(ActionEvent e) {
            NntpFolderPropertiesPane.this.updateCBStates();
        }
    }
}

