/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.folderproperties;

import com.novell.gw.ab.DistributionList;
import com.novell.gw.engine.SharedFolderNotificationInfo;
import com.novell.gw.folder.FolderAccessRights;
import com.novell.gw.folder.FolderSharedEntry;
import com.novell.gw.jclient.application.controls.basicdialogs.OkCancelDialog;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableTabbedPane;
import com.novell.gw.jclient.application.dialogs.folderproperties.ParticipantsPane;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class ShareFolderNotificationDialog
extends OkCancelDialog {
    private ParticipantsPane pnlDelete;
    private ParticipantsPane pnlNew;
    private ParticipantsPane pnlModify;
    private OrientableTabbedPane tabPane = new OrientableTabbedPane();

    public ShareFolderNotificationDialog(Dialog dialog, boolean isCalendar, DistributionList newParticipants, DistributionList modifiedParticipants, DistributionList deletedParticipants) {
        super(dialog, true);
        this.buildUI(isCalendar, newParticipants, modifiedParticipants, deletedParticipants);
        this.setLocationRelativeTo(this.getParent());
    }

    public ShareFolderNotificationDialog(Frame frame, boolean isCalendar, DistributionList newParticipants, DistributionList modifiedParticipants, DistributionList deletedParticipants) {
        super(frame, true);
        this.buildUI(isCalendar, newParticipants, modifiedParticipants, deletedParticipants);
        this.setLocationRelativeTo(this.getParent());
    }

    private void buildUI(boolean isCalendar, DistributionList newParticipants, DistributionList modifiedParticipants, DistributionList deletedParticipants) {
        JComponent cp = (JComponent)this.getContentPane();
        if (isCalendar) {
            this.pnlDelete = new ParticipantsPane(StringResources.DELETED_PARTICIPANTS_LABEL_CALENDAR, StringResources.DELETE_SUBJECT);
            this.pnlNew = new ParticipantsPane(StringResources.NEW_PARTICIPANTS_LABEL_CALENDAR, StringResources.NEW_SUBJECT);
        } else {
            this.pnlDelete = new ParticipantsPane(StringResources.DELETED_PARTICIPANTS_LABEL_FOLDER, StringResources.DELETE_SUBJECT);
            this.pnlNew = new ParticipantsPane(StringResources.NEW_PARTICIPANTS_LABEL_FOLDER, StringResources.NEW_SUBJECT);
        }
        this.pnlModify = new ParticipantsPane(StringResources.MODIFIED_PARTICIPANTS_LABEL, StringResources.MODIFIED_SUBJECT);
        cp.setLayout(new BorderLayout());
        cp.add((Component)this.tabPane, "Center");
        cp.add((Component)this.getButtonPanel(), "South");
        if (newParticipants != null && newParticipants.getSize() > 0) {
            this.tabPane.addTab(StringResources.NEW_PARTICIPANTS, this.pnlNew);
            this.pnlNew.setParticipants(newParticipants);
        }
        if (deletedParticipants != null && deletedParticipants.getSize() > 0) {
            this.tabPane.addTab(StringResources.DELETED_PARTICIPANTS, this.pnlDelete);
            this.pnlDelete.setParticipants(deletedParticipants);
        }
        if (modifiedParticipants != null && modifiedParticipants.getSize() > 0) {
            this.tabPane.addTab(StringResources.MODIFIED_PARTICIPANTS, this.pnlModify);
            this.pnlModify.setParticipants(modifiedParticipants);
        }
        this.setContentPane(cp);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private JPanel getButtonPanel() {
        OrientablePanel pnlResult = new OrientablePanel(new BorderLayout());
        pnlResult.add((Component)this.createOkCancelButtonsPanel(), "After");
        pnlResult.setBorder(new EmptyBorder(5, 5, 5, 5));
        return pnlResult;
    }

    public SharedFolderNotificationInfo getSharedFolderNotificationInfo() {
        return new SharedFolderNotificationInfo(this.pnlNew.getSubject(), this.pnlNew.getMessage(), this.pnlModify.getSubject(), this.pnlModify.getMessage(), this.pnlDelete.getSubject(), this.pnlDelete.getMessage());
    }

    public void setSubjectForDeletedParticipants(String aSubject) {
        this.pnlDelete.setSubject(aSubject);
    }

    public void setMessageForDeleteParticipants(String aMessage) {
        this.pnlDelete.setMessage(aMessage);
    }

    public void setSubjectForModifiedParticipants(String aSubject) {
        this.pnlModify.setSubject(aSubject);
    }

    public void setMessageForModifiedParticipants(String aMessage) {
        this.pnlModify.setMessage(aMessage);
    }

    public void setSubjectForNewParticipants(String aSubject) {
        this.pnlNew.setSubject(aSubject);
    }

    public void setMessageForNewParticipants(String aMessage) {
        this.pnlNew.setMessage(aMessage);
    }

    public static boolean equalsFolderSharedEntry(FolderSharedEntry folderSharedEntry1, FolderSharedEntry folderSharedEntry2) {
        if (!folderSharedEntry1.getName().equals(folderSharedEntry2.getName())) {
            return false;
        }
        return ShareFolderNotificationDialog.equalsFolderAccessRights(folderSharedEntry1.getAccessRights(), folderSharedEntry2.getAccessRights());
    }

    private static boolean equalsFolderAccessRights(FolderAccessRights accessRights1, FolderAccessRights accessRights2) {
        if (accessRights1.hasAddAccess() ^ accessRights2.hasAddAccess()) {
            return false;
        }
        if (accessRights1.hasDeleteAccess() ^ accessRights2.hasDeleteAccess()) {
            return false;
        }
        if (accessRights1.hasEditAccess() ^ accessRights2.hasEditAccess()) {
            return false;
        }
        return !(accessRights1.hasReadAccess() ^ accessRights2.hasReadAccess());
    }
}

