/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.folderproperties.viewby;

import com.novell.gw.jclient.api.enums.CalendarViewType;
import com.novell.gw.jclient.api.interfaces.IFolderDisplaySettings;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.folderproperties.viewby.AdvancedViewByTableMode;
import com.novell.gw.jclient.application.dialogs.folderproperties.viewby.ViewByCalendar;
import com.novell.gw.jclient.application.dialogs.folderproperties.viewby.ViewBySettings;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class AdvancedViewByCalendar
extends ViewByCalendar {
    private JCheckBox cbReceived = new OrientableCheckBox(StringResources.RECEIVED);
    private JCheckBox cbSent = new OrientableCheckBox(StringResources.SENT);
    private JCheckBox cbPosted = new OrientableCheckBox(StringResources.POSTED);
    private JCheckBox cbDraft = new OrientableCheckBox(StringResources.DRAFT);
    private JCheckBox cbShowAppointments = new OrientableCheckBox(StringResources.SHOW_APPOINTMENTS);
    private JCheckBox cbShowTasks = new OrientableCheckBox(StringResources.SHOW_TASKS);
    private JCheckBox cbShowNotes = new OrientableCheckBox(StringResources.SHOW_NOTES);
    private JComboBox cmbCalendarViews = new OrientableComboBox(GWCalendarUtils.getCalendarPropertiesViewList().getNamesList().toArray());

    protected AdvancedViewByCalendar(String userGuid, IFolder folder, ViewBySettings viewBySettings) {
        super(userGuid, folder, viewBySettings);
        this.init();
    }

    private void init() {
        this.propertyManager.addPropertyView(this.cbReceived);
        this.propertyManager.addPropertyView(this.cbSent);
        this.propertyManager.addPropertyView(this.cbPosted);
        this.propertyManager.addPropertyView(this.cbDraft);
        this.propertyManager.addPropertyView(this.cbShowAppointments);
        this.propertyManager.addPropertyView(this.cbShowTasks);
        this.propertyManager.addPropertyView(this.cbShowNotes);
        this.propertyManager.addPropertyView(this.cmbCalendarViews);
        this.cmbCalendarViews.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                CalendarViewType view = GWCalendarUtils.getCalendarPropertiesViewList().getListItem(AdvancedViewByCalendar.this.cmbCalendarViews.getSelectedIndex()).getView();
                if (view == CalendarViewType.YEARLY) {
                    AdvancedViewByCalendar.this.cbShowMonthPicker.setEnabled(false);
                } else {
                    AdvancedViewByCalendar.this.cbShowMonthPicker.setEnabled(true);
                }
            }
        });
    }

    public boolean loadProperties() {
        IFolderDisplaySettings folderDisplaySettings = this.getFolderDisplaySettings();
        IViewDisplaySettings viewDisplaySettings = folderDisplaySettings.asViewDisplaySettings();
        int boxType = folderDisplaySettings.getBoxType();
        this.cbReceived.setSelected((boxType & 1) == 1);
        this.cbPosted.setSelected((boxType & 4) == 4);
        this.cbSent.setSelected((boxType & 2) == 2);
        this.cbDraft.setSelected((boxType & 8) == 8);
        int itemType = viewDisplaySettings.getItemType();
        this.cbShowAppointments.setSelected((itemType & 8) == 8);
        this.cbShowTasks.setSelected((itemType & 4) == 4);
        this.cbShowNotes.setSelected((itemType & 2) == 2);
        CalendarViewType calendarViewType = viewDisplaySettings.getCalViewType();
        this.cmbCalendarViews.setSelectedIndex(calendarViewType == null ? 0 : calendarViewType.getValue());
        int colCount = viewDisplaySettings.getCalWeekColumnCount();
        if (colCount > 0 && colCount <= 7) {
            this.spnOnWeekViewShowDays.setValue(colCount);
        }
        return super.loadProperties();
    }

    public boolean saveProperties() {
        boolean result = super.saveProperties();
        int boxType = 0;
        boxType = this.cbReceived.isSelected() ? boxType | 1 : boxType;
        boxType = this.cbPosted.isSelected() ? boxType | 4 : boxType;
        boxType = this.cbSent.isSelected() ? boxType | 2 : boxType;
        boxType = this.cbDraft.isSelected() ? boxType | 8 : boxType;
        result = result && this.folderDisplaySettings.setBoxType(boxType);
        IViewDisplaySettings viewDisplaySettings = this.folderDisplaySettings.asViewDisplaySettings();
        int itemType = 0;
        itemType = this.cbShowAppointments.isSelected() ? itemType | 8 : itemType;
        itemType = this.cbShowNotes.isSelected() ? itemType | 2 : itemType;
        itemType = this.cbShowTasks.isSelected() ? itemType | 4 : itemType;
        result = result && viewDisplaySettings.setItemType(itemType);
        viewDisplaySettings.setCalViewType(CalendarViewType.getEnum(this.cmbCalendarViews.getSelectedIndex()));
        return result;
    }

    public JPanel getRightPanel() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridy = 0;
        constraints.insets.bottom = 5;
        constraints.anchor = 23;
        constraints.fill = 2;
        panel.add((Component)AdvancedViewByTableMode.createLabelWithSeparator(StringResources.CHOOSE_ITEM_SOURCE_C), constraints);
        ++constraints.gridy;
        constraints.insets.bottom = 10;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        panel.add((Component)AdvancedViewByTableMode.createCheckBoxesPanel(new JCheckBox[][]{{this.cbReceived, this.cbPosted}, {this.cbSent, this.cbDraft}}), constraints);
        return panel;
    }

    public JPanel getLeftPanel() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridy = 0;
        constraints.anchor = 23;
        constraints.fill = 2;
        panel.add((Component)new OrientableLabel(StringResources.CALENDAR_VIEWS_C), constraints);
        ++constraints.gridy;
        constraints.insets.bottom = 10;
        panel.add((Component)this.cmbCalendarViews, constraints);
        ++constraints.gridy;
        constraints.insets.bottom = 0;
        panel.add((Component)this.cbShowAppointments, constraints);
        ++constraints.gridy;
        panel.add((Component)this.cbShowTasks, constraints);
        ++constraints.gridy;
        constraints.insets.bottom = 10;
        panel.add((Component)this.cbShowNotes, constraints);
        ++constraints.gridy;
        constraints.insets.bottom = 0;
        panel.add((Component)this.cbShowMonthPicker, constraints);
        ++constraints.gridy;
        constraints.insets.bottom = 10;
        panel.add((Component)this.cbShowCalendarToolbar, constraints);
        ++constraints.gridy;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        panel.add((Component)this.createOnWeekViewShowNDaysPanel(), constraints);
        return panel;
    }
}

