/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.folderproperties.viewby;

import com.novell.gw.jclient.api.enums.ItemType;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableRadioButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableSpinner;
import com.novell.gw.jclient.application.dialogs.folderproperties.viewby.AdvancedViewByTableMode;
import com.novell.gw.jclient.application.dialogs.folderproperties.viewby.ViewBySettings;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public abstract class AdvancedViewByTableMode_Messages
extends AdvancedViewByTableMode {
    private static final int DEFAULT_BACKWARD_VALUE = 14;
    private static final int DEFAULT_FORWARD_VALUE = 30;
    protected JRadioButton rbWnenCompleted = new OrientableRadioButton(StringResources.WHEN_COMPLETED);
    protected JRadioButton rbNextDayAfterCompleted = new OrientableRadioButton(StringResources.NEXT_DAY_AFTER_COMPLETED);
    protected JCheckBox cbMessagePreview = new OrientableCheckBox(StringResources.MESSAGE_PREVIEW);
    protected JCheckBox cbHideItemsNotInTaskList = new OrientableCheckBox(StringResources.HIDE_ITEMS_NOT_IN_TASKLIST);
    protected JCheckBox cbHideTasklistItems = new OrientableCheckBox(StringResources.HIDE_TASKLIST_ITEMS_C);
    private JCheckBox cbReceived = new OrientableCheckBox(StringResources.RECEIVED);
    private JCheckBox cbSent = new OrientableCheckBox(StringResources.SENT);
    private JCheckBox cbPosted = new OrientableCheckBox(StringResources.POSTED);
    private JCheckBox cbDraft = new OrientableCheckBox(StringResources.DRAFT);
    private JCheckBox cbMail = new OrientableCheckBox(StringResources.MAIL);
    private JCheckBox cbTasks = new OrientableCheckBox(StringResources.TASKS);
    private JCheckBox cbAppointments = new OrientableCheckBox(StringResources.APPOINTMENTS);
    private JCheckBox cbDocuments = new OrientableCheckBox(StringResources.DOCUMENTS);
    private JCheckBox cbPhoneMessages = new OrientableCheckBox(StringResources.PHONE_MESSAGES);
    private JCheckBox cbReminderNotes = new OrientableCheckBox(StringResources.REMINDER_NOTES);
    private JCheckBox cbStarting = new OrientableCheckBox(StringResources.STARTING);
    private JCheckBox cbThrough = new OrientableCheckBox(StringResources.STARTING_TODAY_THROUGH);
    private JSpinner spnDaysAgo = new OrientableSpinner(new SpinnerNumberModel(0, 0, 365, 1));
    private JSpinner spnDaysInTheFuture = new OrientableSpinner(new SpinnerNumberModel(0, 0, 365, 1));
    private JLabel lblDaysAgo = new OrientableLabel(StringResources.DAYS_AGO_THROUGH_THE_FUTURE);

    protected AdvancedViewByTableMode_Messages(String userGuid, IFolder folder, ViewBySettings viewBySettings) {
        super(userGuid, folder, viewBySettings);
        this.init();
    }

    private void init() {
        this.cbHideItemsNotInTaskList.setEnabled(false);
        this.cbHideTasklistItems.setEnabled(false);
        this.rbWnenCompleted.setEnabled(false);
        this.rbNextDayAfterCompleted.setEnabled(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.rbWnenCompleted);
        group.add(this.rbNextDayAfterCompleted);
        this.propertyManager.addPropertyView(this.rbWnenCompleted);
        this.propertyManager.addPropertyView(this.rbNextDayAfterCompleted);
        this.propertyManager.addPropertyView(this.cbMessagePreview);
        this.propertyManager.addPropertyView(this.cbHideItemsNotInTaskList);
        this.propertyManager.addPropertyView(this.cbHideTasklistItems);
        this.propertyManager.addPropertyView(this.cbReceived);
        this.propertyManager.addPropertyView(this.cbSent);
        this.propertyManager.addPropertyView(this.cbPosted);
        this.propertyManager.addPropertyView(this.cbDraft);
        this.propertyManager.addPropertyView(this.cbMail);
        this.propertyManager.addPropertyView(this.cbTasks);
        this.propertyManager.addPropertyView(this.cbAppointments);
        this.propertyManager.addPropertyView(this.cbDocuments);
        this.propertyManager.addPropertyView(this.cbPhoneMessages);
        this.propertyManager.addPropertyView(this.cbReminderNotes);
        this.propertyManager.addPropertyView(this.cbStarting);
        this.propertyManager.addPropertyView(this.cbThrough);
        this.propertyManager.addPropertyView(this.spnDaysAgo);
        this.propertyManager.addPropertyView(this.spnDaysInTheFuture);
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                AdvancedViewByTableMode_Messages.this.refreshDateRangeOptionComponents();
            }
        };
        this.cbStarting.addItemListener(itemListener);
        this.cbThrough.addItemListener(itemListener);
        this.cbHideTasklistItems.addItemListener(new HideItemsNotInTasklistListener());
    }

    public boolean loadProperties() {
        IViewDisplaySettings viewDisplaySettings = this.folderDisplaySettings.asViewDisplaySettings();
        this.cbMessagePreview.setSelected(viewDisplaySettings.getMsgPreview());
        this.cbHideItemsNotInTaskList.setSelected(viewDisplaySettings.isHideNonChecklist());
        boolean hideCompleted = viewDisplaySettings.getHideCompleted();
        boolean hideCompletedAfterADay = viewDisplaySettings.getHideCompletedAfterADay();
        this.cbHideTasklistItems.setSelected(hideCompleted || hideCompletedAfterADay);
        if (hideCompletedAfterADay) {
            this.rbNextDayAfterCompleted.setSelected(true);
        } else {
            this.rbWnenCompleted.setSelected(true);
        }
        this.refreshHideItemsNotInTasklist();
        this.refreshDateRangeOptionComponents();
        int boxType = this.folderDisplaySettings.getBoxType();
        this.cbReceived.setSelected((boxType & 1) == 1);
        this.cbPosted.setSelected((boxType & 4) == 4);
        this.cbSent.setSelected((boxType & 2) == 2);
        this.cbDraft.setSelected((boxType & 8) == 8);
        int itemType = this.folderDisplaySettings.asViewDisplaySettings().getItemType();
        this.cbMail.setSelected((itemType & ItemType.MAIL.getValue()) == ItemType.MAIL.getValue());
        this.cbReminderNotes.setSelected((itemType & ItemType.NOTE.getValue()) == ItemType.NOTE.getValue());
        this.cbAppointments.setSelected((itemType & ItemType.APPT.getValue()) == ItemType.APPT.getValue());
        this.cbPhoneMessages.setSelected((itemType & ItemType.PHONE.getValue()) == ItemType.PHONE.getValue());
        this.cbTasks.setSelected((itemType & ItemType.TODO.getValue()) == ItemType.TODO.getValue());
        this.cbDocuments.setSelected((itemType & ItemType.PROFILE.getValue()) == ItemType.PROFILE.getValue());
        int daysBackward = viewDisplaySettings.getFilterDaysBackward();
        boolean backwardSelected = daysBackward != 0;
        this.cbStarting.setSelected(backwardSelected);
        this.spnDaysAgo.setValue(backwardSelected ? daysBackward : 14);
        int daysForward = viewDisplaySettings.getFilterDaysForward();
        boolean forwardSelected = daysForward != 0;
        this.cbThrough.setSelected(forwardSelected);
        this.spnDaysInTheFuture.setValue(forwardSelected ? daysForward : 30);
        return super.loadProperties();
    }

    private void refreshHideItemsNotInTasklist() {
        boolean selected = this.cbHideTasklistItems.isSelected() && this.cbHideTasklistItems.isEnabled();
        this.rbWnenCompleted.setEnabled(selected);
        this.rbNextDayAfterCompleted.setEnabled(selected);
    }

    public boolean saveProperties() {
        boolean result = super.saveProperties();
        IViewDisplaySettings viewDisplaySettings = this.folderDisplaySettings.asViewDisplaySettings();
        viewDisplaySettings.setHideNonChecklist(this.cbHideItemsNotInTaskList.isSelected());
        viewDisplaySettings.setMsgPreview(this.cbMessagePreview.isSelected());
        int boxType = 0;
        boxType = this.cbReceived.isSelected() ? boxType | 1 : boxType;
        boxType = this.cbPosted.isSelected() ? boxType | 4 : boxType;
        boxType = this.cbSent.isSelected() ? boxType | 2 : boxType;
        boxType = this.cbDraft.isSelected() ? boxType | 8 : boxType;
        result = result && this.folderDisplaySettings.setBoxType(boxType);
        int itemType = 0;
        itemType = this.cbMail.isSelected() ? itemType | ItemType.MAIL.getValue() : itemType;
        itemType = this.cbReminderNotes.isSelected() ? itemType | ItemType.NOTE.getValue() : itemType;
        itemType = this.cbAppointments.isSelected() ? itemType | ItemType.APPT.getValue() : itemType;
        itemType = this.cbPhoneMessages.isSelected() ? itemType | ItemType.PHONE.getValue() : itemType;
        itemType = this.cbTasks.isSelected() ? itemType | ItemType.TODO.getValue() : itemType;
        itemType = this.cbDocuments.isSelected() ? itemType | ItemType.PROFILE.getValue() : itemType;
        result = result && this.folderDisplaySettings.asViewDisplaySettings().setItemType(itemType);
        int filterDaysBackward = (Integer)this.spnDaysAgo.getValue();
        viewDisplaySettings.setFilterDaysBackward(this.cbStarting.isSelected() ? filterDaysBackward : 0);
        int filterDaysForward = (Integer)this.spnDaysInTheFuture.getValue();
        viewDisplaySettings.setFilterDaysForward(this.cbThrough.isSelected() ? filterDaysForward : 0);
        return result;
    }

    public JPanel getRightPanel() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets.bottom = 5;
        constraints.anchor = 23;
        constraints.fill = 2;
        panel.add((Component)AdvancedViewByTableMode_Messages.createLabelWithSeparator(StringResources.CHOOSE_ITEM_SOURCE_C), constraints);
        ++constraints.gridy;
        constraints.insets.bottom = 10;
        panel.add((Component)AdvancedViewByTableMode_Messages.createCheckBoxesPanel(new JCheckBox[][]{{this.cbReceived, this.cbPosted}, {this.cbSent, this.cbDraft}}), constraints);
        ++constraints.gridy;
        constraints.insets.bottom = 5;
        panel.add((Component)AdvancedViewByTableMode_Messages.createLabelWithSeparator(StringResources.CHOOSE_ITEM_TYPE_C), constraints);
        ++constraints.gridy;
        constraints.insets.bottom = 10;
        panel.add((Component)AdvancedViewByTableMode_Messages.createCheckBoxesPanel(new JCheckBox[][]{{this.cbMail, this.cbReminderNotes}, {this.cbAppointments, this.cbPhoneMessages}, {this.cbTasks, this.cbDocuments}}), constraints);
        ++constraints.gridy;
        constraints.insets.bottom = 5;
        panel.add((Component)AdvancedViewByTableMode_Messages.createLabelWithSeparator(StringResources.CHOOSE_DATE_RANGE_C), constraints);
        ++constraints.gridy;
        constraints.insets.bottom = 0;
        panel.add((Component)this.cbStarting, constraints);
        ++constraints.gridy;
        constraints.insets = new Insets(0, 20, 10, 0);
        panel.add((Component)AdvancedViewByTableMode_Messages.createSpinnerWithLabel(this.spnDaysAgo, this.lblDaysAgo), constraints);
        ++constraints.gridy;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)this.cbThrough, constraints);
        ++constraints.gridy;
        constraints.insets.left = 20;
        panel.add((Component)AdvancedViewByTableMode_Messages.createSpinnerWithLabel(this.spnDaysInTheFuture, new OrientableLabel(StringResources.DAYS_IN_THE_FUTURE)), constraints);
        ++constraints.gridy;
        constraints.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)this.cbHideItemsNotInTaskList, constraints);
        ++constraints.gridy;
        panel.add((Component)this.cbHideTasklistItems, constraints);
        ++constraints.gridy;
        constraints.insets = new Insets(0, 20, 0, 0);
        panel.add((Component)this.rbWnenCompleted, constraints);
        ++constraints.gridy;
        constraints.insets.top = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        panel.add((Component)this.rbNextDayAfterCompleted, constraints);
        return panel;
    }

    private void refreshDateRangeOptionComponents() {
        boolean isStartingSelected = this.cbStarting.isSelected();
        this.spnDaysAgo.setEnabled(isStartingSelected);
        this.cbThrough.setText(isStartingSelected ? StringResources.THROUGH : StringResources.DAYS_AGO_THROUGH_THE_FUTURE);
        boolean isThroughSelected = this.cbThrough.isSelected();
        this.spnDaysInTheFuture.setEnabled(isThroughSelected);
        this.lblDaysAgo.setText(isStartingSelected && isThroughSelected ? StringResources.DAYS_AGO : StringResources.DAYS_AGO_THROUGH_THE_FUTURE);
    }

    public JPanel getLeftPanel() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 23;
        constraints.fill = 2;
        panel.add((Component)new OrientableLabel(StringResources.SORT_BY_C), constraints);
        ++constraints.gridy;
        panel.add((Component)this.cmbSortBy, constraints);
        ++constraints.gridy;
        constraints.insets.top = 10;
        panel.add((Component)new OrientableLabel(StringResources.SORT_ORDER_C), constraints);
        ++constraints.gridy;
        constraints.insets.top = 0;
        panel.add((Component)this.cmbSortOrder, constraints);
        ++constraints.gridy;
        constraints.insets.top = 10;
        panel.add((Component)this.cbShowGroupLabels, constraints);
        ++constraints.gridy;
        constraints.insets.top = 0;
        panel.add((Component)this.cbMessagePreview, constraints);
        ++constraints.gridy;
        constraints.insets.top = 10;
        panel.add((Component)this.rbSummary, constraints);
        ++constraints.gridy;
        constraints.insets.top = 0;
        panel.add((Component)this.rbColumns, constraints);
        ++constraints.gridy;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets.top = 10;
        constraints.fill = 1;
        panel.add((Component)this.createColumnsPanel(), constraints);
        return panel;
    }

    private class HideItemsNotInTasklistListener
    implements ItemListener {
        private HideItemsNotInTasklistListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            AdvancedViewByTableMode_Messages.this.refreshHideItemsNotInTasklist();
        }
    }
}

