/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.folderproperties.viewby;

import com.novell.gw.jclient.api.interfaces.IColumnAndSortInfo;
import com.novell.gw.jclient.api.interfaces.IColumnFieldInfo;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableRadioButton;
import com.novell.gw.jclient.application.dialogs.folderproperties.viewby.ViewBy;
import com.novell.gw.jclient.application.dialogs.folderproperties.viewby.ViewBySettings;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.utils.SortOrder;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public abstract class ViewByTableMode
extends ViewBy {
    protected JRadioButton rbSummary = new OrientableRadioButton(StringResources.SUMMARY);
    protected JRadioButton rbColumns = new OrientableRadioButton(StringResources.COLUMNS);
    protected JComboBox cmbSortBy = new OrientableComboBox();
    protected JComboBox cmbSortOrder = new OrientableComboBox();
    protected JCheckBox cbShowGroupLabels = new OrientableCheckBox(StringResources.SHOW_GROUP_LABELS);
    protected static final SortOrder[] SORT_ORDERS = new SortOrder[]{SortOrder.ASCENDING, SortOrder.DESCENDING};

    protected ViewByTableMode(String userGuid, IFolder folder, ViewBySettings viewBySettings) {
        super(userGuid, folder, viewBySettings);
        this.init();
    }

    private void init() {
        ButtonGroup group = new ButtonGroup();
        group.add(this.rbColumns);
        group.add(this.rbSummary);
        this.propertyManager.addPropertyView(this.cmbSortBy);
        this.propertyManager.addPropertyView(this.cmbSortOrder);
        this.propertyManager.addPropertyView(this.cbShowGroupLabels);
        this.propertyManager.addPropertyView(this.rbColumns);
        this.propertyManager.addPropertyView(this.rbSummary);
        this.cmbSortOrder.setModel(new DefaultComboBoxModel<SortOrder>(SORT_ORDERS));
    }

    public boolean loadProperties() {
        IViewDisplaySettings viewDisplaySettings = this.getFolderDisplaySettings().asViewDisplaySettings();
        this.cbShowGroupLabels.setSelected(viewDisplaySettings.showGroupHeaders());
        if (viewDisplaySettings.isSummaryView()) {
            this.rbSummary.setSelected(true);
        } else {
            this.rbColumns.setSelected(true);
        }
        this.cmbSortBy.setModel(new DefaultComboBoxModel<IColumnFieldInfo>(GWCommandManager.getInstance(this.userGuid).getCurrentDataStore().getDisplayColumnFields(this.folder.isContactsFolder())));
        IColumnFieldInfo columnFieldInfo = viewDisplaySettings.getColumnAndSortInfo().getSortField();
        if (columnFieldInfo != null) {
            this.cmbSortBy.setSelectedItem(columnFieldInfo);
            this.cmbSortOrder.setSelectedItem(columnFieldInfo.getSortOption() == 16 ? SortOrder.ASCENDING : SortOrder.DESCENDING);
        }
        return super.loadProperties();
    }

    public boolean saveProperties() {
        boolean result = super.saveProperties();
        IViewDisplaySettings viewDisplaySettings = this.folderDisplaySettings.asViewDisplaySettings();
        viewDisplaySettings.setShowGroupHeaders(this.cbShowGroupLabels.isSelected());
        viewDisplaySettings.setSummaryView(this.rbSummary.isSelected());
        IColumnAndSortInfo columnAndSortInfo = viewDisplaySettings.getColumnAndSortInfo();
        IColumnFieldInfo[] visibleColumns = columnAndSortInfo.getVisibleColumns();
        IColumnFieldInfo sortedColumn = (IColumnFieldInfo)this.cmbSortBy.getSelectedItem();
        int sortOrder = this.cmbSortOrder.getSelectedItem().equals(SortOrder.ASCENDING) ? 16 : 17;
        sortedColumn.setSortOption(sortOrder);
        result = result && viewDisplaySettings.setColumnAndSortInfo(visibleColumns, sortedColumn);
        return result;
    }

    public JPanel getLeftPanel() {
        OrientablePanel panel = new OrientablePanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridy = 0;
        constraints.anchor = 23;
        constraints.fill = 2;
        panel.add((Component)new OrientableLabel(StringResources.SORT_BY_C), constraints);
        ++constraints.gridy;
        panel.add((Component)this.cmbSortBy, constraints);
        ++constraints.gridy;
        constraints.insets.top = 10;
        panel.add((Component)new OrientableLabel(StringResources.SORT_ORDER_C), constraints);
        ++constraints.gridy;
        constraints.insets.top = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        panel.add((Component)this.cmbSortOrder, constraints);
        return panel;
    }
}

