/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.installfolder;

import com.appframework.ApplicationFrame;
import com.appframework.components.ActionEnablerTextField;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialog;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextArea;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.dialogs.installfolder.InstallFolderDialogController;
import com.novell.gw.jclient.application.frames.search.PlainFoldersTree;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.impl.cache.FoldersCache;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.CabinetFolder;
import com.novell.gw.jclient.bl.om.folders.CalendarFolder;
import com.novell.gw.jclient.bl.om.items.GWSharedFolderNotification;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallFolderDialog
extends ApplicationDialog<InstallFolderDialogController> {
    public static final String MESSAGE_PANE = "MessagePane";
    public static final String ACCEPT_PANE = "AcceptPane";
    private JButton btnNextFinish;
    private GWSharedFolderNotification item;
    private JTextField tfName;
    private JTextArea taDescription;
    private PlainFoldersTree foldersTree;
    private JPanel pnlMessage;
    private JPanel pnlCard;
    private ActionNext actionNext = new ActionNext();
    private ActionFinish actionFinish = new ActionFinish();
    private ActionPrev actionPrev = new ActionPrev();
    private JPanel pnlAccept;

    public InstallFolderDialog(ApplicationFrame frame, GWSharedFolderNotification theItem) {
        super((Frame)frame, frame.getController());
        this.item = theItem;
        this.build();
        this.setLocationRelativeTo(this.getParent());
        this.tfName.grabFocus();
        this.tfName.selectAll();
        this.tfName.grabFocus();
    }

    private void build() {
        this.setTitle(StringResources.INSTALL_SHARED_FOLDER);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.pnlCard = new OrientablePanel(new CardLayout());
        OrientablePanel pnlButtons = new OrientablePanel(new FlowLayout(4, 0, 15));
        JButton btnPrev = new JButton(this.actionPrev);
        pnlButtons.add(btnPrev);
        this.btnNextFinish = new JButton(this.actionNext);
        pnlButtons.add(this.btnNextFinish);
        OrientablePanel pnlCancel = new OrientablePanel(new BorderLayout());
        pnlCancel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        pnlCancel.add(this.getBtnCancel());
        pnlButtons.add(pnlCancel);
        this.buildMessagePane();
        this.buildAcceptPane();
        this.pnlCard.add((Component)this.pnlAccept, ACCEPT_PANE);
        this.pnlCard.add((Component)this.pnlMessage, MESSAGE_PANE);
        this.pnlCard.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        ((CardLayout)this.pnlCard.getLayout()).show(this.pnlCard, MESSAGE_PANE);
        OrientablePanel pnlBottom = new OrientablePanel(new BorderLayout());
        pnlBottom.add((Component)new JSeparator(), "North");
        pnlBottom.add((Component)pnlButtons, "South");
        pnlBottom.setBorder(BorderFactory.createEmptyBorder(5, 10, 0, 10));
        contentPane.add((Component)pnlBottom, "South");
        contentPane.add((Component)this.pnlCard, "Center");
        this.setDefaultButton(this.btnNextFinish);
        this.pack();
    }

    private void next() {
        ((CardLayout)this.pnlCard.getLayout()).next(this.pnlCard);
    }

    private void previous() {
        ((CardLayout)this.pnlCard.getLayout()).previous(this.pnlCard);
    }

    private void buildMessagePane() {
        this.pnlMessage = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        String installMessage = StringResources.formatString(StringResources.HAS_SHARED_A_FOLDER, this.item.getSender().getDisplayText(), this.item.getSharedFolderName());
        constraints.gridx = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 0, 5, 0);
        this.pnlMessage.add((Component)new OrientableLabel(installMessage), constraints);
        this.pnlMessage.add((Component)new OrientableLabel(StringResources.TO_INSTALL_THIS_FOLDER), constraints);
        String message = StringResources.formatString(StringResources.MESSAGE_FROM_PC, this.item.getSender().getDisplayText());
        constraints.anchor = 21;
        constraints.insets.bottom = 0;
        constraints.insets.top = 20;
        this.pnlMessage.add((Component)new OrientableLabel(message), constraints);
        JTextArea taMessage = new JTextArea(6, 1);
        taMessage.setEditable(false);
        taMessage.setBackground(this.pnlMessage.getBackground());
        taMessage.setText(this.item.getMessage().getPlainText());
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.insets.bottom = 5;
        constraints.insets.top = 3;
        OrientableScrollPane scroll = new OrientableScrollPane(taMessage);
        scroll.setVerticalScrollBarPolicy(22);
        this.pnlMessage.add((Component)scroll, constraints);
        constraints.fill = 0;
        constraints.insets.top = 5;
        this.pnlMessage.add((Component)new OrientableLabel(StringResources.YOU_HAVE_BEEN_GRANTED), constraints);
        this.pnlMessage.add((Component)new OrientableLabel(this.item.getTextGrantedRights()), constraints);
        constraints.weighty = 1.0;
        this.pnlMessage.add((Component)new JPanel(), constraints);
    }

    private void buildAcceptPane() {
        this.pnlAccept = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 0, 5, 0);
        this.pnlAccept.add((Component)new OrientableLabel(StringResources.NAME_THE_NEW_FOLDER), constraints);
        constraints.insets.bottom = 0;
        constraints.insets.top = 5;
        this.pnlAccept.add((Component)new OrientableLabel(StringResources.NAME_C), constraints);
        this.tfName = new ActionEnablerTextField(this.actionFinish);
        this.tfName.setText(this.item.getSharedFolderName());
        this.tfName.selectAll();
        constraints.insets.bottom = 5;
        constraints.insets.top = 3;
        constraints.fill = 2;
        this.pnlAccept.add((Component)this.tfName, constraints);
        constraints.fill = 0;
        constraints.insets.bottom = 0;
        constraints.insets.top = 5;
        this.pnlAccept.add((Component)new OrientableLabel(StringResources.DESCRIPTION_C), constraints);
        this.taDescription = new GWTextArea(3, 1);
        constraints.insets.bottom = 5;
        constraints.insets.top = 3;
        constraints.fill = 1;
        constraints.weighty = 20.0;
        OrientableScrollPane scroll = new OrientableScrollPane(this.taDescription);
        scroll.setVerticalScrollBarPolicy(22);
        this.pnlAccept.add((Component)scroll, constraints);
        constraints.insets.bottom = 0;
        constraints.insets.top = 5;
        constraints.fill = 0;
        constraints.weighty = 0.0;
        this.pnlAccept.add((Component)new OrientableLabel(StringResources.POSITION_C), constraints);
        String userGuid = ControlsUtils.getUserGuid(this.getController());
        this.foldersTree = new PlainFoldersTree((MVCController)this.getController(), userGuid);
        this.foldersTree.addTreeSelectionListener(new IFTreeSelectionListener());
        constraints.insets.bottom = 5;
        constraints.insets.top = 3;
        constraints.weighty = 70.0;
        constraints.fill = 1;
        OrientableScrollPane scrollPane = new OrientableScrollPane(this.foldersTree);
        scrollPane.setPreferredSize(new Dimension(scrollPane.getPreferredSize().width, 200));
        this.pnlAccept.add((Component)scrollPane, constraints);
        AbstractFolder folder = this.item.isSharedCalendarNotification() ? FoldersCache.getFolder(CalendarFolder.class, userGuid) : FoldersCache.getFolder(CabinetFolder.class, userGuid);
        if (folder != null) {
            this.foldersTree.selectFolder(folder);
        }
    }

    @Override
    protected void processOkAction(ActionEvent event) {
        AbstractFolder folder = this.foldersTree.getSelectedFolder();
        IFolder newFolder = this.item.accept(this.tfName.getText(), folder, 0, this.taDescription.getText());
        if (newFolder != null) {
            ((InstallFolderDialogController)this.getController()).getActionList().performAction(ActionKey.REFRESH);
            super.processOkAction(event);
            this.dispose();
        }
    }

    @Override
    protected void doBeforeDispose() {
        this.foldersTree.clear();
        super.doBeforeDispose();
    }

    @Override
    protected InstallFolderDialogController createController(MVCController parentController) {
        return new InstallFolderDialogController(this, parentController);
    }

    private class IFTreeSelectionListener
    implements TreeSelectionListener {
        private IFTreeSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            Object selectedObject = ((DefaultMutableTreeNode)e.getPath().getLastPathComponent()).getUserObject();
            if (InstallFolderDialog.this.item.isSharedCalendarNotification()) {
                if (((AbstractFolder)selectedObject).isCalendarFolder() && !((AbstractFolder)selectedObject).isCalendarChildFolder()) {
                    InstallFolderDialog.this.actionFinish.setEnabled(true);
                } else {
                    InstallFolderDialog.this.actionFinish.setEnabled(false);
                }
            } else if (!((AbstractFolder)selectedObject).canHaveChildren() || ((AbstractFolder)selectedObject).isCalendarFolder() || ((AbstractFolder)selectedObject).isJunkMailFolder()) {
                InstallFolderDialog.this.actionFinish.setEnabled(false);
            } else if (InstallFolderDialog.this.tfName.getText().trim().length() != 0) {
                InstallFolderDialog.this.actionFinish.setEnabled(true);
            }
        }
    }

    class ActionPrev
    extends AbstractAction {
        public ActionPrev() {
            super(StringResources.PREV);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            InstallFolderDialog.this.previous();
            InstallFolderDialog.this.btnNextFinish.setAction(InstallFolderDialog.this.actionNext);
            this.setEnabled(false);
        }
    }

    class ActionFinish
    extends AbstractAction {
        public ActionFinish() {
            super(StringResources.FINISH);
        }

        public void actionPerformed(ActionEvent e) {
            InstallFolderDialog.this.processOkAction(e);
        }
    }

    class ActionNext
    extends AbstractAction {
        public ActionNext() {
            super(StringResources.NEXT_G);
        }

        public void actionPerformed(ActionEvent e) {
            InstallFolderDialog.this.next();
            InstallFolderDialog.this.btnNextFinish.setAction(InstallFolderDialog.this.actionFinish);
            InstallFolderDialog.this.actionPrev.setEnabled(true);
        }
    }
}

