/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.junkmail;

import com.novell.gw.engine.JunkMailSettings;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextArea;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableSpinner;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class JunkSettingsPanel
extends OrientablePanel {
    private JCheckBox cbJunkList = new JMnemonicCheckBox(StringResources.ENABLE_JUNK_LIST);
    private JCheckBox cbJunkPAB = new JMnemonicCheckBox(StringResources.ENABLE_JUNK_PAB);
    private JCheckBox cbJunkICalPAB = new JMnemonicCheckBox(StringResources.ENABLE_JUNK_ICAL_PAB);
    private JCheckBox cbAutoDelete = new JMnemonicCheckBox(StringResources.AUTOMATICALLY_DELETE_ITEMS);
    private JCheckBox cbBlockList = new JMnemonicCheckBox(StringResources.ENABLE_BLOCK_LIST);
    private JSpinner spinnerDays = new OrientableSpinner(new SpinnerNumberModel(new Integer(0), new Integer(0), new Integer(999), new Integer(1)));
    private static int shift = 21;
    private ActionListener changesListener;
    private boolean locked = false;
    private JLabel labelAutoDelete;

    public JunkSettingsPanel(ActionListener l) {
        if (l == null) {
            throw new NullPointerException();
        }
        this.changesListener = l;
        this.buildUI();
    }

    void setSettings(JunkMailSettings settings) {
        if (settings != null) {
            this.locked = true;
            this.cbJunkList.setSelected(settings.isJunkListEnabled());
            this.cbJunkList.setEnabled(!settings.isJunkListEnabledLocked());
            this.cbJunkPAB.setSelected(settings.isJunkPABEnabled());
            this.cbJunkPAB.setEnabled(!settings.isJunkPABEnabledLocked());
            this.cbJunkICalPAB.setSelected(settings.isJunkICalPABEnabled());
            this.cbJunkICalPAB.setEnabled(!settings.isJunkICalPABEnabledLocked());
            this.cbAutoDelete.setSelected(settings.isFolderAutoRemoveEnabled());
            this.cbAutoDelete.setEnabled(!settings.isFolderAutoRemoveEnabledLocked());
            this.spinnerDays.setEnabled(!settings.isFolderAutoRemoveEnabledLocked() && settings.isFolderAutoRemoveEnabled());
            this.labelAutoDelete.setEnabled(!settings.isFolderAutoRemoveEnabledLocked());
            this.cbBlockList.setSelected(settings.isBlockListEnabled());
            this.cbBlockList.setEnabled(!settings.isBlockListEnabledLocked());
            this.spinnerDays.setValue(new Integer(settings.getFolderRetention()));
            this.locked = false;
        }
    }

    JunkMailSettings getSettings() {
        JunkMailSettings settings = new JunkMailSettings();
        settings.setJunkListEnabled(this.cbJunkList.isSelected());
        settings.setJunkPABEnabled(this.cbJunkPAB.isSelected());
        settings.setJunkICalPABEnabled(this.cbJunkICalPAB.isSelected());
        settings.setBlockListEnabled(this.cbBlockList.isSelected());
        settings.setFolderAutoRemoveEnabled(this.cbAutoDelete.isSelected());
        settings.setFolderRetention(((Integer)this.spinnerDays.getValue()).intValue());
        return settings;
    }

    private void buildUI() {
        this.cbJunkList.addActionListener(this.changesListener);
        this.cbJunkPAB.addActionListener(this.changesListener);
        this.cbJunkICalPAB.addActionListener(this.changesListener);
        this.cbAutoDelete.addActionListener(this.changesListener);
        this.cbBlockList.addActionListener(this.changesListener);
        this.setName(StringResources.SETTINGS);
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.gridx = 0;
        c.fill = 2;
        c.insets.top = 15;
        c.weightx = 1.0;
        this.add((Component)new FlatTextArea(StringResources.JUNK_MAIL_HANDLING_PROVIDES), c);
        this.add((Component)this.createJunkMailPanel(), c);
        c.anchor = 11;
        c.weighty = 1.0;
        this.add((Component)this.createBlockedMailPanel(), c);
    }

    private JPanel createJunkMailPanel() {
        this.cbAutoDelete.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JunkSettingsPanel.this.spinnerDays.setEnabled(JunkSettingsPanel.this.cbAutoDelete.isSelected());
            }
        });
        this.spinnerDays.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (JunkSettingsPanel.this.locked) {
                    return;
                }
                JunkSettingsPanel.this.changesListener.actionPerformed(null);
            }
        });
        OrientablePanel content = new OrientablePanel(new GridBagLayout());
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(StringResources.JUNK_MAIL), BorderFactory.createEmptyBorder(1, 5, 5, 5));
        content.setBorder(border);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 0;
        content.add((Component)new FlatTextArea(StringResources.YOU_CAN_SPECIFY), c);
        c.fill = 0;
        ++c.gridy;
        c.insets.top = 5;
        content.add((Component)this.cbJunkList, c);
        c.fill = 2;
        ++c.gridy;
        c.insets.top = 0;
        c.insets.left = shift;
        content.add((Component)new FlatTextArea(StringResources.ENABLE_JUNK_LIST_COMMENT), c);
        c.fill = 0;
        ++c.gridy;
        c.insets.top = 5;
        c.insets.left = 0;
        content.add((Component)this.cbJunkPAB, c);
        c.fill = 2;
        ++c.gridy;
        c.insets.top = 0;
        c.insets.left = shift;
        content.add((Component)new FlatTextArea(StringResources.ENABLE_JUNK_PAB_COMMENT), c);
        c.fill = 0;
        ++c.gridy;
        c.insets.top = 5;
        c.insets.left = 0;
        content.add((Component)this.cbJunkICalPAB, c);
        c.fill = 2;
        ++c.gridy;
        c.insets.top = 0;
        c.insets.left = shift;
        content.add((Component)new FlatTextArea(StringResources.ENABLE_JUNK_ICAL_PAB_COMMENT), c);
        ++c.gridy;
        c.insets.top = 10;
        c.insets.left = 0;
        content.add((Component)new OrientableLabel(StringResources.JUNK_MAIL_FOLDER_C), c);
        c.fill = 0;
        ++c.gridy;
        c.insets.top = 5;
        c.gridwidth = 1;
        c.weightx = 0.0;
        content.add((Component)this.cbAutoDelete, c);
        c.fill = 0;
        c.gridx = 1;
        content.add((Component)this.spinnerDays, c);
        c.fill = 2;
        c.gridx = 2;
        c.insets.left = shift;
        c.weightx = 1.0;
        this.labelAutoDelete = new OrientableLabel(StringResources.DAYS_AFTER_DELIVERY);
        content.add((Component)this.labelAutoDelete, c);
        return content;
    }

    private JPanel createBlockedMailPanel() {
        OrientablePanel content = new OrientablePanel(new GridBagLayout());
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(StringResources.JUNK_MAIL), BorderFactory.createEmptyBorder(1, 5, 5, 5));
        content.setBorder(border);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.gridx = 0;
        c.fill = 0;
        c.weightx = 1.0;
        content.add((Component)this.cbBlockList, c);
        c.fill = 2;
        c.insets.top = 0;
        c.insets.left = shift;
        content.add((Component)new FlatTextArea(StringResources.ENABLE_BLOCK_LIST_COMMENT), c);
        return content;
    }

    private static class FlatTextArea
    extends GWTextArea {
        public FlatTextArea(String theText) {
            this();
            this.setText(theText);
        }

        public FlatTextArea() {
            this.setEditable(false);
            this.setOpaque(false);
        }
    }
}

