/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.junkmail;

import com.novell.gw.engine.JunkMailList;
import com.novell.gw.jclient.application.HeaderRenderer;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.itemlisttable.IconsFactory;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import org.apache.log4j.Logger;

class JunkTableModel
extends AbstractTableModel {
    private static Logger logger = Logger.getLogger(JunkTableModel.class);
    private JunkMailList junkMailList;
    private String[] columns = new String[]{"", StringResources.ADDRESS_DOMAIN, StringResources.LAST_USED, StringResources.COUNT};
    private JTableHeader tableHeader;
    private int sortDirection = -1;
    private static final int SORTUP = 1;
    private static final int SORTDOWN = 0;
    private int sortColumn = 0;

    public JunkTableModel(JunkMailList theJunkMailList) {
        this.junkMailList = theJunkMailList;
    }

    public String getColumnName(int column) {
        if (column < 0 || column >= 4) {
            return "";
        }
        return this.columns[column];
    }

    public int getRowCount() {
        return this.junkMailList.getSize();
    }

    public int getColumnCount() {
        return 4;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                if (this.junkMailList.getItemAddressType(rowIndex) == 1) {
                    return ImageResources.FLD_USER;
                }
                if (this.junkMailList.getItemAddressType(rowIndex) == 2) {
                    return ImageResources.ICON_ADDRESS_BOOK_GROUP;
                }
            }
            case 1: {
                return this.junkMailList.getItemAddress(rowIndex);
            }
            case 2: {
                return this.junkMailList.getItemLastUsedDateString(rowIndex);
            }
            case 3: {
                return String.valueOf(this.junkMailList.getItemUseCount(rowIndex));
            }
        }
        return null;
    }

    public void setTableHeader(JTableHeader tableHeader) {
        this.tableHeader = tableHeader;
        this.tableHeader.setDefaultRenderer(new CurrentHeaderSortRenderer(ControlsUtils.getHeaderRendererSize()));
        this.initListeners();
    }

    private void initListeners() {
        this.tableHeader.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                JTableHeader tableHeader = (JTableHeader)e.getSource();
                int column = tableHeader.getColumnModel().getColumnIndexAtX(e.getPoint().x);
                if (column == 0) {
                    return;
                }
                if (column != JunkTableModel.this.sortColumn) {
                    JunkTableModel.this.sortDirection = 0;
                } else if (JunkTableModel.this.sortDirection == 1) {
                    JunkTableModel.this.sortDirection = 0;
                } else {
                    JunkTableModel.this.sortDirection++;
                }
                JunkTableModel.this.sortColumn = column;
                tableHeader.resizeAndRepaint();
                JunkTableModel.this.junkMailList.sort(JunkTableModel.this.getSortField(JunkTableModel.this.sortColumn), JunkTableModel.this.sortDirection == 0);
                JunkTableModel.this.fireTableDataChanged();
            }
        });
    }

    private int getSortField(int sortColumn) {
        if (sortColumn == 1) {
            return 1511;
        }
        if (sortColumn == 2) {
            return 1515;
        }
        return 1514;
    }

    private class CurrentHeaderSortRenderer
    extends HeaderRenderer {
        public CurrentHeaderSortRenderer(Dimension thePreferedSize) {
            super(thePreferedSize);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            HeaderRenderer headerRenderer = (HeaderRenderer)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (column == JunkTableModel.this.sortColumn && JunkTableModel.this.sortDirection != -1) {
                if (JunkTableModel.this.sortDirection == 1) {
                    headerRenderer.setIcon(IconsFactory.getAscendingSortIcon());
                } else {
                    headerRenderer.setIcon(IconsFactory.getDescendingSortIcon());
                }
            } else {
                headerRenderer.setIcon(IconsFactory.getBlankSortIcon());
            }
            return headerRenderer;
        }
    }
}

