/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.login;

import com.appframework.utils.OS;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePasswordField;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class MailServerLoginDialog
extends GWDialog {
    private String userName;
    private String serverName;
    private String accountName;
    private char[] userPassword;
    private boolean savePassword;
    private JCheckBox cbSavePassword;
    private JTextField tfUserName;
    private JPasswordField pfUserPassword;

    public MailServerLoginDialog(JFrame theFrame, String userName, String password, boolean savePassword, String serverName, String accountName) {
        super(theFrame);
        this.userName = userName;
        this.userPassword = password.toCharArray();
        this.savePassword = savePassword;
        this.serverName = serverName;
        this.accountName = accountName;
        this.init();
        this.buildUI();
        this.pack();
    }

    private void init() {
        this.tfUserName = new GWTextField(this.userName);
        this.tfUserName.setBorder(BorderFactory.createLoweredBevelBorder());
        this.pfUserPassword = new OrientablePasswordField(String.valueOf(this.userPassword));
        this.cbSavePassword = new OrientableCheckBox(StringResources.SAVE_PASSWORD);
        this.cbSavePassword.setSelected(this.savePassword);
        this.setTitle(StringResources.formatString(StringResources.LOGON_TO, this.accountName));
    }

    private void buildUI() {
        this.panCenterPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 2;
        constraints.anchor = 21;
        constraints.fill = 2;
        constraints.insets = new Insets(10, 10, 10, 10);
        this.panCenterPanel.add((Component)new OrientableLabel(StringResources.ENTER_A_USER_NAME_AND_PASSWORD_FOR_T_F_S), constraints);
        ++constraints.gridy;
        constraints.gridwidth = 1;
        constraints.insets.bottom = 0;
        this.panCenterPanel.add((Component)new OrientableLabel(StringResources.SERVER_C), constraints);
        ++constraints.gridy;
        this.panCenterPanel.add((Component)new OrientableLabel(StringResources.USER_NAME_C), constraints);
        ++constraints.gridy;
        this.panCenterPanel.add((Component)new OrientableLabel(StringResources.PASSWORD_C), constraints);
        ++constraints.gridy;
        this.panCenterPanel.add((Component)new JPanel(), constraints);
        ++constraints.gridx;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.weightx = 1.0;
        this.panCenterPanel.add((Component)new OrientableLabel(this.serverName), constraints);
        ++constraints.gridy;
        this.panCenterPanel.add((Component)this.tfUserName, constraints);
        ++constraints.gridy;
        this.panCenterPanel.add((Component)this.pfUserPassword, constraints);
        ++constraints.gridy;
        constraints.insets.bottom = 10;
        this.panCenterPanel.add((Component)this.cbSavePassword, constraints);
        OrientablePanel panel = new OrientablePanel();
        OS.addButtons(panel, this.btnOK, this.btnCancel);
        this.panBottomPanel.add(panel);
    }

    protected void performOkAction() {
        super.performOkAction();
    }

    public String getUserName() {
        return this.tfUserName.getText();
    }

    public boolean isSavePassword() {
        return this.cbSavePassword.isSelected();
    }

    public char[] getUserPassword() {
        return this.pfUserPassword.getPassword();
    }
}

