/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.newfolder;

import com.appframework.mvc.GlobalCommand;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialog;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialogController;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.folderproperties.SharingPropertyPane;
import com.novell.gw.jclient.application.dialogs.newfolder.FolderNamePane;
import com.novell.gw.jclient.application.dialogs.newfolder.FolderTypePane;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.impl.cache.FoldersCache;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.ItemListsCache;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateFolderDialog
extends ApplicationDialog<ApplicationDialogController> {
    private static Logger logger = Logger.getLogger(CreateFolderDialog.class);
    public static final String FOLDER_TYPE_PANE = "FolderTypePane";
    public static final String FOLDER_NAME_PANE = "FolderNamePane";
    public static final String FOLDER_PROPERTIES_PANE = "FolderPropertiesPane";
    public static final String FOLDER_SHARING_PANE = "FolderSharingPane";
    private JPanel pnlPanes = new OrientablePanel(new CardLayout());
    private AbstractAction nextAction = new NextAction();
    private AbstractAction finishAction = new FinishAction();
    private AbstractButton btnNext = new JMnemonicButton(this.nextAction);
    private AbstractButton btnPrev = new JMnemonicButton(new PrevAction());
    private FolderTypePane folderTypePane;
    private SharingPropertyPane sharingPropertyPane = new SharingPropertyPane(this, (MVCController)this.getController());
    private FolderNamePane folderNamePane;
    private String currentPane = "FolderTypePane";

    public CreateFolderDialog(JFrame parentFrame, MVCController parentController, AbstractFolder parentFolder) {
        super((Frame)parentFrame, (MVCController)(parentController == null ? ((MVCView)((Object)parentFrame)).getController() : parentController));
        this.folderNamePane = new FolderNamePane((MVCController)this.getController(), parentFolder, this.btnNext);
        this.folderTypePane = new FolderTypePane((MVCController)this.getController(), this.folderNamePane);
        this.buildUI();
        this.folderTypePane.setPersonalFolderType();
    }

    @Override
    protected ApplicationDialogController createController(MVCController parentController) {
        return new ApplicationDialogController<CreateFolderDialog>(this, parentController);
    }

    private void buildUI() {
        this.pnlPanes.add((Component)this.folderTypePane, FOLDER_TYPE_PANE);
        this.pnlPanes.add((Component)this.buildSharingPane(), FOLDER_SHARING_PANE);
        this.pnlPanes.add((Component)this.folderNamePane, FOLDER_NAME_PANE);
        JPanel pnlContent = (JPanel)this.getContentPane();
        OrientablePanel pnlButtons = new OrientablePanel(new GridLayout(-1, 2));
        pnlButtons.add(this.btnPrev);
        pnlButtons.add(this.btnNext);
        OrientablePanel pnlTemp = new OrientablePanel(new FlowLayout(4, 0, 0));
        pnlTemp.add(pnlButtons);
        OrientablePanel pnlCancel = new OrientablePanel(new FlowLayout(1, 0, 0));
        pnlCancel.add(this.getBtnCancel());
        pnlCancel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        pnlTemp.add(pnlCancel);
        OrientablePanel pnlBottom = new OrientablePanel(new BorderLayout());
        pnlBottom.add((Component)new JSeparator(), "North");
        pnlBottom.add((Component)pnlTemp, "South");
        pnlTemp.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        pnlBottom.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        pnlContent.add((Component)this.pnlPanes, "Center");
        pnlContent.add((Component)pnlBottom, "South");
    }

    private JPanel buildSharingPane() {
        OrientablePanel pnlContent = new OrientablePanel(new BorderLayout(0, 10));
        pnlContent.add((Component)new OrientableLabel(StringResources.ENTER_THE_NAMES_OF_PEOPLE), "North");
        pnlContent.add((Component)this.sharingPropertyPane, "Center");
        pnlContent.setBorder(BorderFactory.createEmptyBorder(10, 20, 40, 40));
        return pnlContent;
    }

    private void next() {
        String nextPane = "";
        if (this.currentPane.equals(FOLDER_TYPE_PANE)) {
            nextPane = FOLDER_NAME_PANE;
            if (!this.folderTypePane.isSharingFolderType()) {
                this.btnNext.setAction(this.finishAction);
            }
        } else if (this.folderTypePane.isSharingFolderType()) {
            nextPane = FOLDER_SHARING_PANE;
            this.btnNext.setAction(this.finishAction);
        }
        this.showPane(nextPane);
        this.btnPrev.setEnabled(true);
    }

    private void prev() {
        String prevPane;
        if (this.currentPane.equals(FOLDER_SHARING_PANE)) {
            prevPane = FOLDER_NAME_PANE;
        } else {
            prevPane = FOLDER_TYPE_PANE;
            this.btnPrev.setEnabled(false);
        }
        this.btnNext.setAction(this.nextAction);
        this.showPane(prevPane);
    }

    private void showPane(String pane) {
        ((CardLayout)this.pnlPanes.getLayout()).show(this.pnlPanes, pane);
        this.currentPane = pane;
    }

    private void createFolder() {
        block6: {
            String folderName = this.folderNamePane.getFolderName();
            String folderDescription = this.folderNamePane.getFolderDescription();
            AbstractFolder parentFolder = this.folderNamePane.getParentFolder();
            int folderPosition = this.folderNamePane.getFolderPosition();
            String userGuid = ControlsUtils.getUserGuid(this.getController());
            try {
                FoldersCache.clear();
                ItemListsCache.clear();
                AbstractFolder newFolder = this.folderTypePane.isSharingFolderType() ? GWCommandManager.getInstance(userGuid).createSharedFolder(folderName, folderDescription, parentFolder, folderPosition, this.sharingPropertyPane.getFolderSharedAccessList()) : GWCommandManager.getInstance(userGuid).createFolder(folderName, folderDescription, parentFolder, folderPosition);
                if (newFolder == null) {
                    return;
                }
                AbstractFolder selectedFolder = GWClient.getGWMainAppFrame().getFolder();
                if (selectedFolder == parentFolder || selectedFolder.getID().equals(parentFolder)) {
                    GlobalCommand cmd = new GlobalCommand(1090, parentFolder);
                    cmd.setAttribute("FORCE_REFRESH", Boolean.TRUE);
                    ((ApplicationDialogController)this.getController()).processCommand(cmd);
                }
                this.dispose();
            }
            catch (EngineException e) {
                logger.error((Object)e);
                if (e.getErrorCode() != 53331 || 0 != JOptionPane.showConfirmDialog(this, StringResources.YOU_SHARE_LIST_IS_EMPTY, StringResources.NOVELL_GROUPWISE, 0)) break block6;
                try {
                    GWCommandManager.getInstance(userGuid).createFolder(folderName, folderDescription, parentFolder, folderPosition);
                    this.dispose();
                }
                catch (EngineException e1) {
                    logger.error((Object)e1);
                }
            }
        }
    }

    private class PrevAction
    extends AbstractAction {
        public PrevAction() {
            super(StringResources.PREV);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            CreateFolderDialog.this.prev();
        }
    }

    private class NextAction
    extends AbstractAction {
        public NextAction() {
            super(StringResources.NEXT_G);
        }

        public void actionPerformed(ActionEvent e) {
            CreateFolderDialog.this.next();
        }
    }

    private class FinishAction
    extends AbstractAction {
        public FinishAction() {
            super(StringResources.FINISH);
        }

        public void actionPerformed(ActionEvent e) {
            CreateFolderDialog.this.createFolder();
        }
    }
}

