/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.newfolder;

import com.appframework.components.EmptyStringDocumentListener;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextArea;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.dialogs.newfolder.FolderNamePaneController;
import com.novell.gw.jclient.application.frames.search.PlainFoldersTree;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.impl.cache.FoldersCache;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.CabinetFolder;
import com.novell.gw.jclient.bl.om.folders.NormalFolder;
import com.novell.gw.jclient.bl.om.folders.SharedFolder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;

public class FolderNamePane
extends OrientablePanel
implements MVCView {
    private JTextComponent tfName = new GWTextField();
    private JTextComponent taDescription = new GWTextArea(3, 1);
    private PlainFoldersTree foldersTree;
    private AbstractFolder parentFolder;
    private AbstractFolder newFolder;
    private AbstractAction actionUp = new MoveUPFolderAction();
    private AbstractAction actionDown = new MoveDownFolderAction();
    private AbstractAction actionRight = new MoveRightFolderAction();
    private AbstractAction actionLeft = new MoveLeftFolderAction();
    private MVCController controller;
    private boolean wasShown = false;
    private int folderStartPosition = 0;

    public FolderNamePane(MVCController controller, AbstractFolder folder, AbstractButton btnNext) {
        this.controller = new FolderNamePaneController(this, controller);
        this.parentFolder = folder;
        this.tfName.getDocument().addDocumentListener(new EmptyStringDocumentListener(btnNext));
        this.tfName.setText(StringResources.NEW_FOLDER);
        this.setLayout(new GridBagLayout());
        this.buildUI();
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.tfName.getDocument().addDocumentListener(new FNDocumentListener());
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                FolderNamePane.this.tfName.requestFocus();
                FolderNamePane.this.tfName.selectAll();
                if (!FolderNamePane.this.wasShown) {
                    FolderNamePane.this.foldersTree.scrollFolderToBottom(FolderNamePane.this.newFolder);
                    FolderNamePane.this.wasShown = true;
                }
            }
        });
    }

    public FolderNamePane(MVCController controller, AbstractFolder folder, AbstractButton btnNext, boolean disableNameEditing) {
        this(controller, folder, btnNext);
        if (disableNameEditing) {
            this.tfName.setEnabled(false);
        }
    }

    public FolderNamePane(MVCController controller, AbstractFolder folder, AbstractButton btnNext, boolean disableNameEditing, int folderStartPosition) {
        this(controller, folder, btnNext, disableNameEditing);
        this.folderStartPosition = folderStartPosition;
    }

    private void buildUI() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.gridwidth = 1;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 0, 5, 0);
        this.add((Component)new OrientableLabel(StringResources.NAME_THE_NEW_FOLDER), constraints);
        constraints.insets.bottom = 0;
        constraints.insets.top = 5;
        ++constraints.gridy;
        this.add((Component)new OrientableLabel(StringResources.NAME_C), constraints);
        this.tfName.selectAll();
        constraints.insets.bottom = 5;
        constraints.insets.top = 3;
        constraints.fill = 2;
        ++constraints.gridy;
        this.add((Component)this.tfName, constraints);
        constraints.fill = 0;
        constraints.insets.bottom = 0;
        constraints.insets.top = 5;
        ++constraints.gridy;
        this.add((Component)new OrientableLabel(StringResources.DESCRIPTION_C), constraints);
        constraints.insets.bottom = 5;
        constraints.insets.top = 3;
        constraints.fill = 1;
        constraints.weighty = 0.0;
        constraints.ipady = 25;
        OrientableScrollPane scroll = new OrientableScrollPane(this.taDescription);
        scroll.setVerticalScrollBarPolicy(22);
        ++constraints.gridy;
        this.add((Component)scroll, constraints);
        constraints.ipady = 0;
        constraints.insets.bottom = 0;
        constraints.insets.top = 5;
        constraints.fill = 0;
        constraints.weighty = 0.0;
        ++constraints.gridy;
        this.add((Component)new OrientableLabel(StringResources.POSITION_C), constraints);
        String userGuid = ControlsUtils.getUserGuid(this.controller);
        this.foldersTree = new PlainFoldersTree(this.controller, userGuid);
        constraints.insets.bottom = 5;
        constraints.insets.top = 3;
        constraints.weighty = 1.0;
        constraints.gridwidth = 1;
        constraints.fill = 1;
        ++constraints.gridy;
        OrientableScrollPane scroll1 = new OrientableScrollPane(this.foldersTree);
        scroll1.setPreferredSize(new Dimension(300, 150));
        this.add((Component)scroll1, constraints);
        constraints.gridx = 1;
        constraints.anchor = 23;
        constraints.fill = 2;
        constraints.insets.left = 10;
        constraints.weightx = 0.0;
        this.add((Component)this.buildButtonsPane(), constraints);
        if (!this.parentFolder.canHaveChildren() || this.parentFolder.isCalendarFolder()) {
            this.parentFolder = FoldersCache.getFolder(CabinetFolder.class, userGuid);
        }
    }

    public void setController(MVCController theController) {
    }

    public MVCController getController() {
        return null;
    }

    public void setMVCModel(Object theModel) {
        this.addNewFolder((Boolean)theModel);
    }

    public Object getMVCModel() {
        return null;
    }

    private void addNewFolder(boolean isShared) {
        this.foldersTree.setRefreshBlocked(true);
        DefaultMutableTreeNode node = this.foldersTree.getFolderNode(this.parentFolder);
        this.newFolder = isShared ? new SharedFolder() : new NormalFolder();
        this.newFolder.setName(this.tfName.getText());
        this.newFolder.setExist(false);
        DefaultMutableTreeNode folderNode = this.foldersTree.getFolderNode(this.newFolder);
        if (folderNode != null) {
            folderNode.removeFromParent();
        }
        int insertPosition = this.folderStartPosition;
        if (this.folderStartPosition == -1) {
            insertPosition = node.getChildCount();
        }
        node.insert(new DefaultMutableTreeNode(this.newFolder), insertPosition);
        this.foldersTree.updateFolderNode(node, this.newFolder);
        this.enableActions(this.newFolder);
        this.foldersTree.scrollFolderToBottom(this.newFolder);
    }

    private JPanel buildButtonsPane() {
        OrientablePanel pnlButtons = new OrientablePanel();
        pnlButtons.setLayout(new BoxLayout(pnlButtons, 1));
        OrientablePanel pnlButtons1 = new OrientablePanel(new GridLayout(-1, 1, 0, 5));
        OrientablePanel pnlButtons2 = new OrientablePanel(new GridLayout(-1, 1, 0, 5));
        pnlButtons1.add(new JMnemonicButton(this.actionUp));
        pnlButtons1.add(new JMnemonicButton(this.actionDown));
        pnlButtons2.add(new JMnemonicButton(this.actionLeft));
        pnlButtons2.add(new JMnemonicButton(this.actionRight));
        pnlButtons2.setBorder(BorderFactory.createEmptyBorder(15, 0, 0, 0));
        pnlButtons.add(pnlButtons1);
        pnlButtons.add(pnlButtons2);
        return pnlButtons;
    }

    private void enableActions(AbstractFolder folder) {
        this.foldersTree.enableActions(folder, this.actionUp, this.actionDown, this.actionRight, this.actionLeft);
    }

    public String getFolderName() {
        return this.tfName.getText();
    }

    public void setFolderName(String folderName) {
        this.tfName.setText(folderName);
    }

    public String getFolderDescription() {
        return this.taDescription.getText();
    }

    public AbstractFolder getParentFolder() {
        DefaultMutableTreeNode folderNode = this.foldersTree.getFolderNode(this.newFolder);
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)folderNode.getParent();
        return (AbstractFolder)parent.getUserObject();
    }

    public int getFolderPosition() {
        DefaultMutableTreeNode folderNode = this.foldersTree.getFolderNode(this.newFolder);
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)folderNode.getParent();
        int index = parent.getIndex(folderNode);
        if (index > 0) {
            AbstractFolder previousFolder = ((AbstractFolder)parent.getUserObject()).getChildFolders().get(index - 1);
            index = previousFolder.getNativeFolder().getSequenceNumber() + 1;
        }
        return index;
    }

    public void requestFocusForName() {
        this.tfName.requestFocus();
    }

    private class FNDocumentListener
    implements DocumentListener {
        private FNDocumentListener() {
        }

        private void updateFolderName() {
            FolderNamePane.this.newFolder.setName(FolderNamePane.this.tfName.getText());
            FolderNamePane.this.foldersTree.updateUI();
        }

        public void changedUpdate(DocumentEvent e) {
            this.updateFolderName();
        }

        public void insertUpdate(DocumentEvent e) {
            this.updateFolderName();
        }

        public void removeUpdate(DocumentEvent e) {
            this.updateFolderName();
        }
    }

    private class MoveRightFolderAction
    extends AbstractAction {
        public MoveRightFolderAction() {
            super(StringResources.RIGHT);
        }

        public void actionPerformed(ActionEvent e) {
            FolderNamePane.this.foldersTree.moveRightFolder(FolderNamePane.this.newFolder);
            FolderNamePane.this.enableActions(FolderNamePane.this.newFolder);
        }
    }

    private class MoveLeftFolderAction
    extends AbstractAction {
        public MoveLeftFolderAction() {
            super(StringResources.LEFT);
        }

        public void actionPerformed(ActionEvent e) {
            FolderNamePane.this.foldersTree.moveLeftFolder(FolderNamePane.this.newFolder);
            FolderNamePane.this.enableActions(FolderNamePane.this.newFolder);
        }
    }

    private class MoveDownFolderAction
    extends AbstractAction {
        public MoveDownFolderAction() {
            super(StringResources.DOWN);
        }

        public void actionPerformed(ActionEvent e) {
            FolderNamePane.this.foldersTree.moveDownFolder(FolderNamePane.this.newFolder);
            FolderNamePane.this.enableActions(FolderNamePane.this.newFolder);
        }
    }

    private class MoveUPFolderAction
    extends AbstractAction {
        public MoveUPFolderAction() {
            super(StringResources.UP);
        }

        public void actionPerformed(ActionEvent e) {
            FolderNamePane.this.foldersTree.moveUpFolder(FolderNamePane.this.newFolder);
            FolderNamePane.this.enableActions(FolderNamePane.this.newFolder);
        }
    }
}

