/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.rules;

import com.appframework.ActionList;
import com.appframework.mvc.MVCController;
import com.appframework.utils.OS;
import com.novell.gw.engine.Filter;
import com.novell.gw.engine.ItemListFilter;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialog;
import com.novell.gw.jclient.application.controls.filter.OpenFilterDialog;
import com.novell.gw.jclient.application.controls.filter.SaveFilterDialog;
import com.novell.gw.jclient.application.controls.gwcalendar.CalendarScrollPane;
import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextArea;
import com.novell.gw.jclient.application.controls.menus.GWMenu;
import com.novell.gw.jclient.application.controls.orientable.MenuItemFactory;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableMenuItem;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.rules.AdvancedConditionsDialogActionList;
import com.novell.gw.jclient.application.dialogs.rules.GroupPane;
import com.novell.gw.jclient.application.dialogs.rules.OperatorButton;
import com.novell.gw.jclient.application.dialogs.rules.RowPane;
import com.novell.gw.jclient.application.dialogs.rules.RowPaneInfo;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.eng_impl.GWEngineUtils;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.MenuElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvancedConditionsDialog
extends ApplicationDialog<AdvancedConditionsDialogActionList> {
    public static final int MIN_ROW_COUNT_TO_SCROLL = 8;
    public static final int PREFERRED_WIDTH = 635;
    public static final int PREFERRED_HEIGHT = (int)(Toolkit.getDefaultToolkit().getScreenSize().getHeight() / 4.0);
    private OperatorButton btnOperator;
    private JPanel pnlCenter = new OrientablePanel(new GridLayout(0, 1, 0, 10));
    private RowPane selectedRow;
    private RemoveRowAction actionRemoveRow = new RemoveRowAction();
    private JPopupMenu popupCondition = new GWPopupMenu();
    private NewGroupAction actionNewGroup = new NewGroupAction();
    private AddRowAction actionAddRow = new AddRowAction();
    private JTextArea taDescription;
    private Filter filter;
    private String userGuid;
    private boolean isRule = true;

    public AdvancedConditionsDialog(JDialog dialog, MVCController controller, Filter theFilter, String userGuid) {
        super((Dialog)dialog, controller);
        this.userGuid = userGuid;
        this.filter = theFilter;
        this.setController(new AdvancedConditionsDialogActionList(this, controller));
        this.setTitle(StringResources.DEFINE_CONDITIONS);
        this.buildUI();
    }

    public AdvancedConditionsDialog(JDialog dialog, MVCController controller, Filter filter, String userGuid, boolean isRule) {
        this(dialog, controller, filter, userGuid);
        this.isRule = isRule;
    }

    @Override
    protected AdvancedConditionsDialogActionList createController(MVCController parentController) {
        return new AdvancedConditionsDialogActionList(this, parentController);
    }

    private void buildPopup() {
        ButtonGroup group = new ButtonGroup();
        JMenuItem menuItem = MenuItemFactory.createCkeckBoxMenuItem(new AndOrAction(0));
        menuItem.setText(StringResources.AND);
        this.popupCondition.add(menuItem);
        group.add(menuItem);
        menuItem = MenuItemFactory.createCkeckBoxMenuItem(new AndOrAction(1));
        menuItem.setText(StringResources.OR);
        this.popupCondition.add(menuItem);
        group.add(menuItem);
        this.popupCondition.addSeparator();
        menuItem = OS.createMenuItemForAction(this.actionAddRow);
        this.popupCondition.add(menuItem);
        group.add(menuItem);
        menuItem = OS.createMenuItemForAction(this.actionRemoveRow);
        this.popupCondition.add(menuItem);
        group.add(menuItem);
        this.popupCondition.addSeparator();
        menuItem = OS.createMenuItemForAction(this.actionNewGroup);
        this.popupCondition.add(menuItem);
        group.add(menuItem);
        menuItem = MenuItemFactory.createCkeckBoxMenuItem(new EndAction());
        this.popupCondition.add(menuItem);
        group.add(menuItem);
    }

    private void readFilterData() {
        this.filter = this.isRule ? new Filter(GWCommandManager.getInstance(this.userGuid).getCurrentDataStore().getNativeDataStore(), true) : new Filter(GWCommandManager.getInstance(this.userGuid).getCurrentDataStore().getNativeDataStore(), new ItemListFilter(), false);
        for (GroupPane group : this.getGroups()) {
            if (!group.isFirstGroup()) {
                this.filter.addRowGroup(group.getGroupOperator());
            }
            for (RowPaneInfo rowPaneInfo : group.getRowPanesInfo()) {
                this.filter.addRow(rowPaneInfo.getFieldID(), rowPaneInfo.getOperatorID(), rowPaneInfo.getValueType(), rowPaneInfo.getValue(), rowPaneInfo.getRowOperator());
            }
        }
        if (!this.isRule) {
            this.filter.render();
        }
    }

    private GroupPane[] getGroups() {
        ArrayList<Component> result = new ArrayList<Component>();
        int nCount = this.pnlCenter.getComponentCount();
        for (int i = 0; i < nCount; ++i) {
            if (!(this.pnlCenter.getComponent(i) instanceof GroupPane)) continue;
            result.add(this.pnlCenter.getComponent(i));
        }
        return result.toArray(new GroupPane[0]);
    }

    private void buildUI() {
        JMenuBar mb = new JMenuBar();
        this.setJMenuBar(mb);
        GWMenu m = new GWMenu(StringResources.FIND);
        mb.add(m);
        OpenAction openAction = new OpenAction();
        m.add(openAction.getMenuItem());
        SaveAction saveAction = new SaveAction();
        m.add(saveAction.getMenuItem());
        OrientablePanel pnlContent = new OrientablePanel(){

            public Dimension getPreferredSize() {
                Dimension preferredSize = super.getPreferredSize();
                if (preferredSize.width < 635) {
                    preferredSize.width = 635;
                }
                return preferredSize;
            }
        };
        this.setContentPane(pnlContent);
        this.buildPopup();
        pnlContent.setLayout(new BorderLayout(5, 5));
        this.pnlCenter.setLayout(new BoxLayout(this.pnlCenter, 1));
        int rowCount = this.filter.getRowCount();
        ArrayList<RowPane> rowPanes = new ArrayList<RowPane>(rowCount);
        boolean isFirstGroup = true;
        int groupOperator = -1;
        if (rowCount == 0) {
            rowPanes.add(this.buildRow());
        }
        for (int i = 0; i < rowCount; ++i) {
            if (this.filter.isGroup(i)) {
                GroupPane groupPane = new GroupPane(isFirstGroup, rowPanes);
                if (groupOperator != -1) {
                    groupPane.setGroupOperator(groupOperator);
                }
                groupOperator = this.filter.getGroupOperator(i);
                this.pnlCenter.add(groupPane);
                isFirstGroup = false;
                rowPanes.clear();
                continue;
            }
            rowPanes.add(new RowPane((ActionList)this.getController(), this.filter, this.filter.getRow(i)));
        }
        GroupPane groupPane = new GroupPane(isFirstGroup, rowPanes);
        if (groupOperator != -1) {
            groupPane.setGroupOperator(groupOperator);
        }
        this.pnlCenter.add(groupPane);
        OrientablePanel pnlTemp = new OrientablePanel(new BorderLayout());
        pnlTemp.add((Component)this.pnlCenter, "North");
        DefinedSizeScrollPane scroll = new DefinedSizeScrollPane(pnlTemp);
        scroll.setBorder(null);
        pnlContent.add((Component)scroll, "Center");
        pnlContent.add((Component)this.buildButtonsPane(), "After");
        this.taDescription = new GWTextArea();
        this.taDescription.setText(StringResources.INCLUDE_ENTRIES_WHERE_D);
        this.taDescription.setEditable(false);
        this.taDescription.setOpaque(false);
        pnlContent.add((Component)this.taDescription, "North");
        pnlContent.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
    }

    private RowPane buildRow() {
        return new RowPane((ActionList)this.getController(), this.filter, null);
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void processRowSelection(JButton theSelectedButton) {
        this.btnOperator = (OperatorButton)theSelectedButton;
        this.selectedRow = (RowPane)theSelectedButton.getParent();
        this.selectPopupMenuItem(theSelectedButton.getText());
        GroupPane groupPane = AdvancedConditionsDialog.findGroupPane(this.selectedRow);
        boolean isLastRow = groupPane.getRowCount() == 1 && groupPane.isFirstGroup();
        this.actionRemoveRow.setEnabled(!isLastRow);
        this.popupCondition.show(theSelectedButton, 0, 0);
    }

    private Container buildButtonsPane() {
        OrientablePanel pnlContent = new OrientablePanel(new BorderLayout());
        OrientablePanel buttonPanel = new OrientablePanel(new GridLayout(0, 1, 0, 5));
        OrientableButton btnClear = new OrientableButton(new ClearAction());
        this.setDefaultButton(this.getBtnOk());
        buttonPanel.add(this.getBtnOk());
        buttonPanel.add(this.getBtnCancel());
        buttonPanel.add(btnClear);
        pnlContent.add((Component)buttonPanel, "North");
        return pnlContent;
    }

    private void selectPopupMenuItem(String theItemText) {
        for (MenuElement menuElement : this.popupCondition.getSubElements()) {
            JMenuItem menuItem;
            if (!(menuElement instanceof JMenuItem) || !(menuItem = (JMenuItem)menuElement).getText().equals(theItemText)) continue;
            menuItem.setSelected(true);
            break;
        }
    }

    private static GroupPane findGroupPane(RowPane innerComponent) {
        Container parent;
        for (parent = innerComponent.getParent(); parent != null && !(parent instanceof GroupPane); parent = parent.getParent()) {
        }
        return (GroupPane)parent;
    }

    private int getGroupPaneIndex(GroupPane theGroupPane) {
        Component component;
        int result = 0;
        int n = this.pnlCenter.getComponentCount();
        for (int i = 0; i < n && !(component = this.pnlCenter.getComponent(i)).equals(theGroupPane); ++i) {
            if (!(component instanceof GroupPane)) continue;
            ++result;
        }
        return result;
    }

    private GroupPane getNextGroup(GroupPane theGroupPane) {
        int index = this.getGroupPaneIndex(theGroupPane);
        if (index < this.pnlCenter.getComponentCount() - 1) {
            return (GroupPane)this.pnlCenter.getComponent(++index);
        }
        return null;
    }

    private GroupPane getPrevGroup(GroupPane theGroupPane) {
        int index = this.getGroupPaneIndex(theGroupPane);
        if (index > 0) {
            return (GroupPane)this.pnlCenter.getComponent(--index);
        }
        return null;
    }

    private int getTotalRowsCount() {
        int result = 0;
        for (GroupPane group : this.getGroups()) {
            if (!group.isFirstGroup()) {
                ++result;
            }
            result += group.getRowCount();
        }
        return result;
    }

    private void scrollToVisible() {
        this.pnlCenter.scrollRectToVisible(new Rectangle(0, this.pnlCenter.getHeight(), 10, 100));
    }

    private void updateSize() {
        if (this.getTotalRowsCount() <= 8) {
            this.pack();
        } else {
            this.scrollToVisible();
        }
    }

    @Override
    protected void processOkAction(ActionEvent event) {
        this.readFilterData();
        super.processOkAction(event);
    }

    private class DefinedSizeScrollPane
    extends CalendarScrollPane {
        public DefinedSizeScrollPane(Component view) {
            super(view);
            this.setHorizontalScrollBarPolicy(31);
        }

        public Dimension getPreferredSize() {
            Dimension preferredSize = super.getPreferredSize();
            if (preferredSize.height > PREFERRED_HEIGHT) {
                preferredSize = new Dimension(preferredSize.width, PREFERRED_HEIGHT);
            }
            return preferredSize;
        }
    }

    private class SaveAction
    extends AbstractAction {
        public SaveAction() {
            super(StringResources.SAVE_D);
        }

        public void actionPerformed(ActionEvent e) {
            String user = EngineCommandManager.getUserGuid();
            IDataStore dataStore = EngineCommandManager.getInstance(user).getCurrentDataStore();
            AdvancedConditionsDialog.this.readFilterData();
            SaveFilterDialog dlg = new SaveFilterDialog(AdvancedConditionsDialog.this, GWEngineUtils.createFilter(new ItemListFilter(AdvancedConditionsDialog.this.getFilter()), dataStore));
            dlg.showMe();
        }

        public OrientableMenuItem getMenuItem() {
            return new OrientableMenuItem(this);
        }
    }

    private class OpenAction
    extends AbstractAction {
        public OpenAction() {
            super(StringResources.OPEN_D);
        }

        public void actionPerformed(ActionEvent e) {
            OpenFilterDialog dlg = new OpenFilterDialog(AdvancedConditionsDialog.this);
            dlg.showMe();
            if (dlg.isActionCompleteSuccessfully()) {
                String user = EngineCommandManager.getUserGuid();
                IDataStore dataStore = EngineCommandManager.getInstance(user).getCurrentDataStore();
                ItemListFilter itemListFilter = dlg.getFilter().getItemListFilter();
                AdvancedConditionsDialog.this.pnlCenter.removeAll();
                AdvancedConditionsDialog.this.filter = new Filter(dataStore.getNativeDataStore(), itemListFilter, AdvancedConditionsDialog.this.isRule);
                AdvancedConditionsDialog.this.buildUI();
                AdvancedConditionsDialog.this.pack();
                AdvancedConditionsDialog.this.repaint();
                AdvancedConditionsDialog.this.validate();
            }
        }

        public OrientableMenuItem getMenuItem() {
            return new OrientableMenuItem(this);
        }
    }

    private class ClearAction
    extends AbstractAction {
        public ClearAction() {
            super(StringResources.CLEAR);
        }

        public void actionPerformed(ActionEvent e) {
            AdvancedConditionsDialog.this.pnlCenter.removeAll();
            RowPane[] rowPanes = new RowPane[]{AdvancedConditionsDialog.this.buildRow()};
            AdvancedConditionsDialog.this.pnlCenter.add(new GroupPane(true, Arrays.asList(rowPanes)));
            AdvancedConditionsDialog.this.pnlCenter.updateUI();
            AdvancedConditionsDialog.this.pack();
        }
    }

    private class RemoveRowAction
    extends AbstractAction {
        public RemoveRowAction() {
            super(StringResources.DELETE_ROW);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            GroupPane groupPane = AdvancedConditionsDialog.findGroupPane(AdvancedConditionsDialog.this.selectedRow);
            if (groupPane.getRowCount() == 1) {
                AdvancedConditionsDialog.this.getPrevGroup(groupPane).getLastRowPane().setRowOperator(2);
                AdvancedConditionsDialog.this.pnlCenter.remove(groupPane);
            } else {
                groupPane.deleteRow(AdvancedConditionsDialog.this.selectedRow);
                if (AdvancedConditionsDialog.this.getNextGroup(groupPane) == null) {
                    groupPane.getLastRowPane().setRowOperator(2);
                } else {
                    groupPane.getLastRowPane().setRowOperator(3);
                }
            }
            AdvancedConditionsDialog.this.pnlCenter.updateUI();
            if (AdvancedConditionsDialog.this.getTotalRowsCount() <= 8) {
                AdvancedConditionsDialog.this.pack();
            }
        }
    }

    private class NewGroupAction
    extends AbstractAction {
        public NewGroupAction() {
            super(StringResources.NEW_GROUP);
        }

        public void actionPerformed(ActionEvent e) {
            GroupPane groupPane = AdvancedConditionsDialog.findGroupPane(AdvancedConditionsDialog.this.selectedRow);
            RowPane[] rowPanes = groupPane.removeRowsAfter(AdvancedConditionsDialog.this.selectedRow);
            if (rowPanes.length == 0) {
                rowPanes = new RowPane[]{AdvancedConditionsDialog.this.buildRow()};
            }
            AdvancedConditionsDialog.this.pnlCenter.add((Component)new GroupPane(false, Arrays.asList(rowPanes)), AdvancedConditionsDialog.this.getGroupPaneIndex(groupPane) + 1);
            AdvancedConditionsDialog.this.updateSize();
            groupPane.getLastRowPane().setRowOperator(3);
        }
    }

    private class AddRowAction
    extends AbstractAction {
        public AddRowAction() {
            super(StringResources.INSERT_ROW);
        }

        public void actionPerformed(ActionEvent e) {
            GroupPane groupPane = AdvancedConditionsDialog.findGroupPane(AdvancedConditionsDialog.this.selectedRow);
            RowPane rowPane = AdvancedConditionsDialog.this.buildRow();
            groupPane.insertRow(AdvancedConditionsDialog.this.selectedRow, rowPane);
            AdvancedConditionsDialog.this.updateSize();
            if (!AdvancedConditionsDialog.this.btnOperator.getText().equals(StringResources.OR)) {
                AdvancedConditionsDialog.this.selectedRow.setRowOperator(0);
            }
            if (AdvancedConditionsDialog.this.getNextGroup(groupPane) != null) {
                groupPane.getLastRowPane().setRowOperator(3);
            }
        }
    }

    private class EndAction
    extends AbstractAction {
        public EndAction() {
            super(StringResources.END);
        }

        public void actionPerformed(ActionEvent e) {
            GroupPane groupPane = AdvancedConditionsDialog.findGroupPane(AdvancedConditionsDialog.this.selectedRow);
            GroupPane nextGroup = AdvancedConditionsDialog.this.getNextGroup(groupPane);
            while (nextGroup != null) {
                AdvancedConditionsDialog.this.pnlCenter.remove(nextGroup);
                nextGroup = AdvancedConditionsDialog.this.getNextGroup(groupPane);
            }
            while (!groupPane.getLastRowPane().equals(AdvancedConditionsDialog.this.selectedRow)) {
                groupPane.deleteRow(groupPane.getLastRowPane());
            }
            AdvancedConditionsDialog.this.selectedRow.setRowOperator(2);
        }
    }

    private class AndOrAction
    extends AbstractAction {
        int operator;

        public AndOrAction(int operator) {
            this.operator = operator;
        }

        public void actionPerformed(ActionEvent e) {
            AdvancedConditionsDialog.this.btnOperator.setOperator(this.operator);
            GroupPane groupPane = AdvancedConditionsDialog.findGroupPane(AdvancedConditionsDialog.this.selectedRow);
            int count = groupPane.getRowCount();
            int index = groupPane.getRowIndex(AdvancedConditionsDialog.this.selectedRow);
            if (--count == index) {
                AdvancedConditionsDialog.this.actionAddRow.actionPerformed(null);
            }
        }
    }
}

