/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.rules;

import com.novell.gw.engine.Filter;
import com.novell.gw.jclient.api.enums.CategoryListRecordStatusType;
import com.novell.gw.jclient.api.impl.APIWrapperManager;
import com.novell.gw.jclient.api.interfaces.ICategory;
import com.novell.gw.jclient.api.interfaces.ICategoryList;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.rules.AbstractConditionField;
import com.novell.gw.jclient.application.dialogs.rules.RowPaneInfo;
import com.novell.gw.jclient.application.frames.options.compose.send.SelectCategoryControl;
import com.novell.gw.jclient.bl.om.categories.CategoryUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class CategoryConditionField
extends AbstractConditionField {
    private static Logger logger = Logger.getLogger(CategoryConditionField.class);
    private JPanel pnlCondition;
    private JPanel pnlContent = new OrientablePanel(new BorderLayout(5, 0));
    private SelectCategoryControl selectCategoriesControl;
    private String userGuid;

    public CategoryConditionField(Filter.FilterData fieldData, Filter theFilter, String userGuid) {
        super(fieldData, theFilter);
        this.userGuid = userGuid;
        this.selectCategoriesControl = new SelectCategoryControl(CategoryUtils.createNewCategoryList(userGuid), false, userGuid);
    }

    public Container getConditionPane() {
        if (this.pnlCondition == null) {
            this.pnlCondition = new OrientablePanel(new BorderLayout(5, 0));
            this.buildUI();
            if (this.rowInfo != null) {
                this.updateRowInfo();
            }
        }
        return this.pnlContent;
    }

    protected void operatorChanged(Filter.FilterData operator) {
        this.rebuildContent(this.getValidValueType().getType());
    }

    private void buildUI() {
        this.buildPopup();
        this.rebuildContent(this.getValidValueType().getType());
        this.pnlContent.add((Component)this.btnCondition, "Before");
    }

    private void rebuildContent(int type) {
        this.pnlContent.remove(this.pnlCondition);
        this.pnlCondition.removeAll();
        switch (type) {
            case 7: {
                this.selectCategoriesControl.setPreferredSize(new Dimension(150, this.selectCategoriesControl.getPreferredSize().height));
                this.pnlCondition.add((Component)this.selectCategoriesControl, "Center");
            }
        }
        this.pnlContent.add((Component)this.pnlCondition, "Center");
        this.pnlContent.updateUI();
    }

    public RowPaneInfo getRowInfo() {
        RowPaneInfo rowInfo = super.getRowInfo();
        int valueType = this.getValidValueType().getType();
        rowInfo.setValueType(valueType);
        Filter.FilterValue filterValue = new Filter.FilterValue(this.filter);
        if (valueType == 7) {
            ICategory c = this.selectCategoriesControl.getCategories().getCategoryAt(0);
            filterValue.setCategory(c.getNativeCategory());
        }
        rowInfo.setValue(filterValue);
        return rowInfo;
    }

    protected void updateRowInfo() {
        super.updateRowInfo();
        if (this.getValidValueType().getType() == 7) {
            ICategoryList c = CategoryUtils.createNewCategoryList(this.userGuid);
            c.addCategory(APIWrapperManager.getCategory(this.rowInfo.getValue().getValue().getCategory()), CategoryListRecordStatusType.ADD);
            this.selectCategoriesControl.setCategories(c);
        }
    }
}

