/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.rules;

import com.appframework.ActionList;
import com.appframework.utils.UIUtils;
import com.novell.gw.engine.Filter;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.rules.AbstractConditionField;
import com.novell.gw.jclient.application.dialogs.rules.AllFilterFieldsDialog;
import com.novell.gw.jclient.application.dialogs.rules.OperatorButton;
import com.novell.gw.jclient.application.dialogs.rules.RowPaneInfo;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.apache.log4j.Logger;

class RowPane
extends OrientablePanel {
    private static Logger logger = Logger.getLogger(RowPane.class);
    private OperatorButton btnOperator;
    private JComboBox cbFields = new OrientableComboBox();
    private ActionList actionList;
    private boolean isAdded;
    private Filter filter;
    private Filter.RowInfo rowInfo;
    private String userGuid;

    public RowPane(ActionList actionList, Filter theFilter, Filter.RowInfo rowInfo) {
        this.actionList = actionList;
        this.rowInfo = rowInfo;
        this.filter = theFilter;
        this.userGuid = ControlsUtils.getUserGuid(actionList);
        this.setLayout(new BorderLayout(5, 0));
        this.buildUI();
        this.cbFields.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent event) {
                if (RowPane.this.isAdded) {
                    return;
                }
                RowPane.this.isAdded = true;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (RowPane.this.rowInfo == null) {
                            RowPane.this.showPopup();
                        }
                    }
                });
            }

            public void ancestorRemoved(AncestorEvent event) {
            }

            public void ancestorMoved(AncestorEvent event) {
            }
        });
    }

    private void showPopup() {
        this.cbFields.requestFocus();
        this.cbFields.showPopup();
    }

    public void setRowOperator(int operator) {
        this.btnOperator.setOperator(operator);
    }

    private void buildUI() {
        this.btnOperator = new OperatorButton(this.actionList.getAction(ActionKey.SHOW_CONDITION_POPUP));
        this.btnOperator.setHorizontalTextPosition(10);
        UIUtils.setButtonPreferedSize(this.btnOperator, new String[]{StringResources.AND, StringResources.OR, StringResources.INSERT_ROW, StringResources.DELETE_ROW, StringResources.NEW_GROUP, StringResources.END});
        Filter.FilterData[] recentlyUsedFields = this.filter.getRecentlyUsedFields();
        AbstractConditionField selectedField = null;
        for (int i = 0; i < recentlyUsedFields.length; ++i) {
            Filter.FilterData recentlyUsedField = recentlyUsedFields[i];
            AbstractConditionField conditionField = AbstractConditionField.createConditionField(recentlyUsedField, this.filter, this.userGuid);
            if (this.rowInfo != null && this.rowInfo.getField().getId() == recentlyUsedField.getId()) {
                selectedField = conditionField;
            }
            this.cbFields.addItem(conditionField);
        }
        if (selectedField == null && this.rowInfo != null) {
            AbstractConditionField conditionField;
            selectedField = conditionField = AbstractConditionField.createConditionField(this.rowInfo.getField(), this.filter, this.userGuid);
            this.cbFields.addItem(conditionField);
        }
        this.cbFields.addItem(StringResources.ALL_FIELDS_C);
        this.add((Component)this.cbFields, "Before");
        this.buildDefaultPane();
        this.add((Component)this.btnOperator, "After");
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.cbFields.setSelectedItem(null);
        this.cbFields.addItemListener(new RPItemListener());
        if (this.rowInfo != null) {
            if (selectedField != null) {
                selectedField.setRowInfo(this.rowInfo);
            }
            this.cbFields.setSelectedItem(selectedField);
            this.btnOperator.setOperator(this.rowInfo.getRowOperator());
        }
    }

    public RowPaneInfo getRowPaneInfo() {
        Object selectedItem = this.cbFields.getSelectedItem();
        if (selectedItem instanceof AbstractConditionField) {
            AbstractConditionField conditionField = (AbstractConditionField)selectedItem;
            RowPaneInfo rowInfo = conditionField.getRowInfo();
            rowInfo.setRowOperator(this.btnOperator.getOperator());
            return rowInfo;
        }
        return null;
    }

    private void buildDefaultPane() {
        OrientablePanel pnlDefault = new OrientablePanel(new BorderLayout(5, 0));
        OrientableButton btnTemp = new OrientableButton(ImageResources.ADV_FILTER_UP_DOWN);
        btnTemp.setEnabled(false);
        pnlDefault.add((Component)btnTemp, "Before");
        GWTextField tfTemp = new GWTextField();
        tfTemp.setEditable(false);
        pnlDefault.add((Component)tfTemp, "Center");
        this.add((Component)pnlDefault, "Center");
        this.btnOperator.setEnabled(false);
        this.updateUI();
    }

    private void removeAllButButton() {
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            if (!(this.getComponent(i) instanceof JPanel)) continue;
            this.remove(this.getComponent(i));
            break;
        }
        this.updateUI();
    }

    private static class RPListRenderrer
    extends DefaultListCellRenderer {
        public RPListRenderrer() {
            this.setBackground(Color.white);
            this.setForeground(Color.white);
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component listCellRendererComponent = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            }
            if (index == list.getModel().getSize() - 1) {
                this.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.BLACK));
            }
            return listCellRendererComponent;
        }
    }

    private class RPItemListener
    implements ItemListener {
        private RPItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                JComboBox cbFields = (JComboBox)e.getSource();
                if (cbFields.getSelectedIndex() == cbFields.getItemCount() - 1) {
                    AllFilterFieldsDialog dialog = new AllFilterFieldsDialog((JDialog)RowPane.this.getTopLevelAncestor(), RowPane.this.filter);
                    cbFields.setEnabled(false);
                    dialog.showMe();
                    if (dialog.isActionCompleteSuccessfully()) {
                        AbstractConditionField field = AbstractConditionField.createConditionField(dialog.getSelectedField(), RowPane.this.filter, RowPane.this.userGuid);
                        cbFields.insertItemAt(field, cbFields.getItemCount() - 1);
                        cbFields.setSelectedItem(field);
                        cbFields.setEnabled(true);
                    } else {
                        cbFields.setEnabled(true);
                        cbFields.setSelectedItem(null);
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                RowPane.this.showPopup();
                            }
                        });
                    }
                } else {
                    RowPane.this.removeAllButButton();
                    if (e.getItem() instanceof AbstractConditionField) {
                        AbstractConditionField item = (AbstractConditionField)e.getItem();
                        RowPane.this.add((Component)item.getConditionPane(), "Center");
                        RowPane.this.btnOperator.setEnabled(true);
                        RowPane.this.updateUI();
                    } else {
                        RowPane.this.buildDefaultPane();
                    }
                }
            }
        }
    }
}

