/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.saveasdialog;

import com.appframework.ApplicationFrame;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.api.enums.AttachmentDownloadState;
import com.novell.gw.jclient.api.interfaces.message.IAttachment;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.api.interfaces.message.IMessageAttachment;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.basicdialogs.OkCancelDialog;
import com.novell.gw.jclient.application.controls.filechoser.FileChooserPanel;
import com.novell.gw.jclient.application.controls.filechoser.GWFileChooser;
import com.novell.gw.jclient.application.controls.filechoser.GWMacFileChooser;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableList;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.options.OptionsDefaults;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.GWItemFactory;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.exceptions.GWException;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.DocumentItem;
import com.novell.gw.jclient.bl.om.items.GWAttachment;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import com.novell.gw.jclient.bl.store.GWItemSerializer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveAsDialog
extends OkCancelDialog {
    private static final Logger logger = Logger.getLogger(SaveAsDialog.class);
    private JTextField tfSaveAs;
    private FileChooserPanel fileChooserPanel;
    private String currentDir = ApplicationOptions.getInstance().getString("LAST_ITEM_SAVING_PATH", OptionsDefaults.LAST_ITEM_SAVING_PATH);
    private AbstractItem item;
    private JList itemsList;
    private JComboBox cmbMailExtension;
    private JCheckBox cbReportConflict;
    private boolean isDocument;
    private String userGuid;
    private final Action actionRetrieve = new ActionRetrieve();
    private final Action actionSave = new ActionSave();

    private SaveAsDialog(ApplicationFrame theParent) {
        super(theParent);
        this.userGuid = theParent.getUserGuid();
        this.getBtnCancel().setText(StringResources.CLOSE);
        this.buildUI();
    }

    private void buildUI() {
        this.setTitle(StringResources.SAVE);
        JComponent content = (JComponent)this.getContentPane();
        content.setLayout(new BorderLayout());
        content.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
        content.add((Component)this.buildMainPanel(), "Center");
        content.add((Component)this.buildButtonsPanel(), "After");
        this.getBtnOk().setAction(this.actionSave);
    }

    public static void showSaveAsDialog(AbstractItem theItem, ApplicationFrame parent, int[] selectedIndices) {
        SaveAsDialog dialog = new SaveAsDialog(parent);
        dialog.setItem(theItem);
        if (selectedIndices != null) {
            dialog.selectAttachments(selectedIndices);
        }
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
    }

    private void selectAttachments(int[] selectedIndices) {
        this.itemsList.setSelectedIndices(selectedIndices);
    }

    private void setItem(AbstractItem item) {
        this.item = item;
        this.fileChooserPanel.setText(this.currentDir);
        this.setModelToList();
        this.setSaveAsText();
        this.setSaveAsExtension();
        this.itemsList.addListSelectionListener(new ItemsListSelectionListener());
    }

    private void setModelToList() {
        Vector<ListItem> vector = new Vector<ListItem>();
        this.isDocument = this.item instanceof DocumentItem;
        if (this.isDocument) {
            this.cmbMailExtension.setEnabled(false);
        }
        SaveAsDialog.findAllAttachmentsAndItems(this.item, vector);
        this.itemsList.setListData(vector);
        this.itemsList.setSelectedIndex(0);
    }

    private static void findAllAttachmentsAndItems(AbstractItem item, Vector<ListItem> vector) {
        if (!(item instanceof DocumentItem)) {
            vector.add(new ListItem(item));
        }
        for (GWAttachment attachment : item.getAttachments()) {
            IAttachment nativeAttachment = attachment.getNativeAttachment();
            if (nativeAttachment instanceof IMessageAttachment) {
                try {
                    IMessage message = ((IMessageAttachment)nativeAttachment).getMessage();
                    AbstractItem newItem = GWItemFactory.gwObjectToItem(message);
                    SaveAsDialog.findAllAttachmentsAndItems(newItem, vector);
                }
                catch (GWCommandException e) {
                    logger.error((Object)e);
                }
                continue;
            }
            vector.add(new ListItem(attachment));
        }
    }

    private void setSaveAsText() {
        int selected = this.itemsList.getSelectedValues().length;
        if (selected <= 0) {
            return;
        }
        Object object = ((ListItem)this.itemsList.getSelectedValues()[selected - 1]).getObject();
        if (object instanceof AbstractItem) {
            this.tfSaveAs.setText(SaveAsDialog.getFileNameFromSubject(((AbstractItem)object).getSubject()));
        } else if (object instanceof GWAttachment) {
            this.tfSaveAs.setText(SaveAsDialog.getFileNameFromSubject(((GWAttachment)object).getName()));
        }
        this.tfSaveAs.setEditable(selected == 1 && !this.isDocument);
    }

    private static String removeAttachmentExtension(String fileName, String otherExtension) {
        String[] extensions = GWItemSerializer.getPosibleFileExtensions();
        int nLen = extensions.length;
        for (int i = 0; i < nLen; ++i) {
            if (!fileName.endsWith(extensions[i])) continue;
            int x = fileName.lastIndexOf(extensions[i]);
            fileName = x > 0 ? fileName.substring(0, x - 1) : fileName;
        }
        if (otherExtension != null && fileName.endsWith(otherExtension)) {
            int x = fileName.lastIndexOf(otherExtension);
            fileName = x > 0 ? fileName.substring(0, x - 1) : fileName;
        }
        return fileName;
    }

    private void setSaveAsExtension() {
        String text = this.tfSaveAs.getText();
        if (this.itemsList.getSelectedIndices().length == 1 && this.itemsList.getSelectedIndex() == 0) {
            if (text.endsWith(this.cmbMailExtension.getSelectedItem().toString()) || this.isDocument) {
                return;
            }
            text = SaveAsDialog.removeAttachmentExtension(text, null);
            this.tfSaveAs.setText(text + '.' + this.cmbMailExtension.getSelectedItem());
        } else {
            GWAttachment attachment;
            int selected = this.itemsList.getSelectedValues().length;
            if (selected <= 0) {
                return;
            }
            Object object = ((ListItem)this.itemsList.getSelectedValues()[selected - 1]).getObject();
            if (object instanceof GWAttachment && (attachment = (GWAttachment)object).isMessageAttachment()) {
                this.cmbMailExtension.setEnabled(true);
                text = SaveAsDialog.removeAttachmentExtension(text, "doc");
                this.tfSaveAs.setText(text + '.' + this.cmbMailExtension.getSelectedItem());
            }
        }
    }

    private JComponent buildButtonsPanel() {
        OrientablePanel result = new OrientablePanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 1;
        c.insets = new Insets(0, 10, 0, 0);
        result.add((Component)this.getBtnOk(), c);
        c.gridy = 1;
        c.insets = new Insets(10, 10, 0, 0);
        result.add((Component)this.getBtnCancel(), c);
        c.gridy = 2;
        c.weighty = 1.0;
        result.add((Component)new OrientableLabel(), c);
        return result;
    }

    private JPanel buildMainPanel() {
        OrientablePanel result = new OrientablePanel(new BorderLayout(0, 5));
        OrientableLabel label = new OrientableLabel(StringResources.ITEMS_TO_SAVE_C);
        result.add((Component)label, "North");
        this.itemsList = new OrientableList(){};
        this.itemsList.setCellRenderer(new ListRenderer());
        result.add((Component)new OrientableScrollPane(this.itemsList), "Center");
        result.add((Component)this.buildSaveAsPanel(), "South");
        return result;
    }

    private JPanel buildSaveAsPanel() {
        OrientablePanel content = new OrientablePanel(new GridBagLayout());
        content.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagConstraints c = new GridBagConstraints();
        this.cbReportConflict = new OrientableCheckBox(StringResources.REPORT_FILENAME_CONFLICTS);
        this.cbReportConflict.setSelected(true);
        Object[] str = new String[]{StringResources.SAVE_TO_DISK};
        OrientableComboBox cmbSaveTo = new OrientableComboBox(str);
        this.cmbMailExtension = new OrientableComboBox(GWItemSerializer.getPosibleFileExtensions());
        this.cmbMailExtension.addActionListener(new CmbMailExtensionListenert());
        this.tfSaveAs = new GWTextField();
        this.fileChooserPanel = new FileChooserPanel(StringResources.CURRENT_DIRECTORY_C, "", 1);
        int space = 10;
        Insets spaced_insets = new Insets(space, 0, 0, 0);
        Insets empty_insets = new Insets(0, 0, 0, 0);
        c.anchor = 21;
        c.fill = 0;
        c.gridx = 0;
        c.insets = spaced_insets;
        c.weightx = 1.0;
        content.add((Component)this.cbReportConflict, c);
        content.add((Component)cmbSaveTo, c);
        c.fill = 0;
        content.add((Component)new OrientableLabel(StringResources.SAVE_MAIL_AS_C), c);
        c.fill = 2;
        c.insets = empty_insets;
        content.add((Component)this.cmbMailExtension, c);
        c.fill = 0;
        c.insets = spaced_insets;
        content.add((Component)new OrientableLabel(StringResources.SAVE_FILE_AS_C), c);
        c.fill = 2;
        c.gridwidth = 2;
        c.insets = empty_insets;
        content.add((Component)this.tfSaveAs, c);
        this.tfSaveAs.setPreferredSize(new Dimension(200, this.tfSaveAs.getPreferredSize().height));
        c.gridwidth = 1;
        c.insets = spaced_insets;
        content.add((Component)this.fileChooserPanel, c);
        return content;
    }

    private static boolean isEmbeddedItem(Object object) {
        if (object instanceof GWAttachment) {
            GWAttachment gwAttachment = (GWAttachment)object;
            return gwAttachment.isMessageAttachment();
        }
        return false;
    }

    private boolean saveSelectedItems() {
        boolean isSaved = false;
        int selected = this.itemsList.getSelectedValues().length;
        for (int i = 0; i < selected; ++i) {
            ListItem li = (ListItem)this.itemsList.getSelectedValues()[i];
            Object object = li.getObject();
            boolean isEmbeddedItem = SaveAsDialog.isEmbeddedItem(object);
            if (object instanceof AbstractItem || isEmbeddedItem) {
                if (isEmbeddedItem) {
                    GWAttachment gwAttachment = (GWAttachment)object;
                    try {
                        li.setSaved(this.saveGWItem(GWCommandManager.getInstance(this.userGuid).getEnclosedItem(gwAttachment)));
                    }
                    catch (GWCommandException e) {
                        logger.error((Object)e, (Throwable)e);
                        ErrorDialog.processGWException(e);
                    }
                } else {
                    li.setSaved(this.saveGWItem((AbstractItem)object));
                }
            } else if (object instanceof GWAttachment) {
                this.saveAttachment((GWAttachment)object);
                li.setSaved(true);
            }
            isSaved |= li.isSaved();
            isEmbeddedItem = false;
        }
        if (isSaved) {
            this.setListSelection();
            this.itemsList.updateUI();
        }
        return isSaved;
    }

    private void setListSelection() {
        if (this.itemsList.getSelectedIndices().length == 0) {
            return;
        }
        int selected = this.itemsList.getSelectedIndices()[this.itemsList.getSelectedValues().length - 1];
        this.itemsList.clearSelection();
        boolean isSelectionSet = this.setSelectionToNextUnsaved(selected + 1);
        if (!isSelectionSet) {
            isSelectionSet = this.setSelectionToNextUnsaved(0);
        }
        if (!isSelectionSet) {
            this.itemsList.setSelectedIndex(selected);
        }
    }

    private boolean setSelectionToNextUnsaved(int start) {
        boolean result = false;
        ListModel model = this.itemsList.getModel();
        int nSize = model.getSize();
        for (int i = start; i < nSize; ++i) {
            ListItem li = (ListItem)model.getElementAt(i);
            if (li.isSaved()) continue;
            this.itemsList.setSelectedIndex(i);
            this.itemsList.ensureIndexIsVisible(i);
            result = true;
            break;
        }
        return result;
    }

    private boolean saveGWItem(AbstractItem theItem) {
        String fileName = this.fileChooserPanel.getText() + Utils.FILE_SEPARATOR;
        fileName = this.tfSaveAs.isEditable() ? fileName + this.tfSaveAs.getText() : fileName + SaveAsDialog.getFileNameFromSubject(theItem.getSubject()) + '.' + this.cmbMailExtension.getSelectedItem();
        if (!this.canSaveToFile(fileName)) {
            return false;
        }
        try {
            GWItemSerializer.saveAs(fileName, this.cmbMailExtension.getSelectedItem().toString(), theItem, false, false);
        }
        catch (GWException e) {
            JOptionPane.showMessageDialog(this, StringResources.UNKNOWN_FILE_EXTENSION);
            return false;
        }
        return true;
    }

    private boolean saveAttachment(GWAttachment theGWAttachment) {
        String fileName = this.fileChooserPanel.getText() + Utils.FILE_SEPARATOR;
        fileName = this.tfSaveAs.isEditable() ? fileName + this.tfSaveAs.getText() : fileName + SaveAsDialog.getFileNameFromSubject(theGWAttachment.getFileName());
        if (!this.canSaveToFile(fileName)) {
            return false;
        }
        MessageUtils.saveAttachment(theGWAttachment, fileName);
        return true;
    }

    private boolean canSaveToFile(String fileName) {
        File file = new File(fileName);
        if (this.cbReportConflict.isSelected() && file.exists()) {
            int res = JOptionPane.showConfirmDialog(this, StringResources.formatString(StringResources.FILE_ALREADY_EXISTS_OVERWRITE_Q, file.getPath()), StringResources.SAVE + ' ' + file.getName(), 0, 2);
            return res != 1;
        }
        return true;
    }

    private static String getFileNameFromSubject(String theSubject) {
        String fileName = theSubject;
        fileName = fileName.replaceAll("/", "_");
        fileName = fileName.replaceAll("\\\\", "_");
        fileName = fileName.replaceAll("\\*", "_");
        return fileName;
    }

    private static boolean isDownloadedAttachments(GWAttachment attachment) {
        return attachment.getNativeAttachment().getDownloadState() == AttachmentDownloadState.DOWNLOADED;
    }

    private static boolean isQueuedForDownloadAttachments(GWAttachment attachment) {
        return attachment.getNativeAttachment().getDownloadState() == AttachmentDownloadState.QUEUED_FOR_DOWNLOAD;
    }

    private static void doDownload(Object o) {
        if (o instanceof GWAttachment && ((GWAttachment)o).getDownloadState() != AttachmentDownloadState.DOWNLOADED) {
            ((GWAttachment)o).getNativeAttachment().checkDownloadStateAndStartRetrieve();
        }
    }

    static class ListItem {
        private boolean isSaved = false;
        private Object object;

        public ListItem(Object theObject) {
            this.object = theObject;
        }

        public boolean isSaved() {
            return this.isSaved;
        }

        public void setSaved(boolean saved) {
            this.isSaved = saved;
        }

        public Object getObject() {
            return this.object;
        }
    }

    private class ActionRetrieve
    extends AbstractAction {
        private ActionRetrieve() {
            super(StringResources.RETRIEVE);
        }

        public void actionPerformed(ActionEvent e) {
            for (Object o : SaveAsDialog.this.itemsList.getSelectedValues()) {
                Object selectedObject = ((ListItem)o).getObject();
                if (!(selectedObject instanceof GWAttachment) || SaveAsDialog.isDownloadedAttachments((GWAttachment)selectedObject) || SaveAsDialog.isQueuedForDownloadAttachments((GWAttachment)selectedObject)) continue;
                SaveAsDialog.doDownload(selectedObject);
            }
            SaveAsDialog.this.getBtnOk().setEnabled(false);
        }
    }

    private class CmbMailExtensionListenert
    extends AbstractAction {
        private CmbMailExtensionListenert() {
        }

        public void actionPerformed(ActionEvent e) {
            SaveAsDialog.this.setSaveAsExtension();
        }
    }

    class ItemsListSelectionListener
    implements ListSelectionListener {
        int lastSelectedIndex = 0;

        ItemsListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            JButton btnOk = SaveAsDialog.this.getBtnOk();
            if (SaveAsDialog.this.itemsList.getSelectedIndices().length == 0) {
                btnOk.setEnabled(false);
                return;
            }
            btnOk.setEnabled(true);
            boolean isMultySelect = SaveAsDialog.this.itemsList.getSelectedIndices().length > 1;
            SaveAsDialog.this.tfSaveAs.setEditable(!isMultySelect);
            if (isMultySelect) {
                SaveAsDialog.this.tfSaveAs.setText("");
                this.lastSelectedIndex = -1;
            } else {
                if (SaveAsDialog.this.itemsList.getSelectedIndices()[0] != this.lastSelectedIndex) {
                    SaveAsDialog.this.setSaveAsText();
                    SaveAsDialog.this.setSaveAsExtension();
                }
                this.lastSelectedIndex = SaveAsDialog.this.itemsList.getSelectedIndices()[0];
            }
            SaveAsDialog.this.cmbMailExtension.setEnabled(false);
            boolean needRetrieving = false;
            boolean isEnabledRetrieving = false;
            boolean hasForSaving = false;
            for (Object o : SaveAsDialog.this.itemsList.getSelectedValues()) {
                Object selectedObject = ((ListItem)o).getObject();
                if (selectedObject instanceof GWAttachment && !SaveAsDialog.isDownloadedAttachments((GWAttachment)selectedObject)) {
                    needRetrieving = true;
                    if (!SaveAsDialog.isQueuedForDownloadAttachments((GWAttachment)selectedObject)) {
                        isEnabledRetrieving = true;
                    }
                } else {
                    hasForSaving = true;
                }
                if (!(selectedObject instanceof AbstractItem) && !SaveAsDialog.isEmbeddedItem(selectedObject) || selectedObject instanceof DocumentItem) continue;
                SaveAsDialog.this.cmbMailExtension.setEnabled(true);
            }
            if (hasForSaving) {
                SaveAsDialog.this.getBtnOk().setAction(SaveAsDialog.this.actionSave);
                SaveAsDialog.this.getBtnOk().setEnabled(!needRetrieving);
            } else {
                SaveAsDialog.this.getBtnOk().setAction(SaveAsDialog.this.actionRetrieve);
                SaveAsDialog.this.getBtnOk().setEnabled(isEnabledRetrieving);
            }
        }
    }

    private class BtnBrowseAction
    extends AbstractAction {
        public BtnBrowseAction() {
            super(StringResources.BROWSE);
        }

        public void actionPerformed(ActionEvent e) {
            if (OS.isMacOS()) {
                System.setProperty("apple.awt.fileDialogForDirectories", "true");
                Frame frame = ControlsUtils.getFrameForComponent(SaveAsDialog.this);
                if (frame == null) {
                    return;
                }
                GWMacFileChooser fileChoser = new GWMacFileChooser(frame, StringResources.BROWSE_FOR_FOLDER, new File(SaveAsDialog.this.currentDir), 0);
                UIUtils.centerWindow((Window)fileChoser, SaveAsDialog.this);
                fileChoser.setVisible(true);
                String selectedFile = fileChoser.getFile();
                String selecteddirectory = fileChoser.getDirectory();
                if (selectedFile != null) {
                    SaveAsDialog.this.currentDir = selecteddirectory + selectedFile;
                    if (new File(SaveAsDialog.this.currentDir).exists()) {
                        SaveAsDialog.this.fileChooserPanel.setText(SaveAsDialog.this.currentDir);
                    }
                }
                System.setProperty("apple.awt.fileDialogForDirectories", "false");
            } else {
                GWFileChooser gwFileChooser = new GWFileChooser(SaveAsDialog.this, StringResources.BROWSE_FOR_FOLDER, new File(SaveAsDialog.this.currentDir), 1, 0, false);
                UIUtils.centerWindow((Window)gwFileChooser, SaveAsDialog.this);
                gwFileChooser.getChooser().setApproveButtonText(StringResources.OK);
                gwFileChooser.setVisible(true);
                String[] fileNames = gwFileChooser.getResult();
                if (fileNames != null && new File(fileNames[0]).exists()) {
                    SaveAsDialog.this.currentDir = fileNames[0];
                    SaveAsDialog.this.fileChooserPanel.setText(SaveAsDialog.this.currentDir);
                }
            }
        }
    }

    private class ActionSave
    extends AbstractAction {
        public ActionSave() {
            super(StringResources.SAVE);
        }

        public void actionPerformed(ActionEvent e) {
            if (SaveAsDialog.this.saveSelectedItems()) {
                ApplicationOptions.getInstance().put("LAST_ITEM_SAVING_PATH", SaveAsDialog.this.fileChooserPanel.getText());
            }
        }
    }

    private class ListRenderer
    extends OrientablePanel
    implements ListCellRenderer {
        private int attachmentMargin;
        private JLabel label;

        public ListRenderer() {
            super(new FlowLayout(3, 0, 0));
            this.attachmentMargin = 20;
            this.label = new OrientableLabel("", 10);
            this.add(this.label);
            this.label.setPreferredSize(new Dimension(200, new OrientableLabel((String)" ").getPreferredSize().height));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            String title = null;
            Object object = ((ListItem)value).getObject();
            if (object instanceof GWAttachment) {
                GWAttachment gwAttachment = (GWAttachment)object;
                title = gwAttachment.getName();
                if (!SaveAsDialog.this.isDocument) {
                    title = this.getComponentOrientation().isLeftToRight() ? "+ " + title : title + " +";
                    ((FlowLayout)this.getLayout()).setHgap(this.attachmentMargin);
                }
            } else if (object instanceof AbstractItem) {
                title = ((AbstractItem)object).getSubject();
                ((FlowLayout)this.getLayout()).setHgap(0);
            }
            if (((ListItem)value).isSaved()) {
                title = this.getComponentOrientation().isLeftToRight() ? title + ' ' + StringResources.D_SAVED : StringResources.D_SAVED + ' ' + title;
            } else if (object instanceof GWAttachment && ((GWAttachment)object).getNativeAttachment().getDownloadState() == AttachmentDownloadState.QUEUED_FOR_DOWNLOAD) {
                title = StringResources.D_RETRIEVING + ' ' + title;
            }
            this.label.setText(title);
            this.label.setEnabled(list.isEnabled());
            return this;
        }
    }
}

