/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.addressbook;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.ApplicationFrame;
import com.appframework.ApplicationFrameActionList;
import com.appframework.mvc.MVCController;
import com.appframework.utils.UIUtils;
import com.novell.gw.ab.AddressBookItemListFilter;
import com.novell.gw.ab.AddressBookManager;
import com.novell.gw.engine.ItemListFilter;
import com.novell.gw.jclient.api.enums.EngineMode;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.GWSplitPane;
import com.novell.gw.jclient.application.controls.WrappedNativeListCellRenderer;
import com.novell.gw.jclient.application.controls.addressbook.AddressBookScrollPane;
import com.novell.gw.jclient.application.controls.addressbook.AddressBookTree;
import com.novell.gw.jclient.application.controls.addressbook.table.AddressBookTable;
import com.novell.gw.jclient.application.controls.filter.ComponentWithMenu;
import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.menus.FrameAddressBookMenuBar;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableRadioButtonMenuItem;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.skinnable.SkinnableLabel;
import com.novell.gw.jclient.application.controls.skinnable.SkinnablePanel;
import com.novell.gw.jclient.application.controls.toolbars.FrameAddressBookToolBar;
import com.novell.gw.jclient.application.frames.addressbook.FilterOffAction;
import com.novell.gw.jclient.application.frames.addressbook.FrameAddressBookActionList;
import com.novell.gw.jclient.application.frames.addressbook.GroupFilterAction;
import com.novell.gw.jclient.application.frames.addressbook.OrganizationFilterAction;
import com.novell.gw.jclient.application.frames.addressbook.ResourceFilterAction;
import com.novell.gw.jclient.application.frames.addressbook.UserFilterAction;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.options.DividerPositionListener;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.directory.AbstractAddressBook;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Arrays;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameAddressBook
extends ApplicationFrame<FrameAddressBookActionList, Object> {
    private static Logger logger = Logger.getLogger(FrameAddressBook.class);
    private JTextField tfInput;
    public static final String LOOK_FOR = "Look For";
    public static final String SEARCH = "Search";
    private AbstractAddressBook selectedDirectory;
    private SkinnableLabel lbABName = new SkinnableLabel();
    private SkinnableLabel lbNCCPosition = new SkinnableLabel(StringResources.formatString(StringResources.NAME_COMPLETION_POSITION_C, StringResources.NOT_SEARCHED));
    private JLabel lbFilter = new OrientableLabel(ImageResources.ICON_UNACTIVE_FILTER);
    private AddressBookTable tableAddressBook;
    private FilterPopupMenu popupFilter;
    private AddressBookTree addressBookTree;

    public FrameAddressBook(MVCController theParentController, String userGuid) {
        super(StringResources.ADDRESS_BOOK, "ADDRESS_BOOK_FRAME", userGuid);
        this.setController(new FrameAddressBookActionList(this, theParentController));
        this.tfInput = new GWTextField();
        this.tfInput.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                FrameAddressBook.this.setStatusText(StringResources.WAITING_FOR_USER_INPUT);
            }

            public void focusLost(FocusEvent e) {
                FrameAddressBook.this.setStatusText("");
            }
        });
        this.tableAddressBook = new AddressBookTable(this.getController(), this.tfInput);
        ((FrameAddressBookActionList)this.getController()).addAction(new FilterOffAction((ActionList)this.getController(), this.tableAddressBook));
        ((FrameAddressBookActionList)this.getController()).addAction(new GroupFilterAction((ActionList)this.getController(), this.tableAddressBook));
        ((FrameAddressBookActionList)this.getController()).addAction(new OrganizationFilterAction((ActionList)this.getController(), this.tableAddressBook));
        ((FrameAddressBookActionList)this.getController()).addAction(new ResourceFilterAction((ActionList)this.getController(), this.tableAddressBook));
        ((FrameAddressBookActionList)this.getController()).addAction(new UserFilterAction((ActionList)this.getController(), this.tableAddressBook));
        this.popupFilter = new FilterPopupMenu(this.appActionList);
        this.buildUI();
        this.setGWMenuBar(new FrameAddressBookMenuBar((ActionList)this.getController()));
    }

    @Override
    public void beforeDispose() {
        this.addressBookTree.dispose();
        this.tableAddressBook.dispose();
        super.beforeDispose();
    }

    @Override
    public void showMe() {
        super.showMe();
        this.tfInput.requestFocus();
    }

    public AddressBookTable getTableAddressBook() {
        return this.tableAddressBook;
    }

    public AddressBookTree getAddressBookTree() {
        return this.addressBookTree;
    }

    public void buildUI() {
        OrientablePanel pnlRight = new OrientablePanel(new BorderLayout());
        OrientablePanel pnlTable = new OrientablePanel(new BorderLayout());
        pnlTable.add((Component)this.buildSearchPane(), "North");
        pnlTable.add((Component)new AddressBookScrollPane(this.tableAddressBook), "Center");
        JPanel pnlRightHeader = (JPanel)this.buildRightHeader();
        pnlRight.add((Component)pnlRightHeader, "North");
        pnlRight.add((Component)pnlTable, "Center");
        this.addressBookTree = new AddressBookTree(this.getController());
        OrientableScrollPane scrollTree = new OrientableScrollPane(this.addressBookTree);
        scrollTree.setMinimumSize(new Dimension(100, 200));
        OrientablePanel pnlLeft = new OrientablePanel(new BorderLayout());
        pnlLeft.add((Component)scrollTree, "Center");
        JPanel pnlLeftHeader = (JPanel)this.buildLeftHeader();
        pnlLeft.add((Component)pnlLeftHeader, "North");
        this.setEqualPanelHeight(pnlRightHeader, pnlLeftHeader);
        GWSplitPane splitPane = new GWSplitPane(1, pnlLeft, pnlRight);
        int width = ApplicationOptions.getInstance().getInteger(this.optionFrameName + '.' + "WIN_WIDTH", 700);
        int fPos = ApplicationOptions.getInstance().getInteger("ADDRESS_BOOK_SPLITPOS", 150);
        if (!UIUtils.getComponentOrientation().isLeftToRight()) {
            fPos = width - fPos;
        }
        splitPane.setDividerLocation(fPos);
        splitPane.addPropertyChangeListener(new DividerPositionListener("ADDRESS_BOOK_SPLITPOS", splitPane));
        this.centeredContentPanel.add((Component)splitPane, "Center");
        FrameAddressBookToolBar toolBar = new FrameAddressBookToolBar((ApplicationFrameActionList)this.getController());
        toolBar.setOpaque(true);
        this.centeredContentPanel.add((Component)toolBar, "North");
    }

    private JComponent buildRightHeader() {
        ControlsUtils.prepareHeaderLabel(this.lbABName);
        ControlsUtils.prepareHeaderLabel(this.lbNCCPosition);
        ComponentOrientation co = UIUtils.getComponentOrientation();
        this.lbABName.setComponentOrientation(co);
        this.lbNCCPosition.setComponentOrientation(co);
        this.lbFilter.setComponentOrientation(co);
        SkinnablePanel pnlRight = new SkinnablePanel();
        ControlsUtils.prepareHeaderPanel(pnlRight);
        pnlRight.setLayout(new BoxLayout(pnlRight, 0));
        pnlRight.add(this.lbNCCPosition);
        pnlRight.add(Box.createHorizontalStrut(10));
        pnlRight.add(new ComponentWithMenu(this.lbFilter, this.popupFilter));
        SkinnablePanel pnlRightHeader = new SkinnablePanel(new BorderLayout());
        ControlsUtils.prepareHeaderPanel(pnlRightHeader);
        pnlRightHeader.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pnlRightHeader.add((Component)this.lbABName, "Before");
        pnlRightHeader.add((Component)pnlRight, "After");
        this.lbNCCPosition.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                e.getComponent().setCursor(new Cursor(12));
            }
        });
        this.lbNCCPosition.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                e.getComponent().setCursor(new Cursor(0));
                ((FrameAddressBookActionList)FrameAddressBook.this.getController()).performAction(ActionKey.NCC_SEARCH_ORDER);
            }
        });
        return pnlRightHeader;
    }

    private JComponent buildLeftHeader() {
        SkinnableLabel lbMode = new SkinnableLabel();
        ControlsUtils.prepareHeaderLabel(lbMode);
        if (EngineCommandManager.getCurrentMode() == EngineMode.CACHING) {
            lbMode.setText(StringResources.CACHING);
            lbMode.setIcon(ImageResources.ACT_SWITCH_CACHING);
        }
        if (EngineCommandManager.getCurrentMode() == EngineMode.ONLINE) {
            lbMode.setText(StringResources.ONLINE);
            lbMode.setIcon(ImageResources.ACT_SWITCH_ONLINE);
        }
        lbMode.setMinimumSize(new Dimension(100, 16));
        SkinnablePanel pnlLeftHeader = new SkinnablePanel(new BorderLayout());
        ControlsUtils.prepareHeaderPanel(pnlLeftHeader);
        pnlLeftHeader.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pnlLeftHeader.add((Component)lbMode, "Before");
        return pnlLeftHeader;
    }

    private void setEqualPanelHeight(JPanel pnlRightHeader, JPanel pnlLeftHeader) {
        int leftHeaderHeight = (int)pnlLeftHeader.getPreferredSize().getHeight();
        int rightHeaderHeight = (int)pnlRightHeader.getPreferredSize().getHeight();
        if (rightHeaderHeight >= leftHeaderHeight) {
            pnlLeftHeader.setMinimumSize(new Dimension(100, rightHeaderHeight));
            pnlLeftHeader.setPreferredSize(new Dimension(100, rightHeaderHeight));
        } else {
            pnlRightHeader.setMinimumSize(new Dimension(100, leftHeaderHeight));
            pnlRightHeader.setPreferredSize(new Dimension(100, leftHeaderHeight));
        }
    }

    private void setNCCNumber() {
        int index = Arrays.asList(EngineCommandManager.getNCCSearchOrder()).indexOf(this.selectedDirectory.getNativeAddressBook());
        String text = index == -1 ? StringResources.formatString(StringResources.NAME_COMPLETION_POSITION_C, StringResources.NOT_SEARCHED) : StringResources.formatString(StringResources.NAME_COMPLETION_POSITION_C, Integer.toString(++index));
        this.lbNCCPosition.setText(text);
    }

    @Override
    public void setMVCModel(Object theModel) {
        if (theModel instanceof AbstractAddressBook) {
            this.selectedDirectory = (AbstractAddressBook)theModel;
            this.lbABName.setIcon(ControlsUtils.getIconForAddressBook(this.selectedDirectory));
            this.lbABName.setText(this.selectedDirectory.getName());
            this.lbFilter.setIcon(ImageResources.ICON_UNACTIVE_FILTER);
            AddressBookItemListFilter filter = new AddressBookItemListFilter(false);
            filter.setContactType(15);
            this.tableAddressBook.setFilter((ItemListFilter)filter);
            this.popupFilter.selectAction(ActionKey.AB_FILTER_OFF);
            this.setNCCNumber();
        }
    }

    private JPanel buildSearchPane() {
        OrientablePanel pnlSearch = new OrientablePanel(new GridBagLayout());
        Object[] columns = new Integer[]{new Integer(25), new Integer(48), new Integer(9), new Integer(3), new Integer(28), new Integer(11)};
        OrientableComboBox cbSearch = new OrientableComboBox(columns);
        cbSearch.setRenderer(new WrappedNativeListCellRenderer(cbSearch.getRenderer()){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component rendererComponent = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (rendererComponent instanceof JLabel) {
                    ((JLabel)rendererComponent).setText(AddressBookManager.getPropertyLabel((int)((Integer)value)));
                }
                return rendererComponent;
            }
        });
        cbSearch.setName(SEARCH);
        cbSearch.setSelectedIndex(3);
        cbSearch.setEnabled(false);
        this.tfInput.setName(LOOK_FOR);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets.right = 4;
        pnlSearch.add((Component)new OrientableLabel(StringResources.LOOK_FOR_C), constraints);
        constraints.insets.right = 0;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        pnlSearch.add((Component)this.tfInput, constraints);
        constraints.weightx = 0.0;
        constraints.fill = 0;
        constraints.insets.left = 2;
        constraints.insets.right = 2;
        constraints.insets.right = 0;
        pnlSearch.setBorder(BorderFactory.createEmptyBorder(4, 2, 2, 2));
        return pnlSearch;
    }

    @Override
    public void release() {
        super.release();
        this.selectedDirectory = null;
        this.lbABName = null;
        for (FocusListener focusListener : this.tfInput.getFocusListeners()) {
            this.tfInput.removeFocusListener(focusListener);
        }
        this.tfInput = null;
        this.lbNCCPosition = null;
        this.lbFilter = null;
        this.tableAddressBook = null;
        this.popupFilter = null;
        this.addressBookTree = null;
    }

    private class FilterPopupMenu
    extends GWPopupMenu {
        private ButtonGroup buttonGroup = new ButtonGroup();
        private ItemListener itemListener = new FilterItemListener();

        public FilterPopupMenu(ActionList theActionList) {
            OrientableRadioButtonMenuItem menuItem = new OrientableRadioButtonMenuItem(theActionList.getAction(ActionKey.AB_FILTER_OFF));
            menuItem.setText(StringResources.FILTER_OFF);
            this.buttonGroup.add(menuItem);
            menuItem.addItemListener(this.itemListener);
            this.add(menuItem);
            menuItem = new OrientableRadioButtonMenuItem(theActionList.getAction(ActionKey.AB_FILTER_GROUP));
            menuItem.setText(StringResources.FILTER_FOR_GROUPS);
            this.add(menuItem);
            menuItem.addItemListener(this.itemListener);
            this.buttonGroup.add(menuItem);
            menuItem = new OrientableRadioButtonMenuItem(theActionList.getAction(ActionKey.AB_FILTER_USER));
            menuItem.setText(StringResources.FILTER_FOR_CONTACTS);
            this.buttonGroup.add(menuItem);
            menuItem.addItemListener(this.itemListener);
            this.add(menuItem);
            menuItem = new OrientableRadioButtonMenuItem(theActionList.getAction(ActionKey.AB_FILTER_RESOURCE));
            menuItem.setText(StringResources.FILTER_FOR_RESOURCES);
            this.buttonGroup.add(menuItem);
            menuItem.addItemListener(this.itemListener);
            this.add(menuItem);
            menuItem = new OrientableRadioButtonMenuItem(theActionList.getAction(ActionKey.AB_FILTER_ORGANIZATION));
            menuItem.setText(StringResources.FILTER_FOR_ORGANIZATIONS);
            this.buttonGroup.add(menuItem);
            menuItem.addItemListener(this.itemListener);
            this.add(menuItem);
        }

        public void selectAction(ActionKey theAction) {
            int nCount = this.getComponents().length;
            for (int i = 0; i < nCount; ++i) {
                ActionKey name;
                Component component = this.getComponents()[i];
                if (!(component instanceof JRadioButtonMenuItem) || !(name = ((AppAction)((JMenuItem)component).getAction()).getActionKey()).equals((Object)theAction)) continue;
                ((JMenuItem)component).setSelected(true);
            }
        }
    }

    private class FilterItemListener
    implements ItemListener {
        private FilterItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                Action action = ((JMenuItem)e.getItem()).getAction();
                if (action instanceof FilterOffAction) {
                    FrameAddressBook.this.lbFilter.setIcon(ImageResources.ICON_UNACTIVE_FILTER);
                } else {
                    FrameAddressBook.this.lbFilter.setIcon(ImageResources.ICON_ACTIVE_FILTER);
                }
            }
        }
    }
}

