/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options;

import com.appframework.mvc.MVCController;
import com.appframework.utils.UIUtils;
import com.novell.gw.account.Account;
import com.novell.gw.account.AccountFolderList;
import com.novell.gw.account.GroupWiseAccount;
import com.novell.gw.account.ImapAccount;
import com.novell.gw.account.NntpAccount;
import com.novell.gw.jclient.api.enums.EngineMode;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.application.GWTable;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialog;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialogController;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.orientable.OrientableTabbedPane;
import com.novell.gw.jclient.application.dialogs.SubscribeNewsgroupDialog;
import com.novell.gw.jclient.application.frames.options.AccountDnD.AccountsTableDragGestureListener;
import com.novell.gw.jclient.application.frames.options.AccountDnD.AccountsTableDropTargetListener;
import com.novell.gw.jclient.application.frames.options.AccountGeneralOptionsDialog;
import com.novell.gw.jclient.application.frames.options.AccountPropertiesDialog;
import com.novell.gw.jclient.application.frames.options.AccountUtils;
import com.novell.gw.jclient.application.frames.options.AccountsDragTableModelInterface;
import com.novell.gw.jclient.application.frames.options.CreateMailAccountDialog;
import com.novell.gw.jclient.application.frames.options.CreateNewsAccountDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccountOptionsDialog
extends ApplicationDialog<ApplicationDialogController> {
    public static int MODE_MAIL = 0;
    public static int MODE_NEWS = 1;
    private static Logger logger = Logger.getLogger(AccountOptionsDialog.class);
    private OrientableTabbedPane tabPane = new OrientableTabbedPane(1);
    private OrientableButton btnAdd = new OrientableButton();
    private OrientableButton btnRemove = new OrientableButton();
    private OrientableButton btnProperties = new OrientableButton();
    private OrientableButton btnSetDefault = new OrientableButton();
    private OrientableButton btnFolders = new OrientableButton();
    private GWTable mailTable;
    private GWTable newsTable;
    private MailTableModelModel mailModel;
    private NewsTableModel newsModel;
    private JFrame parentFrame;
    private JPanel pnlMailTable = new OrientablePanel(new BorderLayout());
    private boolean canDoNews = true;
    private boolean canDoMail = true;
    private ButtonPropertiesAction buttonPropertiesAction = new ButtonPropertiesAction();

    public AccountOptionsDialog(MVCController parentController) {
        super((Frame)((JFrame)parentController.getMVCView()), parentController);
        this.parentFrame = (JFrame)parentController.getMVCView();
        this.setNNTPAndMailPermit();
        this.setTitle(StringResources.ACCOUNTS);
        this.setDefaultCloseOperation(1);
        this.buildUI();
    }

    @Override
    protected ApplicationDialogController createController(MVCController parentController) {
        return new ApplicationDialogController<AccountOptionsDialog>(this, parentController);
    }

    public static synchronized void freeInstance() {
    }

    private void buildUI() {
        Container contentPane = this.getContentPane();
        contentPane.setComponentOrientation(UIUtils.getComponentOrientation());
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.buildAccounts(), "Center");
        contentPane.add((Component)this.buildControls(), "After");
        this.updateControls();
        JButton buttonCancel = this.getBtnCancel();
        buttonCancel.setText(StringResources.CLOSE);
        this.setDefaultButton(buttonCancel);
        this.addDnDSupport();
        this.pack();
        UIUtils.centerWindowOnScreen(this);
    }

    private void addDnDSupport() {
        if (EngineCommandManager.getCurrentMode() == EngineMode.ONLINE) {
            if (this.canDoMail) {
                this.addDnDForMailTable();
            }
            if (this.canDoNews) {
                this.addDnDForNewsTable();
            }
        } else {
            this.addDnDForMailTable();
            this.addDnDForNewsTable();
        }
    }

    private void addDnDForNewsTable() {
        DropTarget target = new DropTarget(this.newsTable, new AccountsTableDropTargetListener(this.newsTable));
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this.newsTable, 2, new AccountsTableDragGestureListener(this.newsTable));
    }

    private void addDnDForMailTable() {
        DropTarget target = new DropTarget(this.mailTable, new AccountsTableDropTargetListener(this.mailTable));
        DragSource dragSource = DragSource.getDefaultDragSource();
        AccountsTableDragGestureListener gesture = new AccountsTableDragGestureListener(this.mailTable);
        dragSource.createDefaultDragGestureRecognizer(this.mailTable, 2, gesture);
    }

    private JComponent buildAccounts() {
        this.tabPane.setBorder(new EmptyBorder(5, 10, 10, 5));
        if (EngineCommandManager.getCurrentMode() == EngineMode.ONLINE) {
            if (this.canDoMail) {
                this.tabPane.addTab(StringResources.MAIL, this.buildMailPanel());
            }
            if (this.canDoNews) {
                this.tabPane.addTab(StringResources.NEWS, this.buildNewsPanel());
            }
        } else {
            this.tabPane.addTab(StringResources.MAIL, this.buildMailPanel());
            this.tabPane.addTab(StringResources.NEWS, this.buildNewsPanel());
        }
        this.tabPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                AccountOptionsDialog.this.updateControls();
                AccountOptionsDialog.this.btnAdd.setEnabled(true);
                AccountOptionsDialog.this.clearNewsMailAccounts();
            }
        });
        return this.tabPane;
    }

    private JPanel buildMailPanel() {
        OrientablePanel mailPanel = new OrientablePanel(new BorderLayout());
        mailPanel.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.mailTable = new GWTable();
        this.mailTable.setSelectionMode(1);
        this.mailModel = new MailTableModelModel();
        this.mailTable.setModel(this.mailModel);
        this.mailTable.getColumnModel().getColumn(0).setCellRenderer(new AccountCheckBoxRenderer());
        this.mailTable.getColumnModel().getColumn(0).setPreferredWidth(24);
        this.mailTable.getColumnModel().getColumn(0).setMinWidth(24);
        this.mailTable.getColumnModel().getColumn(0).setMaxWidth(24);
        this.mailTable.getColumnModel().getColumn(0).setResizable(false);
        this.mailTable.getTableHeader().setBorder(BorderFactory.createEmptyBorder());
        this.mailTable.getTableHeader().setResizingAllowed(true);
        this.mailTable.setShowGrid(false);
        this.mailTable.setAutoResizeMode(3);
        this.mailTable.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.mailTable.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.mailTable.getColumnModel().getColumn(3).setPreferredWidth(100);
        this.mailTable.getSelectionModel().addListSelectionListener(new MailTableSelectionListener());
        this.mailTable.addDoubleClickedRowListener(this.buttonPropertiesAction);
        this.pnlMailTable.add((Component)this.mailTable, "Center");
        this.pnlMailTable.add((Component)this.mailTable.getTableHeader(), "North");
        OrientableScrollPane tableScroll = new OrientableScrollPane(this.pnlMailTable);
        tableScroll.setBorder(BorderFactory.createEmptyBorder());
        mailPanel.add((Component)tableScroll, "Center");
        return mailPanel;
    }

    private JPanel buildNewsPanel() {
        OrientablePanel newsPanel = new OrientablePanel(new BorderLayout());
        newsPanel.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.newsTable = new GWTable();
        this.newsModel = new NewsTableModel();
        this.newsTable.setModel(this.newsModel);
        this.newsTable.getColumnModel().getColumn(0).setCellRenderer(new AccountCheckBoxRenderer());
        this.newsTable.getColumnModel().getColumn(0).setPreferredWidth(24);
        this.newsTable.getColumnModel().getColumn(0).setMinWidth(24);
        this.newsTable.getColumnModel().getColumn(0).setMaxWidth(24);
        this.newsTable.getColumnModel().getColumn(0).setResizable(false);
        this.newsTable.getTableHeader().setBorder(BorderFactory.createEmptyBorder());
        this.newsTable.getTableHeader().setResizingAllowed(true);
        this.newsTable.setShowGrid(false);
        this.newsTable.setAutoResizeMode(3);
        this.newsTable.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.newsTable.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.newsTable.getColumnModel().getColumn(3).setPreferredWidth(100);
        this.newsTable.getSelectionModel().addListSelectionListener(new NewsTableSelectionListener());
        this.newsTable.addDoubleClickedRowListener(this.buttonPropertiesAction);
        OrientablePanel pnlWhite = new OrientablePanel(new BorderLayout());
        pnlWhite.add((Component)this.newsTable, "Center");
        pnlWhite.add((Component)this.newsTable.getTableHeader(), "North");
        OrientableScrollPane tableScroll = new OrientableScrollPane(pnlWhite);
        tableScroll.setBorder(BorderFactory.createEmptyBorder());
        newsPanel.add((Component)tableScroll, "Center");
        return newsPanel;
    }

    private JPanel buildControls() {
        OrientablePanel theControlsPanel = new OrientablePanel(new GridBagLayout());
        theControlsPanel.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(5, 10, 0, 10);
        theControlsPanel.add((Component)this.getBtnCancel(), c);
        this.btnAdd = new OrientableButton(new ButtonAddAction());
        this.btnAdd.setEnabled(true);
        c.gridy = 1;
        c.insets = new Insets(10, 10, 0, 10);
        theControlsPanel.add((Component)this.btnAdd, c);
        this.btnRemove = new OrientableButton(new ButtonRemoveAction());
        this.btnRemove.setEnabled(true);
        c.gridy = 2;
        theControlsPanel.add((Component)this.btnRemove, c);
        this.btnProperties = new OrientableButton(this.buttonPropertiesAction);
        this.btnProperties.setEnabled(false);
        c.gridy = 3;
        theControlsPanel.add((Component)this.btnProperties, c);
        this.btnSetDefault = new OrientableButton(new ButtonDefaultAction());
        this.btnSetDefault.setEnabled(false);
        c.gridy = 4;
        theControlsPanel.add((Component)this.btnSetDefault, c);
        OrientableButton btnGeneralOptions = new OrientableButton(new ButtonGeneralOptionsAction());
        btnGeneralOptions.setEnabled(true);
        c.gridy = 5;
        theControlsPanel.add((Component)btnGeneralOptions, c);
        this.btnFolders = new OrientableButton(new ButtonFoldersAction());
        c.gridy = 6;
        c.insets = new Insets(10, 10, 10, 10);
        theControlsPanel.add((Component)this.btnFolders, c);
        return theControlsPanel;
    }

    @Override
    protected void doBeforeDispose() {
        super.doBeforeDispose();
        this.mailTable.removeDoubleClickedRowListener(this.buttonPropertiesAction);
        this.newsTable.removeDoubleClickedRowListener(this.buttonPropertiesAction);
    }

    public Account getSelectedAccount() {
        int selectedRow;
        Account selectedAccount = null;
        if (this.canDoMail && this.tabPane.getSelectedIndex() == MODE_MAIL) {
            selectedRow = this.mailTable.getSelectedRow();
            if (selectedRow == -1) {
                selectedRow = 0;
            }
            selectedAccount = this.mailModel.getAccount(selectedRow);
        }
        if (this.canDoNews && this.tabPane.getSelectedIndex() == MODE_NEWS) {
            selectedRow = this.newsTable.getSelectedRow();
            if (selectedRow == -1) {
                selectedRow = 0;
            }
            selectedAccount = this.newsModel.getAccount(selectedRow);
        }
        return selectedAccount;
    }

    private void updateControls() {
        int selectedRow;
        if (this.canDoMail && this.tabPane.getSelectedIndex() == MODE_MAIL) {
            if (this.mailTable.getModel().getRowCount() != 0) {
                Account selectedAccount;
                this.btnFolders.setAction(new ButtonFoldersAction());
                selectedRow = this.mailTable.getSelectedRow();
                if (selectedRow == -1) {
                    selectedRow = 0;
                    this.mailTable.setRowSelectionInterval(0, 0);
                }
                this.btnProperties.setEnabled(this.mailTable.getSelectedRow() != -1);
                int rowCount = this.mailTable.getRowCount();
                if (rowCount == selectedRow) {
                    selectedRow = this.mailTable.getSelectedRow() - 1;
                    this.mailTable.setRowSelectionInterval(selectedRow, selectedRow);
                }
                this.btnRemove.setEnabled(!((selectedAccount = this.mailModel.getAccount(selectedRow)) instanceof GroupWiseAccount) && selectedAccount.canDelete());
                if (selectedAccount.isDefault()) {
                    this.btnSetDefault.setEnabled(false);
                } else {
                    this.btnSetDefault.setEnabled(true);
                }
                if (selectedAccount instanceof ImapAccount) {
                    this.btnFolders.setEnabled(true);
                } else {
                    this.btnFolders.setEnabled(false);
                }
            } else {
                this.btnSetDefault.setEnabled(false);
                this.btnRemove.setEnabled(false);
                this.btnProperties.setEnabled(false);
                this.btnFolders.setEnabled(false);
            }
        }
        if (this.canDoNews && this.tabPane.getSelectedIndex() == MODE_NEWS) {
            this.btnFolders.setAction(new ButtonNewsgroupsAction());
            if (this.newsTable.getModel().getRowCount() != 0) {
                selectedRow = this.newsTable.getSelectedRow();
                if (selectedRow == -1) {
                    selectedRow = 0;
                    this.newsTable.setRowSelectionInterval(0, 0);
                }
                this.btnProperties.setEnabled(true);
                Account selectedAccount = this.newsModel.getAccount(selectedRow);
                this.btnRemove.setEnabled(selectedAccount.canDelete());
                this.btnFolders.setEnabled(true);
            } else {
                this.btnRemove.setEnabled(false);
                this.btnProperties.setEnabled(false);
                this.btnFolders.setEnabled(false);
            }
            this.btnSetDefault.setEnabled(false);
        }
    }

    private void updateTableSelection(GWTable table) {
        int selectedRow = table.getSelectedRow();
        if (selectedRow == table.getRowCount()) {
            table.getSelectionModel().setSelectionInterval(table.getSelectedRow() - 1, table.getSelectedRow() - 1);
        }
    }

    private void setNNTPAndMailPermit() {
        IDataStore dataStore = EngineCommandManager.getInstance(EngineCommandManager.getUserGuid()).getCurrentDataStore();
        if (EngineCommandManager.getCurrentMode() == EngineMode.ONLINE) {
            this.canDoNews = dataStore.canDoNntpAccounts();
            this.canDoMail = dataStore.canDoPopAndImapAccounts();
        }
        if (!this.canDoMail && this.canDoNews) {
            MODE_NEWS = 0;
        }
    }

    private void clearNewsMailAccounts() {
        if (EngineCommandManager.getCurrentMode() == EngineMode.ONLINE) {
            if (this.canDoMail) {
                this.mailModel.clearAccounts();
            }
            if (this.canDoNews) {
                this.newsModel.clearAccounts();
            }
        } else {
            this.mailModel.clearAccounts();
            this.newsModel.clearAccounts();
        }
    }

    private class AccountCheckBoxRenderer
    extends OrientableCheckBox
    implements TableCellRenderer {
        public AccountCheckBoxRenderer() {
            this.setOpaque(true);
            this.setBackground(Color.white);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value.equals(Boolean.TRUE)) {
                this.setSelected(true);
            } else if (value.equals(Boolean.FALSE)) {
                this.setSelected(false);
            } else {
                throw new IllegalArgumentException("only Boolean.TRUE or Boolean.False can be apply to checkBox");
            }
            return this;
        }
    }

    private class NewsTableSelectionListener
    implements ListSelectionListener {
        private NewsTableSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                AccountOptionsDialog.this.updateControls();
            }
        }
    }

    private class MailTableSelectionListener
    implements ListSelectionListener {
        private MailTableSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                AccountOptionsDialog.this.updateControls();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NewsTableModel
    extends AbstractTableModel
    implements AccountsDragTableModelInterface {
        private Account[] accounts;

        private NewsTableModel() {
        }

        public void clearAccounts() {
            this.accounts = null;
        }

        @Override
        public int getRowCount() {
            return this.getAccounts().length;
        }

        @Override
        public void movRow(int row, int toPos) {
            EngineCommandManager.getInstance(EngineCommandManager.getUserGuid()).getCurrentDataStore().moveAccountToIndex(this.getAccount(row), toPos + AccountOptionsDialog.this.mailModel.getAccounts().length);
            this.accounts = null;
            this.fireTableDataChanged();
            AccountOptionsDialog.this.newsTable.setRowSelectionInterval(toPos, toPos);
        }

        private Account[] getAccounts() {
            if (this.accounts == null) {
                this.accounts = EngineCommandManager.getNewsAccounts();
            }
            return this.accounts;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.getValueAt(0, columnIndex).getClass();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 1: {
                    return StringResources.MARKED_ACCOUNT;
                }
                case 2: {
                    return StringResources.ACCOUNT_TYPE;
                }
                case 3: {
                    return StringResources.INCOMING_SERVER;
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        @Override
        public Object getValueAt(int row, int column) {
            Account account = this.getAccount(row);
            switch (column) {
                case 0: {
                    if (account.getIncludeInFullRetrieve()) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
                case 1: {
                    return account.getName();
                }
                case 2: {
                    return AccountUtils.getAccountTypeString(account);
                }
                case 3: {
                    return account.getIncomingServer();
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                if (aValue.equals(Boolean.TRUE)) {
                    this.getAccount(rowIndex).setIncludeInFullRetrieve(true);
                } else if (aValue.equals(Boolean.FALSE)) {
                    this.getAccount(rowIndex).setIncludeInFullRetrieve(false);
                } else {
                    throw new IllegalArgumentException("only Boolean.TRUE or Boolean.False can be apply to checkBox");
                }
            }
            super.setValueAt(aValue, rowIndex, columnIndex);
        }

        public Account getAccount(int theRow) {
            return this.getAccounts()[theRow];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MailTableModelModel
    extends AbstractTableModel
    implements AccountsDragTableModelInterface {
        private Account[] accounts;

        private MailTableModelModel() {
        }

        public void clearAccounts() {
            this.accounts = null;
        }

        @Override
        public int getRowCount() {
            return this.getAccounts().length;
        }

        @Override
        public void movRow(int row, int toPos) {
            EngineCommandManager.getInstance(EngineCommandManager.getUserGuid()).getCurrentDataStore().moveAccountToIndex(this.getAccount(row), toPos);
            this.accounts = null;
            this.fireTableDataChanged();
            AccountOptionsDialog.this.mailTable.setRowSelectionInterval(toPos, toPos);
        }

        private Account[] getAccounts() {
            if (this.accounts == null) {
                this.accounts = EngineCommandManager.getMailAccounts();
            }
            return this.accounts;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 1: {
                    return StringResources.MARKED_ACCOUNT;
                }
                case 2: {
                    return StringResources.ACCOUNT_TYPE;
                }
                case 3: {
                    return StringResources.INCOMING_SERVER;
                }
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.getValueAt(0, columnIndex).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                if (aValue.equals(Boolean.TRUE)) {
                    this.getAccount(rowIndex).setIncludeInFullRetrieve(true);
                } else if (aValue.equals(Boolean.FALSE)) {
                    this.getAccount(rowIndex).setIncludeInFullRetrieve(false);
                } else {
                    throw new IllegalArgumentException("only Boolean.TRUE or Boolean.False can be apply to checkBox");
                }
            }
            super.setValueAt(aValue, rowIndex, columnIndex);
        }

        @Override
        public Object getValueAt(int row, int column) {
            Account account = this.getAccount(row);
            switch (column) {
                case 0: {
                    if (account.getIncludeInFullRetrieve()) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
                case 1: {
                    return account.getName();
                }
                case 2: {
                    if (account.isDefault()) {
                        return AccountUtils.getAccountTypeString(account) + "(" + StringResources.L_DEFAULT + ")";
                    }
                    return AccountUtils.getAccountTypeString(account);
                }
                case 3: {
                    return account.getIncomingServer();
                }
            }
            return "";
        }

        public Account getAccount(int theRow) {
            return this.getAccounts()[theRow];
        }
    }

    private class ButtonNewsgroupsAction
    extends AbstractAction {
        public ButtonNewsgroupsAction() {
            super(StringResources.NEWSGROUPS);
        }

        public void actionPerformed(ActionEvent e) {
            AccountFolderList afl = ((NntpAccount)AccountOptionsDialog.this.getSelectedAccount()).getAllNNTPFolders();
            if (afl.getNumFolders() != 0) {
                SubscribeNewsgroupDialog.showDialog(AccountOptionsDialog.this.parentFrame, AccountOptionsDialog.this.getSelectedAccount());
                AccountOptionsDialog.this.clearNewsMailAccounts();
                AccountOptionsDialog.this.newsModel.fireTableDataChanged();
            }
        }
    }

    private class ButtonFoldersAction
    extends AbstractAction {
        public ButtonFoldersAction() {
            super(StringResources.FOLDERS);
        }

        public void actionPerformed(ActionEvent e) {
            AccountFolderList afl = ((ImapAccount)AccountOptionsDialog.this.getSelectedAccount()).getAllIMAPFolders();
            if (afl.getNumFolders() != 0) {
                SubscribeNewsgroupDialog.showDialog(AccountOptionsDialog.this.parentFrame, AccountOptionsDialog.this.getSelectedAccount());
                AccountOptionsDialog.this.clearNewsMailAccounts();
                AccountOptionsDialog.this.mailModel.fireTableDataChanged();
            }
        }
    }

    private class ButtonGeneralOptionsAction
    extends AbstractAction {
        public ButtonGeneralOptionsAction() {
            super(StringResources.GENERAL + ' ' + StringResources.OPTIONS);
        }

        public void actionPerformed(ActionEvent e) {
            logger.debug((Object)"General Options");
            AccountOptionsDialog optionsDialog = AccountOptionsDialog.this;
            AccountGeneralOptionsDialog generalOptionsDialog = new AccountGeneralOptionsDialog((JDialog)optionsDialog, AccountOptionsDialog.this.tabPane.getSelectedIndex());
            UIUtils.centerWindow((Window)generalOptionsDialog, optionsDialog);
            generalOptionsDialog.pack();
            generalOptionsDialog.setVisible(true);
        }
    }

    private class ButtonDefaultAction
    extends AbstractAction {
        public ButtonDefaultAction() {
            super(StringResources.SET_DEFAULT);
        }

        public void actionPerformed(ActionEvent e) {
            logger.debug((Object)"Set Default");
            int sRow = AccountOptionsDialog.this.mailTable.getSelectedRow();
            Account account = ((MailTableModelModel)AccountOptionsDialog.this.mailTable.getModel()).getAccount(sRow);
            account.setDefault();
            ((MailTableModelModel)AccountOptionsDialog.this.mailTable.getModel()).fireTableDataChanged();
            AccountOptionsDialog.this.mailTable.setRowSelectionInterval(sRow, sRow);
        }
    }

    private class ButtonPropertiesAction
    extends AbstractAction
    implements GWTable.DoubleClickedRowListener {
        public ButtonPropertiesAction() {
            super(StringResources.PROPERTIES_C);
        }

        private void showAccountPropertiesDialog(Account account) {
            AccountPropertiesDialog propertiesDialog = new AccountPropertiesDialog(AccountOptionsDialog.this, account, (MVCController)AccountOptionsDialog.this.getController());
            propertiesDialog.setVisible(true);
            if (propertiesDialog.isOkActionProcessed()) {
                if (AccountOptionsDialog.this.canDoMail && AccountOptionsDialog.this.tabPane.getSelectedIndex() == MODE_MAIL) {
                    AccountOptionsDialog.this.mailModel.clearAccounts();
                    AccountOptionsDialog.this.mailModel.fireTableDataChanged();
                }
                if (AccountOptionsDialog.this.canDoNews && AccountOptionsDialog.this.tabPane.getSelectedIndex() == MODE_NEWS) {
                    AccountOptionsDialog.this.newsModel.clearAccounts();
                    AccountOptionsDialog.this.newsModel.fireTableDataChanged();
                }
            }
        }

        public void actionPerformed(ActionEvent e) {
            logger.debug((Object)"Properties");
            Account selectedAccount = AccountOptionsDialog.this.getSelectedAccount();
            this.showAccountPropertiesDialog(selectedAccount);
        }

        public void tableRowDoubleClicked(GWTable.DoubleClickedRowEvent event) {
            logger.debug((Object)"Properties");
            if (event.getSource() instanceof GWTable) {
                GWTable table = (GWTable)event.getSource();
                if (table.getModel().equals(AccountOptionsDialog.this.mailModel)) {
                    Account account = AccountOptionsDialog.this.mailModel.getAccount(event.getRowIndex());
                    this.showAccountPropertiesDialog(account);
                } else if (table.getModel().equals(AccountOptionsDialog.this.newsModel)) {
                    Account account = AccountOptionsDialog.this.newsModel.getAccount(event.getRowIndex());
                    this.showAccountPropertiesDialog(account);
                }
            }
        }
    }

    private class ButtonRemoveAction
    extends AbstractAction {
        public ButtonRemoveAction() {
            super(StringResources.REMOVE);
        }

        public void actionPerformed(ActionEvent e) {
            logger.debug((Object)"Remove");
            Account selectedAccount = AccountOptionsDialog.this.getSelectedAccount();
            int result = JOptionPane.showConfirmDialog(AccountOptionsDialog.this, StringResources.formatString(StringResources.ARE_YOU_SURE_YOU_WANT_TO_DELETE_THE_ACCOUNT, selectedAccount.getName()), StringResources.CONFIRM_ACCOUNT_DELETE, 0);
            if (result == 0) {
                IDataStore dataStore = EngineCommandManager.getInstance(EngineCommandManager.getUserGuid()).getCurrentDataStore();
                dataStore.deleteAccount(selectedAccount);
            }
            AccountOptionsDialog.this.clearNewsMailAccounts();
            if (AccountOptionsDialog.this.canDoMail && AccountOptionsDialog.this.tabPane.getSelectedIndex() == MODE_MAIL) {
                AccountOptionsDialog.this.mailModel.fireTableDataChanged();
                AccountOptionsDialog.this.updateTableSelection(AccountOptionsDialog.this.mailTable);
            }
            if (AccountOptionsDialog.this.canDoNews && AccountOptionsDialog.this.tabPane.getSelectedIndex() == MODE_NEWS) {
                AccountOptionsDialog.this.newsModel.fireTableDataChanged();
                AccountOptionsDialog.this.updateTableSelection(AccountOptionsDialog.this.newsTable);
            }
        }
    }

    private class ButtonAddAction
    extends AbstractAction {
        public ButtonAddAction() {
            super(StringResources.ADD);
        }

        public void actionPerformed(ActionEvent e) {
            String[] names;
            if (AccountOptionsDialog.this.canDoMail && AccountOptionsDialog.this.tabPane.getSelectedIndex() == MODE_MAIL) {
                names = new String[AccountOptionsDialog.this.mailModel.getAccounts().length];
                for (int i = 0; i < names.length; ++i) {
                    names[i] = AccountOptionsDialog.this.mailModel.getAccounts()[i].getName();
                }
                CreateMailAccountDialog dialog = new CreateMailAccountDialog(AccountOptionsDialog.this, (MVCController)AccountOptionsDialog.this.getController());
                dialog.setNames(names);
                dialog.setVisible(true);
                AccountOptionsDialog.this.mailModel.clearAccounts();
                AccountOptionsDialog.this.mailModel.fireTableDataChanged();
            }
            if (AccountOptionsDialog.this.canDoNews && AccountOptionsDialog.this.tabPane.getSelectedIndex() == MODE_NEWS) {
                names = new String[AccountOptionsDialog.this.newsModel.getAccounts().length];
                for (int i = 0; i < names.length; ++i) {
                    names[i] = AccountOptionsDialog.this.newsModel.getAccounts()[i].getName();
                }
                CreateNewsAccountDialog dialog = new CreateNewsAccountDialog(AccountOptionsDialog.this, (MVCController)AccountOptionsDialog.this.getController());
                dialog.setNames(names);
                dialog.setVisible(true);
                AccountOptionsDialog.this.newsModel.clearAccounts();
                AccountOptionsDialog.this.newsModel.fireTableDataChanged();
            }
        }
    }
}

