/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options;

import com.appframework.mvc.MVCController;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialog;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialogController;
import com.novell.gw.jclient.application.controls.folderstree.CheckFoldersTree;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextArea;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.dialogs.newfolder.FolderNamePane;
import com.novell.gw.jclient.application.frames.options.AccountUtils;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.impl.cache.FoldersCache;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.CabinetFolder;
import com.novell.gw.jclient.bl.om.folders.UniversalFolder;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateMailAccountDialog
extends ApplicationDialog<ApplicationDialogController> {
    private static Logger logger = Logger.getLogger(CreateMailAccountDialog.class);
    private static final Object[] ACCOUNT_TYPES = new Object[]{StringResources.POP3, StringResources.IMAP4};
    private static final String[] TITLES = new String[]{StringResources.CREATE_MAIL_ACCOUNT_CREATE_ACCOUNT, StringResources.CREATE_MAIL_ACCOUNT_CREATE_INTERNET_ACCOUNT, StringResources.CREATE_MAIL_ACCOUNT_CREATE_INTERNET_ACCOUNT, StringResources.CREATE_MAIL_ACCOUNT_CREATE_INTERNET_ACCOUNT};
    private int currentDialog = 1;
    private CardLayout cardLayout = new CardLayout();
    private OrientablePanel cardPnl = new OrientablePanel(this.cardLayout);
    private OrientableButton btnBack = new OrientableButton();
    private OrientableButton btnNext = new OrientableButton();
    private GWTextField d1AccountNameField = new GWTextField(20);
    private OrientableComboBox d1AccountTypesComboBox = new OrientableComboBox(ACCOUNT_TYPES);
    private OrientableCheckBox d1UploadCheckBox = new OrientableCheckBox(StringResources.CREATE_ACCOUNT_D1_UPLOAD_THIS_ACCOUNT);
    private OrientableLabel d2LblIncoming;
    private GWTextField d2IncomingServerField;
    private GWTextField d2LoginNameField;
    private GWTextField d2OutgoingServerField;
    private GWTextField d2EmailAddressField;
    private GWTextField d2FromNameField;
    private OrientablePanel dialog3;
    private CheckFoldersTree d3CheckFoldersTree;
    private OrientableCheckBox d3CreateNewFolderCheckBox;
    private FolderNamePane folderPOPNamePane;
    private FolderNamePane folderIMAPNamePane;
    private String[] names;

    CreateMailAccountDialog(JDialog window, MVCController parentController) {
        super((Dialog)window, parentController);
        this.d1UploadCheckBox.setSelected(true);
        this.d2LblIncoming = new OrientableLabel();
        this.d2IncomingServerField = new GWTextField(20);
        this.d2LoginNameField = new GWTextField(10);
        this.d2OutgoingServerField = new GWTextField(20);
        this.d2EmailAddressField = new GWTextField(20);
        this.d3CreateNewFolderCheckBox = new OrientableCheckBox(StringResources.CREATE_MAIL_ACCOUNT_D3_CREATE_NEW_FOLDER);
        String userGuid = ControlsUtils.getUserGuid(this.getController());
        this.d3CheckFoldersTree = new CheckFoldersTree((MVCController)this.getController(), this.btnNext, userGuid);
        UniversalFolder mailboxFolder = FoldersCache.getMailboxFolder(userGuid);
        AbstractFolder cabinetFolder = FoldersCache.getFolder(CabinetFolder.class, userGuid);
        this.d3CheckFoldersTree.selectFolder(mailboxFolder);
        this.folderPOPNamePane = new FolderNamePane((MVCController)this.getController(), cabinetFolder, this.btnNext);
        this.folderPOPNamePane.setMVCModel((Object)true);
        AbstractFolder rootFolder = FoldersCache.getRootFolder(userGuid);
        this.folderIMAPNamePane = new FolderNamePane((MVCController)this.getController(), rootFolder, this.btnNext, true, -1);
        this.folderIMAPNamePane.setMVCModel((Object)true);
        this.buildUI();
    }

    @Override
    protected ApplicationDialogController createController(MVCController parentController) {
        return new ApplicationDialogController<CreateMailAccountDialog>(this, parentController);
    }

    private void buildUI() {
        JSeparator separator = new JSeparator(0);
        OrientablePanel contentPnl = new OrientablePanel(new BorderLayout());
        OrientablePanel btnPnl = new OrientablePanel(new GridBagLayout());
        OrientablePanel downPnl = new OrientablePanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.btnBack.setText(StringResources.BACK_G);
        this.btnNext.setText(StringResources.NEXT_G);
        this.btnBack.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateMailAccountDialog.this.btnBackPressed(e);
            }
        });
        this.btnNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateMailAccountDialog.this.btnNextPressed(e);
            }
        });
        this.btnBack.setEnabled(false);
        gbc.fill = 0;
        gbc.anchor = 22;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        btnPnl.add((Component)this.btnBack, gbc);
        gbc.gridx = 1;
        btnPnl.add((Component)this.btnNext, gbc);
        gbc.insets = new Insets(0, 10, 0, 0);
        gbc.gridx = 2;
        btnPnl.add((Component)this.getBtnCancel(), gbc);
        gbc.fill = 1;
        gbc.insets = new Insets(10, 0, 10, 0);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        downPnl.add((Component)separator, gbc);
        gbc.fill = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        downPnl.add((Component)btnPnl, gbc);
        this.btnBack.setMnemonic(66);
        this.btnNext.setMnemonic(78);
        contentPnl.add((Component)this.cardPnl, "Center");
        contentPnl.add((Component)downPnl, "South");
        this.cardPnl.add((Component)this.buildDialog1(), "1");
        this.cardPnl.add((Component)this.buildDialog2(), "2");
        this.dialog3 = this.buildDialog3();
        this.cardPnl.add((Component)this.dialog3, "3");
        contentPnl.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setContentPane(contentPnl);
        this.setDefaultCloseOperation(2);
        this.setTitle(TITLES[0]);
        this.pack();
        this.d1AccountNameField.requestFocus(true);
    }

    private OrientablePanel buildDialog1() {
        OrientablePanel dialog1 = new OrientablePanel(new BorderLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        GWTextArea d1LblMainText = new GWTextArea();
        OrientableLabel d1LblAccountName = new OrientableLabel(StringResources.CREATE_MAIL_ACCOUNT_D1_ACCOUNT_NAME);
        GWTextArea d1LblText = new GWTextArea();
        OrientableLabel d1LblAccountType = new OrientableLabel(StringResources.CREATE_MAIL_ACCOUNT_D1_ACCOUNT_TYPE);
        OrientablePanel d1MainPnl = new OrientablePanel(new GridBagLayout());
        OrientablePanel d1MainTextPnl = new OrientablePanel(new BorderLayout());
        OrientablePanel d1AccountNamePnl = new OrientablePanel(new GridBagLayout());
        OrientablePanel d1TextPnl = new OrientablePanel(new BorderLayout());
        OrientablePanel d1AccountTypePnl = new OrientablePanel(new GridBagLayout());
        OrientablePanel d1CheckBoxPnl = new OrientablePanel(new BorderLayout());
        ((JTextComponent)d1LblMainText).setText(StringResources.CREATE_MAIL_ACCOUNT_D1_TYPE_THE_NAME);
        ((JTextComponent)d1LblMainText).setEditable(false);
        d1LblMainText.setOpaque(false);
        ((JTextComponent)d1LblText).setText(StringResources.CREATE_MAIL_ACCOUNT_D1_SELECT_WHAT_TYPE);
        ((JTextComponent)d1LblText).setEditable(false);
        d1LblText.setOpaque(false);
        d1MainTextPnl.add((Component)d1LblMainText, "Center");
        gbc.insets = new Insets(0, 0, 0, 10);
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        d1AccountNamePnl.add((Component)d1LblAccountName, gbc);
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        d1AccountNamePnl.add((Component)this.d1AccountNameField, gbc);
        gbc.insets = new Insets(0, 0, 0, 10);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        d1AccountTypePnl.add((Component)d1LblAccountType, gbc);
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        d1AccountTypePnl.add((Component)this.d1AccountTypesComboBox, gbc);
        d1CheckBoxPnl.add((Component)this.d1UploadCheckBox, "Center");
        d1TextPnl.add((Component)d1LblText, "Center");
        gbc.insets = new Insets(0, 0, 10, 0);
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        d1MainPnl.add((Component)d1MainTextPnl, gbc);
        gbc.gridy = 1;
        d1MainPnl.add((Component)d1AccountNamePnl, gbc);
        gbc.gridy = 2;
        d1MainPnl.add((Component)d1TextPnl, gbc);
        gbc.gridy = 3;
        d1MainPnl.add((Component)d1AccountTypePnl, gbc);
        gbc.gridy = 4;
        d1MainPnl.add((Component)d1CheckBoxPnl, gbc);
        dialog1.add((Component)d1MainPnl, "North");
        return dialog1;
    }

    private OrientablePanel buildDialog2() {
        OrientablePanel dialog2 = new OrientablePanel(new BorderLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        GWTextArea d2LblMainText = new GWTextArea();
        OrientableLabel d2LblLoginName = new OrientableLabel(StringResources.LOGIN_NAME_C);
        OrientableLabel d2LblOutgoing = new OrientableLabel(StringResources.OUTGOING_MAIL_SERVER);
        OrientableLabel d2LblEMail = new OrientableLabel(StringResources.CREATE_ACCOUNT_D2_EMAIL_ADDRESS);
        OrientableLabel d2LblFromName = new OrientableLabel(StringResources.CREATE_ACCOUNT_D2_FROM_NAME);
        OrientablePanel d2MainPnl = new OrientablePanel(new GridBagLayout());
        OrientablePanel d2MainTextPnl = new OrientablePanel(new BorderLayout());
        OrientablePanel d2PnlIncoming = new OrientablePanel(new BorderLayout());
        OrientablePanel d2LoginNamePnl = new OrientablePanel(new BorderLayout());
        OrientablePanel d2PnlOutgoing = new OrientablePanel(new BorderLayout());
        OrientablePanel d2EMailPnl = new OrientablePanel(new BorderLayout());
        OrientablePanel d2FromNamePnl = new OrientablePanel(new BorderLayout());
        ((JTextComponent)d2LblMainText).setText(StringResources.CREATE_MAIL_ACCOUNT_D2_CONTACT_YOUR_INTERNET_SERVICE_PROVIDER);
        d2LblMainText.setOpaque(false);
        ((JTextComponent)d2LblMainText).setEditable(false);
        d2MainTextPnl.add((Component)d2LblMainText, "North");
        d2PnlIncoming.add((Component)this.d2LblIncoming, "North");
        d2PnlIncoming.add((Component)this.d2IncomingServerField, "Center");
        d2LoginNamePnl.add((Component)d2LblLoginName, "Before");
        d2LoginNamePnl.add((Component)this.d2LoginNameField, "Center");
        if (d2LoginNamePnl.getComponentOrientation() != ComponentOrientation.RIGHT_TO_LEFT) {
            d2LoginNamePnl.setBorder(new EmptyBorder(0, 40, 0, 0));
        } else {
            d2LoginNamePnl.setBorder(new EmptyBorder(0, 0, 0, 40));
        }
        d2PnlOutgoing.add((Component)d2LblOutgoing, "North");
        d2PnlOutgoing.add((Component)this.d2OutgoingServerField, "Center");
        d2EMailPnl.add((Component)d2LblEMail, "North");
        d2EMailPnl.add((Component)this.d2EmailAddressField, "Center");
        d2FromNamePnl.add((Component)d2LblFromName, "North");
        this.d2FromNameField = new GWTextField(GWCommandManager.getInstance(ControlsUtils.getUserGuid(this.getController())).getCurrentUserInfo().getFromText(), 20);
        d2FromNamePnl.add((Component)this.d2FromNameField, "Center");
        gbc.insets = new Insets(0, 0, 10, 0);
        gbc.anchor = 21;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        d2MainPnl.add((Component)d2MainTextPnl, gbc);
        gbc.gridy = 1;
        d2MainPnl.add((Component)d2PnlIncoming, gbc);
        gbc.gridy = 2;
        d2MainPnl.add((Component)d2LoginNamePnl, gbc);
        gbc.gridy = 3;
        d2MainPnl.add((Component)d2PnlOutgoing, gbc);
        gbc.gridy = 4;
        d2MainPnl.add((Component)d2EMailPnl, gbc);
        gbc.gridy = 5;
        d2MainPnl.add((Component)d2FromNamePnl, gbc);
        dialog2.add((Component)d2MainPnl, "North");
        return dialog2;
    }

    private OrientablePanel buildDialog3() {
        OrientablePanel dialog3 = new OrientablePanel(new BorderLayout());
        OrientablePanel d3MainPnl = new OrientablePanel(new BorderLayout());
        OrientablePanel d3LblPnl = new OrientablePanel(new BorderLayout());
        OrientableScrollPane d3TreeScroll = new OrientableScrollPane(this.d3CheckFoldersTree);
        OrientableLabel d3MainLbl = new OrientableLabel(StringResources.CREATE_MAIL_ACCOUNT_D3_SELECT_FOLDER);
        d3MainPnl.add((Component)d3TreeScroll, "Center");
        this.d3CreateNewFolderCheckBox.addItemListener(new CreateNewFolderItemListener());
        d3LblPnl.add((Component)this.d3CreateNewFolderCheckBox, "North");
        d3LblPnl.add((Component)d3MainLbl, "South");
        d3MainPnl.add((Component)d3LblPnl, "North");
        dialog3.add((Component)d3MainPnl, "Center");
        this.d3CheckFoldersTree.setComponentOrientation(UIUtils.getComponentOrientation());
        return dialog3;
    }

    public void btnBackPressed(ActionEvent e) {
        this.cardLayout.previous(this.cardPnl);
        if (this.currentDialog > 1) {
            --this.currentDialog;
        }
        if (this.currentDialog == 1) {
            this.btnBack.setEnabled(false);
            this.d1AccountNameField.requestFocus(true);
        }
        if (this.currentDialog > 1) {
            this.btnNext.setText(StringResources.NEXT_G);
        }
        this.setTitle(TITLES[this.currentDialog - 1]);
    }

    public void btnNextPressed(ActionEvent e) {
        if (this.currentDialog == 1) {
            if (this.d1AccountNameField.getText().length() == 0) {
                JOptionPane.showMessageDialog(this, StringResources.CREATE_MAIL_ACCOUNT_PLEASE_ENTER_AN_ACCOUNT_NAME);
                this.d1AccountNameField.requestFocus(true);
                return;
            }
            for (String currentName : this.names) {
                if (!this.d1AccountNameField.getText().equals(currentName)) continue;
                JOptionPane.showMessageDialog(this, StringResources.formatString(StringResources.THE_NAME_HAS_BEEN_ALREADY_USED, currentName) + '\n' + StringResources.PLEASE_ENTER_A_UNIQUE_ACCOUNT_NAME, StringResources.NOVELL_GROUPWISE, 1);
                this.d1AccountNameField.requestFocus(true);
                return;
            }
            this.folderIMAPNamePane.setFolderName(this.d1AccountNameField.getText());
            this.d2LblIncoming.setText(StringResources.formatString(StringResources.INCOMING_MAIL_SERVER, this.d1AccountTypesComboBox.getSelectedItem().toString()));
            if (this.d1AccountTypesComboBox.getSelectedItem() == StringResources.IMAP4) {
                this.cardPnl.remove(this.dialog3);
                this.cardPnl.remove(this.folderPOPNamePane);
                this.cardPnl.add((Component)this.folderIMAPNamePane, "3");
            } else {
                this.cardPnl.remove(this.folderIMAPNamePane);
                this.cardPnl.add((Component)this.dialog3, "3");
                this.cardPnl.add((Component)this.folderPOPNamePane, "4");
            }
        } else if (this.currentDialog == 2) {
            if (this.d2IncomingServerField.getText().length() == 0) {
                JOptionPane.showMessageDialog(this, StringResources.formatString(StringResources.CREATE_MAIL_ACCOUNT_PLEASE_ENTER_SERVER, this.d1AccountTypesComboBox.getSelectedItem().toString()));
                return;
            }
            if (this.d2LoginNameField.getText().length() == 0) {
                JOptionPane.showMessageDialog(this, StringResources.formatString(StringResources.CREATE_MAIL_ACCOUNT_PLEASE_ENTER_LOGIN, this.d2IncomingServerField.getText(), this.d1AccountTypesComboBox.getSelectedItem().toString()));
                return;
            }
            if (this.d2OutgoingServerField.getText().length() == 0) {
                JOptionPane.showMessageDialog(this, StringResources.formatString(StringResources.CREATE_MAIL_ACCOUNT_PLEASE_ENTER_SERVER, StringResources.SMTP));
                this.d2OutgoingServerField.setText(this.d2IncomingServerField.getText());
                return;
            }
            if (this.d1AccountTypesComboBox.getSelectedItem() == StringResources.IMAP4) {
                this.btnNext.setText(StringResources.FINISH);
            }
        } else if (this.currentDialog == 3) {
            if (!this.d3CreateNewFolderCheckBox.isSelected()) {
                this.createMailAccount(this.d3CheckFoldersTree.getSelectedFolder());
                return;
            }
            this.btnNext.setText(StringResources.FINISH);
        } else if (this.currentDialog == 4) {
            if (this.d1AccountTypesComboBox.getSelectedItem() == StringResources.IMAP4) {
                this.createMailAccount(this.createFolder(this.folderIMAPNamePane));
                return;
            }
            AbstractFolder folder = this.createFolder(this.folderPOPNamePane);
            if (folder != null) {
                this.createMailAccount(folder);
                return;
            }
            this.folderPOPNamePane.requestFocusForName();
        }
        this.btnBack.setEnabled(true);
        if (this.currentDialog < 4) {
            ++this.currentDialog;
            this.cardLayout.next(this.cardPnl);
            this.setTitle(TITLES[this.currentDialog - 1]);
        }
    }

    private AbstractFolder createFolder(FolderNamePane folderNamePane) {
        if (this.d1AccountTypesComboBox.getSelectedItem() == StringResources.IMAP4) {
            return null;
        }
        return AccountUtils.createFolder(folderNamePane, this.getController());
    }

    private void createMailAccount(AbstractFolder folder) {
        IDataStore dataStore = EngineCommandManager.getInstance(ControlsUtils.getUserGuid(this.getController())).getCurrentDataStore();
        if (this.d2EmailAddressField.getText().length() == 0) {
            this.d2EmailAddressField.setText(this.d2LoginNameField.getText() + '@' + this.d2IncomingServerField.getText());
        }
        Object account = null;
        account = this.d1AccountTypesComboBox.getSelectedItem() == StringResources.IMAP4 ? dataStore.createImapAccount(this.d1AccountNameField.getText(), this.d2IncomingServerField.getText(), this.d2LoginNameField.getText(), this.d2OutgoingServerField.getText(), this.d2EmailAddressField.getText(), this.d2FromNameField.getText(), this.folderIMAPNamePane.getParentFolder().getNativeFolder(), this.folderIMAPNamePane.getFolderPosition()) : dataStore.createPop3Account(this.d1AccountNameField.getText(), this.d2IncomingServerField.getText(), this.d2LoginNameField.getText(), this.d2OutgoingServerField.getText(), this.d2EmailAddressField.getText(), this.d2FromNameField.getText(), folder.getNativeFolder());
        logger.debug((Object)("canUploadToMaster: " + account.canUploadToMaster()));
        if (account.canUploadToMaster()) {
            account.setUploadToMaster(this.d1UploadCheckBox.isSelected(), true);
        }
        dataStore.writeMemoryCachedData();
        this.setVisible(false);
        this.dispose();
    }

    public void setNames(String[] names) {
        this.names = names;
    }

    private class CreateNewFolderItemListener
    implements ItemListener {
        private CreateNewFolderItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                CreateMailAccountDialog.this.d3CheckFoldersTree.setEnabled(false);
                CreateMailAccountDialog.this.btnNext.setEnabled(true);
                CreateMailAccountDialog.this.btnNext.setText(StringResources.NEXT_G);
            } else {
                CreateMailAccountDialog.this.d3CheckFoldersTree.setEnabled(true);
                if (CreateMailAccountDialog.this.d3CheckFoldersTree.getSelectedFolder() == null) {
                    CreateMailAccountDialog.this.btnNext.setEnabled(false);
                }
                CreateMailAccountDialog.this.btnNext.setText(StringResources.FINISH);
            }
        }
    }
}

