/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options;

import com.appframework.ApplicationFrame;
import com.appframework.mvc.MVCController;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialog;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.frames.options.Options;
import com.novell.gw.jclient.application.frames.options.OptionsDialogController;
import com.novell.gw.jclient.application.frames.options.compose.security.ChangePasswordPane;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionsDialog
extends ApplicationDialog<OptionsDialogController> {
    private Options optionsPane;
    private static final int top = 5;
    private static final int left = 5;
    private static final int bottom = 5;
    private static final int right = 5;
    private OptionsFrameModel model = new OptionsFrameModel(true);
    private String userGuid;

    public OptionsDialog(ApplicationFrame parentFrame, MVCController parentController) {
        super((Frame)parentFrame, parentController);
        if (OS.isMacOS()) {
            this.setTitle(StringResources.PREFERENCES);
        } else {
            this.setTitle(StringResources.OPTIONS);
        }
        this.setName("Frame Options");
        this.userGuid = ControlsUtils.getUserGuid(this);
        this.getBtnApply().setEnabled(false);
        this.buildUI();
        this.pack();
        this.setLocationRelativeTo(null);
    }

    @Override
    protected void processOkAction(ActionEvent event) {
        ChangePasswordPane changePasswordPane = this.getOptionsPane().getOptionsViewPane().getSecurityPane().getPnlPassword();
        if (changePasswordPane != null && changePasswordPane.isShowing()) {
            if (changePasswordPane.isOldPasswordValid()) {
                if (changePasswordPane.saveChanges()) {
                    this.setVisible(true);
                    this.save();
                    this.dispose();
                    return;
                }
                changePasswordPane.setFocusOldPassword();
            } else {
                changePasswordPane.checkOldPassword();
            }
        }
        this.setVisible(false);
        this.save();
        this.dispose();
    }

    @Override
    protected void processCloseAction(WindowEvent event) {
        super.processCloseAction(event);
        this.dispose();
    }

    @Override
    protected void processCancelAction(ActionEvent event) {
        super.processCancelAction(event);
        this.dispose();
    }

    public Options getOptionsPane() {
        return this.optionsPane;
    }

    private void buildUI() {
        this.optionsPane = new Options((MVCController)this.getController(), this.userGuid);
        this.optionsPane.setPreferencesPage("General");
        this.appendEmptyBorder(this.optionsPane);
        this.getContentPane().add((Component)this.optionsPane, "Center");
        this.getContentPane().add((Component)this.createButtonsPanel(), "South");
    }

    private void appendEmptyBorder(JPanel p) {
        if (p.getBorder() == null) {
            p.setBorder(new EmptyBorder(5, 5, 5, 5));
        } else {
            CompoundBorder border = BorderFactory.createCompoundBorder(new EmptyBorder(5, 5, 5, 5), p.getBorder());
            p.setBorder(border);
        }
    }

    @Override
    protected void processApplyAction(ActionEvent event) {
        this.save();
    }

    private JPanel createButtonsPanel() {
        OrientablePanel buttonPanel = new OrientablePanel(new FlowLayout(4));
        buttonPanel.setBorder(new EmptyBorder(0, 5, 5, 5));
        buttonPanel.add(this.createOkCancelApplyButtonsPanel());
        return buttonPanel;
    }

    public void setPreferencesPage(String name) {
        this.optionsPane.setPreferencesPage(name);
    }

    @Override
    protected OptionsDialogController createController(MVCController parentController) {
        return new OptionsDialogController(this, parentController);
    }

    @Override
    public void setMVCModel(Object theModel) {
        if (theModel instanceof OptionsFrameModel) {
            if (this.model.isOptinsApplied() == ((OptionsFrameModel)theModel).isOptinsApplied()) {
                return;
            }
            this.model = (OptionsFrameModel)theModel;
            if (this.model.isOptinsApplied()) {
                this.getBtnApply().setEnabled(false);
            } else {
                this.getBtnApply().setEnabled(true);
            }
        }
    }

    public void save() {
        this.optionsPane.getOptionsViewPane().saveOptions();
    }

    public String getUserGuid() {
        return this.userGuid;
    }

    public static class OptionsFrameModel {
        private boolean optinsApplied;

        public OptionsFrameModel(boolean theOptinsApplied) {
            this.optinsApplied = theOptinsApplied;
        }

        public boolean isOptinsApplied() {
            return this.optinsApplied;
        }
    }
}

