/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose;

import com.appframework.mvc.Command;
import com.appframework.mvc.GlobalCommand;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.frames.options.compose.ComposeOption;
import com.novell.gw.jclient.application.frames.options.compose.OptionsPaneController;
import com.novell.gw.jclient.application.frames.options.compose.dateAndTime.DateTimeOptionsPane;
import com.novell.gw.jclient.application.frames.options.compose.general.GeneralOptionPane;
import com.novell.gw.jclient.application.frames.options.compose.printing.PrintOptionsPane;
import com.novell.gw.jclient.application.frames.options.compose.security.SecurityOptionsPane;
import com.novell.gw.jclient.application.frames.options.compose.send.SendOptionsPane;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class OptionsViewPane
extends OrientablePanel
implements MVCView {
    private static Logger logger = Logger.getLogger(OptionsViewPane.class);
    private MVCController controller;
    private String selectedPageID;
    private HashMap mapOptions = new HashMap();
    private String userGuid;
    private GeneralOptionPane generalPane;
    private SendOptionsPane sendPane;
    private SecurityOptionsPane securityPane;
    private PrintOptionsPane printPane;
    private DateTimeOptionsPane dateTimePane;

    public OptionsViewPane(MVCController theParentController, String userGuid) {
        this.userGuid = userGuid;
        this.controller = new OptionsPaneController(this, theParentController);
        this.build();
    }

    private void build() {
        long t = System.currentTimeMillis();
        this.setLayout(new CardLayout());
        this.generalPane = new GeneralOptionPane("General", this.controller, this.userGuid);
        this.sendPane = new SendOptionsPane("Send", this.controller, this.userGuid);
        this.securityPane = new SecurityOptionsPane("Security", this.controller, this.userGuid);
        this.printPane = new PrintOptionsPane("Printing", this.controller);
        this.dateTimePane = new DateTimeOptionsPane("Date and Time", this.controller);
        this.putComposeOption(this.generalPane);
        this.putComposeOption(this.sendPane);
        this.putComposeOption(this.securityPane);
        this.putComposeOption(this.printPane);
        this.putComposeOption(this.dateTimePane);
        logger.debug((Object)("buildOptions time: " + (System.currentTimeMillis() - t)));
    }

    private void putComposeOption(ComposeOption co) {
        this.mapOptions.put(co.getOptionID(), co);
        this.add((Component)co, co.getOptionID());
    }

    public void setSelectedPage(String pageName) {
        ComposeOption currentOption = (ComposeOption)this.mapOptions.get(pageName);
        if (!currentOption.isPrepared) {
            currentOption.prepareForShow();
            currentOption.isPrepared = true;
        }
        ((CardLayout)this.getLayout()).show(this, pageName);
        this.selectedPageID = pageName;
        Command command = new Command(170, pageName);
        this.controller.processCommand(command);
    }

    public void setController(MVCController theController) {
        this.controller = theController;
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object theModel) {
    }

    public Object getMVCModel() {
        return this.selectedPageID;
    }

    public void saveOptions() {
        ComposeOption currentOption = (ComposeOption)this.mapOptions.get(this.selectedPageID);
        currentOption.save(this.controller);
        Command command = new Command(160);
        this.controller.processCommand(command);
        this.controller.processCommand(new GlobalCommand(85));
    }

    public SecurityOptionsPane getSecurityPane() {
        return this.securityPane;
    }

    protected void showPage(String pageName) {
        if (!this.selectedPageID.equals(pageName)) {
            ComposeOption currentOption = (ComposeOption)this.mapOptions.get(this.selectedPageID);
            if (currentOption.needSaving()) {
                int askRes = JOptionPane.showConfirmDialog(this, StringResources.SOME_OPTIONS_HAVE_BEEN_MODIFIEDK_DO, StringResources.SAVE_DIALOG, 1, 3);
                if (askRes == 0) {
                    this.processYesAnswer(currentOption, pageName);
                } else if (askRes == 1) {
                    this.processNoAnswer(currentOption, pageName);
                }
            } else {
                this.setSelectedPage(pageName);
            }
        }
    }

    private void processYesAnswer(ComposeOption currentOption, String pageName) {
        currentOption.save(this.controller);
        Command command = new Command(160);
        this.controller.processCommand(command);
        this.setSelectedPage(pageName);
    }

    private void processNoAnswer(ComposeOption currentOption, String pageName) {
        currentOption.putOptionValuesIntoFields();
        currentOption.changesListener.setValueSaved();
        Command command = new Command(160);
        this.controller.processCommand(command);
        this.setSelectedPage(pageName);
    }
}

