/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.dateAndTime;

import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import com.novell.gw.jclient.application.controls.orientable.MenuItemFactory;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.resources.ImageResources;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ButtonTextChooser
extends OrientableButton {
    private List<String> names;
    private int current;
    private int count;
    private List<JMenuItem> menuItems;
    public static final String BUTTON_SELECTED_TEXT_CHANGE = "ButtontextChooser selected text change";

    public ButtonTextChooser(List<String> items, int current) {
        super(items.get(current));
        this.names = items;
        this.current = current;
        this.initBtn();
    }

    public ButtonTextChooser(List<String> items, String current) {
        this.names = items;
        this.initBtn();
        this.setText(current);
    }

    private void adjustPreferredSize(List<String> strings) {
        String previousText = super.getText();
        super.setText(String.format(" %s ", Utils.getTheLongestTextOnScreen(this.getPreferredSize(), this.getFont(), strings)));
        Dimension preferredSize = this.getPreferredSize();
        super.setText(previousText);
        this.setPreferredSize(preferredSize);
    }

    private void initBtn() {
        this.count = this.names.size();
        this.setIcon(ImageResources.ADV_FILTER_UP_DOWN);
        this.setHorizontalTextPosition(2);
        this.adjustPreferredSize(this.names);
        GWPopupMenu popup = new GWPopupMenu();
        this.menuItems = new LinkedList<JMenuItem>();
        for (int i = 0; i < this.count; ++i) {
            JMenuItem menuItem = MenuItemFactory.createCkeckBoxMenuItem(this.names.get(i));
            this.menuItems.add(menuItem);
            popup.add(menuItem);
            menuItem.addActionListener(new CheckListener(i));
        }
        this.addActionListener(new ActionShowPopup(popup));
    }

    @Override
    public void setText(String text) {
        if (this.names.contains(text)) {
            super.setText(text);
            this.menuItems.get(this.current).setSelected(false);
            this.menuItems.get(this.names.indexOf(text)).setSelected(true);
            this.firePropertyChange(BUTTON_SELECTED_TEXT_CHANGE, this.names.get(this.current), this.names.get(this.names.indexOf(text)));
            this.current = this.names.indexOf(text);
        }
    }

    private class ActionShowPopup
    implements ActionListener {
        private final JPopupMenu popup;

        public ActionShowPopup(JPopupMenu popup) {
            this.popup = popup;
        }

        public void actionPerformed(ActionEvent e) {
            this.popup.show(ButtonTextChooser.this, 0, ButtonTextChooser.this.getHeight());
        }
    }

    private class CheckListener
    implements ActionListener {
        int thisNumber;

        public CheckListener(int number) {
            this.thisNumber = number;
        }

        public void actionPerformed(ActionEvent e) {
            ButtonTextChooser.this.setText((String)ButtonTextChooser.this.names.get(this.thisNumber));
        }
    }
}

