/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.dateAndTime;

import com.appframework.mvc.MVCController;
import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.jclient.api.enums.AppointmentAcceptLevel;
import com.novell.gw.jclient.application.controls.filechoser.OptionChangesListener;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextArea;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicCheckBox;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicRadioButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableSpinner;
import com.novell.gw.jclient.application.frames.options.compose.AbstractOptionPanel;
import com.novell.gw.jclient.application.frames.options.compose.dateAndTime.TimePickerPanel;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.options.AbstractCloneObject;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public class CalendarOptionsPanel
extends AbstractOptionPanel {
    Logger logger = Logger.getLogger(CalendarOptionsPanel.class);
    private JCheckBox cbShowWeekNumber;
    private JCheckBox cbIncludeMyselfOnNewApp;
    private JCheckBox cbAppintments;
    private JCheckBox cbAllDayEvents;
    private JCheckBox cbHighlightWeekends;
    private JCheckBox cbOnAcceptContinueToDisplayItem;
    private JRadioButton rbDuration;
    private JRadioButton rbEndDateAndTime;
    private JSpinner spnAppHours;
    private JSpinner spnAppMinutes;
    private JSpinner spnAlarmHours;
    private JSpinner spnAlarmMinutes;
    private JSpinner spnAlarmAppointmentsHours;
    private JSpinner spnAlarmAppointmentsMinutes;
    private TimePickerPanel pnlTimePicker;
    private JComboBox cmbFirstDayOfWeek;
    private OrientableComboBox cmbAcceptLevel;

    public CalendarOptionsPanel(OptionChangesListener theChangesListener, MVCController theParentController) {
        super(theChangesListener, theParentController);
        this.isPrepared = true;
        this.build();
    }

    private void init() {
        this.cbShowWeekNumber = new JMnemonicCheckBox(StringResources.SHOW_WEEK_NUMBER);
        this.cbShowWeekNumber.addItemListener(this.itemListener);
        this.cbIncludeMyselfOnNewApp = new JMnemonicCheckBox(StringResources.INCLUDE_MYSELF_ON_NEW_APPOINTMENTS);
        this.cbIncludeMyselfOnNewApp.addItemListener(this.itemListener);
        this.cbHighlightWeekends = new JMnemonicCheckBox(StringResources.HIGHLIGHT_WEEKENDS);
        this.cbHighlightWeekends.addItemListener(this.itemListener);
        this.rbDuration = new JMnemonicRadioButton(StringResources.DURATION);
        this.rbDuration.addItemListener(this.itemListener);
        this.rbEndDateAndTime = new JMnemonicRadioButton(StringResources.END_DATE_AND_TIME);
        this.rbEndDateAndTime.addItemListener(this.itemListener);
        this.spnAppHours = new OrientableSpinner(new SpinnerNumberModel(0, 0, 120, 1));
        this.spnAppHours.addChangeListener(new AbstractOptionPanel.CustomItemChangeListener(this.changesListener));
        this.spnAppMinutes = new OrientableSpinner(new SpinnerNumberModel(0, 0, 59, 1));
        this.spnAppMinutes.addChangeListener(new AbstractOptionPanel.CustomItemChangeListener(this.changesListener));
        this.pnlTimePicker = new TimePickerPanel(this.changesListener, this.controller);
        this.spnAlarmHours = new OrientableSpinner(new SpinnerNumberModel(0, 0, 255, 1));
        this.spnAlarmHours.addChangeListener(new AbstractOptionPanel.CustomItemChangeListener(this.changesListener));
        this.spnAlarmMinutes = new OrientableSpinner(new SpinnerNumberModel(0, 0, 59, 1));
        this.spnAlarmMinutes.addChangeListener(new AbstractOptionPanel.CustomItemChangeListener(this.changesListener));
        this.spnAlarmAppointmentsHours = new OrientableSpinner(new SpinnerNumberModel(1, 0, 255, 1));
        this.spnAlarmAppointmentsHours.addChangeListener(new AbstractOptionPanel.CustomItemChangeListener(this.changesListener));
        this.spnAlarmAppointmentsMinutes = new OrientableSpinner(new SpinnerNumberModel(0, 0, 59, 1));
        this.spnAlarmAppointmentsMinutes.addChangeListener(new AbstractOptionPanel.CustomItemChangeListener(this.changesListener));
        this.cbAppintments = new OrientableCheckBox(StringResources.APPOINTMENTS);
        this.cbAppintments.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean b = CalendarOptionsPanel.this.cbAppintments.isSelected();
                CalendarOptionsPanel.this.spnAlarmAppointmentsHours.setEnabled(b);
                CalendarOptionsPanel.this.spnAlarmAppointmentsMinutes.setEnabled(b);
            }
        });
        this.cbAppintments.setSelected(true);
        this.cbAppintments.addItemListener(this.itemListener);
        this.cbAllDayEvents = new OrientableCheckBox(StringResources.ALL_DAY_EVENTS);
        this.cbAllDayEvents.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean b = CalendarOptionsPanel.this.cbAllDayEvents.isSelected();
                CalendarOptionsPanel.this.spnAlarmHours.setEnabled(b);
                CalendarOptionsPanel.this.spnAlarmMinutes.setEnabled(b);
            }
        });
        this.cbAllDayEvents.setSelected(true);
        this.cbAllDayEvents.addItemListener(this.itemListener);
        this.cmbFirstDayOfWeek = new OrientableComboBox(GWCalendarUtils.dayNames);
        this.cmbFirstDayOfWeek.addItemListener(this.itemListener);
        this.cmbAcceptLevel = new OrientableComboBox((Object[])new AppointmentAcceptLevel[]{AppointmentAcceptLevel.FREE, AppointmentAcceptLevel.TENTATIVE, AppointmentAcceptLevel.BUSY, AppointmentAcceptLevel.OUT_OF_OFFICE, AppointmentAcceptLevel.USE_SEND_VALUE});
        this.cbOnAcceptContinueToDisplayItem = new OrientableCheckBox();
        this.cbOnAcceptContinueToDisplayItem.addItemListener(this.itemListener);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbDuration);
        buttonGroup.add(this.rbEndDateAndTime);
    }

    private void buildUI() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 23;
        constraints.fill = 2;
        this.add((Component)this.createMonthDisplayOption(), constraints);
        ++constraints.gridy;
        constraints.weighty = 1.0;
        this.add((Component)this.createAppointmentOptions(), constraints);
        ++constraints.gridx;
        constraints.gridy = 0;
        constraints.gridheight = 2;
        constraints.weighty = 0.0;
        constraints.insets.left = 5;
        this.add((Component)this.createAcceptOptions(), constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        constraints.gridwidth = 2;
        constraints.weighty = 1.0;
        this.add((Component)new JPanel(), constraints);
    }

    protected void build() {
        this.init();
        this.buildUI();
    }

    public void collectValues() {
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        dataStoreSettings.setMonthCalendarShowWeekNumber(this.cbShowWeekNumber.isSelected());
        dataStoreSettings.setAppointmentIncludeSelf(this.cbIncludeMyselfOnNewApp.isSelected());
        dataStoreSettings.setAppointmentEventMode(this.rbDuration.isSelected() ? 0 : 1);
        int time = (Integer)this.spnAppHours.getValue() * 60 + (Integer)this.spnAppMinutes.getValue();
        dataStoreSettings.setAppointmentDefaultLength(time);
        dataStoreSettings.setAppointmentAlarmSet(this.cbAppintments.isSelected());
        time = (Integer)this.spnAlarmAppointmentsHours.getValue() * 60 + (Integer)this.spnAlarmAppointmentsMinutes.getValue();
        dataStoreSettings.setAppointmentAlarmMinutes(time);
        dataStoreSettings.setAllDayEventAlarmSet(this.cbAllDayEvents.isSelected());
        time = (Integer)this.spnAlarmHours.getValue() * 60 + (Integer)this.spnAlarmMinutes.getValue();
        dataStoreSettings.setAllDayEventAlarmMinutes(time);
        dataStoreSettings.setCalendarWorkDayStartTime(this.pnlTimePicker.getStartTime());
        dataStoreSettings.setCalendarWorkDayEndTime(this.pnlTimePicker.getEndTime());
        dataStoreSettings.setMonthCalendarFirstDay(this.cmbFirstDayOfWeek.getSelectedIndex());
        dataStoreSettings.setMyAllDayEventAcceptLevel(((AppointmentAcceptLevel)((Object)this.cmbAcceptLevel.getSelectedItem())).getValue());
        dataStoreSettings.setMonthCalendarHighlightDays(this.cbHighlightWeekends.isSelected() ? 1 : 0);
        dataStoreSettings.setLeaveItemInInboxOnAccept(this.cbOnAcceptContinueToDisplayItem.isSelected());
    }

    public void fireOptionsChanged() {
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        this.cbShowWeekNumber.setEnabled(!dataStoreSettings.getMonthCalendarShowWeekNumber().isLocked());
        this.cbShowWeekNumber.setSelected((Boolean)dataStoreSettings.getMonthCalendarShowWeekNumber().getValue());
        this.cbIncludeMyselfOnNewApp.setEnabled(!dataStoreSettings.getAppointmentIncludeSelf().isLocked());
        this.cbIncludeMyselfOnNewApp.setSelected((Boolean)dataStoreSettings.getAppointmentIncludeSelf().getValue());
        this.rbEndDateAndTime.setEnabled(!dataStoreSettings.getAppointmentEventMode().isLocked());
        this.rbEndDateAndTime.setSelected(true);
        this.rbDuration.setEnabled(!dataStoreSettings.getAppointmentEventMode().isLocked());
        this.rbDuration.setSelected((Integer)dataStoreSettings.getAppointmentEventMode().getValue() == 0);
        int time = (Integer)dataStoreSettings.getAppointmentDefaultLength().getValue();
        int hours = time / 60;
        this.spnAppHours.setEnabled(!dataStoreSettings.getAppointmentDefaultLength().isLocked());
        this.spnAppHours.getModel().setValue(hours);
        int minutes = time - hours * 60;
        this.spnAppMinutes.getModel().setValue(minutes);
        this.spnAppMinutes.setEnabled(!dataStoreSettings.getAppointmentDefaultLength().isLocked());
        this.cbAppintments.setSelected((Boolean)dataStoreSettings.getAppointmentAlarmSet().getValue());
        time = (Integer)dataStoreSettings.getAppointmentAlarmMinutes().getValue();
        hours = time / 60;
        boolean enabledSpinner = !dataStoreSettings.getAppointmentAlarmMinutes().isLocked() && this.cbAppintments.isSelected();
        this.spnAlarmAppointmentsHours.setEnabled(enabledSpinner);
        this.spnAlarmAppointmentsHours.getModel().setValue(hours);
        minutes = time - hours * 60;
        this.spnAlarmAppointmentsMinutes.setEnabled(enabledSpinner);
        this.spnAlarmAppointmentsMinutes.getModel().setValue(minutes);
        this.cbAllDayEvents.setSelected((Boolean)dataStoreSettings.getAllDayEventAlarmSet().getValue());
        this.cbAllDayEvents.setEnabled(!dataStoreSettings.getAllDayEventAlarmSet().isLocked());
        time = (Integer)dataStoreSettings.getAllDayEventAlarmMinutes().getValue();
        hours = time / 60;
        this.spnAlarmHours.getModel().setValue(hours);
        enabledSpinner = !dataStoreSettings.getAllDayEventAlarmMinutes().isLocked() && this.cbAllDayEvents.isSelected();
        this.spnAlarmHours.setEnabled(enabledSpinner);
        minutes = time - hours * 60;
        this.spnAlarmMinutes.getModel().setValue(minutes);
        this.spnAlarmMinutes.setEnabled(enabledSpinner);
        this.pnlTimePicker.setStartTime((Integer)dataStoreSettings.getCalendarWorkDayStartTime().getValue());
        this.pnlTimePicker.setEnabled(!dataStoreSettings.getCalendarWorkDayStartTime().isLocked());
        this.pnlTimePicker.setEndTime((Integer)dataStoreSettings.getCalendarWorkDayEndTime().getValue());
        this.cmbFirstDayOfWeek.setSelectedIndex((Integer)dataStoreSettings.getMonthCalendarFirstDay().getValue());
        this.cmbFirstDayOfWeek.setEnabled(!dataStoreSettings.getMonthCalendarFirstDay().isLocked());
        int value = (Integer)dataStoreSettings.getMyAllDayEventAcceptLevel().getValue();
        this.cmbAcceptLevel.setSelectedItem((Object)AppointmentAcceptLevel.getEnumForOptions(value));
        if ((Integer)dataStoreSettings.getMonthCalendarHighlightDays().getValue() == 1) {
            this.cbHighlightWeekends.setSelected(true);
        }
        this.cbHighlightWeekends.setEnabled(!dataStoreSettings.getMonthCalendarHighlightDays().isLocked());
        this.cbOnAcceptContinueToDisplayItem.setEnabled(!dataStoreSettings.getLeaveItemInInboxOnAccept().isLocked());
        this.cbOnAcceptContinueToDisplayItem.setSelected((Boolean)dataStoreSettings.getLeaveItemInInboxOnAccept().getValue());
    }

    public void setOptions(AbstractCloneObject theAbstractOptions) throws IllegalArgumentException {
    }

    private JPanel createLabel() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 21;
        panel.add((Component)this.cbOnAcceptContinueToDisplayItem, constraints);
        GWTextArea str = new GWTextArea();
        ((JTextComponent)str).setEditable(false);
        str.setOpaque(false);
        ((JTextComponent)str).setText(StringResources.ON_ACCEPT_CONTINUE_TO_DISPLAY_THE_ITEM_IN_MAILBOX);
        ++constraints.gridx;
        constraints.insets = new Insets(5, 0, 5, 0);
        constraints.weightx = 1.0;
        constraints.fill = 2;
        panel.add((Component)str, constraints);
        return panel;
    }

    private JPanel createMonthDisplayOption() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        panel.setBorder(new TitledBorder(StringResources.CALENDAR_DISPLAY_OPTIONS));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(10, 10, 0, 0);
        panel.add((Component)new OrientableLabel(StringResources.FIRST_DAY_OF_WEEK_C), constraints);
        ++constraints.gridx;
        constraints.insets.right = 10;
        constraints.weightx = 1.0;
        panel.add((Component)this.cmbFirstDayOfWeek, constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.gridwidth = 2;
        panel.add((Component)this.cbHighlightWeekends, constraints);
        ++constraints.gridy;
        constraints.insets = new Insets(0, 10, 10, 10);
        panel.add((Component)this.cbShowWeekNumber, constraints);
        return panel;
    }

    private JPanel createAppointmentOptions() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        panel.setBorder(new TitledBorder(StringResources.APPOINTMENT_OPTIONS));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 3;
        constraints.weightx = 1.0;
        constraints.anchor = 23;
        constraints.insets = new Insets(10, 10, 0, 10);
        panel.add((Component)this.cbIncludeMyselfOnNewApp, constraints);
        constraints.gridy = 1;
        panel.add((Component)new OrientableLabel(StringResources.DISPLAY_APPOINTMENT_LENGTH_USING_C), constraints);
        constraints.gridy = 2;
        constraints.weightx = 0.0;
        constraints.insets.top = 0;
        panel.add((Component)this.rbDuration, constraints);
        constraints.gridy = 3;
        panel.add((Component)this.rbEndDateAndTime, constraints);
        constraints.gridy = 4;
        constraints.anchor = 21;
        constraints.insets.top = 10;
        panel.add((Component)new OrientableLabel(StringResources.DEFAULT_APPOINTMENT_LENGTH_C), constraints);
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.weightx = 1.0;
        constraints.gridwidth = 1;
        panel.add((Component)new OrientableLabel(), constraints);
        constraints.gridx = 1;
        constraints.weightx = 0.0;
        constraints.insets = new Insets(5, 10, 0, 10);
        constraints.anchor = 21;
        panel.add((Component)new JMnemonicLabel(StringResources.HOURS_C, this.spnAppHours), constraints);
        constraints.gridx = 2;
        panel.add((Component)new JMnemonicLabel(StringResources.MINUTES_C, this.spnAppMinutes), constraints);
        constraints.gridx = 1;
        constraints.gridy = 6;
        constraints.insets.top = 10;
        constraints.insets.bottom = 10;
        panel.add((Component)this.spnAppHours, constraints);
        constraints.gridx = 2;
        panel.add((Component)this.spnAppMinutes, constraints);
        return panel;
    }

    private JPanel createAcceptOptions() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        panel.setBorder(new TitledBorder(StringResources.ACCEPT_OPTIONS));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 3;
        constraints.anchor = 23;
        constraints.insets = new Insets(10, 10, 0, 0);
        panel.add((Component)new OrientableLabel(StringResources.ON_ACCEPT_SET_A_DEFAULT_ALARM_FOR_C), constraints);
        constraints.gridy = 2;
        constraints.gridheight = 1;
        constraints.insets.top = 5;
        constraints.gridwidth = 1;
        constraints.anchor = 21;
        panel.add((Component)this.cbAppintments, constraints);
        constraints.gridy = 3;
        constraints.insets.bottom = 5;
        panel.add((Component)this.cbAllDayEvents, constraints);
        constraints.gridy = 1;
        constraints.gridx = 1;
        constraints.gridwidth = 1;
        panel.add((Component)new JMnemonicLabel(StringResources.HOURS_C, this.spnAlarmHours), constraints);
        constraints.gridx = 2;
        panel.add((Component)new JMnemonicLabel(StringResources.MINUTES_C, this.spnAlarmMinutes), constraints);
        constraints.gridy = 2;
        constraints.gridx = 1;
        constraints.insets.top = 5;
        panel.add((Component)this.spnAlarmAppointmentsHours, constraints);
        constraints.gridx = 2;
        panel.add((Component)this.spnAlarmAppointmentsMinutes, constraints);
        constraints.gridx = 1;
        constraints.gridy = 3;
        constraints.insets.bottom = 5;
        panel.add((Component)this.spnAlarmHours, constraints);
        constraints.gridx = 2;
        constraints.weightx = 1.0;
        panel.add((Component)this.spnAlarmMinutes, constraints);
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.weighty = 1.0;
        constraints.gridwidth = 3;
        constraints.anchor = 23;
        constraints.insets.bottom = 10;
        constraints.fill = 2;
        panel.add((Component)this.createLabel(), constraints);
        constraints.gridy = 5;
        constraints.insets.bottom = 0;
        constraints.fill = 0;
        panel.add((Component)new OrientableLabel(StringResources.ACCEPT_ALL_DAY_EVENTS_I_SEND_TO_MYSELF_AS_C), constraints);
        constraints.gridy = 6;
        this.cmbAcceptLevel.addItemListener(this.itemListener);
        panel.add((Component)this.cmbAcceptLevel, constraints);
        return panel;
    }
}

