/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.dateAndTime;

import com.appframework.ApplicationFrame;
import com.appframework.ApplicationFrameActionList;
import com.appframework.mvc.GlobalCommand;
import com.appframework.mvc.MVCController;
import com.appframework.utils.NetUtils;
import com.appframework.utils.ToolkitUtils;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.filechoser.OptionChangesListener;
import com.novell.gw.jclient.application.controls.gwcalendar.DateAndTimeFormattingUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.frames.help.FrameHelp;
import com.novell.gw.jclient.application.frames.options.compose.AbstractOptionPanel;
import com.novell.gw.jclient.application.frames.options.compose.dateAndTime.ButtonTextChooser;
import com.novell.gw.jclient.application.frames.options.compose.dateAndTime.DateAndTimeFormat;
import com.novell.gw.jclient.application.frames.options.compose.dateAndTime.DateTimeOptionsPane;
import com.novell.gw.jclient.application.frames.options.compose.dateAndTime.ExtendedComboBox;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.options.AbstractCloneObject;
import com.novell.gw.jclient.bl.om.options.DateTimeOptions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTimeFormatOptionsPanel
extends AbstractOptionPanel {
    private static Logger logger = Logger.getLogger(DateTimeOptionsPane.class);
    public final String[] monthes = GWCalendarUtils.monthNames;
    ButtonTextChooser btnDate;
    ButtonTextChooser btnWindowOptions;
    ButtonTextChooser btnPropertiesOptions;
    ButtonTextChooser btnFileOptions;
    private OrientableLabel lblSystemFormatsLongDate = new OrientableLabel();
    private OrientableLabel lblSystemFormatsTime = new OrientableLabel();
    private OrientableLabel lblSystemFormatsShortDate = new OrientableLabel();
    private OrientableLabel lblGeneralFormatsDate = new OrientableLabel();
    private OrientableLabel lblGeneralFormatsTime = new OrientableLabel();
    private OrientableLabel lblSpecificFormatsWindow = new OrientableLabel();
    private OrientableLabel lblSpecificFormatsProperties = new OrientableLabel();
    private OrientableLabel lblSpecificFormatsFile = new OrientableLabel();
    private ExtendedComboBox cmbTime;
    private ExtendedComboBox cmbShortDate;
    private ExtendedComboBox cmbLongDate;
    private OrientableButton btnHelpTime;
    private OrientableButton btnHelpShortDate;
    private OrientableButton btnHelpLongDate;
    private DateTimeOptions dateTime;
    private OptionChangesListener changeListener;
    private JPopupMenu popup = new GWPopupMenu();
    private JLabel helpLabel = new OrientableLabel();
    private String prevTime;
    private String prevShortDate;
    private String prevLongDate;
    private boolean helpButtonsVisible = false;

    public DateTimeFormatOptionsPanel(DateTimeOptions theDateTime, OptionChangesListener theChangesListener, MVCController parentController) {
        super(theChangesListener, parentController);
        this.dateTime = theDateTime.clone();
        this.changeListener = theChangesListener;
        this.cmbTime = new ExtendedComboBox(DateAndTimeFormattingUtils.TIME_DEFAULT_TYPES);
        this.cmbShortDate = new ExtendedComboBox(DateAndTimeFormattingUtils.SHORT_DATE_DEFAULT_TYPES);
        this.cmbLongDate = new ExtendedComboBox(DateAndTimeFormattingUtils.LONG_DATE_DEFAULT_TYPES);
    }

    @Override
    public void collectValues() {
        String currentTimeFormat = (String)this.cmbTime.getSelectedItem();
        String currentShortDateFormat = (String)this.cmbShortDate.getSelectedItem();
        String currentLongDateFormat = (String)this.cmbLongDate.getSelectedItem();
        this.dateTime.setTimeFormat(currentTimeFormat);
        this.dateTime.setShortDateFormat(currentShortDateFormat);
        this.dateTime.setLongDateFormat(currentLongDateFormat);
        DateAndTimeFormat selectedFormat = DateAndTimeFormat.getDateAndTimeFormat(this.btnFileOptions.getText());
        String stringValue = DateAndTimeFormattingUtils.convertDateAndTimeFormatToString(selectedFormat, currentTimeFormat, currentShortDateFormat, currentLongDateFormat);
        this.dateTime.setFileInfoFormat(stringValue);
        selectedFormat = DateAndTimeFormat.getDateAndTimeFormat(this.btnPropertiesOptions.getText());
        stringValue = DateAndTimeFormattingUtils.convertDateAndTimeFormatToString(selectedFormat, currentTimeFormat, currentShortDateFormat, currentLongDateFormat);
        this.dateTime.setPropertiesFormat(stringValue);
        selectedFormat = DateAndTimeFormat.getDateAndTimeFormat(this.btnWindowOptions.getText());
        stringValue = DateAndTimeFormattingUtils.convertDateAndTimeFormatToString(selectedFormat, currentTimeFormat, currentShortDateFormat, currentLongDateFormat);
        this.dateTime.setMainWindowFormat(stringValue);
        selectedFormat = DateAndTimeFormat.getDateAndTimeFormat(this.btnDate.getText());
        stringValue = DateAndTimeFormattingUtils.convertDateAndTimeFormatToString(selectedFormat, currentTimeFormat, currentShortDateFormat, currentLongDateFormat);
        this.dateTime.setDateFormat(stringValue);
        OptionManager.getInstance().setDateTimeOptions(this.dateTime);
        this.controller.processCommand(new GlobalCommand(1880));
    }

    @Override
    public void setOptions(AbstractCloneObject theAbstractOptions) throws IllegalArgumentException {
    }

    @Override
    protected void build() {
        this.helpButtonsVisible = ToolkitUtils.isModalExclusionTypeSupported(ToolkitUtils.ModalExclusionType.APPLICATION_EXCLUDE);
        logger.debug((Object)("helpButtonsVisible: " + this.helpButtonsVisible));
        this.init();
        this.buildUI();
    }

    private void init() {
        String currentTimeFormat = this.dateTime.getTimeFormat();
        String currentShortDateFormat = this.dateTime.getShortDateFormat();
        String currentLongDateFormat = this.dateTime.getLongDateFormat();
        List<String> list = new ArrayList<String>();
        list.add(DateAndTimeFormat.DATE_LONG.getLocalizedName());
        list.add(DateAndTimeFormat.DATE_SHORT.getLocalizedName());
        String selectedLocalizedName = DateTimeFormatOptionsPanel.getFormatLocalizedName(this.dateTime.getDateFormat(), currentTimeFormat, currentShortDateFormat, currentLongDateFormat, list, DateAndTimeFormat.DATE_LONG.getLocalizedName());
        this.btnDate = new ButtonTextChooser(list, selectedLocalizedName);
        list = DateAndTimeFormat.getLocalizedNames();
        selectedLocalizedName = DateTimeFormatOptionsPanel.getFormatLocalizedName(this.dateTime.getMainWindowFormat(), currentTimeFormat, currentShortDateFormat, currentLongDateFormat, list, DateAndTimeFormat.SHORT_DATE_TIME.getLocalizedName());
        this.btnWindowOptions = new ButtonTextChooser(list, selectedLocalizedName);
        selectedLocalizedName = DateTimeFormatOptionsPanel.getFormatLocalizedName(this.dateTime.getPropertiesFormat(), currentTimeFormat, currentShortDateFormat, currentLongDateFormat, list, DateAndTimeFormat.SHORT_DATE_TIME.getLocalizedName());
        this.btnPropertiesOptions = new ButtonTextChooser(list, selectedLocalizedName);
        selectedLocalizedName = DateTimeFormatOptionsPanel.getFormatLocalizedName(this.dateTime.getFileInfoFormat(), currentTimeFormat, currentShortDateFormat, currentLongDateFormat, list, DateAndTimeFormat.SHORT_DATE_TIME.getLocalizedName());
        this.btnFileOptions = new ButtonTextChooser(list, selectedLocalizedName);
        ButtonChangeListener buttonChangeListener = new ButtonChangeListener();
        this.btnDate.addPropertyChangeListener(buttonChangeListener);
        this.btnWindowOptions.addPropertyChangeListener(buttonChangeListener);
        this.btnPropertiesOptions.addPropertyChangeListener(buttonChangeListener);
        this.btnFileOptions.addPropertyChangeListener(buttonChangeListener);
        if (this.helpButtonsVisible) {
            this.btnHelpTime = new OrientableButton("?");
            this.btnHelpShortDate = new OrientableButton("?");
            this.btnHelpLongDate = new OrientableButton("?");
            this.btnHelpTime.setMargin(new Insets(1, 1, 1, 1));
            this.btnHelpShortDate.setMargin(new Insets(1, 1, 1, 1));
            this.btnHelpLongDate.setMargin(new Insets(1, 1, 1, 1));
            this.btnHelpTime.addActionListener(new FormatHelpActionListener(DateTimeFormatType.TIME));
            this.btnHelpLongDate.addActionListener(new FormatHelpActionListener(DateTimeFormatType.DATE_LONG));
            this.btnHelpShortDate.addActionListener(new FormatHelpActionListener(DateTimeFormatType.DATE_SHORT));
        }
        this.popup.add(this.helpLabel);
        this.cmbTime.setPreferredSize(this.calcSize());
        this.cmbTime.setEditable(true);
        this.cmbLongDate.setEditable(true);
        this.cmbShortDate.setEditable(true);
        this.cmbTime.addActionListener(new TimeFormatActionListener());
        this.cmbShortDate.addActionListener(new ShortDateFormatActionListener());
        this.cmbLongDate.addActionListener(new LongDateFormatActionListener());
    }

    private static String getFormatLocalizedName(String format, String customTimeFormat, String customShortDateFormat, String customLongDateFormat, List<String> acceptableValues, String defaultValue) {
        assert (acceptableValues != null && acceptableValues.size() > 0 && acceptableValues.get(0) != null);
        try {
            DateAndTimeFormat dateAndTimeFormat = DateAndTimeFormattingUtils.convertStringToDateAndTimeFormat(format, customTimeFormat, customShortDateFormat, customLongDateFormat);
            String localizedName = dateAndTimeFormat.getLocalizedName();
            if (acceptableValues.contains(localizedName)) {
                return localizedName;
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
        if (acceptableValues.contains(defaultValue)) {
            return defaultValue;
        }
        return acceptableValues.get(0);
    }

    private Dimension calcSize() {
        return new Dimension(UIUtils.getColumnWidth(15, this.cmbTime), (int)this.cmbTime.getPreferredSize().getHeight());
    }

    private void buildUI() {
        this.setLayout(new BorderLayout());
        OrientablePanel pnlMain = new OrientablePanel(new BorderLayout());
        OrientablePanel pnlUp = new OrientablePanel(new BorderLayout());
        OrientablePanel pnlMid = new OrientablePanel(new BorderLayout());
        OrientablePanel pnlDown = new OrientablePanel(new BorderLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        OrientablePanel pnl = new OrientablePanel(new GridBagLayout());
        gbc.insets = new Insets(0, 0, 5, 5);
        gbc.anchor = 21;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        OrientableLabel lbl = new OrientableLabel(StringResources.TIME_C);
        pnl.add((Component)lbl, gbc);
        gbc.gridx = 1;
        gbc.insets = new Insets(0, this.getUpInset(), 5, 5);
        OrientablePanel pnl2 = new OrientablePanel(new BorderLayout());
        pnl2.add((Component)this.cmbTime, "Center");
        if (this.helpButtonsVisible) {
            pnl2.add((Component)this.btnHelpTime, "After");
        }
        pnl.add((Component)pnl2, gbc);
        gbc.insets = new Insets(0, 0, 5, 5);
        gbc.gridx = 2;
        pnl.add((Component)this.lblSystemFormatsTime, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        lbl = new OrientableLabel(StringResources.SHORT_DATE);
        pnl.add((Component)lbl, gbc);
        gbc.gridx = 1;
        gbc.insets = new Insets(0, this.getUpInset(), 5, 5);
        pnl2 = new OrientablePanel(new BorderLayout());
        pnl2.add((Component)this.cmbShortDate, "Center");
        if (this.helpButtonsVisible) {
            pnl2.add((Component)this.btnHelpShortDate, "After");
        }
        pnl.add((Component)pnl2, gbc);
        gbc.insets = new Insets(0, 0, 5, 5);
        gbc.gridx = 2;
        pnl.add((Component)this.lblSystemFormatsShortDate, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        lbl = new OrientableLabel(StringResources.LONG_DATE);
        pnl.add((Component)lbl, gbc);
        gbc.gridx = 1;
        gbc.insets = new Insets(0, this.getUpInset(), 5, 5);
        pnl2 = new OrientablePanel(new BorderLayout());
        pnl2.add((Component)this.cmbLongDate, "Center");
        if (this.helpButtonsVisible) {
            pnl2.add((Component)this.btnHelpLongDate, "After");
        }
        pnl.add((Component)pnl2, gbc);
        gbc.insets = new Insets(0, 0, 5, 5);
        gbc.gridx = 2;
        pnl.add((Component)this.lblSystemFormatsLongDate, gbc);
        gbc.fill = 1;
        pnl2 = new OrientablePanel();
        gbc.gridheight = 3;
        gbc.weightx = 1.0;
        gbc.gridx = 2;
        gbc.gridy = 0;
        pnl.add((Component)pnl2, gbc);
        pnlUp.add((Component)pnl, "Before");
        gbc.gridheight = 1;
        pnl = new OrientablePanel(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 0, 0, 5);
        lbl = new OrientableLabel(StringResources.TIME_C);
        pnl.add((Component)lbl, gbc);
        gbc.gridx = 1;
        gbc.insets = new Insets(5, this.getMidInset(), 0, 5);
        pnl.add((Component)this.lblGeneralFormatsTime, gbc);
        gbc.gridx = 0;
        gbc.insets = new Insets(5, 0, 0, 5);
        gbc.gridy = 1;
        lbl = new OrientableLabel(StringResources.DATE);
        pnl.add((Component)lbl, gbc);
        gbc.gridx = 1;
        gbc.insets = new Insets(0, this.getMidInset(), 0, 5);
        pnl.add((Component)this.btnDate, gbc);
        gbc.insets = new Insets(5, 0, 0, 5);
        gbc.gridx = 2;
        pnl.add((Component)this.lblGeneralFormatsDate, gbc);
        gbc.insets = new Insets(0, 0, 0, 0);
        pnlMid.add((Component)pnl, "Before");
        pnl = new OrientablePanel(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 0, 5, 5);
        lbl = new OrientableLabel(StringResources.MAIN_WINDOW);
        pnl.add((Component)lbl, gbc);
        gbc.gridy = 1;
        lbl = new OrientableLabel(StringResources.PROPERTIES);
        pnl.add((Component)lbl, gbc);
        gbc.gridy = 2;
        lbl = new OrientableLabel(StringResources.FILE_INFO);
        pnl.add((Component)lbl, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, this.getDownInset(), 5, 5);
        pnl.add((Component)this.btnWindowOptions, gbc);
        gbc.gridy = 1;
        pnl.add((Component)this.btnPropertiesOptions, gbc);
        gbc.gridy = 2;
        pnl.add((Component)this.btnFileOptions, gbc);
        gbc.insets = new Insets(0, 0, 5, 5);
        gbc.gridx = 2;
        gbc.gridy = 0;
        pnl.add((Component)this.lblSpecificFormatsWindow, gbc);
        gbc.gridy = 1;
        pnl.add((Component)this.lblSpecificFormatsProperties, gbc);
        gbc.gridy = 2;
        pnl.add((Component)this.lblSpecificFormatsFile, gbc);
        pnlDown.add((Component)pnl, "Before");
        this.btnDate.setPreferredSize(this.btnWindowOptions.getPreferredSize());
        pnlUp.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(StringResources.DEFAULT_FORMATS), new EmptyBorder(5, 10, 5, 10)));
        pnlMid.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(StringResources.GENERAL_GW_FORMAT), new EmptyBorder(5, 10, 5, 10)));
        pnlDown.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(StringResources.SPECIFIC_GW_FORMAT), new EmptyBorder(5, 10, 0, 10)));
        pnlMain.add((Component)pnlUp, "North");
        pnlMain.add((Component)pnlMid, "Center");
        pnlMain.add((Component)pnlDown, "South");
        pnlMain.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.add((Component)pnlMain, "North");
    }

    public int getMidInset() {
        int v5;
        int v4 = SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), StringResources.DATE);
        int max = v4;
        if (max < (v5 = SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), StringResources.TIME_C))) {
            max = v5;
        }
        return this.getLongestLbl() - max;
    }

    public int getDownInset() {
        int v1 = SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), StringResources.MAIN_WINDOW);
        int v2 = SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), StringResources.PROPERTIES);
        int v3 = SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), StringResources.FILE_INFO);
        int max = v1;
        if (max < v2) {
            max = v2;
        }
        if (max < v3) {
            max = v3;
        }
        return this.getLongestLbl() - max;
    }

    public int getUpInset() {
        int v5 = SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), StringResources.SHORT_DATE);
        int v6 = SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), StringResources.LONG_DATE);
        int v7 = SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), StringResources.TIME_C);
        int max = v5;
        if (max < v6) {
            max = v6;
        }
        if (max < v7) {
            max = v7;
        }
        return this.getLongestLbl() - max;
    }

    public int getLongestLbl() {
        int v1 = SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), StringResources.MAIN_WINDOW);
        int v2 = SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), StringResources.PROPERTIES);
        int v3 = SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), StringResources.FILE_INFO);
        int v4 = SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), StringResources.DATE);
        int v5 = SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), StringResources.SHORT_DATE);
        int v6 = SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), StringResources.LONG_DATE);
        int v7 = SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), StringResources.TIME_C);
        int max = v1;
        if (max < v2) {
            max = v2;
        }
        if (max < v3) {
            max = v3;
        }
        if (max < v4) {
            max = v4;
        }
        if (max < v5) {
            max = v5;
        }
        if (max < v6) {
            max = v6;
        }
        if (max < v7) {
            max = v7;
        }
        return max;
    }

    @Override
    public void fireOptionsChanged() {
        if (!this.cmbTime.containsItem(this.dateTime.getTimeFormat())) {
            this.cmbTime.addItem(this.dateTime.getTimeFormat());
        }
        this.cmbTime.setSelectedItem(this.dateTime.getTimeFormat());
        this.prevTime = this.dateTime.getTimeFormat();
        if (!this.cmbShortDate.containsItem(this.dateTime.getShortDateFormat())) {
            this.cmbShortDate.addItem(this.dateTime.getShortDateFormat());
        }
        this.cmbShortDate.setSelectedItem(this.dateTime.getShortDateFormat());
        this.prevShortDate = this.dateTime.getShortDateFormat();
        if (!this.cmbLongDate.containsItem(this.dateTime.getLongDateFormat())) {
            this.cmbLongDate.addItem(this.dateTime.getLongDateFormat());
        }
        this.cmbLongDate.setSelectedItem(this.dateTime.getLongDateFormat());
        this.prevLongDate = this.dateTime.getLongDateFormat();
        this.refreshSamples();
    }

    private void refreshSamples() {
        Date currentDate = new Date();
        String currentTimeFormat = (String)this.cmbTime.getSelectedItem();
        String currentShortDateFormat = (String)this.cmbShortDate.getSelectedItem();
        String currentLongDateFormat = (String)this.cmbLongDate.getSelectedItem();
        this.lblSystemFormatsTime.setText(DateAndTimeFormattingUtils.formatDate(currentDate, currentTimeFormat));
        this.lblSystemFormatsLongDate.setText(DateAndTimeFormattingUtils.formatDate(currentDate, currentLongDateFormat));
        this.lblSystemFormatsShortDate.setText(DateAndTimeFormattingUtils.formatDate(currentDate, currentShortDateFormat));
        this.lblGeneralFormatsDate.setText(DateAndTimeFormattingUtils.formatDate(currentDate, this.getStringFormatFromLocalizedFormatName(this.btnDate.getText())));
        this.lblGeneralFormatsTime.setText(DateAndTimeFormattingUtils.formatDate(currentDate, currentTimeFormat));
        this.lblSpecificFormatsWindow.setText(DateAndTimeFormattingUtils.formatDate(currentDate, this.getStringFormatFromLocalizedFormatName(this.btnWindowOptions.getText())));
        this.lblSpecificFormatsProperties.setText(DateAndTimeFormattingUtils.formatDate(currentDate, this.getStringFormatFromLocalizedFormatName(this.btnPropertiesOptions.getText())));
        this.lblSpecificFormatsFile.setText(DateAndTimeFormattingUtils.formatDate(currentDate, this.getStringFormatFromLocalizedFormatName(this.btnFileOptions.getText())));
    }

    private String getStringFormatFromLocalizedFormatName(String localizedName) {
        String currentTimeFormat = (String)this.cmbTime.getSelectedItem();
        String currentShortDateFormat = (String)this.cmbShortDate.getSelectedItem();
        String currentLongDateFormat = (String)this.cmbLongDate.getSelectedItem();
        DateAndTimeFormat selectedFormat = DateAndTimeFormat.getDateAndTimeFormat(localizedName);
        String stringValue = DateAndTimeFormattingUtils.convertDateAndTimeFormatToString(selectedFormat, currentTimeFormat, currentShortDateFormat, currentLongDateFormat);
        return stringValue;
    }

    private String getUserGuid() {
        return ControlsUtils.getUserGuid(this.controller);
    }

    private class ButtonChangeListener
    implements PropertyChangeListener {
        private ButtonChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("ButtontextChooser selected text change")) {
                DateTimeFormatOptionsPanel.this.changeListener.setValueChanged();
                DateTimeFormatOptionsPanel.this.refreshSamples();
            }
        }
    }

    private class FormatHelpActionListener
    implements ActionListener {
        private DateTimeFormatType type;

        private FormatHelpActionListener(DateTimeFormatType type) {
            assert (type != null);
            this.type = type;
        }

        public void actionPerformed(ActionEvent e) {
            if (GWClient.USE_EXTERNAL_HTML_VIEWER()) {
                ApplicationFrame frame = ControlsUtils.getFrameForController(DateTimeFormatOptionsPanel.this.controller);
                ApplicationFrameActionList actionList = frame.getAppActionList();
                FrameHelp helpFrame = new FrameHelp(DateTimeFormatOptionsPanel.this.getUserGuid(), this.type.getFileName());
                helpFrame.setModalExclusionType(ToolkitUtils.ModalExclusionType.APPLICATION_EXCLUDE);
                GlobalCommand command = new GlobalCommand(480, helpFrame);
                actionList.processCommand(command);
                helpFrame.showMe();
            } else {
                String url = FrameHelp.getHelpDirUrl() + this.type.getFileName();
                NetUtils.showInSystemBrowser(url);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DateTimeFormatType {
        TIME{

            public String getFileName() {
                return "getorg_customizing_datetime_defaults.html#time";
            }
        }
        ,
        DATE_SHORT{

            public String getFileName() {
                return "getorg_customizing_datetime_defaults.html#dateshort";
            }
        }
        ,
        DATE_LONG{

            public String getFileName() {
                return "getorg_customizing_datetime_defaults.html#datelong";
            }
        };


        public abstract String getFileName();
    }

    private class LongDateFormatActionListener
    implements ActionListener {
        private LongDateFormatActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String selectedFormat = (String)DateTimeFormatOptionsPanel.this.cmbLongDate.getSelectedItem();
            if (DateAndTimeFormattingUtils.isFormatValid(selectedFormat)) {
                if (!DateTimeFormatOptionsPanel.this.cmbLongDate.containsItem(selectedFormat)) {
                    DateTimeFormatOptionsPanel.this.cmbLongDate.addItem(selectedFormat);
                }
                DateTimeFormatOptionsPanel.this.changesListener.setValueChanged();
                DateTimeFormatOptionsPanel.this.refreshSamples();
            } else {
                logger.debug((Object)"wrong longDate format");
                JOptionPane.showMessageDialog(DateTimeFormatOptionsPanel.this, StringResources.DATE_TIME_TYPING_ERROR, StringResources.ERROR, 0);
                DateTimeFormatOptionsPanel.this.cmbLongDate.setSelectedItem(DateTimeFormatOptionsPanel.this.prevLongDate);
            }
        }
    }

    private class ShortDateFormatActionListener
    implements ActionListener {
        private ShortDateFormatActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String selectedFormat = (String)DateTimeFormatOptionsPanel.this.cmbShortDate.getSelectedItem();
            if (DateAndTimeFormattingUtils.isFormatValid(selectedFormat)) {
                if (!DateTimeFormatOptionsPanel.this.cmbShortDate.containsItem(selectedFormat)) {
                    DateTimeFormatOptionsPanel.this.cmbShortDate.addItem(selectedFormat);
                }
                DateTimeFormatOptionsPanel.this.changesListener.setValueChanged();
                DateTimeFormatOptionsPanel.this.refreshSamples();
            } else {
                JOptionPane.showMessageDialog(DateTimeFormatOptionsPanel.this, StringResources.DATE_TIME_TYPING_ERROR, StringResources.ERROR, 0);
                logger.debug((Object)"wrong shortDate format");
                DateTimeFormatOptionsPanel.this.cmbShortDate.setSelectedItem(DateTimeFormatOptionsPanel.this.prevShortDate);
            }
        }
    }

    private class TimeFormatActionListener
    implements ActionListener {
        private TimeFormatActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String selectedFormat = (String)DateTimeFormatOptionsPanel.this.cmbTime.getSelectedItem();
            if (DateAndTimeFormattingUtils.isFormatValid(selectedFormat)) {
                if (!DateTimeFormatOptionsPanel.this.cmbTime.containsItem(selectedFormat)) {
                    DateTimeFormatOptionsPanel.this.cmbTime.addItem(selectedFormat);
                }
                DateTimeFormatOptionsPanel.this.changesListener.setValueChanged();
                DateTimeFormatOptionsPanel.this.refreshSamples();
            } else {
                JOptionPane.showMessageDialog(DateTimeFormatOptionsPanel.this, StringResources.DATE_TIME_TYPING_ERROR, StringResources.ERROR, 0);
                logger.debug((Object)"wrong time format");
                DateTimeFormatOptionsPanel.this.cmbTime.setSelectedItem(DateTimeFormatOptionsPanel.this.prevTime);
            }
        }
    }
}

