/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.dateAndTime;

import com.appframework.components.customizedbutton.ToolBarButton;
import com.appframework.mvc.MVCController;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.filechoser.OptionChangesListener;
import com.novell.gw.jclient.application.controls.timepicker.TimePicker;
import com.novell.gw.jclient.application.controls.timepicker.TimeTextField;
import com.novell.gw.jclient.application.frames.options.compose.AbstractOptionPanel;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.TimeDuration;
import com.novell.gw.jclient.bl.om.options.AbstractCloneObject;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class TimePickerPanel
extends AbstractOptionPanel {
    private TimePicker timePicker;
    private TimeTextField tfStartTime;
    private TimeTextField tfEndTime;
    private boolean checkForStartTimeEqualsEndTime = false;
    private boolean isStartTimeEqualsEndTimeWarningDisplayed = false;

    public TimePickerPanel(OptionChangesListener theChangesListener, MVCController theParentController) {
        this(theChangesListener, theParentController, false);
    }

    public TimePickerPanel(OptionChangesListener theChangesListener, MVCController theParentController, boolean checkForStartTimeEqualsEndTime) {
        super(theChangesListener, theParentController);
        this.checkForStartTimeEqualsEndTime = checkForStartTimeEqualsEndTime;
        this.init();
        this.buildUI();
    }

    private void init() {
        this.timePicker = new TimePicker((JFrame)this.getParent());
        this.timePicker.setDuration(new TimeDuration(0, 0));
        this.tfStartTime = new TimeTextField();
        this.tfStartTime.addFocusListener(new StartTimeFocusListener());
        this.tfStartTime.setColumns(7);
        this.tfStartTime.addPropertyChangeListener("value", new StartTimePropertyChangeListener());
        this.tfEndTime = new TimeTextField();
        this.tfEndTime.addFocusListener(new EndTimeFocusListener());
        this.tfEndTime.setColumns(7);
        this.tfEndTime.addPropertyChangeListener("value", new EndTimePropertyChangeListener());
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.tfStartTime.setEnabled(enabled);
        this.tfEndTime.setEnabled(enabled);
    }

    private void buildUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 23;
        this.tfStartTime.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add((Component)this.tfStartTime, constraints);
        constraints.gridy = 1;
        constraints.insets.top = 2;
        this.tfEndTime.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add((Component)this.tfEndTime, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.insets.top = 0;
        this.add((Component)new ShowTimePickerButton(), constraints);
        constraints.gridy = 1;
        constraints.insets.top = 2;
        this.add((Component)new ShowTimePickerButton(), constraints);
    }

    protected void build() {
    }

    public void collectValues() {
    }

    public void fireOptionsChanged() {
    }

    public void setOptions(AbstractCloneObject theAbstractOptions) throws IllegalArgumentException {
    }

    public void setStartTime(int minutes) {
        this.tfStartTime.setTime(this.getGregorianCalendar(minutes));
    }

    public int getStartTime() {
        return this.getTime(this.tfStartTime.getTime());
    }

    public void setEndTime(int time) {
        this.tfEndTime.setTime(this.getGregorianCalendar(time));
    }

    public int getEndTime() {
        return this.getTime(this.tfEndTime.getTime());
    }

    private Calendar getGregorianCalendar(int time) {
        Calendar gregorianCalendar = Calendar.getInstance();
        int hours = time / 60;
        int minutes = time - hours * 60;
        gregorianCalendar.set(0, 0, 0, hours, minutes);
        return gregorianCalendar;
    }

    private int getTime(Calendar gregorianCalendar) {
        int hours = gregorianCalendar.get(11);
        int minutes = gregorianCalendar.get(12);
        return hours * 60 + minutes;
    }

    private class StartTimePropertyChangeListener
    implements PropertyChangeListener {
        private StartTimePropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getOldValue() == null) {
                return;
            }
            if (TimePickerPanel.this.checkForStartTimeEqualsEndTime && TimePickerPanel.this.getStartTime() == TimePickerPanel.this.getEndTime()) {
                if (TimePickerPanel.this.isStartTimeEqualsEndTimeWarningDisplayed) {
                    return;
                }
                TimePickerPanel.this.isStartTimeEqualsEndTimeWarningDisplayed = true;
                JOptionPane.showMessageDialog(TimePickerPanel.this.getParent(), StringResources.THE_START_TIME_MUST_BE_BEFORE_THE_END_TIME, StringResources.NOVELL_GROUPWISE, 2);
                TimePickerPanel.this.tfStartTime.setValue((Date)evt.getOldValue());
                TimePickerPanel.this.isStartTimeEqualsEndTimeWarningDisplayed = false;
                return;
            }
            if (TimePickerPanel.this.getStartTime() > TimePickerPanel.this.getEndTime()) {
                if (TimePickerPanel.this.checkForStartTimeEqualsEndTime) {
                    TimePickerPanel.this.tfStartTime.setValue((Date)evt.getOldValue());
                } else {
                    TimePickerPanel.this.setEndTime(TimePickerPanel.this.getStartTime());
                }
            }
            TimePickerPanel.this.changesListener.setValueChanged();
        }
    }

    private class EndTimePropertyChangeListener
    implements PropertyChangeListener {
        private EndTimePropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getOldValue() == null) {
                return;
            }
            if (TimePickerPanel.this.checkForStartTimeEqualsEndTime && TimePickerPanel.this.getStartTime() == TimePickerPanel.this.getEndTime()) {
                if (TimePickerPanel.this.isStartTimeEqualsEndTimeWarningDisplayed) {
                    return;
                }
                TimePickerPanel.this.isStartTimeEqualsEndTimeWarningDisplayed = true;
                JOptionPane.showMessageDialog(TimePickerPanel.this.getParent(), StringResources.THE_START_TIME_MUST_BE_BEFORE_THE_END_TIME, StringResources.NOVELL_GROUPWISE, 2);
                TimePickerPanel.this.tfEndTime.setValue(evt.getOldValue());
                TimePickerPanel.this.isStartTimeEqualsEndTimeWarningDisplayed = false;
                return;
            }
            if (TimePickerPanel.this.getStartTime() > TimePickerPanel.this.getEndTime()) {
                if (TimePickerPanel.this.checkForStartTimeEqualsEndTime) {
                    TimePickerPanel.this.tfEndTime.setValue(evt.getOldValue());
                } else {
                    TimePickerPanel.this.setStartTime(TimePickerPanel.this.getEndTime());
                }
            }
            TimePickerPanel.this.changesListener.setValueChanged();
        }
    }

    private class StartTimeFocusListener
    implements FocusListener {
        int startTimeOnFocus;

        private StartTimeFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            this.startTimeOnFocus = TimePickerPanel.this.getStartTime();
        }

        public void focusLost(FocusEvent e) {
        }
    }

    private class EndTimeFocusListener
    implements FocusListener {
        int endTimeOnFocus;

        private EndTimeFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            this.endTimeOnFocus = TimePickerPanel.this.getEndTime();
        }

        public void focusLost(FocusEvent e) {
        }
    }

    private class ShowTimePickerButton
    extends ToolBarButton {
        public ShowTimePickerButton() {
            this.setIcon(ImageResources.ACT_TIMEPICKER);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TimeDuration timeDuration = new TimeDuration(TimePickerPanel.this.getStartTime(), TimePickerPanel.this.getEndTime());
                    TimePickerPanel.this.timePicker.setDuration(timeDuration);
                    UIUtils.centerWindow((Window)TimePickerPanel.this.timePicker, TimePickerPanel.this.timePicker.getOwner());
                    TimePickerPanel.this.timePicker.setVisible(true);
                    TimePickerPanel.this.setStartTime(TimePickerPanel.this.timePicker.getDuration().getStartMinutes());
                    TimePickerPanel.this.setEndTime(TimePickerPanel.this.timePicker.getDuration().getEndMinutes());
                }
            });
        }
    }
}

