/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.general;

import com.appframework.components.JListElementWrapper;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.ColorScheme;
import com.novell.gw.jclient.application.controls.LookAndFeelManager;
import com.novell.gw.jclient.application.controls.filechoser.OptionChangesListener;
import com.novell.gw.jclient.application.controls.itemview.QuickViewerLocation;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableRadioButton;
import com.novell.gw.jclient.application.controls.skinnable.ComponentPropertyManager;
import com.novell.gw.jclient.application.frames.options.OptionsDialog;
import com.novell.gw.jclient.application.frames.options.compose.AbstractOptionPanel;
import com.novell.gw.jclient.application.options.AppearanceSettings;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.options.AbstractCloneObject;
import com.novell.gw.jclient.bl.om.options.EnvironmentOptions;
import com.novell.gw.jclient.bl.om.options.InterfaceOptions;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class AppearanceOptionsPanel
extends AbstractOptionPanel {
    private static Logger logger = Logger.getLogger(AbstractOptionPanel.class);
    private JCheckBox cbDisplayMainMenu;
    private JCheckBox cbDisplayNavBar;
    private JCheckBox cbDisplayMainToolBar;
    private JCheckBox cbDisplayFolderList;
    private JCheckBox cbLongFolderList;
    private JCheckBox cbDisplayQuickViewer;
    private JCheckBox cbUseGTKLookAndFeel;
    private JRadioButton rbQuickViewerAtBottom;
    private JRadioButton rbQuickViewerAtRight;
    private JComboBox cmbColorSchemes;
    private JComboBox cmbAppearanceSchemes;
    private JLabel lblColorSchemes;
    private final String[] SCHEMES = new String[]{"<" + StringResources.CUSTOM + ">", StringResources.DEFAULT, StringResources.GROUPWISE_65, StringResources.SIMPLIFIED};

    public AppearanceOptionsPanel(OptionChangesListener theChangesListener, MVCController theParentController) {
        super(theChangesListener, theParentController);
    }

    private void init() {
        ViewItemListener viewItemListener = new ViewItemListener();
        this.cbDisplayFolderList = new OrientableCheckBox(StringResources.DISPLAY_FOLDER_LIST);
        this.cbDisplayFolderList.addItemListener(viewItemListener);
        this.cbDisplayMainMenu = new OrientableCheckBox(StringResources.DISPLAY_MAIN_MENU);
        this.cbDisplayMainMenu.addItemListener(viewItemListener);
        this.cbDisplayMainToolBar = new OrientableCheckBox(StringResources.DISPLAY_MAIN_TOOLBAR);
        this.cbDisplayMainToolBar.addItemListener(viewItemListener);
        this.cbDisplayNavBar = new OrientableCheckBox(StringResources.DISPLAY_NAV_BAR);
        this.cbDisplayNavBar.addItemListener(viewItemListener);
        this.cbDisplayQuickViewer = new OrientableCheckBox(StringResources.DISPLAY_QUICK_VIEWER);
        this.cbDisplayQuickViewer.addItemListener(viewItemListener);
        this.cbLongFolderList = new OrientableCheckBox(StringResources.LONG_FOLDER_LIST);
        this.cbLongFolderList.addItemListener(viewItemListener);
        this.cbUseGTKLookAndFeel = new OrientableCheckBox(StringResources.USE_GTK_LOOK_AND_FEEL_RESTART_REQUIRED);
        this.cbUseGTKLookAndFeel.addItemListener(viewItemListener);
        this.rbQuickViewerAtBottom = new OrientableRadioButton(StringResources.QUICKVIEWER_AT_BOTTOM);
        this.rbQuickViewerAtBottom.addItemListener(viewItemListener);
        this.rbQuickViewerAtRight = new OrientableRadioButton(StringResources.QUICKVIEWER_AT_RIGHT);
        this.rbQuickViewerAtRight.addItemListener(viewItemListener);
        this.cmbAppearanceSchemes = new OrientableComboBox(this.SCHEMES);
        this.cmbAppearanceSchemes.addItemListener(new ColorSchemeChooserListener());
        ColorScheme[] values = ColorScheme.sortedValues();
        Object[] wrappers = new JListElementWrapper[values.length];
        for (int i = 0; i < values.length; ++i) {
            wrappers[i] = new JListElementWrapper<ColorScheme>(values[i], "getLocalizedName");
        }
        this.cmbColorSchemes = new OrientableComboBox(wrappers);
        this.cmbColorSchemes.addItemListener(viewItemListener);
        this.lblColorSchemes = new OrientableLabel(StringResources.GW_COLOR_SCHEMES_C);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbQuickViewerAtBottom);
        buttonGroup.add(this.rbQuickViewerAtRight);
        boolean enableColorSchemes = !LookAndFeelManager.isGtkLookAndFeel();
        this.lblColorSchemes.setEnabled(enableColorSchemes);
        this.cmbColorSchemes.setEnabled(enableColorSchemes);
    }

    protected void build() {
        this.init();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 23;
        constraints.fill = 2;
        this.add((Component)this.createChooseASchemePanel(), constraints);
        ++constraints.gridy;
        this.add((Component)this.createSchemeChooserPanel(), constraints);
        ++constraints.gridy;
        this.add((Component)this.createChooseIndividualSettings(), constraints);
        ++constraints.gridy;
        constraints.weighty = 1.0;
        OrientablePanel panel = new OrientablePanel(new GridLayout());
        panel.add(this.createLeftPanel());
        panel.add(this.createRightPanel());
        this.add((Component)panel, constraints);
    }

    private JPanel createSchemeChooserPanel() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(10, 15, 0, 0);
        constraints.anchor = 23;
        panel.add((Component)new OrientableLabel(StringResources.SCHEMES_C), constraints);
        ++constraints.gridx;
        constraints.insets = new Insets(10, 10, 0, 10);
        constraints.weightx = 1.0;
        panel.add((Component)this.cmbAppearanceSchemes, constraints);
        return panel;
    }

    private JPanel createChooseASchemePanel() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(10, 10, 0, 0);
        constraints.anchor = 21;
        panel.add((Component)new OrientableLabel(StringResources.CHOOSE_A_SCHEME), constraints);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        constraints.insets.right = 10;
        constraints.fill = 2;
        panel.add((Component)new JSeparator(), constraints);
        return panel;
    }

    private JPanel createChooseIndividualSettings() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(10, 10, 0, 0);
        constraints.anchor = 21;
        panel.add((Component)new OrientableLabel(StringResources.CHOOSE_INDIVIDUAL_SETTINGS), constraints);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        constraints.insets.right = 10;
        constraints.fill = 2;
        panel.add((Component)new JSeparator(), constraints);
        return panel;
    }

    private JPanel createLeftPanel() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 21;
        constraints.insets = new Insets(10, 10, 0, 10);
        panel.add((Component)this.cbDisplayMainMenu, constraints);
        ++constraints.gridy;
        constraints.insets.top = 5;
        panel.add((Component)this.cbDisplayNavBar, constraints);
        ++constraints.gridy;
        panel.add((Component)this.cbDisplayMainToolBar, constraints);
        ++constraints.gridy;
        constraints.insets.left = 14;
        constraints.insets.bottom = 5;
        panel.add((Component)this.lblColorSchemes, constraints);
        ++constraints.gridy;
        constraints.insets = new Insets(0, 30, 10, 10);
        panel.add((Component)this.cmbColorSchemes, constraints);
        ++constraints.gridy;
        constraints.insets = new Insets(0, 10, 0, 10);
        if (OS.isLinuxOS()) {
            panel.add((Component)this.cbUseGTKLookAndFeel, constraints);
            constraints.gridheight = 6;
        } else {
            constraints.gridheight = 5;
        }
        ++constraints.gridx;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.insets = new Insets(0, 0, 0, 10);
        constraints.fill = 3;
        panel.add((Component)new JSeparator(1), constraints);
        return panel;
    }

    private JPanel createRightPanel() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 21;
        constraints.insets = new Insets(10, 10, 0, 10);
        panel.add((Component)this.cbDisplayFolderList, constraints);
        ++constraints.gridy;
        constraints.insets.top = 5;
        panel.add((Component)this.cbLongFolderList, constraints);
        ++constraints.gridy;
        panel.add((Component)this.cbDisplayQuickViewer, constraints);
        ++constraints.gridy;
        constraints.insets = new Insets(0, 30, 0, 10);
        panel.add((Component)this.rbQuickViewerAtBottom, constraints);
        ++constraints.gridy;
        panel.add((Component)this.rbQuickViewerAtRight, constraints);
        return panel;
    }

    private AppearanceSettings getAppearanceSettings() {
        String userGuid = ((OptionsDialog)SwingUtilities.getWindowAncestor(this)).getUserGuid();
        return GWCommandManager.getInstance(userGuid).getAppearanceSettings();
    }

    public void collectValues() {
        AppearanceSettings appearanceSettings = this.getAppearanceSettings();
        appearanceSettings.setFolderTreeVisible(this.cbDisplayFolderList.isSelected());
        appearanceSettings.setFolderTreeLong(this.cbLongFolderList.isSelected());
        appearanceSettings.setMainMenuVisible(this.cbDisplayMainMenu.isSelected());
        appearanceSettings.setMainToolBarVisible(this.cbDisplayMainToolBar.isSelected());
        appearanceSettings.setNavBarVisible(this.cbDisplayNavBar.isSelected());
        appearanceSettings.setQuickViewerVisible(this.cbDisplayQuickViewer.isSelected());
        if (this.rbQuickViewerAtBottom.isSelected()) {
            appearanceSettings.setQuickViewerLocation(QuickViewerLocation.BOTTOM);
        } else {
            appearanceSettings.setQuickViewerLocation(QuickViewerLocation.RIGHT);
        }
        appearanceSettings.setColorScheme(((ColorScheme)((Object)((JListElementWrapper)this.cmbColorSchemes.getSelectedItem()).getObject())).getApiId());
        ComponentPropertyManager.getInstance().processSkinChanged();
        InterfaceOptions options = OptionManager.getInstance().getInterfaceOptions();
        options.setGtkLookAndFeel(this.cbUseGTKLookAndFeel.isSelected());
        OptionManager.getInstance().setInterfaceOptions(options);
        this.handleOptionsChanged();
    }

    private void handleOptionsChanged() {
        AppearanceSettings appearanceSettings = this.getAppearanceSettings();
        Command command = new Command(1420, this.cbDisplayFolderList.isSelected());
        this.controller.processCommand(command);
        command = new Command(720, this.cbLongFolderList.isSelected());
        this.controller.processCommand(command);
        command = new Command(710, this.cbDisplayQuickViewer.isSelected());
        this.controller.processCommand(command);
        QuickViewerLocation location = this.rbQuickViewerAtBottom.isSelected() ? QuickViewerLocation.BOTTOM : QuickViewerLocation.RIGHT;
        command = new Command(1840, (Object)location);
        this.controller.processCommand(command);
        command = new Command(1850, appearanceSettings.isMainMenuVisible());
        this.controller.processCommand(command);
        command = new Command(1830, appearanceSettings.isNavBarVisible());
        this.controller.processCommand(command);
        command = new Command(1260, appearanceSettings.isMainToolBarVisible());
        this.controller.processCommand(command);
    }

    public void fireOptionsChanged() {
        EnvironmentOptions options = OptionManager.getInstance().getEnvironmentOptions();
        AppearanceSettings appearanceSettings = this.getAppearanceSettings();
        this.cbDisplayMainMenu.setEnabled(!appearanceSettings.isLockedMainMenuVisibility());
        this.cbDisplayMainMenu.setSelected(appearanceSettings.isMainMenuVisible());
        this.cbDisplayNavBar.setEnabled(!appearanceSettings.isLockedNavBarVisibility());
        this.cbDisplayNavBar.setSelected(appearanceSettings.isNavBarVisible());
        this.cbDisplayMainToolBar.setEnabled(!appearanceSettings.isLockedMainToolBarVisibility());
        this.cbDisplayMainToolBar.setSelected(appearanceSettings.isMainToolBarVisible());
        this.cbDisplayFolderList.setEnabled(!appearanceSettings.isLockedFolderTreeVisibility());
        this.cbDisplayFolderList.setSelected(appearanceSettings.isFolderTreeVisible());
        this.cbLongFolderList.setEnabled(!appearanceSettings.isLockedFolderTreeLength());
        this.cbLongFolderList.setSelected(appearanceSettings.isFolderTreeLong());
        this.cbDisplayQuickViewer.setEnabled(!appearanceSettings.isLockedQuickViewerVisibility());
        this.cbDisplayQuickViewer.setSelected(appearanceSettings.isQuickViewerVisible());
        logger.debug((Object)("OS.isGNOMESession(): " + OS.isGNOMESession()));
        this.cbUseGTKLookAndFeel.setEnabled(OS.isGNOMESession());
        this.cbUseGTKLookAndFeel.setSelected(OptionManager.getInstance().getInterfaceOptions().isGtkLookAndFeel());
        boolean isLocked = appearanceSettings.isLockedQuickViewerLocation();
        this.rbQuickViewerAtBottom.setEnabled(!isLocked);
        this.rbQuickViewerAtRight.setEnabled(!isLocked);
        this.rbQuickViewerAtBottom.setSelected(appearanceSettings.getQuickViewerLocation() == QuickViewerLocation.BOTTOM);
        this.rbQuickViewerAtRight.setSelected(appearanceSettings.getQuickViewerLocation() == QuickViewerLocation.RIGHT);
        this.selectCurrentColorScheme(appearanceSettings);
    }

    private void selectCurrentColorScheme(AppearanceSettings appearanceSettings) {
        int apiId = appearanceSettings.getColorScheme().getApiId();
        for (int i = 0; i < this.cmbColorSchemes.getItemCount(); ++i) {
            if (((ColorScheme)((Object)((JListElementWrapper)this.cmbColorSchemes.getItemAt(i)).getObject())).getApiId() != apiId) continue;
            this.cmbColorSchemes.setSelectedIndex(i);
            return;
        }
        assert (false) : "no color scheme is selected";
    }

    public void setOptions(AbstractCloneObject theAbstractOptions) throws IllegalArgumentException {
    }

    private void refreshView() {
        if (this.isRefreshedPanel()) {
            return;
        }
        Object selectedItem = this.cmbAppearanceSchemes.getSelectedItem();
        if (selectedItem == StringResources.DEFAULT) {
            this.setSelectedDefault();
        } else if (selectedItem == StringResources.GROUPWISE_65) {
            this.setSelectedGW();
        } else if (selectedItem == StringResources.SIMPLIFIED) {
            this.setSelectedSimplified();
        }
    }

    private boolean isRefreshedPanel() {
        Object selectedItem = this.cmbAppearanceSchemes.getSelectedItem();
        if (selectedItem == StringResources.DEFAULT) {
            return this.isSelectedDefault();
        }
        if (selectedItem == StringResources.GROUPWISE_65) {
            return this.isSelectedGW();
        }
        if (selectedItem == StringResources.SIMPLIFIED) {
            return this.isSelectedSimplified();
        }
        return false;
    }

    private void refreshColorScheme() {
        if (this.isSelectedDefault()) {
            this.cmbAppearanceSchemes.setSelectedItem(StringResources.DEFAULT);
        } else if (this.isSelectedGW()) {
            this.cmbAppearanceSchemes.setSelectedItem(StringResources.GROUPWISE_65);
        } else if (this.isSelectedSimplified()) {
            this.cmbAppearanceSchemes.setSelectedItem(StringResources.SIMPLIFIED);
        } else {
            this.cmbAppearanceSchemes.setSelectedIndex(0);
        }
    }

    private boolean isSelectedDefault() {
        return this.cbDisplayMainMenu.isSelected() && this.cbDisplayNavBar.isSelected() && this.cbDisplayMainToolBar.isSelected() && !this.cbUseGTKLookAndFeel.isSelected() && this.cbDisplayFolderList.isSelected() && this.cbLongFolderList.isSelected() && !this.cbDisplayQuickViewer.isSelected() && this.rbQuickViewerAtBottom.isSelected();
    }

    private void setSelectedDefault() {
        this.selectOptions(true, true, true, true, true);
    }

    private boolean isSelectedGW() {
        return this.cbDisplayMainMenu.isSelected() && !this.cbDisplayNavBar.isSelected() && this.cbDisplayMainToolBar.isSelected() && !this.cbUseGTKLookAndFeel.isSelected() && this.cbDisplayFolderList.isSelected() && !this.cbLongFolderList.isSelected() && !this.cbDisplayQuickViewer.isSelected() && this.rbQuickViewerAtBottom.isSelected();
    }

    private void setSelectedGW() {
        this.selectOptions(true, false, true, false, true);
    }

    private boolean isSelectedSimplified() {
        return !this.cbDisplayMainMenu.isSelected() && this.cbDisplayNavBar.isSelected() && !this.cbDisplayMainToolBar.isSelected() && !this.cbUseGTKLookAndFeel.isSelected() && this.cbDisplayFolderList.isSelected() && !this.cbLongFolderList.isSelected() && !this.cbDisplayQuickViewer.isSelected() && this.rbQuickViewerAtRight.isSelected();
    }

    private void setSelectedSimplified() {
        this.selectOptions(false, true, false, false, false);
    }

    private void selectOptions(boolean mainMenu, boolean navBar, boolean toolbar, boolean longFolderList, boolean quickViewerPosition) {
        this.cbDisplayMainMenu.setSelected(mainMenu);
        this.cbDisplayNavBar.setSelected(navBar);
        this.cbDisplayMainToolBar.setSelected(toolbar);
        this.cbUseGTKLookAndFeel.setSelected(false);
        this.cbDisplayFolderList.setSelected(true);
        this.cbLongFolderList.setSelected(longFolderList);
        this.cbDisplayQuickViewer.setSelected(false);
        this.rbQuickViewerAtBottom.setSelected(quickViewerPosition);
        this.rbQuickViewerAtRight.setSelected(!quickViewerPosition);
    }

    private class ColorSchemeChooserListener
    implements ItemListener {
        private ColorSchemeChooserListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            AppearanceOptionsPanel.this.changesListener.setValueChanged();
            AppearanceOptionsPanel.this.refreshView();
        }
    }

    private class ViewItemListener
    implements ItemListener {
        private ViewItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            AppearanceOptionsPanel.this.changesListener.setValueChanged();
            AppearanceOptionsPanel.this.refreshColorScheme();
        }
    }
}

