/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.general;

import com.appframework.components.customizedbutton.ToolBarButton;
import com.appframework.mvc.MVCController;
import com.appframework.utils.OS;
import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.engine.MachineSettings;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.filechoser.GWFileChooser;
import com.novell.gw.jclient.application.controls.filechoser.GWMacFileChooser;
import com.novell.gw.jclient.application.controls.filechoser.OptionChangesListener;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicCheckBox;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableSpinner;
import com.novell.gw.jclient.application.controls.toolbars.GWToolBar;
import com.novell.gw.jclient.application.frames.options.compose.AbstractOptionPanel;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.options.AbstractCloneObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;

public class BackupOptionsPane
extends AbstractOptionPanel {
    private JCheckBox cbBackup = new JMnemonicCheckBox(StringResources.BACKUP_CACHING_MAILBOX);
    private JCheckBox cbDoNotPrompt = new JMnemonicCheckBox(StringResources.DO_NOT_PROMPT_BEFORE_PERFORMING_BACKUP);
    private JButton btnSelectFolder = new ToolBarButton(new SelectFolderAction());
    private JSpinner spDays = new OrientableSpinner(new SpinnerNumberModel(1, 1, 99, 1));
    private JTextField tfPath = new GWTextField();
    private String path;

    public BackupOptionsPane(OptionChangesListener theChangesListener, MVCController theParentController) {
        super(theChangesListener, theParentController);
        this.setName(StringResources.BACKUP_OPTIONS);
    }

    private void registerListeners() {
        this.cbBackup.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean b = e.getStateChange() == 1;
                BackupOptionsPane.this.setControlsEnabled(b);
            }
        });
        this.setControlsEnabled(false);
        this.cbBackup.addItemListener(this.itemListener);
        this.cbDoNotPrompt.addItemListener(this.itemListener);
        this.spDays.addChangeListener(new AbstractOptionPanel.CustomItemChangeListener(this.changesListener));
        this.tfPath.getDocument().addDocumentListener(new AbstractOptionPanel.CustomDocumentListener(this.changesListener));
    }

    private void setControlsEnabled(boolean b) {
        this.tfPath.setEditable(b);
        this.btnSelectFolder.setEnabled(b);
        this.spDays.setEnabled(b);
        this.cbDoNotPrompt.setEnabled(b);
    }

    protected void build() {
        this.registerListeners();
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        this.btnSelectFolder.setPreferredSize(new Dimension(this.btnSelectFolder.getPreferredSize().width, this.tfPath.getPreferredSize().height));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(0, 5, 5, 5);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        this.add((Component)this.cbBackup, constraints);
        constraints.gridy = 1;
        OrientablePanel pnlTemp = new OrientablePanel(new BorderLayout(5, 0));
        pnlTemp.add((Component)new JMnemonicLabel(StringResources.DIRECTORY, this.tfPath), "Before");
        pnlTemp.add((Component)this.tfPath, "Center");
        GWToolBar toolBar = new GWToolBar();
        toolBar.add(this.btnSelectFolder);
        toolBar.setBorder(null);
        pnlTemp.add((Component)toolBar, "After");
        constraints.insets.left = 10;
        this.add((Component)pnlTemp, constraints);
        constraints.gridy = 2;
        constraints.anchor = 23;
        constraints.fill = 0;
        pnlTemp = new OrientablePanel();
        pnlTemp.add(new JMnemonicLabel(StringResources.BACKUP_CACHING_MAILBOX_EVERY, this.spDays));
        pnlTemp.add(this.spDays);
        pnlTemp.add(new OrientableLabel(StringResources.L_DAYS));
        constraints.insets.left = 5;
        this.add((Component)pnlTemp, constraints);
        constraints.gridy = 3;
        constraints.weighty = 1.0;
        this.add((Component)this.cbDoNotPrompt, constraints);
        this.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
    }

    public void collectValues() {
        int res;
        MachineSettings machineSettings = OptionManager.getInstance().getMachineSettings();
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        machineSettings.setBackupEnabled(this.cbBackup.isSelected());
        machineSettings.setBackupPromptEnabled(!this.cbDoNotPrompt.isSelected());
        dataStoreSettings.setBackupInterval(((SpinnerNumberModel)this.spDays.getModel()).getNumber().intValue());
        String path = this.tfPath.getText();
        File file = new File(path);
        if (!file.exists() && path != null && !path.equals("") && (res = JOptionPane.showConfirmDialog(this, StringResources.formatString(StringResources.DOES_NOT_EXIST_CREATE_DIRECTORY_Q, path), StringResources.GROUPWISE_CLIENT, 0, 3)) == 0) {
            if (file.mkdirs()) {
                path = file.getAbsolutePath();
            } else {
                JOptionPane.showMessageDialog(this, StringResources.formatString(StringResources.FAILED_TO_CREATE_DIRECTORY, path), StringResources.GROUPWISE_CLIENT, 0);
            }
        }
        dataStoreSettings.setBackupLocation(path);
    }

    public void fireOptionsChanged() {
        MachineSettings machineSettings = OptionManager.getInstance().getMachineSettings();
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        this.cbDoNotPrompt.setSelected(!machineSettings.isBackupPromptEnabled());
        this.cbBackup.setSelected(machineSettings.isBackupEnabled());
        this.path = dataStoreSettings.getBackupLocation();
        this.tfPath.setText(this.path);
        int backupinterval = dataStoreSettings.getBackupInterval();
        if (backupinterval > 0 && backupinterval <= 99) {
            this.spDays.getModel().setValue(new Integer(dataStoreSettings.getBackupInterval()));
        }
    }

    public void setOptions(AbstractCloneObject theAbstractOptions) throws IllegalArgumentException {
    }

    private class SelectFolderAction
    extends AbstractAction {
        public SelectFolderAction() {
            super("", ImageResources.ICON_FOLDER);
        }

        public void actionPerformed(ActionEvent e) {
            if (OS.isMacOS()) {
                File f;
                boolean isOK;
                String dialogCaption = StringResources.SELECT_DIRECTORY;
                System.setProperty("apple.awt.fileDialogForDirectories", "true");
                Frame frame = ControlsUtils.getFrameForComponent(BackupOptionsPane.this);
                if (frame == null) {
                    return;
                }
                GWMacFileChooser fileChoser = new GWMacFileChooser(frame, dialogCaption, null, 0);
                fileChoser.setVisible(true);
                String selectedFile = fileChoser.getFile();
                String selecteddirectory = fileChoser.getDirectory();
                if (selectedFile != null && (isOK = (f = new File(selecteddirectory + selectedFile)).isDirectory())) {
                    BackupOptionsPane.this.tfPath.setText(f.getPath());
                }
                System.setProperty("apple.awt.fileDialogForDirectories", "false");
            } else {
                GWFileChooser fileChooser = new GWFileChooser((Dialog)SwingUtilities.getWindowAncestor(BackupOptionsPane.this), StringResources.OPEN, null, 1, 0, false);
                fileChooser.setVisible(true);
                String[] fileNames = fileChooser.getResult();
                if (fileNames != null) {
                    File selectedFile = fileChooser.getChooser().getSelectedFile();
                    BackupOptionsPane.this.tfPath.setText(selectedFile.getPath());
                }
            }
        }
    }
}

