/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.general;

import com.appframework.mvc.MVCController;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.engine.MachineSettings;
import com.novell.gw.engine.SettingsValue;
import com.novell.gw.jclient.application.controls.LookAndFeelManager;
import com.novell.gw.jclient.application.controls.filechoser.OptionChangesListener;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicCheckBox;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableRadioButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableSpinner;
import com.novell.gw.jclient.application.frames.options.compose.AbstractOptionPanel;
import com.novell.gw.jclient.application.frames.options.compose.country.Language;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.options.fonts.FontOptions;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.options.AbstractCloneObject;
import com.novell.gw.jclient.bl.om.options.GeneralOptions;
import com.novell.gw.jclient.bl.om.options.InterfaceOptions;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class CommonPanel
extends AbstractOptionPanel {
    private static Logger logger = Logger.getLogger(CommonPanel.class);
    public static final String SHOW_NOTIFICATION = "Show notif";
    public static final String REFRESH_TIME = "Refresh time";
    public static final String PREVIEW_AT_STARTUP = "Preview";
    public static final String DELETE_CONFIRMATION = "Delete confirm";
    public static final String PREFIX = "Message prefix";
    public static final String BROWSER = "Browser";
    public static final String TEMP_DIR = "Temp dir";
    public static final String BROWSER_BUTTON = "Browser button";
    public static final String TEMP_DIR_BUTTON = "Temp files dir button";
    private JCheckBox cbShowDeletionConf = new JMnemonicCheckBox(StringResources.ITEM_DELETION_CONFIRMATION);
    private JCheckBox cbReadNextAfter = new JMnemonicCheckBox(StringResources.READ_NEXT_AFTER_ACCEPT_DECLINE_OR_DELETE);
    private JCheckBox cbSmartToolTip = new JMnemonicCheckBox(StringResources.ENABLE_SMART_TOOL_TIPS_FOR_ITEMS);
    private JCheckBox cbShowHiddenFiles = new JMnemonicCheckBox(StringResources.SHOW_HIDDEN_FILES);
    private JCheckBox cbDisableAutoSave = new JMnemonicCheckBox(StringResources.DISABLE_AUTO_SAVE);
    private JCheckBox cbSpellCheckBefore = new JMnemonicCheckBox(StringResources.CHECK_SPELLING_BEFORE_SEND);
    private JCheckBox cbSpellCheckAsYouType = new JMnemonicCheckBox(StringResources.ACTION_RT_SPELL_CHECKER);
    private JCheckBox cbForce = new JMnemonicCheckBox(StringResources.FORCE);
    private JLabel lbLanguage = new JMnemonicLabel(StringResources.INTERFACE_LANGUAGE_C, this.cmbLanguage);
    private JComboBox cmbLanguage = new OrientableComboBox();
    private JLabel lbItemDeleteKey = new JMnemonicLabel(StringResources.ITEM_DELETION_METHOD, this.cmbItemDeleteKey);
    private JComboBox cmbItemDeleteKey = new OrientableComboBox();
    private GeneralOptions generalOptions;
    private JRadioButton rbPlanTextComposer = new OrientableRadioButton(StringResources.PLAIN_TEXT);
    private JRadioButton rbHTMLComposer = new OrientableRadioButton(StringResources.HTML);
    private AbstractButton rbPlanTextReader = new OrientableRadioButton(StringResources.PLAIN_TEXT);
    private JRadioButton rbHTMLReader = new OrientableRadioButton(StringResources.HTML);
    private FontNameComboBox cbDefaultReadPlainTextFont = new FontNameComboBox();
    private FontSizeComboBox cbDefaultReadPlainTextFontSize = new FontSizeComboBox();
    private FontNameComboBox cbDefaultComposePlainTextFont = new FontNameComboBox();
    private FontSizeComboBox cbDefaultComposePlainTextFontSize = new FontSizeComboBox();
    private FontNameComboBox cbDefaultComposeHTMLFont = new FontNameComboBox();
    private FontSizeComboBox cbDefaultComposeHTMLFontSize = new FontSizeComboBox();
    private FontNameComboBox cbInterfaceFont = new FontNameComboBox();
    private FontSizeComboBox cbInterfaceFontSize = new FontSizeComboBox();
    private JSpinner spMinutesInterval = new OrientableSpinner(new SpinnerNumberModel(1, 1, 60, 1));
    private JSpinner spSecondsInterval = new OrientableSpinner(new SpinnerNumberModel(0, 0, 59, 1));

    public CommonPanel(OptionChangesListener theChangesListener, MVCController theParentController) {
        super(theChangesListener, theParentController);
        if (LookAndFeelManager.isGtkLookAndFeel() || LookAndFeelManager.isNimbusLookAndFeel()) {
            this.cbInterfaceFont.setEnabled(false);
            this.cbInterfaceFontSize.setEnabled(false);
        }
        this.setName(StringResources.GENERAL);
        this.buildUI();
        this.isPrepared = true;
        this.spMinutesInterval.getModel().addChangeListener(new AbstractOptionPanel.CustomItemChangeListener(this.changesListener));
        this.spSecondsInterval.getModel().addChangeListener(new AbstractOptionPanel.CustomItemChangeListener(this.changesListener));
        this.cbSmartToolTip.getModel().addItemListener(this.itemListener);
        this.cbShowHiddenFiles.getModel().addItemListener(this.itemListener);
        this.cbDisableAutoSave.getModel().addItemListener(this.itemListener);
        this.cbShowDeletionConf.getModel().addItemListener(this.itemListener);
        this.cbReadNextAfter.getModel().addItemListener(this.itemListener);
        this.cmbLanguage.addItemListener(this.itemListener);
        this.cmbItemDeleteKey.addItemListener(this.itemListener);
        this.cbSpellCheckBefore.addItemListener(this.itemListener);
        this.cbForce.addItemListener(this.itemListener);
        this.cbSpellCheckAsYouType.addItemListener(this.itemListener);
        this.rbPlanTextComposer.getModel().addItemListener(this.itemListener);
        this.rbHTMLComposer.getModel().addItemListener(this.itemListener);
        this.rbPlanTextReader.getModel().addItemListener(this.itemListener);
        this.rbHTMLReader.getModel().addItemListener(this.itemListener);
        this.cbDefaultReadPlainTextFont.addItemListener(this.itemListener);
        this.cbDefaultReadPlainTextFontSize.addItemListener(this.itemListener);
        this.cbDefaultComposePlainTextFont.addItemListener(this.itemListener);
        this.cbDefaultComposePlainTextFontSize.addItemListener(this.itemListener);
        this.cbDefaultComposeHTMLFont.addItemListener(this.itemListener);
        this.cbDefaultComposeHTMLFontSize.addItemListener(this.itemListener);
        this.cbInterfaceFont.addItemListener(this.itemListener);
        this.cbInterfaceFontSize.addItemListener(this.itemListener);
        this.cbReadNextAfter.setSelected(true);
        this.readSystemFonts(this.cbDefaultComposePlainTextFont, this.cbDefaultComposePlainTextFontSize, false);
        this.readSystemFonts(this.cbDefaultReadPlainTextFont, this.cbDefaultReadPlainTextFontSize, false);
        this.readSystemFonts(this.cbDefaultComposeHTMLFont, this.cbDefaultComposeHTMLFontSize, true);
        this.readSystemFonts(this.cbInterfaceFont, this.cbInterfaceFontSize, false);
        CommonPanel.insertEmptyElement(this.cbInterfaceFontSize);
    }

    protected void build() {
    }

    private void readSystemFonts(JComboBox cbFontName, JComboBox cbFontSize, boolean isHTML) {
        cbFontName.setModel(new DefaultComboBoxModel<String>(UIUtils.getSystemFonts()));
        CommonPanel.insertEmptyElement(cbFontName);
        cbFontSize.setModel(new DefaultComboBoxModel<Integer>(isHTML ? FontOptions.SIZES_HTML : FontOptions.SIZES_PLAINTEXT));
        cbFontSize.setSelectedItem(null);
    }

    private static void insertEmptyElement(JComboBox cbFont) {
        if (cbFont.getModel().getSize() > 0) {
            ((DefaultComboBoxModel)cbFont.getModel()).insertElementAt("", 0);
            cbFont.setSelectedIndex(0);
        }
    }

    private void buildUI() {
        this.rbPlanTextReader.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean b = e.getStateChange() == 1;
                CommonPanel.this.cbForce.setEnabled(b);
                if (!b) {
                    CommonPanel.this.cbForce.setSelected(false);
                }
            }
        });
        this.changesListener.setValueSaved();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        OrientablePanel p = new OrientablePanel(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 21;
        c.insets = new Insets(5, 5, 5, 5);
        p.add((Component)this.lbLanguage, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 19;
        c.insets = new Insets(0, 5, 5, 5);
        p.add((Component)this.cmbLanguage, c);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 23;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 5);
        this.add((Component)p, c);
        p = new OrientablePanel(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 21;
        c.insets = new Insets(5, 5, 5, 5);
        p.add((Component)new OrientableLabel(StringResources.INTERFACE_FONT_C), c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 19;
        c.insets = new Insets(0, 5, 5, 5);
        p.add((Component)this.cbInterfaceFont, c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 21;
        c.insets = new Insets(0, 0, 5, 5);
        p.add((Component)this.cbInterfaceFontSize, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 23;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)p, c);
        p = new OrientablePanel(new GridBagLayout());
        p.setBorder(BorderFactory.createTitledBorder(StringResources.DEFAULT_COMPOSE_VIEW_AND_FONT));
        ButtonGroup group = new ButtonGroup();
        group.add(this.rbPlanTextComposer);
        group.add(this.rbHTMLComposer);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 23;
        c.insets = new Insets(5, 5, 5, 10);
        p.add((Component)this.rbPlanTextComposer, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 23;
        c.insets = new Insets(0, 25, 5, 5);
        p.add((Component)this.cbDefaultComposePlainTextFont, c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 23;
        c.insets = new Insets(0, 0, 5, 10);
        p.add((Component)this.cbDefaultComposePlainTextFontSize, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 23;
        c.insets = new Insets(5, 5, 5, 5);
        p.add((Component)this.rbHTMLComposer, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 23;
        c.insets = new Insets(0, 25, 10, 5);
        p.add((Component)this.cbDefaultComposeHTMLFont, c);
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 23;
        c.insets = new Insets(0, 0, 10, 10);
        p.add((Component)this.cbDefaultComposeHTMLFontSize, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 23;
        c.insets = new Insets(0, 0, 0, 5);
        this.add((Component)p, c);
        p = new OrientablePanel(new GridBagLayout());
        p.setBorder(BorderFactory.createTitledBorder(StringResources.DEFAULT_READ_VIEW_AND_FONT));
        group = new ButtonGroup();
        group.add(this.rbPlanTextReader);
        group.add(this.rbHTMLReader);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 23;
        c.insets = new Insets(10, 5, 10, 5);
        p.add((Component)this.rbPlanTextReader, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 24;
        c.insets = new Insets(10, 5, 5, 5);
        p.add((Component)this.cbForce, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 23;
        c.insets = new Insets(0, 25, 5, 5);
        p.add((Component)this.cbDefaultReadPlainTextFont, c);
        c.gridx = 2;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 23;
        c.insets = new Insets(0, 0, 5, 10);
        p.add((Component)this.cbDefaultReadPlainTextFontSize, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 3;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.fill = 3;
        c.anchor = 21;
        c.insets = new Insets(0, 5, 10, 10);
        p.add((Component)this.rbHTMLReader, c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 1;
        c.anchor = 23;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)p, c);
        p = new OrientablePanel(new GridBagLayout());
        p.setBorder(BorderFactory.createTitledBorder(StringResources.DELETE_OPTIONS));
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 23;
        c.insets = new Insets(5, 5, 5, 10);
        p.add((Component)this.cbShowDeletionConf, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 21;
        c.insets = new Insets(0, 10, 10, 5);
        p.add((Component)this.lbItemDeleteKey, c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 21;
        c.insets = new Insets(0, 0, 10, 10);
        p.add((Component)this.cmbItemDeleteKey, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 23;
        c.insets = new Insets(0, 0, 0, 5);
        this.add((Component)p, c);
        p = new OrientablePanel(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 23;
        c.insets = new Insets(5, 5, 5, 5);
        p.add((Component)this.cbReadNextAfter, c);
        this.cbReadNextAfter.setSelected(true);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 23;
        c.insets = new Insets(0, 5, 5, 5);
        if (!OS.isMacOS()) {
            this.cbShowHiddenFiles.setToolTipText(StringResources.SHOW_HIDDEN_FILES_AND_DIRECTORIES_IN_OPEN_SAVEAS_DIALOGS);
            p.add((Component)this.cbShowHiddenFiles, c);
        }
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 23;
        c.insets = new Insets(0, 5, 5, 5);
        p.add((Component)this.cbDisableAutoSave, c);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 23;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)p, c);
        p = new OrientablePanel(new GridBagLayout());
        p.setBorder(BorderFactory.createTitledBorder(StringResources.SPELL_CHECKER));
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 23;
        c.insets = new Insets(10, 10, 10, 10);
        p.add((Component)this.cbSpellCheckBefore, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 23;
        c.insets = new Insets(0, 10, 10, 10);
        p.add((Component)this.cbSpellCheckAsYouType, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 23;
        c.insets = new Insets(0, 0, 0, 5);
        this.add((Component)p, c);
        p = new OrientablePanel(new GridBagLayout());
        p.setBorder(BorderFactory.createTitledBorder(StringResources.REFRESH_INTERVAL));
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 23;
        c.insets = new Insets(10, 10, 10, 10);
        p.add((Component)new OrientableLabel(StringResources.EVERY_C), c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 23;
        c.insets = new Insets(10, 0, 10, 5);
        p.add((Component)this.spMinutesInterval, c);
        c.gridx = 2;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 23;
        c.insets = new Insets(10, 0, 10, 10);
        p.add((Component)new OrientableLabel(StringResources.L_MINUTES), c);
        c.gridx = 3;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 23;
        c.insets = new Insets(10, 0, 10, 5);
        p.add((Component)this.spSecondsInterval, c);
        c.gridx = 4;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 23;
        c.insets = new Insets(10, 0, 10, 10);
        p.add((Component)new OrientableLabel(StringResources.L_SECONDS), c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 2;
        c.anchor = 23;
        c.insets = new Insets(0, 0, 0, 5);
        this.add((Component)p, c);
    }

    public void collectValues() {
        OptionManager.getInstance().setTextOption(CommonPanel.isSelected(this.rbHTMLComposer), CommonPanel.isSelected(this.rbHTMLReader), CommonPanel.isSelected(this.cbForce), this.cbDefaultComposeHTMLFont.getSelectedFontName(), this.cbDefaultComposeHTMLFontSize.getSelectedFontSize(), this.cbDefaultComposePlainTextFont.getSelectedFontName(), this.cbDefaultComposePlainTextFontSize.getSelectedFontSize(), this.cbDefaultReadPlainTextFont.getSelectedFontName(), this.cbDefaultReadPlainTextFontSize.getSelectedFontSize());
        this.generalOptions.setSmartToolTipEnabled(this.cbSmartToolTip.isSelected());
        this.generalOptions.setDeletionConfirmation(this.cbShowDeletionConf.isSelected());
        this.generalOptions.setInterfaceLanguage((Language)this.cmbLanguage.getSelectedItem());
        this.generalOptions.setItemDeleteKey(CommonPanel.getItemDeleteKeyForString((String)this.cmbItemDeleteKey.getSelectedItem()));
        ApplicationOptions.getInstance().put("SHOW_HIDDEN_FILES", this.cbShowHiddenFiles.isSelected());
        InterfaceOptions interfaceOptions = OptionManager.getInstance().getInterfaceOptions();
        if (this.cbInterfaceFont.getSelectedFontName() != null) {
            interfaceOptions.setFontName(this.cbInterfaceFont.getSelectedFontName());
        } else {
            interfaceOptions.setFontName(null);
        }
        if (this.cbInterfaceFontSize.getSelectedFontSize() != null) {
            interfaceOptions.setFontSize(this.cbInterfaceFontSize.getSelectedFontSize());
        } else {
            interfaceOptions.setFontSize(null);
        }
        OptionManager.getInstance().setInterfaceOptions(interfaceOptions);
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        int seconds = (Integer)this.spMinutesInterval.getValue() * 60 + (Integer)this.spSecondsInterval.getValue();
        dataStoreSettings.setRefreshPollInterval(seconds);
        dataStoreSettings.setDisableAutoSave(this.cbDisableAutoSave.isSelected());
        dataStoreSettings.setReadNextOnDelete(this.cbReadNextAfter.isSelected());
        dataStoreSettings.setCheckSpellingBeforeSend(this.cbSpellCheckBefore.isSelected());
        dataStoreSettings.setCheckSpellingAsYouType(this.cbSpellCheckAsYouType.isSelected());
    }

    private static int getItemDeleteKeyForString(String s) {
        if (s == null || s.equals(StringResources.DELETE_KEY)) {
            if (OS.isMacOS()) {
                return 8;
            }
            return 127;
        }
        if (s.equals(StringResources.BACKSPACE_KEY)) {
            return 8;
        }
        if (s.equals(StringResources.DEL_KEY)) {
            return 127;
        }
        return 127;
    }

    private static String getStringForItemDeleteKey(int key) {
        if (key == 8) {
            if (OS.isMacOS()) {
                return StringResources.DELETE_KEY;
            }
            return StringResources.BACKSPACE_KEY;
        }
        if (key == 127) {
            if (OS.isMacOS()) {
                return StringResources.DEL_KEY;
            }
            return StringResources.DELETE_KEY;
        }
        return StringResources.DELETE_KEY;
    }

    private static Boolean isSelected(AbstractButton button) {
        return button.isSelected();
    }

    public void fireOptionsChanged() {
        MachineSettings.TextOption textOption = OptionManager.getInstance().getTextOption();
        this.cbDefaultComposePlainTextFont.setSelectedItem(textOption.getDefaultComposePlainTextFont());
        this.cbDefaultComposePlainTextFontSize.setSelectedItem(textOption.getDefaultComposePlainTextFontSize());
        this.cbDefaultReadPlainTextFont.setSelectedItem(textOption.getDefaultReadPlainTextFont());
        this.cbDefaultReadPlainTextFontSize.setSelectedItem(textOption.getDefaultReadPlainTextFontSize());
        this.cbDefaultComposeHTMLFont.setSelectedItem(textOption.getDefaultComposeHTMLFont());
        this.cbDefaultComposeHTMLFontSize.setSelectedItem(textOption.getDefaultComposeHTMLFontSize());
        this.cbInterfaceFont.setSelectedItem(OptionManager.getInstance().getInterfaceOptions().getFontName());
        this.cbInterfaceFontSize.setSelectedItem(OptionManager.getInstance().getInterfaceOptions().getFontSize());
        this.cbSmartToolTip.setSelected(this.generalOptions.isSmartToolTipEnabled());
        this.cbShowDeletionConf.setSelected(this.generalOptions.isDeleteConfirmationAllowed());
        Object[] langs = this.generalOptions.getAvailableLanguages();
        Arrays.sort(langs);
        this.cmbLanguage.setModel(new DefaultComboBoxModel<Object>(langs));
        this.cmbLanguage.setSelectedItem(this.generalOptions.getInterfaceLanguage());
        String[] delKeys = OS.isMacOS() ? new String[]{StringResources.DEL_KEY, StringResources.DELETE_KEY} : new String[]{StringResources.DELETE_KEY, StringResources.BACKSPACE_KEY};
        this.cmbItemDeleteKey.setModel(new DefaultComboBoxModel<String>(delKeys));
        this.cmbItemDeleteKey.setSelectedItem(CommonPanel.getStringForItemDeleteKey(this.generalOptions.getItemDeleteKey()));
        if (textOption.isDefaultComposeHTML()) {
            this.rbHTMLComposer.setSelected(true);
        } else {
            this.rbPlanTextComposer.setSelected(true);
        }
        if (textOption.isDefaultReadHTML()) {
            this.rbHTMLReader.setSelected(true);
        } else {
            this.rbPlanTextReader.setSelected(true);
        }
        this.cbForce.setSelected(textOption.isPlainTextReadForced());
        this.cbForce.setEnabled(this.rbPlanTextReader.isSelected());
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        this.cbSpellCheckBefore.setSelected((Boolean)dataStoreSettings.getCheckSpellingBeforeSend().getValue());
        this.cbSpellCheckAsYouType.setSelected((Boolean)dataStoreSettings.getCheckSpellingAsYouType().getValue());
        this.cbShowHiddenFiles.setSelected(ApplicationOptions.getInstance().getBoolean("SHOW_HIDDEN_FILES"));
        this.changesListener.setValueSaved();
        int time = (Integer)dataStoreSettings.getRefreshPollInterval().getValue();
        int minutes = time / 60;
        int seconds = time - minutes * 60;
        this.spMinutesInterval.getModel().setValue(minutes);
        this.spMinutesInterval.setEnabled(!dataStoreSettings.getRefreshPollInterval().isLocked());
        this.spSecondsInterval.getModel().setValue(seconds);
        this.spSecondsInterval.setEnabled(!dataStoreSettings.getRefreshPollInterval().isLocked());
        SettingsValue bDisableAutoSave = dataStoreSettings.getDisableAutoSave();
        this.cbDisableAutoSave.setSelected((Boolean)bDisableAutoSave.getValue());
        this.cbDisableAutoSave.setEnabled(!bDisableAutoSave.isLocked());
        this.cbReadNextAfter.setSelected((Boolean)dataStoreSettings.getReadNextOnDelete().getValue());
    }

    public void setOptions(AbstractCloneObject theAbstractOptions) throws IllegalArgumentException {
        if (!(theAbstractOptions instanceof GeneralOptions)) {
            throw new IllegalArgumentException();
        }
        this.generalOptions = (GeneralOptions)theAbstractOptions;
        this.fireOptionsChanged();
    }

    private static class FontNameComboBox
    extends OrientableComboBox {
        public FontNameComboBox() {
            this.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 127 || e.getKeyCode() == 8) {
                        FontNameComboBox.this.setSelectedIndex(0);
                    }
                }
            });
        }

        public String getSelectedFontName() {
            Object selectedItem = this.getSelectedItem();
            if (selectedItem != null && !"".equals(selectedItem)) {
                return selectedItem.toString();
            }
            return null;
        }
    }

    private static class FontSizeComboBox
    extends OrientableComboBox {
        private FontSizeComboBox() {
        }

        public Integer getSelectedFontSize() {
            Object selectedItem = this.getSelectedItem();
            if (selectedItem instanceof Integer) {
                return (Integer)selectedItem;
            }
            return null;
        }
    }
}

