/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.general;

import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.api.enums.EngineMode;
import com.novell.gw.jclient.application.controls.filechoser.FileChooserPanel;
import com.novell.gw.jclient.application.controls.filechoser.OptionChangesListener;
import com.novell.gw.jclient.application.frames.options.compose.AbstractOptionPanel;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.options.AbstractCloneObject;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import org.apache.log4j.Logger;

public class FileLocationOptionPane
extends AbstractOptionPanel {
    private static Logger logger = Logger.getLogger(FileLocationOptionPane.class);
    private FileChooserPanel archiveDirChooser = new FileChooserPanel(StringResources.ARCHIVE_DIRECTORY_C, "", 1);
    private FileChooserPanel cachingDirChooser = new FileChooserPanel(StringResources.CACHING_MAILBOX_DIRECTORY_C, "", 1);
    private String userGuid;
    private String initialArchivePath;

    public FileLocationOptionPane(OptionChangesListener theChangesListener, MVCController theParentController, String userGuid) {
        super(theChangesListener, theParentController);
        this.userGuid = userGuid;
        this.setName(StringResources.FILE_LOCATION);
        this.archiveDirChooser.setChangesListener(this.changesListener);
        this.cachingDirChooser.setChangesListener(this.changesListener);
        this.archiveDirChooser.setName("FileLocationOptionPane_archiveDirChooser");
        this.cachingDirChooser.setName("FileLocationOptionPane_cachingDirChooser");
        this.archiveDirChooser.setDisplayedMnemonic(StringResources.getMnemonic(StringResources.ARCHIVE_DIRECTORY_C));
        this.cachingDirChooser.setDisplayedMnemonic(StringResources.getMnemonic(StringResources.CACHING_MAILBOX_DIRECTORY_C));
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        boolean isOnline = EngineCommandManager.getCurrentMode() == EngineMode.ONLINE;
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        if (isOnline) {
            c.weighty = 0.0;
        }
        c.fill = 2;
        c.anchor = 23;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.archiveDirChooser, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 2;
        c.anchor = 23;
        c.insets = new Insets(0, 0, 0, 0);
        if (isOnline) {
            this.add((Component)this.cachingDirChooser, c);
        }
    }

    void setCashingPath(String path) {
        this.cachingDirChooser.setText(path);
    }

    String getCashingPath() {
        return this.cachingDirChooser.getText();
    }

    public void collectValues() {
        GWCommandManager commandManager = GWCommandManager.getInstance(this.userGuid);
        commandManager.setArchiveLocation(this.archiveDirChooser.getText());
        OptionManager.getInstance().setCashingPath(this.cachingDirChooser.getText());
        logger.debug((Object)("------------------------------: archDir" + this.archiveDirChooser.getText()));
        logger.debug((Object)("------------------------------: cachDir" + this.cachingDirChooser.getText()));
    }

    public void fireOptionsChanged() {
        GWCommandManager commandManager = GWCommandManager.getInstance(this.userGuid);
        this.initialArchivePath = commandManager.getArchiveLocation();
        this.archiveDirChooser.setText(this.initialArchivePath);
        this.cachingDirChooser.setText(OptionManager.getInstance().getCachingPath());
    }

    public void setOptions(AbstractCloneObject theAbstractOptions) throws IllegalArgumentException {
    }

    String getInitialArchivePath() {
        return this.initialArchivePath;
    }
}

