/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.printing;

import com.appframework.components.ComponentBorder;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.filechoser.OptionChangesListener;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.fontchooser.FontChooserDialog;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.border.CompoundBorder;
import org.apache.log4j.Logger;

class FontPanel
extends OrientablePanel {
    private static Logger logger = Logger.getLogger(FontPanel.class);
    private String caption;
    private JLabel lbFont;
    private JButton btnSelectFont;
    private Font font;
    private FontChooserDialog fontChooserDialog;
    private OptionChangesListener changesListener;

    public FontPanel(String theCaption, OptionChangesListener theChangesListener) {
        this.caption = theCaption;
        this.changesListener = theChangesListener;
        this.build();
    }

    private void build() {
        this.btnSelectFont = new JButton(new BtnSelectFontAction());
        this.btnSelectFont.setPreferredSize(new Dimension(19, 19));
        this.lbFont = new OrientableLabel();
        OrientableLabel label = new OrientableLabel(this.caption);
        this.add(label);
        if (!OS.isMacOS()) {
            label.setDisplayedMnemonic(StringResources.getMnemonic(this.caption));
            label.setDisplayedMnemonicIndex(StringResources.getDisplayedMnemonicIndex(this.caption));
        }
        label.setLabelFor(this.btnSelectFont);
        CompoundBorder border = BorderFactory.createCompoundBorder(new ComponentBorder(label), BorderFactory.createEmptyBorder(7, 7, 7, 7));
        this.setBorder(border);
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        c.anchor = 21;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        if (this.font == null) {
            this.font = new Font(PLAFChanger.getFontName(), 0, 14);
        }
        c.insets = new Insets(8, 4, 1, 2);
        c.weightx = 1.0;
        this.add((Component)this.lbFont, c);
        c.anchor = 22;
        c.gridx = 1;
        c.weightx = 0.0;
        c.insets = new Insets(8, 0, 1, 2);
        this.add((Component)this.btnSelectFont, c);
        this.update();
    }

    public void setName(String name) {
        this.btnSelectFont.setName(name);
    }

    private void update() {
        if (this.font != null) {
            String str = this.font.getName();
            str = str + " (";
            switch (this.font.getStyle()) {
                case 0: {
                    str = str + StringResources.PLAIN;
                    break;
                }
                case 1: {
                    str = str + StringResources.BOLD;
                    break;
                }
                case 2: {
                    str = str + StringResources.ITALIC;
                    break;
                }
                case 3: {
                    str = str + StringResources.BOLD_ITALIC;
                    break;
                }
            }
            str = str + ", " + String.valueOf(this.font.getSize()) + ')';
            this.lbFont.setText(str);
            this.lbFont.setFont(Utils.deriveFontForSize(this.font, 14.0f));
        }
    }

    public Font getSelectedFont() {
        return this.font;
    }

    public void setSelectedFont(Font theFont) {
        this.font = theFont;
        this.update();
    }

    private class BtnSelectFontAction
    extends AbstractAction {
        public BtnSelectFontAction() {
            super("...");
        }

        public void actionPerformed(ActionEvent e) {
            Window window = ControlsUtils.getWindowForComponent(FontPanel.this);
            if (window instanceof Frame) {
                FontPanel.this.fontChooserDialog = new FontChooserDialog((Frame)window);
            } else if (window instanceof Dialog) {
                FontPanel.this.fontChooserDialog = new FontChooserDialog((Dialog)window);
            }
            FontPanel.this.fontChooserDialog.setModal(true);
            UIUtils.centerWindow((Window)FontPanel.this.fontChooserDialog, window);
            FontPanel.this.fontChooserDialog.setFont(FontPanel.this.font);
            FontPanel.this.fontChooserDialog.pack();
            FontPanel.this.fontChooserDialog.setVisible(true);
            Font f = FontPanel.this.fontChooserDialog.getChoosenFont();
            if (f != null && !FontPanel.this.font.equals(f)) {
                FontPanel.this.font = f;
                FontPanel.this.changesListener.setValueChanged();
                FontPanel.this.update();
            }
            FontPanel.this.fontChooserDialog.dispose();
        }
    }
}

