/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.printing;

import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.orientable.OrientableTabbedPane;
import com.novell.gw.jclient.application.frames.options.compose.AbstractOptionPanel;
import com.novell.gw.jclient.application.frames.options.compose.ComposeOption;
import com.novell.gw.jclient.application.frames.options.compose.printing.PrintingAddressBookPanel;
import com.novell.gw.jclient.application.frames.options.compose.printing.PrintingCalendarPanel;
import com.novell.gw.jclient.application.frames.options.compose.printing.PrintingGeneralPanel;
import com.novell.gw.jclient.application.frames.options.compose.printing.PrintingMessagePanel;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.bl.om.options.PrintingOptions;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PrintOptionsPane
extends ComposeOption {
    public static final String HEADER_FONT = "header";
    public static final String SUBHEADER_FONT = "subheader";
    public static final String PLAINHEADER_FONT = "plain";
    public static final String PAGE_SETUP = "page setup";
    private AbstractOptionPanel generalPane;
    private AbstractOptionPanel messagePane;
    private AbstractOptionPanel calendarPane;
    private AbstractOptionPanel addressBookPane;
    private PrintingOptions printingOptions;

    public PrintOptionsPane(String theID, MVCController theParentController) {
        super(theID, theParentController);
    }

    public void prepareForShow() {
        this.build();
    }

    protected void build() {
        super.build();
        this.setLayout(new BorderLayout());
        OrientableTabbedPane tp = new OrientableTabbedPane();
        this.generalPane = new PrintingGeneralPanel(this.changesListener, this.controller);
        this.messagePane = new PrintingMessagePanel(this.changesListener, this.controller);
        this.calendarPane = new PrintingCalendarPanel(this.changesListener, this.controller);
        this.addressBookPane = new PrintingAddressBookPanel(this.changesListener, this.controller);
        tp.add(this.generalPane.getName(), new OrientableScrollPane(this.generalPane));
        tp.add(this.messagePane.getName(), new OrientableScrollPane(this.messagePane));
        tp.add(this.calendarPane.getName(), new OrientableScrollPane(this.calendarPane));
        tp.add(this.addressBookPane.getName(), new OrientableScrollPane(this.addressBookPane));
        tp.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                AbstractOptionPanel option = (AbstractOptionPanel)((JScrollPane)((JTabbedPane)e.getSource()).getSelectedComponent()).getViewport().getComponent(0);
                boolean b = PrintOptionsPane.this.changesListener.valueHasChanged();
                option.prepareForShow();
                if (!b) {
                    PrintOptionsPane.this.changesListener.setValueSaved();
                }
            }
        });
        this.add((Component)tp, "Center");
        this.putOptionValuesIntoFields();
    }

    public void save() {
        if (this.changesListener.valueHasChanged()) {
            this.collectValues();
            OptionManager.getInstance().setPrintingOptions((PrintingOptions)this.printingOptions.clone());
            this.changesListener.setValueSaved();
        }
    }

    public void putOptionValuesIntoFields() {
        this.printingOptions = (PrintingOptions)OptionManager.getInstance().getPrintingOptions().clone();
        this.generalPane.setOptions(this.printingOptions);
        this.messagePane.setOptions(this.printingOptions);
        this.calendarPane.setOptions(this.printingOptions);
        this.addressBookPane.setOptions(this.printingOptions);
        this.changesListener.setValueSaved();
    }

    public void collectValues() {
        if (this.generalPane.isPrepared) {
            this.generalPane.collectValues();
        }
        if (this.messagePane.isPrepared) {
            this.messagePane.collectValues();
        }
        if (this.calendarPane.isPrepared) {
            this.calendarPane.collectValues();
        }
        if (this.addressBookPane.isPrepared) {
            this.addressBookPane.collectValues();
        }
    }
}

