/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.security;

import com.novell.gw.ab.Addressable;
import com.novell.gw.engine.ProxyAccessEntry;
import com.novell.gw.engine.ProxyAccessList;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

class AccessTableModel
extends AbstractTableModel {
    private String[] columns = new String[]{StringResources.NAME, StringResources.ADDRESS};
    private ProxyAccessList proxyAccessList;
    private String userGuid;

    public AccessTableModel(String userGuid) {
        this.userGuid = userGuid;
        this.proxyAccessList = GWCommandManager.getInstance(this.userGuid).getProxyAccessList();
    }

    public int getRowCount() {
        return this.proxyAccessList.size();
    }

    public String getColumnName(int column) {
        return this.columns[column];
    }

    public int getColumnCount() {
        return this.columns.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.proxyAccessList.get(rowIndex).getDisplayName();
            }
            case 1: {
                return this.proxyAccessList.get(rowIndex).getEmailAddress();
            }
        }
        return "";
    }

    public ProxyAccessEntry getProxyAccessEntry(int index) {
        return this.proxyAccessList.get(index);
    }

    public int indexOf(IAddressable addr) {
        int index = -1;
        int nSize = this.proxyAccessList.size();
        for (int i = 0; i < nSize && index < 0; ++i) {
            if (!addr.getDisplayName().equals(this.proxyAccessList.get(i).getDisplayName())) continue;
            index = i;
        }
        return index;
    }

    public void removeContact(int index) {
        this.proxyAccessList.remove(index);
        this.fireTableRowsDeleted(index, index);
    }

    public void addContacts(List selectedContacts) {
        int addedUsersCount = 0;
        int nSize = selectedContacts.size();
        for (int i = 0; i < nSize; ++i) {
            if (selectedContacts.get(i) instanceof IContact) {
                IContact contact = (IContact)selectedContacts.get(i);
                if (GWCommandManager.getInstance(this.userGuid).getCurrentUserInfo().getID().equals(contact.getUserName())) {
                    JOptionPane.showMessageDialog(null, StringResources.YOU_CANNOT_SHARE, StringResources.ADDRESS_BOOK_ERROR, 2);
                    continue;
                }
                int paSizeBefore = this.proxyAccessList.size();
                int result = this.proxyAccessList.add((Addressable)contact.getNativeContact());
                int paSizeAfter = this.proxyAccessList.size();
                if (result != -1) {
                    if (paSizeAfter <= paSizeBefore) continue;
                    ++addedUsersCount;
                    continue;
                }
                JOptionPane.showMessageDialog(null, StringResources.formatString(StringResources.IS_NOT_A_VALID_GROUPWISE_USER, contact.getDisplayName(), contact.getDisplayName()), StringResources.NOVELL_GROUPWISE, 2);
                continue;
            }
            throw new IllegalArgumentException();
        }
        if (addedUsersCount > 0) {
            int index = this.proxyAccessList.size() - 1;
            this.fireTableRowsInserted(this.proxyAccessList.size() - addedUsersCount, index);
        }
    }

    public void saveChanges() {
        this.proxyAccessList.commit();
    }
}

