/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.send;

import com.appframework.mvc.MVCController;
import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.engine.SettingsValue;
import com.novell.gw.jclient.api.impl.message.APIMessageWrapperManager;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.application.controls.filechoser.OptionChangesListener;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.ExtendedDateTextField;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.RecuringDateChangeEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.RecuringDateChangeListener;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.RecuringDateSelector;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicCheckBox;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicRadioButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableSpinner;
import com.novell.gw.jclient.application.controls.timepicker.DelayDeliveryTimeDurationSelector;
import com.novell.gw.jclient.application.controls.timepicker.TimePicker;
import com.novell.gw.jclient.application.frames.compose.FrameComposePostedItem;
import com.novell.gw.jclient.application.frames.options.compose.AbstractOptionPanel;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.items.sendoptions.AbstractSendOptions;
import com.novell.gw.jclient.bl.om.items.sendoptions.MimeEncoding;
import com.novell.gw.jclient.bl.om.items.sendoptions.Notification;
import com.novell.gw.jclient.bl.om.items.sendoptions.Priority;
import com.novell.gw.jclient.bl.om.items.sendoptions.Security;
import com.novell.gw.jclient.bl.om.options.AbstractCloneObject;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class CommonSendOptionsPanel
extends AbstractOptionPanel {
    Logger logger = Logger.getLogger(CommonSendOptionsPanel.class);
    private static final Insets SEPARATOR_INSETS = new Insets(10, 10, 0, 5);
    private AbstractSendOptions abstractSendOptions;
    private JRadioButton rbPriorityHigh;
    private JRadioButton rbPriorityStandard;
    private JRadioButton rbPriorityLow;
    private JRadioButton rbWhenConvenient;
    private JRadioButton rbWithin;
    private JCheckBox cbReplyRequest;
    private JCheckBox cbExpirationDate;
    private JCheckBox cbDelayDelivery;
    private JCheckBox cbNotifyRecipients;
    private JComboBox cmbClassification;
    private JComboBox cmbEncoding;
    private JSpinner spnForDays;
    private JSpinner spnAfterDays;
    private JSpinner spnWithinDays;
    private JButton btnCalendar;
    private DelayDeliveryTimeDurationSelector dsTime;
    private RecuringDateSelector tfDate;
    private OrientableLabel lblDays;
    private JMnemonicLabel lblMIMEEncoding;
    private boolean isFromToolsOptions;

    public CommonSendOptionsPanel(OptionChangesListener theChangesListener, MVCController theParentController, boolean isFromToolsOptions) {
        super(theChangesListener, theParentController);
        this.isFromToolsOptions = isFromToolsOptions;
        this.isPrepared = true;
        this.init();
        this.buildUI();
    }

    private void init() {
        this.rbPriorityHigh = new JMnemonicRadioButton(StringResources.HIGH_PRIORITY);
        this.rbPriorityHigh.addItemListener(this.itemListener);
        this.rbPriorityLow = new JMnemonicRadioButton(StringResources.LOW_PRIORITY);
        this.rbPriorityLow.addItemListener(this.itemListener);
        this.rbPriorityStandard = new JMnemonicRadioButton(StringResources.STANDARD_PRIORITY);
        this.rbPriorityStandard.addItemListener(this.itemListener);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbPriorityLow);
        buttonGroup.add(this.rbPriorityStandard);
        buttonGroup.add(this.rbPriorityHigh);
        this.rbWhenConvenient = new JMnemonicRadioButton(StringResources.WHEN_CONVENIENT);
        this.rbWhenConvenient.addItemListener(this.itemListener);
        this.rbWithin = new JMnemonicRadioButton(StringResources.WITHIN);
        this.rbWithin.addItemListener(this.itemListener);
        this.rbWithin.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean enable = CommonSendOptionsPanel.this.rbWithin.isSelected();
                CommonSendOptionsPanel.this.spnWithinDays.setEnabled(enable);
                CommonSendOptionsPanel.this.lblDays.setEnabled(enable);
            }
        });
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbWithin);
        buttonGroup.add(this.rbWhenConvenient);
        this.cbDelayDelivery = new JMnemonicCheckBox(StringResources.DELAY_DELIVERY);
        this.cbDelayDelivery.addItemListener(this.itemListener);
        this.cbDelayDelivery.addItemListener(new DelayListener());
        this.cbExpirationDate = new JMnemonicCheckBox(StringResources.EXPIRATION_DATE);
        this.cbExpirationDate.addItemListener(this.itemListener);
        this.cbExpirationDate.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                CommonSendOptionsPanel.this.spnAfterDays.setEnabled(CommonSendOptionsPanel.this.cbExpirationDate.isSelected());
            }
        });
        this.cbNotifyRecipients = new JMnemonicCheckBox(StringResources.NOTIFY_RECIPIENTS);
        this.cbNotifyRecipients.addItemListener(this.itemListener);
        this.cbReplyRequest = new JMnemonicCheckBox(StringResources.REPLY_REQUESTED);
        this.cbReplyRequest.addItemListener(this.itemListener);
        this.cbReplyRequest.addItemListener(new CheckReplyItemListener());
        this.spnAfterDays = new OrientableSpinner(new SpinnerNumberModel(0, 0, 999, 1));
        this.spnAfterDays.addChangeListener(this.changeListener);
        this.spnAfterDays.setName("CommonSendOptionsPanel_spnAfterDays");
        this.spnForDays = new OrientableSpinner(new SpinnerNumberModel(0, 0, 999, 1));
        this.spnForDays.addChangeListener(this.changeListener);
        this.spnForDays.addChangeListener(new DelayDeliveryChangeListener());
        this.spnForDays.setName("CommonSendOptionsPanel_spnForDays");
        this.spnWithinDays = new OrientableSpinner(new SpinnerNumberModel(0, 0, 99, 1));
        this.spnWithinDays.addChangeListener(this.changeListener);
        this.spnWithinDays.setName("CommonSendOptionsPanel_spnWithinDays");
        ClickAction clickAction = new ClickAction();
        this.cmbEncoding = new OrientableComboBox(MimeEncoding.MIME_ENC_LIST);
        this.cmbEncoding.addActionListener(clickAction);
        this.cmbClassification = new NotificationComboBox(Security.SECURITY_LIST);
        this.cmbClassification.setFocusable(false);
        this.cmbClassification.addActionListener(clickAction);
        this.btnCalendar = new OrientableButton(ImageResources.CALENDAR_LITTLE);
        this.btnCalendar.setMargin(new Insets(0, 0, 0, 0));
        this.btnCalendar.setIcon(ImageResources.CALENDAR_LITTLE);
        Calendar startTime = Calendar.getInstance();
        startTime.set(11, 23);
        startTime.set(12, 59);
        this.dsTime = new DelayDeliveryTimeDurationSelector(startTime);
        this.dsTime.setEnabled(false);
        this.dsTime.setDisplayTimeMode(TimePicker.DisplayTimeMode.START);
        this.dsTime.setStartTimeFieldColumns(7);
        this.dsTime.setBevelBorder();
        this.dsTime.getTextComponent().setName("CommonSendOptionsPanel_tfTime");
        this.dsTime.getTextComponent().addPropertyChangeListener("value", new CustomValueChangeListener());
        this.tfDate = new RecuringDateSelector(false);
        this.tfDate.setDate(GWCalendarUtils.getTodayWithoutTimeFraction());
        Object dateTextField = this.tfDate.getTextComponent();
        ((JComponent)dateTextField).setBorder(BorderFactory.createLoweredBevelBorder());
        ((JTextField)dateTextField).setColumns(7);
        this.tfDate.addRecuringDateChangeListener(new CustomRecuringDateChangeListener());
        ((ExtendedDateTextField)this.tfDate.getTextComponent()).setName("CommonSendOptionsPanel_tfDate_dateField");
        this.cbExpirationDate.setSelected(true);
        this.cbDelayDelivery.setSelected(true);
        this.dsTime.setEnabled(!this.isFromToolsOptions);
        this.lblDays = new OrientableLabel(StringResources.L_DAYS);
        this.lblMIMEEncoding = new JMnemonicLabel(StringResources.MIME_ENCODING_C, this.cmbEncoding);
    }

    private void buildUI() {
        this.setLayout(new GridLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        OrientablePanel pnlLeft = new OrientablePanel(new GridBagLayout());
        OrientablePanel pnlRight = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.anchor = 21;
        pnlLeft.add((Component)this.createPriorityPanel(), constraints);
        ++constraints.gridy;
        pnlLeft.add((Component)this.createReplyPanel(), constraints);
        ++constraints.gridy;
        pnlLeft.add((Component)this.createEncodingPanel(), constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridheight = 3;
        constraints.weightx = 0.0;
        constraints.fill = 3;
        pnlLeft.add((Component)new JSeparator(1), constraints);
        constraints.gridy = 3;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weighty = 1.0;
        pnlLeft.add((Component)new JPanel(), constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        constraints.anchor = 21;
        pnlRight.add((Component)this.createExpirationPanel(), constraints);
        ++constraints.gridy;
        pnlRight.add((Component)this.createDelayPanel(), constraints);
        ++constraints.gridy;
        pnlRight.add((Component)this.createNotifyPanel(), constraints);
        ++constraints.gridy;
        constraints.weighty = 1.0;
        pnlRight.add((Component)new JPanel(), constraints);
        this.add(pnlLeft);
        this.add(pnlRight);
    }

    protected void build() {
    }

    public void collectValues() {
        this.collectValues(this.abstractSendOptions, null);
    }

    public void fireOptionsChanged() {
        JRadioButton rb;
        boolean isPostedItem = this.controller.getParentController().getMVCView() instanceof FrameComposePostedItem;
        switch (this.abstractSendOptions.getPriority().getValue()) {
            case 4: {
                rb = this.rbPriorityHigh;
                break;
            }
            case 1: {
                rb = this.rbPriorityLow;
                break;
            }
            case 2: {
                rb = this.rbPriorityStandard;
                break;
            }
            default: {
                rb = this.rbPriorityStandard;
            }
        }
        rb.setSelected(true);
        this.setEnablePriority(!this.abstractSendOptions.isPriorityLocked());
        this.cmbClassification.setSelectedItem(this.abstractSendOptions.getSecurity());
        this.cmbClassification.setEnabled(!this.abstractSendOptions.isSecurityLocked());
        if (this.abstractSendOptions.isReplyWhenConvenient()) {
            this.rbWhenConvenient.setSelected(true);
        } else {
            this.rbWithin.setSelected(true);
        }
        this.spnWithinDays.setValue(this.abstractSendOptions.getReplyRequestDay());
        this.cbReplyRequest.setSelected(true);
        this.cbReplyRequest.setSelected(this.abstractSendOptions.isReplyRequested());
        this.cbReplyRequest.setEnabled(!isPostedItem);
        this.cmbEncoding.setSelectedItem(this.abstractSendOptions.getMimeEncoding());
        this.cmbEncoding.setEnabled(!this.abstractSendOptions.isMimeLocked() && !isPostedItem);
        this.lblMIMEEncoding.setEnabled(!isPostedItem);
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        this.cbNotifyRecipients.setSelected((Boolean)dataStoreSettings.getSendOptionNotifyRecipients().getValue());
        this.cbNotifyRecipients.setEnabled(!dataStoreSettings.getSendOptionNotifyRecipients().isLocked() && !isPostedItem);
        this.spnAfterDays.getModel().setValue(dataStoreSettings.getSendOptionExpireDays().getValue());
        this.spnAfterDays.setEnabled(!dataStoreSettings.getSendOptionExpireDays().isLocked());
        boolean b = (Integer)dataStoreSettings.getSendOptionExpireDays().getValue() != 0;
        this.cbExpirationDate.setSelected(b);
        this.cbExpirationDate.setEnabled(!dataStoreSettings.getSendOptionExpireDays().isLocked());
        SettingsValue settingsValue = dataStoreSettings.getSendOptionDelayDeliverDays();
        boolean locked = settingsValue.isLocked();
        int value = (Integer)settingsValue.getValue();
        this.logger.debug((Object)("value: " + value));
        int spinnerValue = value;
        if (value > 0) {
            --spinnerValue;
        }
        this.spnForDays.setEnabled(!locked);
        this.spnForDays.getModel().setValue(spinnerValue);
        this.cbDelayDelivery.setSelected(value > 0);
        this.cbDelayDelivery.setEnabled(!locked);
    }

    public void setOptions(AbstractCloneObject theAbstractOptions) throws IllegalArgumentException {
        if (theAbstractOptions == null) {
            return;
        }
        if (!(theAbstractOptions instanceof AbstractSendOptions)) {
            throw new IllegalArgumentException();
        }
        this.abstractSendOptions = (AbstractSendOptions)theAbstractOptions;
        this.fireOptionsChanged();
    }

    public void collectValues(AbstractSendOptions abstractSendOptions, IMessage message) {
        if (this.rbPriorityHigh.isSelected()) {
            abstractSendOptions.setPriority(Priority.HIGH);
        } else if (this.rbPriorityStandard.isSelected()) {
            abstractSendOptions.setPriority(Priority.STANDARD);
        } else if (this.rbPriorityLow.isSelected()) {
            abstractSendOptions.setPriority(Priority.LOW);
        } else {
            abstractSendOptions.setPriority(Priority.STANDARD);
        }
        abstractSendOptions.setSecurity((Security)this.cmbClassification.getSelectedItem());
        abstractSendOptions.setReplyRequested(this.cbReplyRequest.isSelected());
        abstractSendOptions.setReplyWhenConvenient(this.rbWhenConvenient.isSelected());
        abstractSendOptions.setReplyRequestDay((Integer)this.spnWithinDays.getValue());
        if (this.cmbEncoding.getSelectedIndex() >= 0) {
            abstractSendOptions.setMimeEncodingType((MimeEncoding)this.cmbEncoding.getSelectedItem());
        }
        abstractSendOptions.setNotifyRecipients(this.cbNotifyRecipients.isSelected());
        if (this.cbExpirationDate.isSelected()) {
            abstractSendOptions.setExpireDays((Integer)this.spnAfterDays.getValue());
        } else {
            abstractSendOptions.setExpireDays(0);
        }
        if (message != null) {
            if (this.cbDelayDelivery.isSelected()) {
                int days = (Integer)this.spnForDays.getValue();
                int hours = this.dsTime.getHours();
                int mins = this.dsTime.getMinutes();
                this.logger.debug((Object)("days: " + days + "  hours: " + hours + "  minutes: " + mins));
                abstractSendOptions.setDelayDeliverInfo(APIMessageWrapperManager.createDelayDeliverInfo(message, days, hours, mins));
            } else {
                abstractSendOptions.setDelayDeliverInfo(null);
            }
        } else if (this.cbDelayDelivery.isSelected()) {
            int days = (Integer)this.spnForDays.getValue();
            abstractSendOptions.setDelayDeliverDays(++days);
        } else {
            abstractSendOptions.setDelayDeliverDays(0);
        }
    }

    private void setEnablePriority(Boolean b) {
        this.rbPriorityHigh.setEnabled(b);
        this.rbPriorityLow.setEnabled(b);
        this.rbPriorityStandard.setEnabled(b);
    }

    private void setEnableReply(Boolean b) {
        this.rbWhenConvenient.setEnabled(b);
        this.rbWithin.setEnabled(b);
        this.spnWithinDays.setEnabled(b);
        this.lblDays.setEnabled(b);
        if (b.booleanValue() && !this.rbWithin.isSelected()) {
            this.spnWithinDays.setEnabled(false);
            this.lblDays.setEnabled(false);
        }
    }

    private JPanel createPriorityPanel() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 21;
        constraints.insets = new Insets(10, 10, 0, 10);
        panel.add((Component)this.rbPriorityHigh, constraints);
        ++constraints.gridy;
        constraints.insets.top = 5;
        panel.add((Component)this.rbPriorityStandard, constraints);
        ++constraints.gridy;
        panel.add((Component)this.rbPriorityLow, constraints);
        ++constraints.gridy;
        constraints.insets.top = 10;
        panel.add((Component)new JMnemonicLabel(StringResources.CLASSIFICATION_C, this.cmbClassification), constraints);
        ++constraints.gridy;
        constraints.insets = new Insets(5, 10, 0, 15);
        constraints.fill = 2;
        panel.add((Component)this.cmbClassification, constraints);
        ++constraints.gridy;
        constraints.insets.top = 10;
        constraints.insets.right = 10;
        panel.add((Component)new JSeparator(), constraints);
        return panel;
    }

    private JPanel createReplyPanel() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 3;
        constraints.anchor = 21;
        constraints.insets = new Insets(10, 10, 0, 10);
        panel.add((Component)this.cbReplyRequest, constraints);
        ++constraints.gridy;
        constraints.insets = new Insets(5, 30, 0, 10);
        panel.add((Component)this.rbWhenConvenient, constraints);
        ++constraints.gridy;
        constraints.gridwidth = 1;
        panel.add((Component)this.rbWithin, constraints);
        ++constraints.gridx;
        constraints.insets.left = 0;
        panel.add((Component)this.spnWithinDays, constraints);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        panel.add((Component)this.lblDays, constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.gridwidth = 3;
        constraints.insets = new Insets(10, 10, 0, 10);
        constraints.fill = 2;
        panel.add((Component)new JSeparator(), constraints);
        return panel;
    }

    private JPanel createEncodingPanel() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(10, 10, 0, 15);
        panel.add((Component)this.lblMIMEEncoding, constraints);
        ++constraints.gridy;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        constraints.insets.top = 5;
        panel.add((Component)this.cmbEncoding, constraints);
        return panel;
    }

    private JPanel createExpirationPanel() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 3;
        constraints.anchor = 21;
        constraints.insets = new Insets(10, 10, 0, 10);
        panel.add((Component)this.cbExpirationDate, constraints);
        ++constraints.gridy;
        constraints.gridwidth = 1;
        constraints.insets = new Insets(5, 30, 0, 10);
        panel.add((Component)new JMnemonicLabel(StringResources.AFTER, this.spnAfterDays), constraints);
        ++constraints.gridx;
        constraints.insets.left = 0;
        panel.add((Component)this.spnAfterDays, constraints);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        panel.add((Component)new OrientableLabel(StringResources.L_DAYS), constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 3;
        constraints.insets = SEPARATOR_INSETS;
        constraints.fill = 2;
        panel.add((Component)new JSeparator(), constraints);
        return panel;
    }

    private JPanel createDelayPanel() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 3;
        constraints.anchor = 21;
        constraints.insets = new Insets(10, 10, 0, 10);
        panel.add((Component)this.cbDelayDelivery, constraints);
        ++constraints.gridy;
        constraints.insets.top = 5;
        constraints.insets.left = 30;
        constraints.gridwidth = 1;
        panel.add((Component)new JMnemonicLabel(StringResources.FOR, this.spnForDays), constraints);
        ++constraints.gridx;
        constraints.insets.left = 0;
        panel.add((Component)this.spnForDays, constraints);
        ++constraints.gridx;
        panel.add((Component)new OrientableLabel(StringResources.L_DAYS), constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.gridwidth = 3;
        constraints.insets = new Insets(10, 30, 0, 10);
        panel.add((Component)new JMnemonicLabel(StringResources.UNTIL, this.tfDate), constraints);
        ++constraints.gridy;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        constraints.insets.top = 5;
        panel.add((Component)this.createTimePanel(), constraints);
        ++constraints.gridy;
        constraints.insets = SEPARATOR_INSETS;
        panel.add((Component)new JSeparator(), constraints);
        return panel;
    }

    private JPanel createNotifyPanel() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 21;
        constraints.insets = new Insets(10, 10, 10, 10);
        panel.add((Component)this.cbNotifyRecipients, constraints);
        return panel;
    }

    private JPanel createTimePanel() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.insets.bottom = 1;
        panel.add((Component)this.tfDate, constraints);
        ++constraints.gridy;
        panel.add((Component)this.dsTime, constraints);
        return panel;
    }

    public int getDuration() {
        Calendar newDate = this.tfDate.getDate();
        Calendar today = GWCalendarUtils.getToday();
        long dayDuration = 86400000L;
        GWCalendarUtils.clearTime(newDate);
        GWCalendarUtils.clearTime(today);
        long duration = newDate.getTimeInMillis() - today.getTimeInMillis();
        if ((duration += 1000L) < 0L) {
            this.tfDate.setDate(today);
            duration = 0L;
        }
        return (int)(duration / dayDuration);
    }

    private class CustomRecuringDateChangeListener
    implements RecuringDateChangeListener {
        private CustomRecuringDateChangeListener() {
        }

        public void valueChanged(RecuringDateChangeEvent event) {
            CommonSendOptionsPanel.this.changesListener.setValueChanged();
            int duration = CommonSendOptionsPanel.this.getDuration();
            if ((Integer)CommonSendOptionsPanel.this.spnForDays.getValue() != duration) {
                CommonSendOptionsPanel.this.spnForDays.getModel().setValue(duration);
            }
        }
    }

    private class DelayDeliveryChangeListener
    implements ChangeListener {
        private DelayDeliveryChangeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            int value = (Integer)CommonSendOptionsPanel.this.spnForDays.getValue();
            Calendar day = GWCalendarUtils.getToday();
            int dayOfMonth = day.get(5);
            day.set(5, dayOfMonth + value);
            if (CommonSendOptionsPanel.this.getDuration() != value) {
                CommonSendOptionsPanel.this.tfDate.setDate(day);
            }
        }
    }

    private class CustomValueChangeListener
    implements PropertyChangeListener {
        private CustomValueChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            CommonSendOptionsPanel.this.logger.debug((Object)("evt.getPropertyName(): " + evt.getPropertyName()));
            CommonSendOptionsPanel.this.logger.debug((Object)("evt.getNewValue(): " + evt.getNewValue()));
            CommonSendOptionsPanel.this.logger.debug((Object)("evt.getOldValue(): " + evt.getOldValue()));
            CommonSendOptionsPanel.this.changesListener.setValueChanged();
        }
    }

    private class CheckReplyItemListener
    implements ItemListener {
        private CheckReplyItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            boolean selected = CommonSendOptionsPanel.this.cbReplyRequest.isSelected();
            CommonSendOptionsPanel.this.setEnableReply(selected);
        }
    }

    private class ClickAction
    extends AbstractAction {
        private ClickAction() {
        }

        public void actionPerformed(ActionEvent e) {
            CommonSendOptionsPanel.this.changesListener.setValueChanged();
        }
    }

    protected static class NotificationComboBox
    extends OrientableComboBox {
        public NotificationComboBox(Object[] items) {
            super(items);
        }

        public void setNotification(Notification theNotification) {
            this.setSelectedItem(theNotification);
            this.setEnabled(!theNotification.isLocked());
        }
    }

    private class DelayListener
    implements ItemListener {
        private DelayListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            boolean b = CommonSendOptionsPanel.this.cbDelayDelivery.isSelected();
            CommonSendOptionsPanel.this.spnForDays.setEnabled(b);
            CommonSendOptionsPanel.this.tfDate.setEnabled(b);
            CommonSendOptionsPanel.this.btnCalendar.setEnabled(b);
            CommonSendOptionsPanel.this.dsTime.setEnabled(!CommonSendOptionsPanel.this.isFromToolsOptions && b);
        }
    }
}

