/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.send;

import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.api.interfaces.ICategoryList;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.filechoser.OptionChangesListener;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.categories.CategoriesEditDialog;
import com.novell.gw.jclient.application.frames.options.compose.AbstractOptionPanel;
import com.novell.gw.jclient.application.frames.options.compose.send.CommonSendOptionsPanel;
import com.novell.gw.jclient.application.frames.options.compose.send.SelectCategoryControl;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.categories.CategoryUtils;
import com.novell.gw.jclient.bl.om.items.sendoptions.ComposeItemSendOptions;
import com.novell.gw.jclient.bl.om.options.AbstractCloneObject;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JSeparator;

public class ComposeGeneralOptionsPanel
extends AbstractOptionPanel {
    private CommonSendOptionsPanel pnlSendOptions;
    private SelectCategoryControl categoriesChooser;
    private ActionEditSendOptionsCategories categoryAction;
    private String userGuid;

    protected ComposeGeneralOptionsPanel(OptionChangesListener theChangesListener, MVCController theParentController) {
        super(theChangesListener, theParentController);
        this.userGuid = ControlsUtils.getUserGuid(theParentController);
        this.init();
        this.buildUI();
    }

    protected void build() {
    }

    public void collectValues() {
    }

    public void fireOptionsChanged() {
    }

    public void setOptions(AbstractCloneObject abstractSendOptions) throws IllegalArgumentException {
        this.pnlSendOptions.setOptions(abstractSendOptions);
        ICategoryList categories = ((ComposeItemSendOptions)abstractSendOptions).getCategories();
        if (categories == null) {
            categories = CategoryUtils.createNewCategoryList(this.userGuid);
        }
        this.categoryAction.setCategories(categories);
        this.categoriesChooser.setCategories(categories);
    }

    private void init() {
        this.categoryAction = new ActionEditSendOptionsCategories();
        this.pnlSendOptions = new CommonSendOptionsPanel(this.changesListener, this.controller, false);
    }

    private void buildUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(10, 10, 0, 10);
        constraints.weightx = 1.0;
        this.add((Component)this.createCategoriesPanel(), constraints);
        ++constraints.gridy;
        constraints.fill = 2;
        this.add((Component)new JSeparator(), constraints);
        ++constraints.gridy;
        constraints.insets.left = 0;
        constraints.fill = 0;
        this.add((Component)this.pnlSendOptions, constraints);
    }

    private OrientablePanel createCategoriesPanel() {
        OrientablePanel content = new OrientablePanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 3;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 0, 10);
        content.add((Component)new OrientableLabel(StringResources.CATEGORY), c);
        this.categoriesChooser = new SelectCategoryControl(CategoryUtils.createNewCategoryList(this.userGuid), this.userGuid);
        ++c.gridx;
        content.add((Component)this.categoriesChooser, c);
        ++c.gridx;
        content.add((Component)new JMnemonicButton(this.categoryAction), c);
        return content;
    }

    public void collectValues(ComposeItemSendOptions abstractSendOptions, IMessage message) {
        abstractSendOptions.setCategories(this.categoryAction.getCategories());
        this.pnlSendOptions.collectValues(abstractSendOptions, message);
    }

    private class ActionEditSendOptionsCategories
    extends AbstractAction {
        public ActionEditSendOptionsCategories() {
            super(StringResources.EDIT_CATEGORIES);
        }

        public void setCategories(ICategoryList categories) {
            ComposeGeneralOptionsPanel.this.categoriesChooser.setCategories(categories);
        }

        public ICategoryList getCategories() {
            if (ComposeGeneralOptionsPanel.this.categoriesChooser == null) {
                return null;
            }
            return ComposeGeneralOptionsPanel.this.categoriesChooser.getCategories();
        }

        public void actionPerformed(ActionEvent e) {
            ICategoryList categories = CategoriesEditDialog.show(ControlsUtils.getWindowForComponent(ComposeGeneralOptionsPanel.this), ComposeGeneralOptionsPanel.this.controller, this.getCategories());
            if (categories != null) {
                this.setCategories(categories);
                ComposeGeneralOptionsPanel.this.categoriesChooser.updateText();
            }
        }
    }
}

