/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.send;

import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.orientable.OrientableTabbedPane;
import com.novell.gw.jclient.application.frames.options.compose.AbstractOptionPanel;
import com.novell.gw.jclient.application.frames.options.compose.ComposeOption;
import com.novell.gw.jclient.application.frames.options.compose.send.CommonSendOptionsPanel;
import com.novell.gw.jclient.application.frames.options.compose.send.SendSecurityOptionsPanel;
import com.novell.gw.jclient.application.frames.options.compose.send.SignaturePanel;
import com.novell.gw.jclient.application.frames.options.compose.send.StatusTrackingOptionsPanel;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.options.SendOptions;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class SendOptionsPane
extends ComposeOption {
    private static Logger logger = Logger.getLogger(SendOptionsPane.class);
    public static final String BUTTON_ADD = "add sign";
    public static final String BUTTON_EDIT = "edit sign";
    public static final String BUTTON_REMOVE = "remove sign";
    public static final String BUTTON_SET_DEFAULT = "set default";
    public static final String BUTTON_OK = "ok";
    public static final String LIST_SIGNATURES = "list sign";
    public static final String CHECK_LOCAL_SIGN = "local sign";
    public static final String FIELD_NAME = "name";
    private AbstractOptionPanel serverSignaturePanel;
    private AbstractOptionPanel sendSecurityOptionsPanel;
    private AbstractOptionPanel statusTrackingOptionsPanel;
    private AbstractOptionPanel commonSendOptionsPanel;
    private AbstractOptionPanel signatureOptionsPanel;
    private AbstractOptionPanel vCardOptionsPanel;
    private SendOptions sendOptions;
    private String userGuid;

    public SendOptionsPane(String theID, MVCController theParentController, String userGuid) {
        super(theID, theParentController);
        this.userGuid = userGuid;
    }

    public void prepareForShow() {
        this.build();
    }

    protected void build() {
        super.build();
        this.setLayout(new BorderLayout());
        this.commonSendOptionsPanel = new CommonSendOptionsPanel(this.changesListener, this.controller, true);
        this.statusTrackingOptionsPanel = new StatusTrackingOptionsPanel(this.changesListener, this.controller);
        this.serverSignaturePanel = new SignaturePanel(this.changesListener, this.getController(), this.userGuid, EngineCommandManager.getInstance(this.userGuid).getCurrentDataStore().getGroupWiseAccount());
        this.sendSecurityOptionsPanel = new SendSecurityOptionsPanel(this.changesListener, this.getController());
        OrientableTabbedPane tpSend = new OrientableTabbedPane();
        ((JTabbedPane)tpSend).addTab(StringResources.SEND_OPTIONS, new OrientableScrollPane(this.commonSendOptionsPanel));
        ((JTabbedPane)tpSend).addTab(StringResources.STATUS_TRACKING, new OrientableScrollPane(this.statusTrackingOptionsPanel));
        ((JTabbedPane)tpSend).addTab(StringResources.SECURITY, new OrientableScrollPane(this.sendSecurityOptionsPanel));
        ((JTabbedPane)tpSend).addTab(StringResources.SIGNATURE, new OrientableScrollPane(this.serverSignaturePanel));
        tpSend.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                AbstractOptionPanel option = (AbstractOptionPanel)((JScrollPane)((JTabbedPane)e.getSource()).getSelectedComponent()).getViewport().getComponent(0);
                boolean b = SendOptionsPane.this.changesListener.valueHasChanged();
                option.prepareForShow();
                if (!b) {
                    SendOptionsPane.this.changesListener.setValueSaved();
                }
            }
        });
        this.add((Component)tpSend, "Center");
        this.putOptionValuesIntoFields();
    }

    public void save() {
        if (this.changesListener.valueHasChanged()) {
            this.collectValues();
            OptionManager.getInstance().setSendOptions((SendOptions)this.sendOptions.clone(), this.userGuid);
            this.changesListener.setValueSaved();
            logger.debug((Object)"Send options saved");
        }
    }

    public void putOptionValuesIntoFields() {
        this.sendOptions = (SendOptions)OptionManager.getInstance().getSendOptions(this.userGuid).clone();
        this.commonSendOptionsPanel.setOptions(this.sendOptions.getItemSendOptions());
        this.serverSignaturePanel.setOptions(this.sendOptions);
        this.statusTrackingOptionsPanel.setOptions(this.sendOptions.getItemSendOptions());
        this.sendSecurityOptionsPanel.setOptions(this.sendOptions);
        this.changesListener.setValueSaved();
    }

    public void collectValues() {
        if (this.commonSendOptionsPanel.isPrepared) {
            this.commonSendOptionsPanel.collectValues();
        }
        if (this.statusTrackingOptionsPanel.isPrepared) {
            this.statusTrackingOptionsPanel.collectValues();
        }
        if (this.serverSignaturePanel.isPrepared) {
            this.serverSignaturePanel.collectValues();
        }
        if (this.sendSecurityOptionsPanel.isPrepared) {
            this.sendSecurityOptionsPanel.collectValues();
        }
    }
}

