/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.send;

import com.appframework.components.customizedbutton.ToolBarButton;
import com.appframework.mvc.MVCController;
import com.appframework.utils.OS;
import com.novell.gw.account.AccountSettings;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.addressbook.SearchTextField;
import com.novell.gw.jclient.application.controls.filechoser.GWFileChooser;
import com.novell.gw.jclient.application.controls.filechoser.GWMacFileChooser;
import com.novell.gw.jclient.application.controls.filechoser.OptionChangesListener;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableRadioButton;
import com.novell.gw.jclient.application.frames.options.compose.AbstractOptionPanel;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.options.AbstractCloneObject;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class VCardOptionsPanel
extends AbstractOptionPanel {
    private JCheckBox cbAddAnElectronicBusinessCard;
    private JRadioButton rbGenerateFromSystemAddressBox;
    private JRadioButton rbSelectFromPersonlaAddressBook;
    private JRadioButton rbSelectAVCardFile;
    private SearchTextField tfSearchAddress;
    private JButton btnSelectFolder;
    private JTextField tfPath;

    public VCardOptionsPanel(OptionChangesListener theChangesListener, MVCController theParentController) {
        super(theChangesListener, theParentController);
    }

    private void init() {
        CurrentItemListener currentItemListener = new CurrentItemListener();
        this.cbAddAnElectronicBusinessCard = new OrientableCheckBox(StringResources.ADD_AN_ELECTRONIC_BUSINESS_CARD);
        this.cbAddAnElectronicBusinessCard.addItemListener(this.itemListener);
        this.cbAddAnElectronicBusinessCard.addItemListener(currentItemListener);
        this.rbGenerateFromSystemAddressBox = new OrientableRadioButton(StringResources.GENERATE_FROM_SYSTEM_ADDRESS_BOX);
        this.rbGenerateFromSystemAddressBox.addItemListener(this.itemListener);
        this.rbGenerateFromSystemAddressBox.addItemListener(currentItemListener);
        this.rbSelectAVCardFile = new OrientableRadioButton(StringResources.SELECT_A_VCARD_FILE);
        this.rbSelectAVCardFile.addItemListener(this.itemListener);
        this.rbSelectAVCardFile.addItemListener(currentItemListener);
        this.rbSelectFromPersonlaAddressBook = new OrientableRadioButton(StringResources.SELECT_FROM_PERSONAL_ADDRESS_BOOK);
        this.rbSelectFromPersonlaAddressBook.addItemListener(this.itemListener);
        this.rbSelectFromPersonlaAddressBook.addItemListener(currentItemListener);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbGenerateFromSystemAddressBox);
        buttonGroup.add(this.rbSelectAVCardFile);
        buttonGroup.add(this.rbSelectFromPersonlaAddressBook);
        this.tfSearchAddress = new SearchTextField();
        this.tfSearchAddress.setBorder(BorderFactory.createLoweredBevelBorder());
        this.tfSearchAddress.getDocument().addDocumentListener(new AbstractOptionPanel.CustomDocumentListener(this.changesListener));
        this.tfPath = new GWTextField();
        this.tfPath.setBorder(BorderFactory.createLoweredBevelBorder());
        this.tfPath.getDocument().addDocumentListener(new AbstractOptionPanel.CustomDocumentListener(this.changesListener));
        this.btnSelectFolder = new ToolBarButton(new SelectFolderAction());
    }

    protected void build() {
        this.init();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 3;
        constraints.anchor = 21;
        constraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)this.cbAddAnElectronicBusinessCard, constraints);
        ++constraints.gridy;
        constraints.insets.left = 30;
        this.add((Component)this.rbGenerateFromSystemAddressBox, constraints);
        constraints.gridwidth = 1;
        ++constraints.gridy;
        this.add((Component)this.rbSelectFromPersonlaAddressBook, constraints);
        ++constraints.gridy;
        this.add((Component)this.rbSelectAVCardFile, constraints);
        ++constraints.gridx;
        constraints.gridy = 2;
        constraints.weightx = 1.0;
        constraints.insets.left = 10;
        constraints.fill = 2;
        this.add((Component)this.tfSearchAddress, constraints);
        ++constraints.gridy;
        this.add((Component)this.tfPath, constraints);
        ++constraints.gridx;
        constraints.weightx = 0.0;
        constraints.fill = 0;
        constraints.insets.left = 0;
        constraints.insets.right = 20;
        this.add((Component)this.btnSelectFolder, constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        constraints.gridwidth = 3;
        constraints.weighty = 1.0;
        this.add((Component)new JPanel(), constraints);
    }

    public void collectValues() {
        AccountSettings accountSettings = EngineCommandManager.getAccountSettings();
        accountSettings.setAddvCard(this.cbAddAnElectronicBusinessCard.isSelected());
        if (this.rbGenerateFromSystemAddressBox.isSelected()) {
            accountSettings.setvCardSource(2);
        } else if (this.rbSelectAVCardFile.isSelected()) {
            accountSettings.setvCardSource(1);
        } else if (this.rbSelectFromPersonlaAddressBook.isSelected()) {
            accountSettings.setvCardSource(3);
        }
        accountSettings.setvCardRecId(this.tfSearchAddress.getText());
        accountSettings.setvCardFilename(this.tfPath.getText());
    }

    public void fireOptionsChanged() {
        AccountSettings accountSettings = EngineCommandManager.getAccountSettings();
        this.cbAddAnElectronicBusinessCard.setSelected(accountSettings.getAddvCard());
        int value = accountSettings.getvCardSource();
        if (value == 1) {
            this.rbSelectAVCardFile.setSelected(true);
        } else if (value == 3) {
            this.rbSelectFromPersonlaAddressBook.setSelected(true);
        }
        if (value == 2) {
            this.rbGenerateFromSystemAddressBox.setSelected(true);
        }
        this.tfPath.setText(accountSettings.getvCardFilename());
        this.tfSearchAddress.setText(accountSettings.getvCardRecId());
    }

    public void setOptions(AbstractCloneObject theAbstractOptions) throws IllegalArgumentException {
    }

    private class CurrentItemListener
    implements ItemListener {
        private CurrentItemListener() {
        }

        private void setEnableAdressSelect(boolean enabled) {
            VCardOptionsPanel.this.tfSearchAddress.setEnabled(enabled);
            VCardOptionsPanel.this.tfSearchAddress.setOpaque(enabled);
        }

        private void setEnableVCardSelect(boolean enabled) {
            VCardOptionsPanel.this.tfPath.setEnabled(enabled);
            VCardOptionsPanel.this.tfPath.setOpaque(enabled);
            VCardOptionsPanel.this.btnSelectFolder.setEnabled(enabled);
        }

        public void itemStateChanged(ItemEvent e) {
            boolean isSelectedBusinessCard = VCardOptionsPanel.this.cbAddAnElectronicBusinessCard.isSelected();
            VCardOptionsPanel.this.rbGenerateFromSystemAddressBox.setEnabled(isSelectedBusinessCard);
            VCardOptionsPanel.this.rbSelectAVCardFile.setEnabled(isSelectedBusinessCard);
            VCardOptionsPanel.this.rbSelectFromPersonlaAddressBook.setEnabled(isSelectedBusinessCard);
            if (isSelectedBusinessCard) {
                if (VCardOptionsPanel.this.rbGenerateFromSystemAddressBox.isSelected()) {
                    this.setEnableAdressSelect(false);
                    this.setEnableVCardSelect(false);
                } else {
                    this.setEnableAdressSelect(VCardOptionsPanel.this.rbSelectFromPersonlaAddressBook.isSelected());
                    this.setEnableVCardSelect(VCardOptionsPanel.this.rbSelectAVCardFile.isSelected());
                }
            } else {
                this.setEnableAdressSelect(false);
                this.setEnableVCardSelect(false);
            }
        }
    }

    private class SelectFolderAction
    extends AbstractAction {
        public SelectFolderAction() {
            super("", ImageResources.ICON_FOLDER);
        }

        public void actionPerformed(ActionEvent e) {
            if (OS.isMacOS()) {
                File f;
                boolean isOK;
                String dialogCaption = StringResources.SELECT_DIRECTORY;
                System.setProperty("apple.awt.fileDialogForDirectories", "true");
                Frame frame = ControlsUtils.getFrameForComponent(VCardOptionsPanel.this);
                if (frame == null) {
                    return;
                }
                GWMacFileChooser fileChoser = new GWMacFileChooser(frame, dialogCaption, null, 0);
                fileChoser.setVisible(true);
                String selectedFile = fileChoser.getFile();
                String selecteddirectory = fileChoser.getDirectory();
                if (selectedFile != null && (isOK = (f = new File(selecteddirectory + selectedFile)).isDirectory())) {
                    VCardOptionsPanel.this.tfPath.setText(f.getPath());
                }
            } else {
                GWFileChooser fileChooser = new GWFileChooser((Dialog)SwingUtilities.getWindowAncestor(VCardOptionsPanel.this), StringResources.OPEN, null, 1, 0, false);
                fileChooser.setVisible(true);
                String[] fileNames = fileChooser.getResult();
                if (fileNames != null) {
                    File selectedFile = fileChooser.getChooser().getSelectedFile();
                    VCardOptionsPanel.this.tfPath.setText(selectedFile.getPath());
                }
            }
        }
    }
}

