/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.send.signatures;

import com.appframework.components.htmleditor.DirtyStateManager;
import com.appframework.components.htmleditor.HTMLTextEditor;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.controls.filechoser.OptionChangesListener;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableList;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.frames.options.compose.AbstractOptionPanel;
import com.novell.gw.jclient.application.frames.options.compose.send.SendOptionsPane;
import com.novell.gw.jclient.application.frames.options.compose.send.signatures.SignatureListModel;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.options.AbstractCloneObject;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class SignatureOptionsPanel
extends AbstractOptionPanel {
    private Logger logger = Logger.getLogger(SendOptionsPane.class);
    private JRadioButton rbDontAddSignature;
    private JRadioButton rbPromptBeforeAdding;
    private JRadioButton rbAutomaticallyAddSignature;
    private JList lstSignatureName;
    private SignatureListModel listModel;
    private JButton btnNew;
    private JButton btnDelete;
    private JButton btnRename;
    private JButton btnDefault;
    private HTMLTextEditor htmlTextEditor;
    private int selectedRow = 0;
    private boolean blnTextEdited = false;
    private String signature;

    public SignatureOptionsPanel(OptionChangesListener theChangesListener, MVCController theParentController) {
        super(theChangesListener, theParentController);
    }

    private void init() {
        this.listModel = new SignatureListModel();
        this.lstSignatureName = new CurrentList(this.listModel);
        this.rbAutomaticallyAddSignature = new JRadioButton(StringResources.AUTOMATICALLY_ADD_SIGNATURE);
        this.rbAutomaticallyAddSignature.addItemListener(this.itemListener);
        this.rbPromptBeforeAdding = new JRadioButton(StringResources.PROMPT_BEFORE_ADDING_SIGNATURE);
        this.rbPromptBeforeAdding.addItemListener(this.itemListener);
        this.rbDontAddSignature = new JRadioButton(StringResources.DONT_ADD_SIGNATURE);
        this.rbDontAddSignature.addItemListener(this.itemListener);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbAutomaticallyAddSignature);
        buttonGroup.add(this.rbDontAddSignature);
        buttonGroup.add(this.rbPromptBeforeAdding);
        this.btnDefault = new WideButton(new ActionDefault());
        this.btnDelete = new WideButton(new ActionDelete());
        this.btnNew = new WideButton(new ActionNew());
        this.btnRename = new WideButton(new ActionRename());
        DirtyStateManager dirtyStateManager = new DirtyStateManager(this.controller);
        this.htmlTextEditor = new HTMLTextEditor(1, dirtyStateManager);
        this.htmlTextEditor.showHeaderPanel(true);
        this.htmlTextEditor.setEnableShortCuts(true);
        this.htmlTextEditor.setPreferredSize(new Dimension(1, 20));
        this.htmlTextEditor.setDragEnabled(true);
        this.htmlTextEditor.getHTMLTextPane().addFocusListener(new HTMLEditorFocusListener());
        this.lstSignatureName.clearSelection();
    }

    private void setText() {
        if (this.blnTextEdited) {
            this.listModel.setText(this.signature, this.htmlTextEditor.getStyledText());
            this.blnTextEdited = false;
        }
    }

    private void updateSelection() {
        boolean isSelected;
        this.setText();
        this.btnDefault.setEnabled(true);
        boolean bl = isSelected = !this.lstSignatureName.isSelectionEmpty();
        if (this.listModel.getSize() == 0) {
            isSelected = false;
        }
        if (isSelected) {
            int selectedRow = this.selectedRow >= this.listModel.getSize() ? this.selectedRow - 1 : this.selectedRow;
            this.lstSignatureName.setSelectedIndex(selectedRow);
            this.logger.debug((Object)"getting text");
            this.htmlTextEditor.setStyledText(this.listModel.getText(selectedRow));
        } else {
            this.htmlTextEditor.setStyledText("");
        }
        boolean isDefault = false;
        String defaultSignature = this.listModel.getDefaultSignature();
        if (defaultSignature != null) {
            isDefault = defaultSignature.equals(this.listModel.getElementAt(this.selectedRow));
        }
        this.btnDefault.setEnabled(isSelected && !isDefault);
        this.htmlTextEditor.setEnabled(isSelected);
        this.btnDelete.setEnabled(isSelected);
        this.btnRename.setEnabled(isSelected);
        this.changesListener.setValueChanged();
    }

    public void collectValues() {
    }

    public void fireOptionsChanged() {
    }

    public void setOptions(AbstractCloneObject theAbstractOptions) throws IllegalArgumentException {
    }

    protected void build() {
        this.init();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 23;
        constraints.fill = 2;
        this.add((Component)this.createRadioButtonsPanel(), constraints);
        ++constraints.gridy;
        this.add((Component)this.createListPanel(), constraints);
        ++constraints.gridy;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        this.add((Component)this.createViewerPanel(), constraints);
    }

    private JPanel createRadioButtonsPanel() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(5, 10, 0, 0);
        constraints.anchor = 23;
        panel.add((Component)this.rbDontAddSignature, constraints);
        ++constraints.gridy;
        panel.add((Component)this.rbPromptBeforeAdding, constraints);
        ++constraints.gridy;
        constraints.insets.bottom = 5;
        panel.add((Component)this.rbAutomaticallyAddSignature, constraints);
        return panel;
    }

    private JPanel createListPanel() {
        OrientablePanel panel = new OrientablePanel(new GridLayout());
        OrientablePanel leftPanel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(10, 10, 0, 0);
        constraints.anchor = 23;
        leftPanel.add((Component)new OrientableLabel(StringResources.SIGNATURE_NAME_C), constraints);
        ++constraints.gridy;
        constraints.gridheight = 4;
        constraints.insets.top = 5;
        constraints.fill = 1;
        leftPanel.add((Component)new OrientableScrollPane(this.lstSignatureName), constraints);
        ++constraints.gridx;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.fill = 2;
        leftPanel.add((Component)this.btnNew, constraints);
        ++constraints.gridy;
        leftPanel.add((Component)this.btnDelete, constraints);
        ++constraints.gridy;
        leftPanel.add((Component)this.btnRename, constraints);
        ++constraints.gridy;
        leftPanel.add((Component)this.btnDefault, constraints);
        JPanel rightPanel = new JPanel();
        panel.add(leftPanel);
        panel.add(rightPanel);
        return panel;
    }

    private JPanel createViewerPanel() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets.top = 10;
        panel.add((Component)this.htmlTextEditor, constraints);
        return panel;
    }

    private class HTMLEditorFocusListener
    implements FocusListener {
        private HTMLEditorFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            SignatureOptionsPanel.this.signature = (String)SignatureOptionsPanel.this.lstSignatureName.getSelectedValue();
            SignatureOptionsPanel.this.blnTextEdited = true;
        }

        public void focusLost(FocusEvent e) {
            SignatureOptionsPanel.this.setText();
        }
    }

    private class CurrentList
    extends OrientableList {
        public CurrentList(ListModel dataModel) {
            super(dataModel);
            this.setSelectionMode(0);
            this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    ListSelectionModel listSelectionModel = (ListSelectionModel)e.getSource();
                    int selectedRow = listSelectionModel.getLeadSelectionIndex();
                    if (selectedRow != -1) {
                        SignatureOptionsPanel.this.selectedRow = selectedRow;
                    }
                    SignatureOptionsPanel.this.updateSelection();
                }
            });
        }
    }

    private class ActionRename
    extends AbstractAction {
        public ActionRename() {
            super(StringResources.RENAME);
        }

        public void actionPerformed(ActionEvent e) {
            String oldName = (String)SignatureOptionsPanel.this.lstSignatureName.getSelectedValue();
            String newName = (String)JOptionPane.showInputDialog((Component)e.getSource(), StringResources.RENAME_SIGNATURE_NAME_AS_C, StringResources.RENAME_SIGNATURE_NAME, -1, null, null, oldName);
            if (newName != null && !newName.equals(oldName)) {
                SignatureOptionsPanel.this.listModel.renameSignature(oldName, newName);
                SignatureOptionsPanel.this.updateSelection();
            }
        }
    }

    private class ActionDefault
    extends AbstractAction {
        public ActionDefault() {
            super(StringResources.DEFAULT);
        }

        public void actionPerformed(ActionEvent e) {
            SignatureOptionsPanel.this.listModel.setDefaultSignature((String)SignatureOptionsPanel.this.lstSignatureName.getSelectedValue());
            ((AbstractButton)e.getSource()).setEnabled(false);
        }
    }

    private class ActionDelete
    extends AbstractAction {
        public ActionDelete() {
            super(StringResources.DELETE);
        }

        public void actionPerformed(ActionEvent e) {
            String name = (String)SignatureOptionsPanel.this.lstSignatureName.getSelectedValue();
            SignatureOptionsPanel.this.listModel.removeSignature(name);
            SignatureOptionsPanel.this.updateSelection();
        }
    }

    private class ActionNew
    extends AbstractAction {
        public ActionNew() {
            super(StringResources.NEW);
        }

        public void actionPerformed(ActionEvent e) {
            String name = (String)JOptionPane.showInputDialog((Component)e.getSource(), StringResources.SIGNATURE_NAME_C, StringResources.NEW_SIGNATURE_NAME, -1, null, null, null);
            if (name != null) {
                if (SignatureOptionsPanel.this.listModel.containsSignature(name)) {
                    JOptionPane.showMessageDialog((Component)e.getSource(), StringResources.THE_SIGNATURE_NAME_YOU_ENTERED_ALREADY_EXISTS, StringResources.SIGNATURE_NAME, 2);
                } else {
                    SignatureOptionsPanel.this.listModel.addItem(name);
                    SignatureOptionsPanel.this.updateSelection();
                }
            }
        }
    }

    private class WideButton
    extends OrientableButton {
        public WideButton(Action a) {
            super(a);
            this.setMargin(new Insets(0, 20, 0, 20));
        }

        public WideButton(String text) {
            super(text);
        }
    }
}

