/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.search;

import com.appframework.AppAction;
import com.appframework.ApplicationFrameActionList;
import com.appframework.Category;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.actions.ActionDisplayFolderOrItemProperties;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.ActionModifyFind;
import com.novell.gw.jclient.application.actions.ActionQuickViewer;
import com.novell.gw.jclient.application.actions.ActionQuickViewerAtBottom;
import com.novell.gw.jclient.application.actions.ActionQuickViewerAtRight;
import com.novell.gw.jclient.application.actions.ActionStartQueryFolder;
import com.novell.gw.jclient.application.actions.ActionStopQueryFolder;
import com.novell.gw.jclient.application.actions.ActionSwitchAttachmentWindow;
import com.novell.gw.jclient.application.actions.ActionSwitchQVToolbar;
import com.novell.gw.jclient.application.actions.filter.ActionAllCategories;
import com.novell.gw.jclient.application.actions.filter.ActionClearFilter;
import com.novell.gw.jclient.application.actions.filter.ActionContextItemFilter;
import com.novell.gw.jclient.application.actions.filter.ActionCreateItemsFilter;
import com.novell.gw.jclient.application.actions.filter.ActionDraftedItemsFilter;
import com.novell.gw.jclient.application.actions.filter.ActionFilterItemsWithAttachments;
import com.novell.gw.jclient.application.actions.filter.ActionMoreCategoriesFilter;
import com.novell.gw.jclient.application.actions.filter.ActionMoreFilter;
import com.novell.gw.jclient.application.actions.filter.ActionPostedItemsFilter;
import com.novell.gw.jclient.application.actions.filter.ActionReceivedItemsFilter;
import com.novell.gw.jclient.application.actions.filter.ActionSentItemsFilter;
import com.novell.gw.jclient.application.actions.folder.ActionCustomizePanels;
import com.novell.gw.jclient.application.actions.folder.ActionFolderPropertiesLight;
import com.novell.gw.jclient.application.controls.header.actions.ActionChangeHeaderColor;
import com.novell.gw.jclient.application.controls.header.actions.ActionChangeHeaderFontSize;
import com.novell.gw.jclient.application.controls.header.actions.ActionChangeHeaderTextColor;
import com.novell.gw.jclient.application.controls.header.actions.ActionResetHeaderToDefault;
import com.novell.gw.jclient.application.frames.search.FrameItemSearch;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.filter.Filter;
import com.novell.gw.jclient.bl.om.folders.QueryFolder;
import com.novell.gw.jclient.bl.om.options.QuickViewerOptions;
import java.awt.event.ActionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameItemSearchActionList
extends ApplicationFrameActionList<FrameItemSearch> {
    private QuickViewerOptions options = OptionManager.getInstance().getQuickViewerOptions();

    public FrameItemSearchActionList(FrameItemSearch view, MVCController parentController) {
        super(view, parentController);
        this.createActions();
        this.createCategories();
    }

    private void createCategories() {
        Category category = new Category(StringResources.FILE);
        category.addAction(ActionKey.NEW_MAIL);
        category.addAction(ActionKey.NEW_APPOINTMENT);
        category.addAction(ActionKey.NEW_TASK);
        category.addAction(ActionKey.NEW_REMINDERNOTE);
        category.addAction(ActionKey.NEW_POSTED_MAIL);
        category.addAction(ActionKey.NEW_PHONEMESSAGE);
        category.addAction(ActionKey.NEW_CONTACT);
        category.addAction(ActionKey.NEW_RESOURCE);
        category.addAction(ActionKey.NEW_ORGANIZATION);
        category.addAction(ActionKey.NEW_GROUP);
        category.addAction(ActionKey.SAVE_GWITEM);
        category.addAction(ActionKey.PRINT);
        category.addAction(ActionKey.CANCEL_FRAME);
        this.categories.add(category);
        category = new Category(StringResources.EDIT);
        category.addAction(ActionKey.CUT);
        category.addAction(ActionKey.COPY);
        category.addAction(ActionKey.PASTE);
        category.addAction(ActionKey.DELETE_ITEM);
        category.addAction(ActionKey.SELECT_ALL);
        category.addAction(ActionKey.FIND_TEXT);
        category.addAction(ActionKey.FIND_NEXT);
        category.addAction(ActionKey.FIND_PREVIOUS);
        category.addAction(ActionKey.CHANGE_ITEM_TO);
        this.categories.add(category);
        category = new Category(StringResources.VIEW);
        category.addAction(ActionKey.QUICKVIEWER);
        category.addAction(ActionKey.PLAIN_TEXT);
        category.addAction(ActionKey.HTML_TEXT);
        this.categories.add(category);
        category = new Category(StringResources.ACTIONS);
        category.addAction(ActionKey.REPLY);
        category.addAction(ActionKey.MARK_PRIVATE);
        this.categories.add(category);
        category = new Category(StringResources.TOOLS);
        category.addAction(ActionKey.RULES);
        category.addAction(ActionKey.FIND);
        category.addAction(ActionKey.MODIFY_FIND);
        category.addAction(ActionKey.BUSYSEARCH);
        category.addAction(ActionKey.STOP_QUERY_FOLDER);
        this.categories.add(category);
        this.categories.add(this.createCategoryForWindowMenu());
        category = new Category(StringResources.HELP);
        category.addAction(ActionKey.HELPTOPICS);
        category.addAction(ActionKey.ABOUT);
        this.categories.add(category);
    }

    private void createActions() {
        this.addAction(new ActionContextItemFilter(this));
        this.addAction(new ActionCreateItemsFilter(this));
        this.addAction(new ActionClearFilter(this));
        this.addAction(new ActionMoreCategoriesFilter(this));
        this.addAction(new ActionReceivedItemsFilter(this));
        this.addAction(new ActionSentItemsFilter(this));
        this.addAction(new ActionPostedItemsFilter(this));
        this.addAction(new ActionDraftedItemsFilter(this));
        this.addAction(new ActionFilterItemsWithAttachments(this));
        this.addAction(new ActionMoreFilter(this));
        ActionQuickViewer action = new ActionQuickViewer(this){

            protected boolean isQuickViewerVisible() {
                return FrameItemSearchActionList.this.options.isQuickViewerEnabled();
            }

            protected void performAction(ActionEvent e) {
                FrameItemSearchActionList.this.options.setQuickViewerEnabled(!this.isQuickViewerVisible());
                this.buttons.setSelected(this.isQuickViewerVisible());
                FrameItemSearchActionList.this.updateQuickViewer();
            }
        };
        this.addAction(action);
        this.addAction(new ActionQuickViewerAtBottom(this){

            protected void performAction(ActionEvent e) {
                FrameItemSearchActionList.this.options.setRightPosition(false);
                this.setEnabled(false);
                AppAction action = FrameItemSearchActionList.this.getAction(ActionKey.QUICKVIEWER_AT_RIGHT);
                action.setEnabled(true);
                action.setSelected(false);
                FrameItemSearchActionList.this.updateQuickViewer();
            }

            protected void setSelected() {
                this.setSelected(!FrameItemSearchActionList.this.options.isRightPosition());
            }
        });
        this.addAction(new ActionQuickViewerAtRight(this){

            protected void performAction(ActionEvent e) {
                FrameItemSearchActionList.this.options.setRightPosition(true);
                this.setEnabled(false);
                AppAction action = FrameItemSearchActionList.this.getAction(ActionKey.QUICKVIEWER_AT_BOTTOM);
                action.setEnabled(true);
                action.setSelected(false);
                FrameItemSearchActionList.this.updateQuickViewer();
            }

            protected void setSelected() {
                this.setSelected(FrameItemSearchActionList.this.options.isRightPosition());
            }
        });
        this.addAction(new ActionSwitchQVToolbar(this){

            protected void setSelected() {
                this.menuItem.setSelected(FrameItemSearchActionList.this.options.isShowQVToolbar());
            }

            protected boolean isQuickViewerVisible() {
                return true;
            }

            protected void performAction(ActionEvent e) {
                FrameItemSearchActionList.this.options.setShowQVToolbar(!FrameItemSearchActionList.this.options.isShowQVToolbar());
                this.setSelected();
                FrameItemSearchActionList.this.saveOptions();
                this.getActionList().processCommand(new Command(900));
            }
        });
        this.addAction(new ActionSwitchAttachmentWindow(this){

            protected void setSelected() {
                boolean isSelected = FrameItemSearchActionList.this.options.isShowAttachmentPanel();
                this.buttons.setSelected(isSelected);
            }

            protected void performAction(ActionEvent e) {
                FrameItemSearchActionList.this.options.setShowAttachmentPanel(!FrameItemSearchActionList.this.options.isShowAttachmentPanel());
                this.setSelected();
                FrameItemSearchActionList.this.saveOptions();
                FrameItemSearchActionList.this.processCommand(new Command(890));
            }
        });
        this.addAction(new ActionStartQueryFolder(this));
        this.addAction(new ActionStopQueryFolder(this));
        this.addAction(new ActionChangeHeaderColor(this));
        this.addAction(new ActionChangeHeaderTextColor(this));
        this.addAction(new ActionChangeHeaderFontSize(this));
        this.addAction(new ActionResetHeaderToDefault(this));
        this.addAction(new ActionDisplayFolderOrItemProperties(this));
        this.addAction(new ActionFolderPropertiesLight(this));
        this.addAction(new ActionCustomizePanels(this));
        this.addAction(new ActionModifyFind(this));
        this.addAction(new ActionAllCategories(this));
    }

    @Override
    protected void initListeners() {
        super.initListeners();
        Level level = this.getFrameLevel();
        AppEventListener listener = new FILTER_CHANGED_Listener();
        AppEventListenerDescriptor descriptor = new AppEventListenerDescriptor(level, 400, listener);
        this.addListenerDescriptor(descriptor);
        listener = new REFRESH_QUERY_FOLDER_STARTED_Listener();
        descriptor = new AppEventListenerDescriptor(level, 660, listener);
        this.addListenerDescriptor(descriptor);
        listener = new REFRESH_QUERY_FOLDER_STOPPED_Listener();
        descriptor = new AppEventListenerDescriptor(level, 650, listener);
        this.addListenerDescriptor(descriptor);
        listener = new REFRESH_QUERY_FOLDER_FINISHED_Listener();
        descriptor = new AppEventListenerDescriptor(level, 670, listener);
        this.addListenerDescriptor(descriptor);
        listener = new FOLDER_SETTINGS_CHANGED_Listener();
        descriptor = new AppEventListenerDescriptor(level, 1210, listener);
        this.addListenerDescriptor(descriptor);
    }

    private void updateQuickViewer() {
        ((FrameItemSearch)this.getMVCView()).updateQuickViewer(this.options);
        this.saveOptions();
    }

    boolean isQuickViewerVisible() {
        return this.options.isQuickViewerEnabled();
    }

    private void saveOptions() {
        OptionManager.getInstance().setQuickViewerOptions(this.options);
    }

    private class FOLDER_SETTINGS_CHANGED_Listener
    extends AppEventListener {
        private FOLDER_SETTINGS_CHANGED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            if (theEvent.getData() instanceof QueryFolder) {
                ((FrameItemSearch)FrameItemSearchActionList.this.getMVCView()).refreshTable();
            }
        }
    }

    private class REFRESH_QUERY_FOLDER_FINISHED_Listener
    extends AppEventListener {
        private REFRESH_QUERY_FOLDER_FINISHED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            ((FrameItemSearch)FrameItemSearchActionList.this.getMVCView()).refreshQueryStatus(false);
        }
    }

    private class REFRESH_QUERY_FOLDER_STOPPED_Listener
    extends AppEventListener {
        private REFRESH_QUERY_FOLDER_STOPPED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            ((FrameItemSearch)FrameItemSearchActionList.this.getMVCView()).refreshQueryStatus(false);
        }
    }

    private class REFRESH_QUERY_FOLDER_STARTED_Listener
    extends AppEventListener {
        private REFRESH_QUERY_FOLDER_STARTED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            ((FrameItemSearch)FrameItemSearchActionList.this.getMVCView()).refreshQueryStatus(true);
        }
    }

    private class FILTER_CHANGED_Listener
    extends AppEventListener {
        private FILTER_CHANGED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            FrameItemSearch frame = (FrameItemSearch)FrameItemSearchActionList.this.getMVCView();
            if (theEvent.getData() == null || theEvent.getData() instanceof Filter) {
                Filter filter = (Filter)theEvent.getData();
                frame.setFilter(filter);
            }
        }
    }
}

