/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.impl;

import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.application.interfaces.ISelectedContactsInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectedContactsInfoImpl
implements ISelectedContactsInfo {
    private static Logger logger = Logger.getLogger(SelectedContactsInfoImpl.class);
    private IItemList itemList;
    private List<IContact> contacts;
    private List<IAddressable> addressables;

    private SelectedContactsInfoImpl(IItemList itemList) {
        this.itemList = itemList;
    }

    public SelectedContactsInfoImpl(IItemList itemList, List<IAddressable> addressables) {
        this(itemList);
        if (addressables == null) {
            throw new IllegalArgumentException();
        }
        this.addressables = addressables;
        this.contacts = SelectedContactsInfoImpl.getContacts(addressables);
    }

    public SelectedContactsInfoImpl(IItemList itemList, IAddressable iAddressable) {
        this(itemList);
        if (iAddressable == null) {
            throw new IllegalArgumentException();
        }
        this.addressables = new ArrayList<IAddressable>();
        this.addressables.add(iAddressable);
        this.contacts = SelectedContactsInfoImpl.getContacts(this.addressables);
    }

    @Override
    public List<IContact> getContacts() {
        if (!this.hasContacts()) {
            throw new IllegalStateException("No Contacts");
        }
        return this.contacts;
    }

    @Override
    public List<IAddressable> getAddressables() {
        if (!this.hasAddressables()) {
            throw new IllegalStateException("No Addressables");
        }
        return this.addressables;
    }

    @Override
    public IContact getContact() {
        if (!this.hasContacts()) {
            throw new IllegalStateException("No Contacts");
        }
        return this.contacts.get(0);
    }

    @Override
    public IItemList getItemList() {
        return this.itemList;
    }

    @Override
    public boolean hasContacts() {
        return this.contacts != null && !this.contacts.isEmpty();
    }

    @Override
    public boolean hasAddressables() {
        return this.addressables != null && !this.addressables.isEmpty();
    }

    @Override
    public boolean hasItemList() {
        return this.itemList != null;
    }

    public static List<IContact> getContacts(List<IAddressable> addressables) {
        ArrayList<IContact> contacts = new ArrayList<IContact>();
        for (IAddressable addressable : addressables) {
            if (!(addressable instanceof IContact)) continue;
            contacts.add((IContact)addressable);
        }
        return contacts;
    }
}

