/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.impl;

import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.application.interfaces.ISelectedItemsInfo;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectedItemsInfoImpl
implements ISelectedItemsInfo {
    private IItemList itemList;
    private List<AbstractItem> items;
    private List<AbstractFolder> folders;

    private SelectedItemsInfoImpl(IItemList itemList) {
        this.itemList = itemList;
    }

    public SelectedItemsInfoImpl(IItemList itemList, List<AbstractItem> items, List<AbstractFolder> folders) {
        this(itemList);
        this.items = items;
        this.folders = folders;
    }

    public SelectedItemsInfoImpl(IItemList itemList, AbstractItem item) {
        this(itemList);
        if (item == null) {
            throw new IllegalArgumentException("Item should not be NULL");
        }
        this.items = new ArrayList<AbstractItem>();
        this.items.add(item);
    }

    public SelectedItemsInfoImpl(IItemList itemList, AbstractFolder folder) {
        this(itemList);
        if (folder == null) {
            throw new IllegalArgumentException("Folder should not be NULL");
        }
        this.folders = new ArrayList<AbstractFolder>();
        this.folders.add(folder);
    }

    @Override
    public List<AbstractItem> getItems() {
        if (!this.hasItems()) {
            throw new IllegalStateException("No Items");
        }
        return this.items;
    }

    @Override
    public AbstractItem getItem() {
        if (!this.hasItems()) {
            throw new IllegalStateException("No Items");
        }
        return this.items.get(0);
    }

    @Override
    public List<AbstractFolder> getFolders() {
        if (!this.hasFolders()) {
            throw new IllegalStateException("No Folders");
        }
        return this.folders;
    }

    @Override
    public AbstractFolder getFolder() {
        if (!this.hasFolders()) {
            throw new IllegalStateException("No Folders");
        }
        return this.folders.get(0);
    }

    @Override
    public IItemList getItemList() {
        return this.itemList;
    }

    @Override
    public boolean hasItemList() {
        return this.itemList != null;
    }

    @Override
    public boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public boolean hasFolders() {
        return this.folders != null && !this.folders.isEmpty();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.hasItemList()) {
            builder.append("\nItemList: ");
            builder.append(this.getItemList().toString());
        }
        if (this.hasItems()) {
            builder.append("\nItems:");
            for (AbstractItem item : this.getItems()) {
                builder.append("\n>>--  ");
                builder.append(item);
            }
        }
        if (this.hasFolders()) {
            builder.append("\nFolders:");
            for (AbstractFolder folder : this.getFolders()) {
                builder.append("\n>>--  ");
                builder.append(folder);
            }
        }
        return builder.toString();
    }
}

