/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.notify;

import com.appframework.Application;
import com.appframework.event.DeadObjectMethodAccessException;
import com.appframework.event.ICanDie;
import com.appframework.utils.OS;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.controls.IconedDialog;
import com.novell.gw.jclient.application.notify.AudioPlayer;
import com.novell.gw.jclient.application.notify.NotifyActionList;
import com.novell.gw.jclient.application.notify.ProcessingNotification;
import com.novell.gw.jclient.application.notify.dialogs.NotificationDialog;
import com.novell.gw.jclient.application.resources.SoundResources;
import com.novell.gw.jclient.bl.om.items.NotificationItem;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class NotificationProcessor
implements ICanDie {
    private static Logger logger = Logger.getLogger(NotificationProcessor.class);
    private boolean alive = true;
    private final Queue<NotificationItem> queue = new LinkedBlockingQueue<NotificationItem>();
    private ProcessingNotification processingNotification = null;
    private AudioPlayerHandler audioPlayerHandler;

    NotificationProcessor() {
    }

    synchronized void offer(NotificationItem item) {
        if (this.isDead()) {
            throw new DeadObjectMethodAccessException();
        }
        boolean result = this.queue.offer(item);
        assert (result) : "failed to offer " + item;
        logger.debug((Object)("added item: " + item + " (queue size: " + this.queue.size() + ')'));
        this.tryProcessNotification();
    }

    synchronized void updatePricessingNotificationStatus(NotificationItem item, Boolean dialogClosedByUser, Boolean soundPlayed) {
        if (this.isDead()) {
            throw new DeadObjectMethodAccessException();
        }
        assert (this.processingNotification != null);
        assert (this.processingNotification.getItem() == item);
        logger.debug((Object)("updating status, dialogClosedByUser: " + dialogClosedByUser + ", soundPlayed: " + soundPlayed));
        if (soundPlayed == Boolean.TRUE) {
            this.processingNotification.setSoundPlaying(false);
        }
        if (dialogClosedByUser != null) {
            this.processingNotification.setDialogStatus(dialogClosedByUser != false ? ProcessingNotification.DialogStatus.CLOSED_BY_USER : ProcessingNotification.DialogStatus.CLOSED_BY_TIMEOUT);
            if (dialogClosedByUser.booleanValue() && this.processingNotification.isSoundPlaying()) {
                this.audioPlayerHandler.terminate();
                return;
            }
        }
        this.tryProcessNotification();
    }

    synchronized void clear() {
        if (this.isDead()) {
            throw new DeadObjectMethodAccessException();
        }
        this.queue.clear();
        logger.debug((Object)"queue cleared");
    }

    public synchronized void die() {
        if (this.isDead()) {
            throw new DeadObjectMethodAccessException();
        }
        logger.debug((Object)"disposing...");
        this.queue.clear();
        if (this.audioPlayerHandler != null) {
            this.audioPlayerHandler.terminate();
        }
        this.processingNotification = null;
        this.alive = false;
        logger.debug((Object)"... disposed");
    }

    public boolean isDead() {
        return !this.alive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryProcessNotification() {
        if (this.alive) {
            NotificationProcessor notificationProcessor = this;
            synchronized (notificationProcessor) {
                logger.debug((Object)("this.processingNotification: " + this.processingNotification + " (queue size: " + this.queue.size() + ')'));
                if (!this.queue.isEmpty()) {
                    if (this.processingNotification == null || !this.processingNotification.isProcessing()) {
                        logger.debug((Object)"polling next notification");
                        NotificationItem notificationItem = this.queue.poll();
                        try {
                            this.processingNotification = new ProcessingNotification(notificationItem);
                            this.processNotification();
                        }
                        catch (Exception e) {
                            logger.error((Object)("failed to process notification: " + notificationItem));
                            logger.debug((Object)e, (Throwable)e);
                            this.tryProcessNotification();
                        }
                    } else if (this.processingNotification.isEligible()) {
                        logger.debug((Object)"terminating sound");
                        assert (this.audioPlayerHandler != null);
                        this.audioPlayerHandler.terminate();
                    }
                }
            }
        }
    }

    private synchronized void processNotification() {
        assert (this.processingNotification != null);
        logger.debug((Object)"processing... ");
        if (this.processingNotification.isSoundPlaying()) {
            this.audioPlayerHandler = new AudioPlayerHandler(this.processingNotification.getSoundFilePath(), this.processingNotification.getItem());
            this.audioPlayerHandler.start();
        }
        if (this.processingNotification.getDialogStatus() == ProcessingNotification.DialogStatus.SHOWING) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NotificationProcessor.this.showNotificationDialog(NotificationProcessor.this.processingNotification.getItem());
                }
            });
        }
        if (this.processingNotification.isProgramLaunching()) {
            Utils.callExternal(this.processingNotification.getProgramFilePath());
            this.processingNotification.setProgramLaunching(false);
            this.updatePricessingNotificationStatus(this.processingNotification.getItem(), null, null);
        }
        logger.debug((Object)"... processed");
    }

    private void showNotificationDialog(NotificationItem item) {
        assert (item != null);
        JFrame parentFrame = null;
        if (OS.getJavaVersionMajor() == 1 && OS.getJavaVersionMinor() < 6) {
            NotifyActionList actionList = GWClient.getNotifyController().getNotifyActionList();
            parentFrame = OS.getjavaVersionBuild() >= 19 && OS.isMacOS() && GWClient.isGwClientRunning() ? IconedDialog.findFrameToBecomeParent() : (actionList != null ? (JFrame)actionList.getMVCView() : (JFrame)Application.getAllFrames().get(0));
        }
        NotificationDialog dialog = new NotificationDialog(parentFrame, GWClient.getNotifyController(), item);
        dialog.showMe();
    }

    private class AudioPlayerHandler
    extends Thread {
        private String pathToSound;
        private NotificationItem item;
        private AudioPlayer audioPlayer;

        private AudioPlayerHandler(String pathToSound, NotificationItem item) {
            super("NotificationProcessor.AudioplayerStarter");
            this.pathToSound = pathToSound;
            this.item = item;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                logger.debug((Object)"will try to play sound...");
                if (this.pathToSound != null && this.pathToSound.length() > 0) {
                    this.audioPlayer = new AudioPlayer();
                    if ("<BEEP>".equals(this.pathToSound)) {
                        this.audioPlayer.init(SoundResources.getAudioStream("sounds/notify_default.wav"), this.item);
                    } else {
                        this.audioPlayer.init(this.pathToSound, this.item);
                    }
                    if (this.audioPlayer.isReady()) {
                        this.audioPlayer.play();
                    }
                    logger.debug((Object)"... sound played");
                } else {
                    logger.warn((Object)("... incorrect sound: " + this.pathToSound));
                }
            }
            finally {
                if (!NotificationProcessor.this.isDead()) {
                    NotificationProcessor.this.updatePricessingNotificationStatus(this.item, null, true);
                }
            }
        }

        void terminate() {
            if (this.audioPlayer != null) {
                this.audioPlayer.terminate();
            }
        }
    }
}

