/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.notify.actions;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.orientable.MenuItemFactory;
import com.novell.gw.jclient.application.notify.actions.AbstractGroupWiseMenuNotifyAction;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWNotify;
import java.awt.CheckboxMenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;

public class ActionEnableNotifications
extends AbstractGroupWiseMenuNotifyAction
implements ItemListener {
    private JMenuItem menuItem;
    private CheckboxMenuItem checkboxMenuItem;

    public ActionEnableNotifications(ActionList actionList) {
        super(actionList, ActionKey.ENABLE_NOTIFICATIONS, StringResources.ENABLE_NOTIFICATIONS, false);
        this.setType(AppAction.ActionType.CHECKABLE);
        this.setEnabled(true);
        this.menuItem = MenuItemFactory.createCkeckBoxMenuItem(this);
        boolean selected = OptionManager.getInstance().getNotifierOptions().isNotificationEnabled();
        this.menuItem.setSelected(selected);
        this.checkboxMenuItem = new CheckboxMenuItem(this.getName(), selected);
        this.checkboxMenuItem.addItemListener(this);
    }

    protected void performAction(ActionEvent e) {
        boolean selected = ((AbstractButton)e.getSource()).isSelected();
        this.doPerformAction(selected);
    }

    public void itemStateChanged(ItemEvent e) {
        boolean state = e.getStateChange() == 1;
        this.doPerformAction(state);
    }

    private void doPerformAction(boolean newState) {
        if (newState) {
            GWNotify.getInstance().setNotificationsEnabled(true);
            new Thread(new Runnable(){

                public void run() {
                    GWClient client = (GWClient)GWClient.getApplication();
                    GWClient.setNotifyStartedWithClient(true);
                    client.startNotifier(false);
                }
            }).start();
        } else {
            GWClient.exitNotify();
            GWNotify.getInstance().setNotificationsEnabled(false);
        }
    }

    protected void notifyEnablementChanged(boolean notifyEnabled) {
        this.setEnabled(true);
        this.menuItem.setSelected(notifyEnabled);
        this.checkboxMenuItem.setState(notifyEnabled);
    }

    public JMenuItem getMenuItem() {
        return this.menuItem;
    }

    public CheckboxMenuItem getCheckboxMenuItem() {
        return this.checkboxMenuItem;
    }
}

