/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.notify.dialogs.options;

import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableList;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.orientable.OrientableSpinner;
import com.novell.gw.jclient.application.notify.dialogs.options.NotifyOptionsDialog;
import com.novell.gw.jclient.application.notify.dialogs.options.NotifyOptionsDialogTabPane;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.GWNotify;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.AbstractBorder;
import org.apache.log4j.Logger;

public class GeneralPane
extends OrientablePanel
implements NotifyOptionsDialogTabPane {
    private static Logger logger = Logger.getLogger(GeneralPane.class);
    private NotifyOptionsDialog dialog;
    private OrientableList listObservedFolders = new OrientableList();
    private List<AbstractFolder> selectedFolderList;
    private JSpinner spnMinutesSpinner;
    private JSpinner spnSecondsSpinner;

    public GeneralPane(NotifyOptionsDialog dialog) {
        this.dialog = dialog;
    }

    public void buildUI() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel pnlSettings = this.buildTimeSettingsPane();
        this.selectedFolderList = GWNotify.getInstance().getNotifyFolders();
        OrientablePanel pnlFolders = new OrientablePanel();
        pnlFolders.setLayout(new BorderLayout());
        AbstractBorder foldersBorder = BorderFactory.createTitledBorder(StringResources.SELECT_FOLDERS_TO_CHECK_FOR_NOTIFICATIONS);
        foldersBorder = BorderFactory.createCompoundBorder(foldersBorder, BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pnlFolders.setBorder(foldersBorder);
        FolderListModel folderListModel = new FolderListModel();
        this.listObservedFolders.setModel(folderListModel);
        this.listObservedFolders.setSelectionMode(2);
        OrientableScrollPane listScrollPane = new OrientableScrollPane(this.listObservedFolders);
        listScrollPane.setMinimumSize(new Dimension(200, 200));
        listScrollPane.setPreferredSize(new Dimension(250, 300));
        pnlFolders.add((Component)listScrollPane, "Center");
        OrientableButton btnReset = new OrientableButton(new ActionReset());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)pnlSettings, c);
        c.gridy = 1;
        this.add((Component)btnReset, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridheight = 2;
        c.weightx = 0.7;
        c.weighty = 1.0;
        c.insets = new Insets(0, 10, 0, 0);
        c.fill = 1;
        this.add((Component)pnlFolders, c);
    }

    public String getTitle() {
        return StringResources.GENERAL;
    }

    public void applyOptions() {
        int[] selectedFolderIndices = this.listObservedFolders.getSelectedIndices();
        GWNotify.getInstance().setNotifyFolders(((FolderListModel)this.listObservedFolders.getModel()).getFolderList(selectedFolderIndices));
        int period = (Integer)this.spnSecondsSpinner.getModel().getValue();
        GWNotify.getInstance().setNotifyDialogTimeout(period);
        if (!GWNotify.getInstance().isPollIntervalLocked()) {
            period = (Integer)this.spnMinutesSpinner.getModel().getValue();
            GWNotify.getInstance().setPollInterval(period);
        }
    }

    public void init() {
        int[] indices = new int[this.selectedFolderList.size()];
        int nSize = this.selectedFolderList.size();
        FolderListModel model = (FolderListModel)this.listObservedFolders.getModel();
        for (int i = 0; i < nSize; ++i) {
            indices[i] = model.indexOf(this.selectedFolderList.get(i));
        }
        this.listObservedFolders.setSelectedIndices(indices);
    }

    public void resetToDefaults() {
        this.selectedFolderList = GWNotify.getInstance().getDefaultNotifyFolders();
        this.spnMinutesSpinner.getModel().setValue(GWNotify.getInstance().getDefaultPollInterval());
        this.spnSecondsSpinner.getModel().setValue(GWNotify.getInstance().getDefaultNotifyDialogTimeout());
    }

    private JPanel buildTimeSettingsPane() {
        OrientablePanel panel = new OrientablePanel();
        panel.setLayout(new GridBagLayout());
        AbstractBorder border = BorderFactory.createTitledBorder(StringResources.SETTINGS);
        border = BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.setBorder(border);
        OrientableLabel lbCheckForMail = new OrientableLabel(StringResources.CHECK_FOR_MAIL_EVERY);
        OrientableLabel lbMinutes = new OrientableLabel(StringResources.L_MINUTES);
        OrientableLabel lbShowNotifyDialog = new OrientableLabel(StringResources.SHOW_NOTIFY_DIALOG_FOR);
        OrientableLabel lbSeconds = new OrientableLabel(StringResources.L_SECONDS);
        int initValue = GWNotify.getInstance().getPollInterval();
        SpinnerNumberModel minutesModel = new SpinnerNumberModel(initValue, 1, 255, 1);
        this.spnMinutesSpinner = new OrientableSpinner(minutesModel);
        GeneralPane.revertTextAlignment(this.spnMinutesSpinner);
        if (GWNotify.getInstance().isPollIntervalLocked()) {
            this.spnMinutesSpinner.setEnabled(false);
        }
        initValue = GWNotify.getInstance().getNotifyDialogTimeout();
        SpinnerNumberModel secondsModel = new SpinnerNumberModel(initValue, 1, Short.MAX_VALUE, 1);
        this.spnSecondsSpinner = new OrientableSpinner(secondsModel);
        GeneralPane.revertTextAlignment(this.spnSecondsSpinner);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.anchor = 21;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        panel.add((Component)lbCheckForMail, c);
        c.gridy = 1;
        c.gridwidth = 1;
        panel.add((Component)this.spnMinutesSpinner, c);
        c.gridx = 1;
        panel.add((Component)lbMinutes, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        panel.add((Component)lbShowNotifyDialog, c);
        c.gridy = 3;
        c.gridwidth = 1;
        panel.add((Component)this.spnSecondsSpinner, c);
        c.gridx = 1;
        panel.add((Component)lbSeconds, c);
        return panel;
    }

    private static void revertTextAlignment(JSpinner spinner) {
        JComponent editor = spinner.getEditor();
        if (editor instanceof JSpinner.DefaultEditor) {
            JFormattedTextField textField = ((JSpinner.DefaultEditor)editor).getTextField();
            switch (textField.getHorizontalAlignment()) {
                case 2: {
                    textField.setHorizontalAlignment(4);
                    break;
                }
                case 4: {
                    textField.setHorizontalAlignment(2);
                    break;
                }
                case 10: {
                    textField.setHorizontalAlignment(11);
                    break;
                }
                case 11: {
                    textField.setHorizontalAlignment(10);
                }
            }
        }
    }

    private class ActionReset
    extends AbstractAction {
        public ActionReset() {
            super(StringResources.RESET_NOTIFY_DEFAULTS);
        }

        public void actionPerformed(ActionEvent e) {
            GeneralPane.this.dialog.resetNotifyDefaults();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FolderListModel
    extends AbstractListModel {
        private static final String SHIFT = "  ";
        private List<AbstractFolder> folderList = new ArrayList<AbstractFolder>();
        private Map<AbstractFolder, Integer> folderMap = new HashMap<AbstractFolder, Integer>();

        public FolderListModel() {
            this.initModel();
        }

        private void initModel() {
            String userGuid = EngineCommandManager.getUserGuid();
            try {
                int level = 0;
                AbstractFolder rootFolder = GWCommandManager.getInstance(userGuid).getRootFolder();
                this.folderList.add(rootFolder);
                this.folderMap.put(rootFolder, 0);
                this.addSubFolders(rootFolder, level);
            }
            catch (GWCommandException e) {
                logger.error((Object)e);
                logger.debug((Object)e, (Throwable)e);
            }
        }

        private void addSubFolders(AbstractFolder parentFolder, int parentLevel) {
            Iterator<AbstractFolder> iterator = parentFolder.getChildFolders().iterator();
            int currentLevel = parentLevel + 1;
            while (iterator.hasNext()) {
                AbstractFolder folder = iterator.next();
                this.folderList.add(folder);
                this.folderMap.put(folder, currentLevel);
                if (folder.getChildFolders().size() <= 0) continue;
                this.addSubFolders(folder, currentLevel);
            }
        }

        @Override
        public Object getElementAt(int index) {
            if (index < 0 || index >= this.folderList.size()) {
                throw new IllegalArgumentException("illegal index: " + index);
            }
            AbstractFolder folder = this.folderList.get(index);
            int level = this.folderMap.get(folder);
            String result = "";
            for (int i = 0; i < level; ++i) {
                result = result + SHIFT;
            }
            result = result + folder.getName();
            return result;
        }

        @Override
        public int getSize() {
            return this.folderList.size();
        }

        public int indexOf(AbstractFolder folder) {
            return this.folderList.indexOf(folder);
        }

        public List<AbstractFolder> getFolderList(int[] indices) {
            ArrayList<AbstractFolder> folders = new ArrayList<AbstractFolder>();
            for (int index : indices) {
                folders.add(this.folderList.get(index));
            }
            return folders;
        }
    }
}

