/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.notify.dialogs.options;

import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.notify.dialogs.options.MessageTypeListCellRenderer;
import com.novell.gw.jclient.application.notify.dialogs.options.NotifyOptionsDialog;
import com.novell.gw.jclient.application.notify.dialogs.options.NotifyOptionsDialogTabPane;
import com.novell.gw.jclient.application.notify.dialogs.options.SettingsPanel;
import com.novell.gw.jclient.application.notify.dialogs.options.SettingsPanelModel;
import com.novell.gw.jclient.application.notify.enums.MessagePriority;
import com.novell.gw.jclient.application.notify.enums.MessageType;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWNotify;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.apache.log4j.Logger;

public class NotifyPane
extends OrientablePanel
implements NotifyOptionsDialogTabPane {
    private static Logger logger = Logger.getLogger(NotifyPane.class);
    private NotifyOptionsDialog dialog;
    private JComboBox cmbMessageTypes;
    private JCheckBox cbSameSettings;
    private SettingsPanel pnlHighPriority;
    private SettingsPanel pnlStandardPriority;
    private SettingsPanel pnlLowPriority;
    private Map<MessageType, Map> panelModelMap = new HashMap<MessageType, Map>();
    private PrepThread m_prepThread = null;

    public NotifyPane(NotifyOptionsDialog dialog) {
        this.dialog = dialog;
    }

    public void applyOptions() {
        logger.debug((Object)"applying options...");
        GWNotify.getInstance().setSameSettingsForAllNewItems(this.cbSameSettings.isSelected());
        this.pnlHighPriority.updateModel();
        this.pnlStandardPriority.updateModel();
        this.pnlLowPriority.updateModel();
        this.saveSettingsPanelModels();
    }

    public void buildUI() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel pnlMessageTypes = this.buildMessageTypesPanel();
        this.pnlHighPriority = new SettingsPanel(StringResources.HIGH_L_PRIORITY);
        this.pnlHighPriority.buildUI();
        this.pnlHighPriority.buildDefaultBorder();
        this.pnlStandardPriority = new SettingsPanel(StringResources.STANDARD_L_PRIORITY);
        this.pnlStandardPriority.buildUI();
        this.pnlStandardPriority.buildDefaultBorder();
        this.pnlLowPriority = new SettingsPanel(StringResources.LOW_L_PRIORITY);
        this.pnlLowPriority.buildUI();
        this.pnlLowPriority.buildDefaultBorder();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 21;
        this.add((Component)pnlMessageTypes, c);
        c.gridy = 1;
        c.anchor = 10;
        c.fill = 2;
        c.weightx = 1.0;
        this.add((Component)this.pnlHighPriority, c);
        c.gridy = 2;
        this.add((Component)this.pnlStandardPriority, c);
        c.gridy = 3;
        c.weighty = 1.0;
        c.anchor = 19;
        this.add((Component)this.pnlLowPriority, c);
        this.doPrepThread();
    }

    public String getTitle() {
        return StringResources.NOTIFY;
    }

    public void init() {
        MessageType msgType = this.getCurrentMessageType();
        if (msgType != null) {
            Map map = this.panelModelMap.get((Object)msgType);
            this.pnlHighPriority.setModel((SettingsPanelModel)map.get((Object)MessagePriority.HIGH));
            this.pnlStandardPriority.setModel((SettingsPanelModel)map.get((Object)MessagePriority.STANDARD));
            this.pnlLowPriority.setModel((SettingsPanelModel)map.get((Object)MessagePriority.LOW));
        } else {
            this.cmbMessageTypes.setModel(this.getMessageTypesModel());
            this.cmbMessageTypes.setEnabled(!this.cbSameSettings.isSelected());
        }
    }

    public void resetToDefaults() {
        this.cbSameSettings.setSelected(GWNotify.getInstance().isDefaultSameSettingsForAllNewItems());
        this.loadDefaultSettingsPanelModels();
        this.handleSameSettingsChange();
    }

    private JPanel buildMessageTypesPanel() {
        OrientablePanel panel = new OrientablePanel();
        panel.setLayout(new GridBagLayout());
        Border border = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        panel.setBorder(border);
        OrientableLabel lbCombobox = new OrientableLabel(StringResources.SETTINGS_FOR_C);
        this.cmbMessageTypes = new OrientableComboBox();
        this.cmbMessageTypes.setRenderer(new MessageTypeListCellRenderer(this.cmbMessageTypes.getRenderer()));
        this.cbSameSettings = new OrientableCheckBox(new ActionUseSameSettings());
        boolean sameSetings = GWNotify.getInstance().isSameSettingsForAllNewItems();
        this.cbSameSettings.setSelected(sameSetings);
        this.cmbMessageTypes.addItemListener(new MessageTypeItemListener());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        constraints.weightx = 0.0;
        constraints.gridwidth = 1;
        panel.add((Component)lbCombobox, constraints);
        constraints.gridwidth = -1;
        panel.add((Component)this.cmbMessageTypes, constraints);
        constraints.weightx = 1.0;
        constraints.gridwidth = 0;
        panel.add((Component)this.cbSameSettings, constraints);
        return panel;
    }

    private void handleSameSettingsChange() {
        this.cmbMessageTypes.setModel(this.getMessageTypesModel());
        this.cmbMessageTypes.setEnabled(!this.cbSameSettings.isSelected());
        this.handleMessageTypeChanged();
    }

    private void handleMessageTypeChanged() {
        logger.debug((Object)("selected type: " + (Object)((Object)this.getCurrentMessageType())));
        this.init();
    }

    private void loadSettingsPanelModels() {
        this.panelModelMap.clear();
        MessageType[] types = MessageType.getConfigurableMessageTypes();
        GWNotify notify = GWNotify.getInstance();
        for (MessageType type : types) {
            HashMap<MessagePriority, SettingsPanelModel> priorityToModelMap = new HashMap<MessagePriority, SettingsPanelModel>();
            for (MessagePriority priority : MessagePriority.values()) {
                priorityToModelMap.put(priority, notify.getNewItemSettingsPanelModel(type, priority));
            }
            this.panelModelMap.put(type, priorityToModelMap);
        }
    }

    private void loadDefaultSettingsPanelModels() {
        this.panelModelMap.clear();
        MessageType[] types = MessageType.getConfigurableMessageTypes();
        GWNotify notify = GWNotify.getInstance();
        for (MessageType type : types) {
            HashMap<MessagePriority, SettingsPanelModel> priorityToModelMap = new HashMap<MessagePriority, SettingsPanelModel>();
            for (MessagePriority priority : MessagePriority.values()) {
                priorityToModelMap.put(priority, notify.getDefaultNewItemSettingsPanelModel(type, priority));
            }
            this.panelModelMap.put(type, priorityToModelMap);
        }
    }

    private void saveSettingsPanelModels() {
        MessageType[] types = MessageType.getConfigurableMessageTypes();
        GWNotify notify = GWNotify.getInstance();
        for (MessageType type : types) {
            Map priorityToModelMap = this.panelModelMap.get((Object)type);
            for (MessagePriority priority : MessagePriority.values()) {
                SettingsPanelModel model = (SettingsPanelModel)priorityToModelMap.get((Object)priority);
                if (model == null || !model.isModified()) continue;
                notify.setNewItemSettingsPanelModel(model, type, priority);
                model.reset();
            }
        }
    }

    private DefaultComboBoxModel getMessageTypesModel() {
        if (this.cbSameSettings.isSelected()) {
            return new DefaultComboBoxModel<MessageType>(new MessageType[]{MessageType.ANY});
        }
        return new DefaultComboBoxModel<MessageType>(MessageType.getRegularMessageTypes());
    }

    private MessageType getCurrentMessageType() {
        return (MessageType)((Object)this.cmbMessageTypes.getSelectedItem());
    }

    private void doPrepThread() {
        this.m_prepThread = new PrepThread();
        this.m_prepThread.start();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.m_prepThread.waitForCounting();
    }

    private class PrepThread
    extends Thread {
        private boolean m_bPrepThreadRunning = false;

        PrepThread() {
        }

        public void run() {
            this.m_bPrepThreadRunning = true;
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        NotifyPane.this.dialog.invalidate();
                        NotifyPane.this.dialog.repaint();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        NotifyPane.this.loadSettingsPanelModels();
                        NotifyPane.this.handleSameSettingsChange();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.m_bPrepThreadRunning = false;
            NotifyPane.this.dialog.setOkayToRunThread();
        }

        private void waitForCounting() {
            while (this.m_bPrepThreadRunning) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ex) {
                    return;
                }
            }
        }
    }

    private class MessageTypeItemListener
    implements ItemListener {
        private MessageTypeItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                NotifyPane.this.handleMessageTypeChanged();
            }
        }
    }

    private class ActionUseSameSettings
    extends AbstractAction {
        public ActionUseSameSettings() {
            super(StringResources.USE_SAME_SETTINGS_FOR_ALL_TYPES);
        }

        public void actionPerformed(ActionEvent e) {
            NotifyPane.this.handleSameSettingsChange();
        }
    }
}

