/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.notify.dialogs.options;

import com.novell.gw.jclient.application.controls.GWLabeledSeparator;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.notify.FileChooserUtils;
import com.novell.gw.jclient.application.notify.dialogs.options.SettingsPanelModel;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class SettingsPanel
extends OrientablePanel {
    private static Logger logger = Logger.getLogger(SettingsPanel.class);
    protected SettingsPanelModel model;
    protected JCheckBox cbShowDialog;
    protected JCheckBox cbPlaySound;
    protected JCheckBox cbLaunchProgram;
    protected JTextField txtSound;
    protected JTextField txtProgram;
    protected JButton btnChooseSound;
    protected JButton btnChooseProgram;
    protected GWLabeledSeparator labeledSeparator;
    private String caption;

    public SettingsPanel(String caption) {
        this.caption = caption;
    }

    public void buildUI() {
        this.setLayout(new GridBagLayout());
        this.labeledSeparator = new GWLabeledSeparator(this.caption);
        this.cbShowDialog = new OrientableCheckBox(StringResources.SHOW_DIALOG);
        this.cbPlaySound = new OrientableCheckBox(new ActionPlaySound());
        this.cbLaunchProgram = new OrientableCheckBox(new ActionLaunchProgram());
        this.txtSound = new GWTextField();
        this.txtSound.addFocusListener(new SoundLostFocusListener());
        this.txtProgram = new GWTextField();
        this.txtProgram.addFocusListener(new ProgramLostFocusListener());
        this.btnChooseSound = new OrientableButton(new ActionChooseSound());
        this.btnChooseProgram = new OrientableButton(new ActionChooseProgram());
        GridBagConstraints c = SettingsPanel.getGridBagConstraints();
        c.gridx = 0;
        c.gridwidth = 3;
        c.fill = 2;
        c.gridy = 0;
        this.add((Component)this.labeledSeparator, c);
        c.gridx = 0;
        c.gridwidth = 1;
        c.fill = 0;
        ++c.gridy;
        this.add((Component)this.cbShowDialog, c);
        ++c.gridy;
        this.add((Component)this.cbPlaySound, c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.fill = 2;
        this.add((Component)this.txtSound, c);
        c.gridx = 2;
        c.weightx = 0.0;
        c.fill = 0;
        this.add((Component)this.btnChooseSound, c);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)this.cbLaunchProgram, c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.fill = 2;
        this.add((Component)this.txtProgram, c);
        c.gridx = 2;
        c.weightx = 0.0;
        c.fill = 0;
        this.add((Component)this.btnChooseProgram, c);
    }

    public static GridBagConstraints getGridBagConstraints() {
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(1, 1, 1, 1);
        c.anchor = 21;
        return c;
    }

    public void setModel(SettingsPanelModel model) {
        if (this.model != null) {
            this.updateModel();
        }
        this.model = model;
        if (model == null) {
            this.changeEnabledState(false);
            this.txtSound.setText("");
            this.txtProgram.setText("");
            this.cbShowDialog.setSelected(false);
            this.cbPlaySound.setSelected(false);
            this.cbLaunchProgram.setSelected(false);
        } else {
            this.changeEnabledState(true);
            this.txtSound.setText(model.getSoundFilePath());
            this.txtProgram.setText(model.getProgramFilePath());
            this.cbShowDialog.setSelected(model.isShowDialog());
            this.cbPlaySound.setSelected(model.isPlaySound());
            this.cbLaunchProgram.setSelected(model.isLaunchProgram());
            this.handlePlaySoundChange();
            this.handleLaunchProgramChange();
        }
    }

    private void changeEnabledState(boolean enabled) {
        this.txtSound.setEnabled(enabled);
        this.txtProgram.setEnabled(enabled);
        this.cbShowDialog.setEnabled(enabled);
        this.cbPlaySound.setEnabled(enabled);
        this.cbLaunchProgram.setEnabled(enabled);
    }

    public void updateModel() {
        if (this.model == null) {
            return;
        }
        this.model.setShowDialog(this.cbShowDialog.isSelected());
        this.model.setPlaySound(this.cbPlaySound.isSelected());
        this.model.setLaunchProgram(this.cbLaunchProgram.isSelected());
        this.model.setSoundFilePath(this.txtSound.getText());
        this.model.setProgramFilePath(this.txtProgram.getText());
    }

    private void handleChooseSound() {
        int returnValue = FileChooserUtils.getSoundFileChooser().showOpenDialog(this.btnChooseSound);
        if (returnValue == 0) {
            File file = FileChooserUtils.getSoundFileChooser().getSelectedFile();
            this.txtSound.setText(file.getAbsolutePath());
        }
    }

    private void handleChooseProgram() {
        int returnValue = FileChooserUtils.getProgramFileChooser().showOpenDialog(this.btnChooseProgram);
        if (returnValue == 0) {
            File file = FileChooserUtils.getProgramFileChooser().getSelectedFile();
            this.txtProgram.setText(file.getAbsolutePath());
        }
    }

    protected void handlePlaySoundChange() {
        this.txtSound.setEnabled(this.cbPlaySound.isSelected());
        this.btnChooseSound.setEnabled(this.cbPlaySound.isSelected());
    }

    protected void handleLaunchProgramChange() {
        this.txtProgram.setEnabled(this.cbLaunchProgram.isSelected());
        this.btnChooseProgram.setEnabled(this.cbLaunchProgram.isSelected());
    }

    private void handleProgramFileFocusLost() {
        if (this.txtProgram.getText().trim().length() == 0) {
            return;
        }
        String error = FileChooserUtils.checkProgramFile(this.txtProgram.getText());
        if (error != null) {
            this.txtProgram.setText("");
            JOptionPane.showMessageDialog(this, error, StringResources.GROUP_WISE_NOTIFY, 0);
        }
    }

    private void handleSoundFileFocusLost() {
        String error = FileChooserUtils.checkSoundFile(this.txtSound.getText());
        if (error != null) {
            this.txtSound.setText("<BEEP>");
            JOptionPane.showMessageDialog(this, error, StringResources.GROUP_WISE_NOTIFY, 0);
        }
    }

    public void buildDefaultBorder() {
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 3, 1));
    }

    private class ProgramLostFocusListener
    implements FocusListener {
        private ProgramLostFocusListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            SettingsPanel.this.handleProgramFileFocusLost();
        }
    }

    private class SoundLostFocusListener
    implements FocusListener {
        private SoundLostFocusListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            SettingsPanel.this.handleSoundFileFocusLost();
        }
    }

    private class ActionLaunchProgram
    extends AbstractAction {
        public ActionLaunchProgram() {
            super(StringResources.LAUNCH_PROGRAM);
        }

        public void actionPerformed(ActionEvent e) {
            SettingsPanel.this.handleLaunchProgramChange();
        }
    }

    private class ActionPlaySound
    extends AbstractAction {
        public ActionPlaySound() {
            super(StringResources.PLAY_SOUND);
        }

        public void actionPerformed(ActionEvent e) {
            SettingsPanel.this.handlePlaySoundChange();
        }
    }

    private class ActionChooseProgram
    extends AbstractAction {
        public ActionChooseProgram() {
            super(null, ImageResources.OPEN_FILE);
        }

        public void actionPerformed(ActionEvent e) {
            SettingsPanel.this.handleChooseProgram();
        }
    }

    private class ActionChooseSound
    extends AbstractAction {
        public ActionChooseSound() {
            super(null, ImageResources.OPEN_FILE);
        }

        public void actionPerformed(ActionEvent e) {
            SettingsPanel.this.handleChooseSound();
        }
    }
}

