/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.notify.frames;

import com.appframework.ApplicationFrame;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.notify.frames.NotificationTable;
import com.novell.gw.jclient.application.notify.frames.NotificationTableModel;
import com.novell.gw.jclient.bl.om.GWNotify;
import com.novell.gw.notification.NotifyEvent;
import com.novell.gw.notification.NotifyListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import org.apache.log4j.Logger;

public class NotificationTableController
extends MVCController
implements NotifyListener {
    private static Logger logger = Logger.getLogger(NotificationTableController.class);
    private static final int TIMER_DELAY = 300;
    private Timer tableModelRefreshTimer = new Timer(300, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            logger.debug((Object)"refreshing table...");
            NotificationTableController.this.getTableModel().loadItems();
            NotificationTableController.this.getTableModel().fireTableDataChanged();
        }
    });

    public NotificationTableController(MVCView theView, MVCController theParentController) {
        super(theView, theParentController);
        this.tableModelRefreshTimer.setRepeats(false);
        logger.debug((Object)(">>> adding NotifyListener: " + this));
        GWNotify.getInstance().addNotifyListener(this);
    }

    public void notification(NotifyEvent e) {
        if (e.getType() == 2) {
            logger.debug((Object)"event of list change received");
            this.tableModelRefreshTimer.restart();
        }
    }

    private NotificationTable getTable() {
        return (NotificationTable)this.getMVCView();
    }

    private NotificationTableModel getTableModel() {
        return (NotificationTableModel)this.getTable().getModel();
    }

    protected void initListeners() {
        Level level = this.getFrameLevel();
        AppEventListener listener = new WINDOW_CLOSED_Listener();
        AppEventListenerDescriptor descriptor = new AppEventListenerDescriptor(level, 490, listener);
        this.addListenerDescriptor(descriptor);
        listener = new CHECK_NOTIFICATIONS_Listener();
        descriptor = new AppEventListenerDescriptor(level, 1570, listener);
        this.addListenerDescriptor(descriptor);
    }

    private class CHECK_NOTIFICATIONS_Listener
    extends AppEventListener {
        private CHECK_NOTIFICATIONS_Listener() {
        }

        public void handle(AppEvent event) {
            NotificationTableController.this.tableModelRefreshTimer.restart();
        }
    }

    private class WINDOW_CLOSED_Listener
    extends AppEventListener {
        private WINDOW_CLOSED_Listener() {
        }

        public void handle(AppEvent event) {
            ApplicationFrame frame = (ApplicationFrame)event.getData();
            Level closedFrameLevel = frame.getController().getLevel();
            Level parentFremeLevel = ControlsUtils.getFrameForController(NotificationTableController.this).getController().getLevel();
            logger.debug((Object)("closedFrameLevel: " + closedFrameLevel + ", parentFremeLevel: " + parentFremeLevel));
            if (parentFremeLevel.equals(closedFrameLevel)) {
                NotificationTableController.this.tableModelRefreshTimer.stop();
                logger.debug((Object)("removing NotifyListener: " + NotificationTableController.this));
                GWNotify.getInstance().removeNotifyListener(NotificationTableController.this);
            }
        }
    }
}

