/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.options;

import com.appframework.utils.Assertions;
import com.novell.gw.engine.EngineLocale;
import com.novell.gw.engine.MachineSettings;
import com.novell.gw.jclient.api.APIFactory;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.application.frames.options.compose.country.Language;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.PathManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.options.DateTimeOptions;
import com.novell.gw.jclient.bl.om.options.EnvironmentOptions;
import com.novell.gw.jclient.bl.om.options.GeneralOptions;
import com.novell.gw.jclient.bl.om.options.InterfaceOptions;
import com.novell.gw.jclient.bl.om.options.ItemSendOptions;
import com.novell.gw.jclient.bl.om.options.LoginOptions;
import com.novell.gw.jclient.bl.om.options.NotifierOptions;
import com.novell.gw.jclient.bl.om.options.Options;
import com.novell.gw.jclient.bl.om.options.PrintingOptions;
import com.novell.gw.jclient.bl.om.options.QuickViewerOptions;
import com.novell.gw.jclient.bl.om.options.SendOptions;
import com.novell.gw.jclient.bl.om.options.ToolBarsOptions;
import com.novell.gw.jclient.bl.om.options.properties.DateAndTimeOptionsProperties;
import com.novell.gw.jclient.bl.om.options.properties.EnvironmentOptionsProperties;
import com.novell.gw.jclient.bl.om.options.properties.GeneralOptionsProperties;
import com.novell.gw.jclient.bl.om.options.properties.InterfaceOptionsProperties;
import com.novell.gw.jclient.bl.om.options.properties.NotifierOptionsProperties;
import com.novell.gw.jclient.bl.om.options.properties.OptionsProperties;
import com.novell.gw.jclient.bl.om.options.properties.PrintingOptionsProperties;
import com.novell.gw.jclient.bl.om.options.properties.QuickViewerOptionsProperties;
import com.novell.gw.jclient.bl.om.options.properties.ToolBarProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.log4j.Logger;

public class OptionManager {
    private static Logger logger = Logger.getLogger(OptionManager.class);
    private static OptionManager instance;
    private static final String FILE_GENERAL_OPTIONS = "general.properties";
    private static final String FILE_PRINTING_OPTIONS = "printing.properties";
    private static final String FILE_ENVIRONMENT_OPTIONS = "environment.properties";
    private static final String FILE_INTERFACE_OPTIONS = "interface.properties";
    private static final String FILE_DATE_TIME_OPTIONS = "date_time.properties";
    private static final String FILE_NOTIFIER_OPTIONS = "notifier.properties";
    private static final String FILE_QUICK_VIEWER_OPTIONS = "quickviewer.properties";
    private static final String FILE_TOOLBAR_PROPERTIES = "toolbar.properties";
    private final HashMap<String, Options> optionsHash = new HashMap();
    private final HashMap<String, String> filesMap = new HashMap();
    private final HashMap<String, OptionsProperties> propertiesMap = new HashMap();
    private MachineSettings machineSettings;
    private MachineSettings.TextOption textOption = null;

    public static synchronized OptionManager getInstance() {
        if (instance == null) {
            instance = new OptionManager();
        }
        return instance;
    }

    public static synchronized void freeInstance() {
        instance = null;
    }

    public OptionManager() {
        this.filesMap.put("General options", FILE_GENERAL_OPTIONS);
        this.filesMap.put("Printing options", FILE_PRINTING_OPTIONS);
        this.filesMap.put("Environment options", FILE_ENVIRONMENT_OPTIONS);
        this.filesMap.put("Interface options", FILE_INTERFACE_OPTIONS);
        this.filesMap.put("Date & Time options", FILE_DATE_TIME_OPTIONS);
        this.filesMap.put("Notifier options", FILE_NOTIFIER_OPTIONS);
        this.filesMap.put("QuickViewer options", FILE_QUICK_VIEWER_OPTIONS);
        this.filesMap.put("ToolBar options", FILE_TOOLBAR_PROPERTIES);
        this.propertiesMap.put("General options", new GeneralOptionsProperties());
        this.propertiesMap.put("Environment options", new EnvironmentOptionsProperties());
        this.propertiesMap.put("Printing options", new PrintingOptionsProperties());
        this.propertiesMap.put("Interface options", new InterfaceOptionsProperties());
        this.propertiesMap.put("Date & Time options", new DateAndTimeOptionsProperties());
        this.propertiesMap.put("Notifier options", new NotifierOptionsProperties());
        this.propertiesMap.put("QuickViewer options", new QuickViewerOptionsProperties());
        this.propertiesMap.put("ToolBar options", new ToolBarProperties());
    }

    public LoginOptions getLoginOptions() {
        LoginOptions loginOptions = (LoginOptions)this.optionsHash.get("Login options");
        if (loginOptions == null) {
            loginOptions = new LoginOptions();
            this.setLoginOptions(loginOptions);
        }
        return loginOptions;
    }

    public void setLoginOptions(LoginOptions theLoginOptions) {
        if (theLoginOptions != null) {
            this.optionsHash.put(theLoginOptions.getID(), theLoginOptions);
        }
    }

    public GeneralOptions getGeneralOptions() {
        GeneralOptions generalOptions;
        try {
            boolean isFirstTimeRead = this.optionsHash.get("General options") == null;
            generalOptions = (GeneralOptions)this.getOptions("General options");
            if (isFirstTimeRead) {
                this.readLocale(generalOptions);
            }
        }
        catch (GWCommandException e) {
            logger.error((Object)e);
            generalOptions = new GeneralOptions();
            this.setOptions(generalOptions);
        }
        return generalOptions;
    }

    private void readLocale(GeneralOptions theGeneralOptions) {
        try {
            EngineLocale[] locales = EngineLocale.getAvailableLocales();
            if (locales != null && locales.length > 0) {
                Language[] languages = new Language[locales.length];
                for (int i = 0; i < locales.length; ++i) {
                    languages[i] = new Language(locales[i].getCode(), locales[i].getDisplayName());
                }
                theGeneralOptions.setAvailableLanguages(languages);
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        try {
            EngineLocale current = EngineLocale.getCurrent();
            EngineLocale machineLocale = this.getMachineSettings().getInterfaceLanguage();
            if (!current.getLocale().equals(machineLocale.getLocale())) {
                for (EngineLocale locale : EngineLocale.getAvailableLocales()) {
                    if (!locale.getLocale().equals(current.getLocale())) continue;
                    this.getMachineSettings().setInterfaceLanguage(current);
                    machineLocale = current;
                    break;
                }
            }
            theGeneralOptions.setInterfaceLanguage(new Language(machineLocale.getCode(), machineLocale.getDisplayName()));
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    public void setGeneralOptions(GeneralOptions theGeneralOptions) {
        String code;
        EngineLocale locale;
        this.setOptions(theGeneralOptions);
        if (theGeneralOptions.getInterfaceLanguage() != null && (locale = EngineLocale.getLocale((String)(code = theGeneralOptions.getInterfaceLanguage().getCode()))) != null && !locale.getCode().equals(EngineLocale.getCurrent().getCode())) {
            this.getMachineSettings().setInterfaceLanguage(locale);
        }
    }

    public PrintingOptions getPrintingOptions() {
        PrintingOptions printingOptions;
        try {
            printingOptions = (PrintingOptions)this.getOptions("Printing options");
        }
        catch (GWCommandException e) {
            logger.error((Object)e);
            printingOptions = new PrintingOptions();
            this.setOptions(printingOptions);
        }
        return printingOptions;
    }

    public void setPrintingOptions(PrintingOptions thePrintingOptions) {
        this.setOptions(thePrintingOptions);
    }

    public SendOptions getSendOptions(String userGuid) {
        boolean isFirstTimeRead;
        SendOptions sendOptions = (SendOptions)this.optionsHash.get("Send options");
        boolean bl = isFirstTimeRead = sendOptions == null;
        if (isFirstTimeRead) {
            sendOptions = new SendOptions();
            this.setSendOptions(sendOptions, userGuid);
            OptionManager.readServerSendOptions(sendOptions, userGuid);
            isFirstTimeRead = false;
        }
        return sendOptions;
    }

    private static void readServerSendOptions(SendOptions theSendOptions, String userGuid) {
        ItemSendOptions iso = null;
        try {
            iso = GWCommandManager.getInstance(userGuid).getItemSendOptions();
        }
        catch (GWCommandException e) {
            logger.error((Object)e);
        }
        theSendOptions.setItemSendOptions(iso == null ? new ItemSendOptions() : iso);
    }

    public void setSendOptions(SendOptions theSendOptions, String userGuid) {
        if (theSendOptions == null) {
            return;
        }
        this.optionsHash.put(theSendOptions.getID(), theSendOptions);
        if (theSendOptions.getItemSendOptions() != null) {
            try {
                GWCommandManager.getInstance(userGuid).modifyItemSendOptions(theSendOptions.getItemSendOptions());
            }
            catch (GWCommandException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    public InterfaceOptions getInterfaceOptions() {
        InterfaceOptions interfaceOptions;
        try {
            interfaceOptions = (InterfaceOptions)this.getOptions("Interface options");
        }
        catch (GWCommandException e) {
            logger.error((Object)e);
            interfaceOptions = new InterfaceOptions();
            this.setOptions(interfaceOptions);
        }
        return interfaceOptions;
    }

    public void setInterfaceOptions(InterfaceOptions interfaceOptions) {
        this.setOptions(interfaceOptions);
    }

    public DateTimeOptions getDateTimeOptions() {
        DateTimeOptions dateTimeOptions;
        try {
            dateTimeOptions = (DateTimeOptions)this.getOptions("Date & Time options");
        }
        catch (GWCommandException e) {
            logger.error((Object)e);
            dateTimeOptions = new DateTimeOptions();
            this.setOptions(dateTimeOptions);
        }
        if (!dateTimeOptions.isDataStoreSettingsRead()) {
            dateTimeOptions.readFromDataStoreSettings();
        }
        return dateTimeOptions;
    }

    public void setDateTimeOptions(DateTimeOptions theDateTimeOptions) {
        theDateTimeOptions.writeToDataStoreSettings();
        this.setOptions(theDateTimeOptions);
    }

    public NotifierOptions getNotifierOptions() {
        NotifierOptions notifierOptions;
        try {
            notifierOptions = (NotifierOptions)this.getOptions("Notifier options");
        }
        catch (GWCommandException e) {
            logger.error((Object)e);
            notifierOptions = new NotifierOptions();
            this.setOptions(notifierOptions);
        }
        return notifierOptions;
    }

    public void setNotifierOptions(NotifierOptions theNotifierOptions) {
        this.setOptions(theNotifierOptions);
    }

    public void setQuickViewerOptions(QuickViewerOptions options) {
        this.setOptions(options);
    }

    public QuickViewerOptions getQuickViewerOptions() {
        QuickViewerOptions options;
        try {
            options = (QuickViewerOptions)this.getOptions("QuickViewer options");
        }
        catch (GWCommandException e) {
            e.printStackTrace();
            options = new QuickViewerOptions();
            this.setOptions(options);
        }
        return options;
    }

    public void setToolBarOptions(QuickViewerOptions options) {
        this.setOptions(options);
    }

    public ToolBarsOptions getToolBarsOptions() {
        ToolBarsOptions options;
        try {
            options = (ToolBarsOptions)this.getOptions("ToolBar options");
        }
        catch (GWCommandException e) {
            e.printStackTrace();
            options = new ToolBarsOptions();
            this.setOptions(options);
        }
        return options;
    }

    public EnvironmentOptions getEnvironmentOptions() {
        EnvironmentOptions environmentOptions;
        try {
            environmentOptions = (EnvironmentOptions)this.getOptions("Environment options");
        }
        catch (GWCommandException e) {
            logger.error((Object)e);
            environmentOptions = new EnvironmentOptions();
            this.setOptions(environmentOptions);
        }
        return environmentOptions;
    }

    public void setEnvironmentOptions(EnvironmentOptions theEnvironmentOptions) {
        this.setOptions(theEnvironmentOptions);
    }

    private Options getOptions(String optionsID) throws GWCommandException {
        Options options = this.optionsHash.get(optionsID);
        if (options == null) {
            options = this.readOptions(optionsID);
            this.optionsHash.put(optionsID, options);
        }
        return options;
    }

    private void setOptions(Options theOptions) {
        if (theOptions == null) {
            return;
        }
        this.optionsHash.put(theOptions.getID(), theOptions);
        try {
            this.writeOptions(theOptions);
        }
        catch (Exception e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
    }

    public static void saveAndClear() {
        try {
            OptionManager.save();
        }
        catch (GWCommandException e) {
            logger.error((Object)e);
        }
        OptionManager.clearOptions();
    }

    public static void clearOptions() {
        OptionManager.getInstance().optionsHash.clear();
    }

    public String getCachingPath() {
        return this.getMachineSettings().getPathToCache();
    }

    public void setCashingPath(String path) {
        this.getMachineSettings().setPathToCache(path);
    }

    public MachineSettings getMachineSettings() {
        if (this.machineSettings == null) {
            APIFactory.getEngine();
            this.machineSettings = new MachineSettings();
        }
        return this.machineSettings;
    }

    public MachineSettings.TextOption getTextOption() {
        if (this.textOption == null) {
            IDataStore currentDataStore = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getCurrentDataStore();
            this.textOption = this.getMachineSettings().getTextOption(currentDataStore.getNativeDataStore());
        }
        return this.textOption;
    }

    public boolean setTextOption(Boolean isDefaultComposeHTML, Boolean isDefaultReadHTML, Boolean isPlainTextReadForced, String defaultComposeHTMLFont, Integer defaultComposeHTMLFontSize, String defaultComposePlainTextFont, Integer defaultComposePlainTextFontSize, String defaultReadPlainTextFont, Integer defaultReadPlainTextFontSize) {
        IDataStore currentDataStore = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getCurrentDataStore();
        boolean retValue = this.getMachineSettings().setTextOption(currentDataStore.getNativeDataStore(), isDefaultComposeHTML, isDefaultReadHTML, isPlainTextReadForced, defaultComposeHTMLFont, defaultComposeHTMLFontSize, defaultComposePlainTextFont, defaultComposePlainTextFontSize, defaultReadPlainTextFont, defaultReadPlainTextFontSize);
        this.textOption = null;
        return retValue;
    }

    public synchronized Options readOptions(String optionsID) throws GWCommandException {
        if (!this.filesMap.keySet().contains(optionsID)) {
            Assertions.assertIllegalArgument("Option [" + optionsID + "] is not supported");
        }
        Properties properties = new Properties();
        try {
            FileInputStream in = new FileInputStream(this.createOptionsFile(optionsID));
            properties.load(in);
            in.close();
        }
        catch (IOException e) {
            logger.error((Object)e);
            throw new GWCommandException("Error while reading file :", e);
        }
        return this.getOptionsProperties(optionsID).readOptions(properties);
    }

    public synchronized void writeOptions(Options theOptions) throws GWCommandException {
        Assertions.assertNotNull(theOptions, "Can not write NULL options object");
        String id = theOptions.getID();
        Properties properties = this.getOptionsProperties(id).createProperties(theOptions);
        try {
            FileOutputStream out = new FileOutputStream(this.createOptionsFile(id));
            properties.store(out, id);
            out.close();
        }
        catch (IOException e) {
            logger.error((Object)e, (Throwable)e);
            throw new GWCommandException("Failed to write options '" + id + "' :", e);
        }
        catch (Exception e) {
            logger.error((Object)"Internal error occured while writing properties to the file.");
            logger.error((Object)e, (Throwable)e);
        }
    }

    public static void save() throws GWCommandException {
        for (Options options : OptionManager.getInstance().optionsHash.values()) {
            OptionManager.getInstance().writeOptions(options);
        }
    }

    private OptionsProperties getOptionsProperties(String optionsID) throws GWCommandException {
        OptionsProperties op = this.propertiesMap.get(optionsID);
        if (op == null) {
            throw new GWCommandException("There is no appropriate properties handler for options [" + optionsID + ']');
        }
        return op;
    }

    private String getOptionFilePath(String optionsID) {
        String path = PathManager.getUserOptionsPath();
        if ("Login options".equals(optionsID)) {
            path = PathManager.getBaseOptionsPath();
        } else if ("Interface options".equals(optionsID)) {
            path = PathManager.getBaseOptionsPath();
        }
        path = path + this.filesMap.get(optionsID);
        return path;
    }

    private File createOptionsFile(String optionsID) throws IOException {
        File file = new File(this.getOptionFilePath(optionsID));
        if (!file.exists()) {
            file.createNewFile();
        }
        return file;
    }
}

