/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.options.mailto;

import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.options.mailto.MailToOptions;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailToStringParser {
    private static Logger logger = Logger.getLogger(MailToStringParser.class);
    static final String TOKEN_MAILTO = "mailto:";
    private static final String TOKEN_QUESTION = "?";
    private static final String TOKEN_EQUAL = "=";
    private static final String TOKEN_AMPERSAND = "&";
    private static final String TOKEN_COMMA_SEMICOLON_SEPARATOR = ",;";
    private static final String TOKEN_TO = "to=";
    private static final String TOKEN_CC = "cc=";
    private static final String TOKEN_BCC = "bcc=";
    private static final String TOKEN_SUBJECT = "subject=";
    private static final String TOKEN_BODY = "body=";
    private static final String TOKEN_OPERA_BCC = "%a";
    private static final String TOKEN_OPERA_BODY = "%b";
    private static final String TOKEN_OPERA_CC = "%c";
    private static final String TOKEN_OPERA_SUBJECT = "%s";
    private static final String TOKEN_OPERA_TO = "%t";
    private static final Set<String> SET_ATTACHMENT_TOKENS = new HashSet<String>();
    private String encoding = "ISO-8859-15";

    public void setEncoding(String encoding) {
        if (encoding == null) {
            throw new IllegalArgumentException("encoding is null");
        }
        if (encoding.trim().length() == 0) {
            throw new IllegalArgumentException("encoding is an empty string");
        }
        this.encoding = encoding;
    }

    public MailToOptions createMailToOptions(String mailtoString) {
        MailToOptions res = new MailToOptions();
        if (mailtoString != null) {
            List<String> lstTo = new ArrayList<String>();
            List<String> lstCC = new ArrayList<String>();
            List<String> lstBCC = new ArrayList<String>();
            String sSubject = "";
            String sBody = "";
            ArrayList<File> attachments = new ArrayList<File>();
            logger.debug((Object)("Start creating instance of mailto: options from string:\n[" + mailtoString + ']'));
            String cp = mailtoString.toLowerCase();
            if (cp.startsWith(TOKEN_MAILTO)) {
                mailtoString = mailtoString.substring(TOKEN_MAILTO.length());
                int posQuestion = (cp = cp.substring(TOKEN_MAILTO.length())).indexOf(TOKEN_QUESTION);
                if (posQuestion == -1) {
                    lstTo = this.parseEmails(lstTo, mailtoString);
                } else {
                    String startTo = mailtoString.substring(0, posQuestion);
                    lstTo = this.parseEmails(lstTo, startTo);
                    String params = mailtoString.substring(posQuestion + 1);
                    StringTokenizer st = new StringTokenizer(params, TOKEN_AMPERSAND, false);
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        logger.debug((Object)("parsing parameter: [" + token + ']'));
                        int posEqual = token.indexOf(TOKEN_EQUAL);
                        if (posEqual == -1) continue;
                        String sName = token.substring(0, posEqual + 1).toLowerCase();
                        String sValue = token.substring(posEqual + 1);
                        if (sName.equals(TOKEN_TO)) {
                            lstTo = this.parseEmails(lstTo, sValue);
                            continue;
                        }
                        if (sName.equals(TOKEN_CC)) {
                            lstCC = this.parseEmails(lstCC, sValue);
                            continue;
                        }
                        if (sName.equals(TOKEN_BCC)) {
                            lstBCC = this.parseEmails(lstBCC, sValue);
                            continue;
                        }
                        if (sName.equals(TOKEN_SUBJECT)) {
                            sSubject = sSubject + (sSubject.length() > 0 ? " " : "") + this.decodeString(MailToStringParser.isOperaToken(sValue) ? "" : sValue);
                            continue;
                        }
                        if (sName.equals(TOKEN_BODY)) {
                            sBody = sBody + (sBody.length() > 0 ? "\n" : "") + this.decodeString(MailToStringParser.isOperaToken(sValue) ? "" : sValue);
                            continue;
                        }
                        if (SET_ATTACHMENT_TOKENS.contains(sName)) {
                            attachments.addAll(Utils.getFileList(this.decodeString(sValue)));
                            continue;
                        }
                        logger.warn((Object)("Invalid token found: name=[" + sName + "] -> value=[" + sValue + ']'));
                    }
                }
            }
            res.setToList(lstTo);
            res.setCcList(lstCC);
            res.setBccList(lstBCC);
            res.setSubject(sSubject);
            res.setBody(sBody);
            res.setAttachments(attachments);
        }
        logger.debug((Object)("Result: " + res));
        return res;
    }

    private String decodeString(String decode) {
        String res = "";
        try {
            res = URLDecoder.decode(decode, this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException ill) {
            logger.warn((Object)ill);
        }
        return res;
    }

    private static boolean isOperaToken(String s) {
        if (s != null) {
            return s.equalsIgnoreCase(TOKEN_OPERA_BCC) || s.equalsIgnoreCase(TOKEN_OPERA_BODY) || s.equalsIgnoreCase(TOKEN_OPERA_CC) || s.equalsIgnoreCase(TOKEN_OPERA_SUBJECT) || s.equalsIgnoreCase(TOKEN_OPERA_TO);
        }
        return false;
    }

    private List<String> parseEmails(List<String> lst, String s) {
        if (s != null && s.length() > 0) {
            if (MailToStringParser.isOperaToken(s)) {
                logger.warn((Object)("Found empty Opera token: [" + s + ']'));
            } else {
                StringTokenizer st = new StringTokenizer(s, TOKEN_COMMA_SEMICOLON_SEPARATOR, false);
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    lst.add(this.decodeString(token).trim());
                }
            }
        }
        return lst;
    }

    static {
        SET_ATTACHMENT_TOKENS.add("attachment=");
        SET_ATTACHMENT_TOKENS.add("attachments=");
        SET_ATTACHMENT_TOKENS.add("attach=");
    }
}

