/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.basicforms;

import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.UIUtils;
import com.novell.gw.ab.AddressBookManager;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.printing.basicforms.AddressBookFormController;
import com.novell.gw.jclient.application.printing.basicforms.PrintForm;
import com.novell.gw.jclient.application.printing.preview.PrintUtils;
import com.novell.gw.jclient.application.printing.printingaddressbook.AddressBookChecksPanel;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddressBookForm
extends PrintForm
implements MVCView {
    private static Logger logger = Logger.getLogger(AddressBookForm.class);
    protected AddressBookFormController controller;
    protected AddressBookChecksPanel addressBookChecksPanel;
    protected int entriesCount;
    protected List<IAddressable> selectedContacts = null;

    public AddressBookForm(List<IAddressable> selectedContacts, MVCController theParentController) {
        this.controller = new AddressBookFormController(this, theParentController);
        this.selectedContacts = selectedContacts;
    }

    @Override
    public int print(Graphics pg, PageFormat pageFormat, int pageIndex) throws PrinterException {
        pg.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        this.pageWidth = (int)pageFormat.getImageableWidth();
        this.pageHeight = (int)pageFormat.getImageableHeight();
        pg.setColor(Color.black);
        pg.setClip(0, 0, this.pageWidth, this.pageHeight);
        if (ApplicationOptions.getInstance().getBoolean("PRINT_HEADER", true)) {
            this.commonHeaderH = this.printCommonHeader(pg, pageIndex);
            pg.translate(0, this.commonHeaderH);
        }
        return 0;
    }

    protected int printCommonHeader(Graphics pg, int pageIndex) {
        int x = 0;
        int y = 0;
        pg.setFont(FNT_PLAIN);
        FontMetrics fm = pg.getFontMetrics();
        String s = StringResources.GROUPWISE_CLIENT;
        int sWidth = (int)pg.getFontMetrics().getStringBounds(s, pg).getWidth();
        pg.drawString(s, x, y += fm.getAscent());
        String date = OptionManager.getInstance().getDateTimeOptions().getGeneralDateString(GWCalendarUtils.getToday().getTime());
        int dateWidth = (int)pg.getFontMetrics().getStringBounds(date, pg).getWidth();
        if (UIUtils.getComponentOrientation().isLeftToRight()) {
            pg.drawString(s, x, y);
            pg.drawString(date, this.pageWidth - dateWidth, y);
        } else {
            pg.drawString(s, this.pageWidth - sWidth, y);
            pg.drawString(date, x, y);
        }
        if (this.addressBookChecksPanel.cbPageNumber.isSelected()) {
            String pageNumber = StringResources.PAGE + ' ' + (pageIndex + 1);
            int pageNumberWidth = (int)pg.getFontMetrics().getStringBounds(pageNumber, pg).getWidth();
            pg.drawString(pageNumber, this.pageWidth / 2 - pageNumberWidth / 2, y);
        }
        pg.drawLine(0, y + 5, this.pageWidth, y + 5);
        return y += fm.getHeight() + 10;
    }

    protected int findMaxKeyLength(int propKey) {
        PageFormat pageFormat = PrintUtils.getPageFormatFromPrintAttributes(OptionManager.getInstance().getPrintingOptions().getPrintAttributeSet());
        int w = (int)pageFormat.getImageableWidth();
        int h = (int)pageFormat.getImageableHeight();
        BufferedImage bi = new BufferedImage(w, h, 2);
        Graphics g = bi.getGraphics();
        g.setFont(FNT_PLAIN);
        FontMetrics fm = g.getFontMetrics();
        String str = AddressBookManager.getPropertyLabel((int)propKey);
        int result = (int)fm.getStringBounds(str, g).getWidth();
        int width = 0;
        for (int i = 0; i < this.entriesCount; ++i) {
            IContact entry = (IContact)this.selectedContacts.get(i);
            String value = entry.getStringValue(propKey);
            width = (int)fm.getStringBounds(value, g).getWidth();
            if (result >= width) continue;
            result = width;
        }
        return result += (int)fm.getStringBounds("ww", g).getWidth();
    }

    public void setController(MVCController theController) {
        this.controller = (AddressBookFormController)theController;
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object theModel) {
        if (theModel instanceof AddressBookChecksPanel) {
            this.addressBookChecksPanel = (AddressBookChecksPanel)theModel;
        }
    }

    public Object getMVCModel() {
        return null;
    }
}

